/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import java.util.Locale;

class FontVariantShorthandSetter
extends ShorthandSetter {
    FontVariantShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "font-variant");
    }

    @Override
    public boolean assignSubproperties() {
        String text;
        if (this.currentValue.getLexicalUnitType() == 35 && ((text = this.currentValue.getStringValue()).equalsIgnoreCase("normal") || text.equalsIgnoreCase("none"))) {
            if (this.currentValue.getNextLexicalUnit() == null) {
                String[] sh;
                for (String s : sh = this.getShorthandSubproperties()) {
                    this.styleDeclaration.setProperty(s, text.toLowerCase(Locale.US), this.getPriority());
                }
                return true;
            }
            StyleDeclarationErrorHandler errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
            if (errHandler != null) {
                errHandler.shorthandError(this.getShorthandName(), "Found '" + text + "' keyword mixed with other values");
            }
            return false;
        }
        return super.assignSubproperties();
    }

    @Override
    protected boolean assignSubproperty(String subproperty) {
        switch (this.currentValue.getLexicalUnitType()) {
            case 35: {
                if (subproperty.equals("font-variant-alternates") && this.testFontVariantAlternates()) {
                    return true;
                }
                boolean is_set = false;
                while (this.currentValue != null) {
                    if (this.testIdentifiers(subproperty)) {
                        AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                        this.addSubpropertyValue(subproperty, cssValue, false);
                        is_set = true;
                        this.nextCurrentValue();
                        if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 35) continue;
                        break;
                    }
                    return is_set;
                }
                return is_set;
            }
            case 41: {
                if (!subproperty.equals("font-variant-alternates") || !this.testFontVariantAlternates()) break;
                return true;
            }
        }
        return false;
    }

    private boolean testFontVariantAlternates() {
        boolean is_set = false;
        while (this.currentValue != null) {
            switch (this.currentValue.getLexicalUnitType()) {
                case 35: {
                    AbstractCSSValue cssValue;
                    if (this.testIdentifiers("font-variant-alternates")) {
                        cssValue = this.createCSSValue("font-variant-alternates", this.currentValue);
                        this.addSubpropertyValue("font-variant-alternates", cssValue, false);
                        this.nextCurrentValue();
                        is_set = true;
                        break;
                    }
                    return is_set;
                }
                case 41: {
                    AbstractCSSValue cssValue = this.createCSSValue("font-variant-alternates", this.currentValue);
                    this.addSubpropertyValue("font-variant-alternates", cssValue, false);
                    this.nextCurrentValue();
                    is_set = true;
                }
            }
        }
        return is_set;
    }
}

