/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.OMMediaList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.net.URL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;

public class OMCSSImportRule
extends BaseCSSRule
implements CSSImportRule,
ExtendedCSSRule {
    private AbstractCSSStyleSheet loadedSheet = null;
    private String styleSheetURI = null;
    private MediaQueryList mediaList;

    public OMCSSImportRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)3, origin);
        this.mediaList = OMMediaList.createMediaList();
    }

    OMCSSImportRule(AbstractCSSStyleSheet parentSheet, MediaQueryList mediaList, byte origin) {
        super(parentSheet, (short)3, origin);
        this.mediaList = mediaList;
    }

    @Override
    public String getHref() {
        return this.styleSheetURI;
    }

    @Override
    public MediaQueryList getMedia() {
        return this.mediaList;
    }

    @Override
    public AbstractCSSStyleSheet getStyleSheet() {
        return this.loadedSheet;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(230);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        wri.write("@import ");
        context.writeURL(wri, this.getStyleSheet().getHref());
        if (!this.mediaList.isAllMedia()) {
            wri.write(' ');
            wri.write(this.mediaList.getMediaText());
        }
        context.writeSemiColon(wri);
    }

    public boolean loadStyleSheet(String uri, String title, SACMediaList media) throws CSSException, IOException, DOMException {
        URL styleSheetURL = this.getURL(uri);
        this.styleSheetURI = styleSheetURL.toExternalForm();
        ((MediaListAccess)((Object)this.mediaList)).appendSACMediaList(media);
        AbstractCSSStyleSheet parentSS = this.getParentStyleSheet();
        if (title == null && parentSS != null) {
            title = parentSS.getTitle();
        }
        BaseCSSStyleSheet css = (BaseCSSStyleSheet)parentSS.getStyleSheetFactory().createRuleStyleSheet(this, title, this.mediaList);
        css.setParentStyleSheet(parentSS);
        this.loadedSheet = css;
        return css.loadStyleSheet(styleSheetURL, "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mediaList == null ? 0 : this.mediaList.hashCode());
        result = 31 * result + (this.styleSheetURI == null ? 0 : this.styleSheetURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSImportRule other = (OMCSSImportRule)obj;
        if (this.mediaList == null ? other.mediaList != null : !this.mediaList.equals(other.mediaList)) {
            return false;
        }
        return !(this.styleSheetURI == null ? other.styleSheetURI != null : !this.styleSheetURI.equals(other.styleSheetURI));
    }

    @Override
    public OMCSSImportRule clone(AbstractCSSStyleSheet parentSheet) {
        OMCSSImportRule rule = new OMCSSImportRule(parentSheet, ((MediaListAccess)((Object)this.getMedia())).unmodifiable(), this.getOrigin());
        rule.styleSheetURI = this.getHref();
        rule.loadedSheet = this.getStyleSheet();
        return rule;
    }
}

