/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSNamespaceRule;
import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.OMCSSGroupingRule;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class OMCSSNamespaceRule
extends BaseCSSRule
implements CSSNamespaceRule {
    private String namespaceURI = null;
    private String prefix = null;

    OMCSSNamespaceRule(AbstractCSSStyleSheet parentSheet, byte origin, String prefix, String namespaceURI) {
        super(parentSheet, (short)10, origin);
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
        AbstractCSSStyleSheet parentSheet = this.getParentStyleSheet();
        if (parentSheet != null) {
            parentSheet.unregisterNamespace(this.namespaceURI);
            parentSheet.registerNamespace(this);
            this.updateSelectorText(parentSheet.getCssRules());
        }
    }

    private void updateSelectorText(CSSRuleArrayList rules) {
        for (ExtendedCSSRule rule : rules) {
            short type = rule.getType();
            if (type == 1) {
                ((CSSStyleDeclarationRule)rule).updateSelectorText();
                continue;
            }
            if (!(rule instanceof OMCSSGroupingRule)) continue;
            this.updateSelectorText(((OMCSSGroupingRule)rule).getCssRules());
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "Cannot modify a namespace rule");
    }

    @Override
    public String getCssText() {
        if (this.namespaceURI == null) {
            return null;
        }
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(this.namespaceURI.length() + 32);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.namespaceURI == null) {
            return;
        }
        wri.write("@namespace ");
        if (this.prefix != null) {
            wri.write(this.prefix);
            wri.write(' ');
        }
        context.writeURL(wri, this.namespaceURI);
        context.writeSemiColon(wri);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSNamespaceRule other = (OMCSSNamespaceRule)obj;
        if (this.namespaceURI == null ? other.namespaceURI != null : !this.namespaceURI.equals(other.namespaceURI)) {
            return false;
        }
        return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
    }

    @Override
    public OMCSSNamespaceRule clone(AbstractCSSStyleSheet parentSheet) {
        return new OMCSSNamespaceRule(parentSheet, this.getOrigin(), this.prefix, this.namespaceURI);
    }
}

