/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSMarginRule;
import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.OMCSSMarginRule;
import io.sf.carte.doc.style.css.om.PropertyDocumentHandler;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPageRule;

public class OMCSSPageRule
extends CSSStyleDeclarationRule
implements CSSPageRule,
ExtendedCSSRule {
    LinkedList<CSSMarginRule> marginRules = null;

    public OMCSSPageRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)6, origin);
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(30 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        String seltext = this.getSelectorText();
        if (seltext.length() != 0 || this.getStyle().getLength() != 0 || this.marginRules != null) {
            StringBuilder buf = new StringBuilder(96);
            buf.append("@page");
            if (seltext.length() != 0) {
                buf.append(' ').append(seltext);
            }
            String styleText = this.getStyle().getMinifiedCssText();
            buf.append('{').append(styleText);
            if (this.marginRules != null) {
                if (styleText.length() != 0) {
                    buf.append(';');
                }
                Iterator it = this.marginRules.iterator();
                while (it.hasNext()) {
                    buf.append(((ExtendedCSSRule)it.next()).getMinifiedCssText());
                }
            }
            buf.append('}');
            return buf.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        String seltext = this.getSelectorText();
        if (seltext.length() != 0 || this.getStyle().getLength() != 0 || this.marginRules != null) {
            context.startRule(wri);
            wri.write("@page");
            if (seltext.length() != 0) {
                wri.write(' ');
                wri.write(seltext);
            }
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            context.startStyleDeclaration(wri);
            this.getStyle().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endStyleDeclaration(wri);
            if (this.marginRules != null) {
                context.updateContext(this);
                for (ExtendedCSSRule extendedCSSRule : this.marginRules) {
                    extendedCSSRule.writeCssText(wri, context);
                }
                context.endCurrentContext(this);
                context.endRuleList(wri);
            }
            context.writeRightCurlyBracket(wri);
            context.endRule(wri);
        }
    }

    @Override
    public String getSelectorText() {
        return super.getSelectorText();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        cssText = cssText.trim();
        int len = cssText.length();
        int idx = cssText.indexOf(123);
        if (len < 10 || idx == -1) {
            throw new DOMException(12, "Invalid @page rule: " + cssText);
        }
        if (!ParseHelper.startsWithIgnoreCase(cssText, "@page")) {
            throw new DOMException(13, "Not a @page rule: " + cssText);
        }
        super.setCssText(cssText);
    }

    @Override
    protected PropertyDocumentHandler createDocumentHandler() {
        return new PageRuleDocumentHandler();
    }

    void addMarginRule(CSSMarginRule marginRule) {
        if (this.marginRules == null) {
            this.marginRules = new LinkedList();
        }
        this.marginRules.add(marginRule);
    }

    public LinkedList<CSSMarginRule> getMarginRules() {
        return this.marginRules;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.marginRules == null ? 0 : this.marginRules.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSPageRule other = (OMCSSPageRule)obj;
        return !(this.marginRules == null ? other.marginRules != null : !this.marginRules.equals(other.marginRules));
    }

    @Override
    public OMCSSPageRule clone(AbstractCSSStyleSheet parentSheet) {
        return (OMCSSPageRule)super.clone(parentSheet);
    }

    class PageRuleDocumentHandler
    extends CSSStyleDeclarationRule.RuleDocumentHandler {
        private OMCSSMarginRule currentMarginRule;

        PageRuleDocumentHandler() {
            super(OMCSSPageRule.this);
            this.currentMarginRule = null;
        }

        @Override
        public void startPage(String name, String pseudo_page) throws CSSException {
            if (name == null) {
                if (pseudo_page != null) {
                    Parser parser = OMCSSPageRule.this.createSACParser();
                    InputSource source = new InputSource((Reader)new StringReader(pseudo_page));
                    try {
                        OMCSSPageRule.this.setSelectorList(parser.parseSelectors(source));
                    }
                    catch (IOException iOException) {}
                } else {
                    OMCSSPageRule.this.setSelectorText("");
                }
            } else {
                this.currentMarginRule = new OMCSSMarginRule(OMCSSPageRule.this.getParentStyleSheet(), OMCSSPageRule.this.getOrigin(), name);
                this.currentMarginRule.setParentRule(OMCSSPageRule.this);
                this.setLexicalPropertyListener(this.currentMarginRule.getLexicalPropertyListener());
            }
        }

        @Override
        public void endPage(String name, String pseudo_page) throws CSSException {
            if (name != null) {
                OMCSSPageRule.this.addMarginRule(this.currentMarginRule);
                this.currentMarginRule = null;
                this.setLexicalPropertyListener(OMCSSPageRule.this.getLexicalPropertyListener());
            }
        }

        @Override
        public void startAtRule(String name, String pseudoSelector) {
            throw new DOMException(13, "Cannot set rule of type: " + name);
        }
    }
}

