/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class OMCSSViewportRule
extends BaseCSSDeclarationRule {
    public OMCSSViewportRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)15, origin);
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        return "@viewport{" + this.getStyle().getMinifiedCssText() + '}';
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        context.startRule(wri);
        wri.write("@viewport");
        context.updateContext(this);
        context.writeLeftCurlyBracket(wri);
        context.startStyleDeclaration(wri);
        this.getStyle().writeCssText(wri, context);
        context.endCurrentContext(this);
        context.endStyleDeclaration(wri);
        context.writeRightCurlyBracket(wri);
        context.endRule(wri);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        cssText = cssText.trim();
        int len = cssText.length();
        int idx = cssText.indexOf(123);
        if (len < 15 || cssText.charAt(len - 1) != '}' || idx == -1) {
            throw new DOMException(12, "Invalid @viewport rule: " + cssText);
        }
        if (!ParseHelper.startsWithIgnoreCase(cssText, "@viewport")) {
            throw new DOMException(12, "Not a @viewport rule: " + cssText);
        }
        String empty = cssText.substring(9, idx).trim();
        if (empty.length() != 0) {
            throw new DOMException(12, "Invalid @viewport rule: " + cssText);
        }
        super.setCssText(cssText);
    }

    @Override
    public OMCSSViewportRule clone(AbstractCSSStyleSheet parentSheet) {
        OMCSSViewportRule rule = new OMCSSViewportRule(parentSheet, this.getOrigin());
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle());
        return rule;
    }
}

