/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.MediaQueryListListener;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.MediaQuery;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

public class OMMediaList
implements MediaQueryList,
MediaListAccess,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final OMMediaList allMediaSingleton;
    private List<String> mediastringList;
    private List<String> mediaList;
    private boolean allMedia;
    private static final List<String> mediaTypes;

    private OMMediaList() {
        this.mediastringList = new ArrayList<String>(5);
        this.mediaList = new ArrayList<String>(5);
    }

    private OMMediaList(List<String> listRef, List<String> mediaList) {
        this.mediastringList = listRef;
        this.mediaList = mediaList;
    }

    public static OMMediaList createMediaList() {
        OMMediaList mlist = new OMMediaList();
        mlist.allMedia = true;
        return mlist;
    }

    public static OMMediaList createMediaList(String media) {
        OMMediaList mlist = new OMMediaList();
        mlist.setMediaText(media);
        return mlist;
    }

    public static OMMediaList createFromMediaList(MediaList list) {
        OMMediaList mlist = new OMMediaList();
        if (list == null) {
            mlist.allMedia = true;
        } else {
            mlist.allMedia = false;
            int mll = list.getLength();
            for (int i = 0; i < mll; ++i) {
                mlist.addMedium(list.item(i));
            }
        }
        return mlist;
    }

    public static OMMediaList createUnmodifiable() {
        return allMediaSingleton;
    }

    public static OMMediaList createUnmodifiable(String media) {
        if (media == null) {
            return OMMediaList.createUnmodifiable();
        }
        return new UnmodifiableMediaList(media);
    }

    public static OMMediaList createMediaList(SACMediaList media) {
        OMMediaList newlist = new OMMediaList();
        if (media == null) {
            newlist.allMedia = true;
        } else {
            int sz = media.getLength();
            for (int i = 0; i < sz; ++i) {
                newlist.appendMedium(media.item(i));
            }
        }
        return newlist;
    }

    @Override
    public String getMedia() {
        return this.getMediaText();
    }

    @Override
    public String getMediaText() {
        if (this.allMedia) {
            return "all";
        }
        StringBuilder sb = new StringBuilder(this.mediastringList.size() * 8 + 2);
        Iterator<String> it = this.mediastringList.iterator();
        if (it.hasNext()) {
            sb.append(MediaQuery.escapeIdentifier(it.next()));
        }
        while (it.hasNext()) {
            sb.append(',').append(MediaQuery.escapeIdentifier(it.next()));
        }
        return sb.toString();
    }

    @Override
    public String getMinifiedMedia() {
        return this.getMediaText();
    }

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        this.allMedia = false;
        this.mediastringList.clear();
        this.mediaList.clear();
        StringTokenizer st = new StringTokenizer(mediaText, ",");
        while (st.hasMoreElements()) {
            this.addMedium(ParseHelper.unescapeStringValue(st.nextToken().trim().toLowerCase(Locale.US)));
        }
    }

    void parseMediaText(String mediaText) {
        this.allMedia = false;
        StringTokenizer st = new StringTokenizer(mediaText, ",");
        while (st.hasMoreElements()) {
            this.addMedium(st.nextToken().trim().toLowerCase(Locale.US));
        }
    }

    @Override
    public int getLength() {
        if (this.allMedia) {
            return 0;
        }
        return this.mediastringList.size();
    }

    @Override
    public String item(int index) {
        try {
            return this.mediastringList.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            if (this.allMedia && index == 0) {
                return "all";
            }
            return null;
        }
    }

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        if (!this.mediastringList.remove(oldMedium = this.extractPlainMedium(oldMedium))) {
            throw new DOMException(8, oldMedium + " not in media list.");
        }
        this.mediaList.remove(oldMedium);
    }

    private String extractPlainMedium(String medium) {
        int idx = medium.indexOf(32);
        if (idx != -1) {
            medium = medium.substring(0, idx);
        }
        return medium;
    }

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        if (newMedium == null) {
            throw new DOMException(5, "Null medium");
        }
        String lcnm = newMedium.toLowerCase(Locale.US);
        this.addMedium(lcnm);
    }

    boolean isValidMedium(String lcmedia) {
        return mediaTypes.contains(lcmedia);
    }

    private void addMedium(String newMedium) {
        if ("all".equals(newMedium)) {
            this.allMedia = true;
            this.mediastringList.clear();
        } else {
            if (newMedium == null) {
                throw new NullPointerException("New medium cannot be null");
            }
            if (!"all".equals(newMedium = this.extractPlainMedium(newMedium))) {
                newMedium = newMedium.intern();
                this.mediastringList.add(newMedium);
                this.mediaList.add(newMedium);
                this.allMedia = false;
            }
        }
    }

    static boolean isPlainMedium(String newMedium) {
        for (int i = 0; i < newMedium.length(); ++i) {
            if (Character.isLetter(newMedium.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllMedia() {
        return this.allMedia;
    }

    @Override
    public boolean isNotAllMedia() {
        return false;
    }

    @Override
    public boolean hasErrors() {
        return false;
    }

    @Override
    public boolean match(SACMediaList sacMedia) {
        if (this.allMedia || sacMedia == null) {
            return true;
        }
        int sz = sacMedia.getLength();
        for (int i = 0; i < sz; ++i) {
            String iitem = sacMedia.item(i).toLowerCase(Locale.US);
            if (!this.mediastringList.contains(iitem) && !"all".equals(iitem)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(MediaList domMedia) {
        if (this.allMedia) {
            return true;
        }
        int sz = domMedia.getLength();
        for (int i = 0; i < sz; ++i) {
            String iitem = domMedia.item(i).toLowerCase(Locale.US);
            if (!this.mediastringList.contains(iitem) && !"all".equals(iitem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(String medium, CSSCanvas canvas) {
        if (this.allMedia) {
            return true;
        }
        if (medium == null) {
            return false;
        }
        if (medium.indexOf(32) != -1) {
            return this.mediastringList.contains(medium);
        }
        return this.mediaList.contains(medium);
    }

    @Override
    public void appendSACMediaList(SACMediaList sacMedia) {
        if (sacMedia != null) {
            int sz = sacMedia.getLength();
            for (int i = 0; i < sz; ++i) {
                this.appendMedium(sacMedia.item(i));
            }
        } else {
            this.allMedia = true;
            this.mediastringList.clear();
        }
    }

    @Override
    public OMMediaList unmodifiable() {
        if (this.allMedia) {
            return new UnmodifiableMediaList();
        }
        return new UnmodifiableMediaList(this);
    }

    public int hashCode() {
        int result = 1;
        if (this.mediastringList != null) {
            for (String media : this.mediastringList) {
                result += media.hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OMMediaList)) {
            return false;
        }
        OMMediaList other = (OMMediaList)obj;
        return !(this.mediastringList == null ? other.mediastringList != null : this.mediastringList.size() != other.mediastringList.size() || !this.mediastringList.containsAll(other.mediastringList));
    }

    public String toString() {
        return this.getMediaText();
    }

    @Override
    public void addListener(MediaQueryListListener listener) throws DOMException {
        throw new DOMException(9, "You should use CSSCanvas for this");
    }

    @Override
    public void removeListener(MediaQueryListListener listener) throws DOMException {
        throw new DOMException(9, "You should use CSSCanvas for this");
    }

    static {
        String[] mediaTypesArray = new String[]{"all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
        mediaTypes = Arrays.asList(mediaTypesArray);
        allMediaSingleton = new UnmodifiableMediaList();
        OMMediaList.allMediaSingleton.allMedia = true;
    }

    private static class UnmodifiableMediaList
    extends OMMediaList {
        private static final long serialVersionUID = 2L;

        private UnmodifiableMediaList() {
        }

        private UnmodifiableMediaList(String media) {
            this.parseMediaText(media);
        }

        private UnmodifiableMediaList(OMMediaList list) {
            super(list.mediastringList, list.mediaList);
        }

        @Override
        public void setMediaText(String mediaText) throws DOMException {
            throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }

        @Override
        public void appendMedium(String newMedium) throws DOMException {
            throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }

        @Override
        public void deleteMedium(String oldMedium) throws DOMException {
            throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }
    }
}

