/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleSheetList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.StyleSheet;

public abstract class OMStyleSheetList
implements StyleSheetList {
    private final List<CSSStyleSheet> list;
    private final MyDOMStringList styleSheetSets = new MyDOMStringList();
    private String preferredStyleSheetSet = "";
    private boolean needsUpdate;

    protected OMStyleSheetList(int initialCapacity) {
        this.list = new ArrayList<CSSStyleSheet>(initialCapacity);
        this.needsUpdate = true;
    }

    @Override
    public int getLength() {
        if (this.needsUpdate) {
            this.update();
        }
        return this.list.size();
    }

    @Override
    public CSSStyleSheet item(int index) {
        if (this.needsUpdate) {
            this.update();
        }
        if (index >= this.list.size() || index < 0) {
            return null;
        }
        return this.list.get(index);
    }

    public DOMStringList getStyleSheetSets() {
        return this.styleSheetSets;
    }

    public void add(CSSStyleSheet sheet) {
        if (sheet != null) {
            this.list.add(sheet);
            String title = sheet.getTitle();
            if (title != null && title.length() > 0) {
                this.styleSheetSets.add(title);
                if (!sheet.getDisabled() && this.preferredStyleSheetSet.length() == 0) {
                    this.preferredStyleSheetSet = title;
                }
            }
        }
    }

    public String getPreferredStyleSheetSet() {
        if (this.needsUpdate) {
            this.update();
        }
        return this.preferredStyleSheetSet;
    }

    public void remove(String title) {
        for (CSSStyleSheet sheet : this.list) {
            if (!title.equals(sheet.getTitle())) continue;
            this.list.remove(sheet);
        }
    }

    public boolean remove(StyleSheet sheet) {
        return this.list.remove(sheet);
    }

    protected Iterator<CSSStyleSheet> iterator() {
        return this.list.iterator();
    }

    protected void clear() {
        this.list.clear();
    }

    protected boolean needsUpdate() {
        return this.needsUpdate;
    }

    protected void setNeedsUpdate(boolean needsUpdate) {
        this.needsUpdate = needsUpdate;
    }

    protected void update() {
        this.styleSheetSets.clear();
        this.clear();
    }

    protected abstract boolean hasErrorsOrWarnings();

    class MyDOMStringList
    implements DOMStringList {
        private final TreeSet<String> titleSet = new TreeSet();

        MyDOMStringList() {
        }

        @Override
        public String item(int index) {
            if (OMStyleSheetList.this.needsUpdate) {
                OMStyleSheetList.this.update();
            }
            if (index >= this.titleSet.size() || index < 0) {
                return null;
            }
            Iterator<String> it = this.titleSet.iterator();
            String title = null;
            int i = 0;
            while (it.hasNext()) {
                String s = it.next();
                if (i == index) {
                    title = s;
                    break;
                }
                ++i;
            }
            return title;
        }

        @Override
        public int getLength() {
            if (OMStyleSheetList.this.needsUpdate) {
                OMStyleSheetList.this.update();
            }
            return this.titleSet.size();
        }

        @Override
        public boolean contains(String str) {
            return this.titleSet.contains(str);
        }

        private void add(String title) {
            this.titleSet.add(title);
        }

        private void clear() {
            this.titleSet.clear();
        }
    }
}

