/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.BoxValues;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSStyleSheetFactory;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.om.BoxModelHelper;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSNumberValue;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

abstract class SimpleBoxModel {
    SimpleBoxModel() {
    }

    protected abstract ComputedCSSStyle getComputedStyle();

    private StyleDatabase getStyleDatabase() {
        return this.getComputedStyle().getStyleDatabase();
    }

    private void computeSharedBoxValues(MyBoxValues box, short unitType) {
        CSSPropertyValueException e;
        ComputedCSSStyle styledecl = this.getComputedStyle();
        AbstractCSSValue cssval = styledecl.getCSSValue("margin-top");
        while (cssval.getCssValueType() == 0 && (styledecl = (ComputedCSSStyle)styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCSSValue("margin-top");
        }
        if (styledecl == null) {
            box.marginTop = 0.0f;
        } else if (cssval.getCssValueType() == 1) {
            box.marginTop = ((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() == 21 && "auto".equals(((CSSPrimitiveValue)((Object)cssval)).getStringValue()) ? 0.0f : this.computeMarginNumberValue(styledecl, "margin-top", (CSSPrimitiveValue)((Object)cssval), unitType);
        } else {
            e = new CSSPropertyValueException("Expected primitive value for margin-top, found " + cssval.getCssText());
            styledecl.getParentRule().getStyleDeclarationErrorHandler().wrongValue("margin-top", e);
            box.marginTop = 0.0f;
        }
        styledecl = this.getComputedStyle();
        cssval = styledecl.getCSSValue("margin-bottom");
        while (cssval.getCssValueType() == 0 && (styledecl = (ComputedCSSStyle)styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCSSValue("margin-bottom");
        }
        if (styledecl == null) {
            box.marginBottom = 0.0f;
        } else if (cssval.getCssValueType() == 1) {
            box.marginBottom = ((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() == 21 && "auto".equals(((CSSPrimitiveValue)((Object)cssval)).getStringValue()) ? 0.0f : this.computeMarginNumberValue(styledecl, "margin-bottom", (CSSPrimitiveValue)((Object)cssval), unitType);
        } else {
            e = new CSSPropertyValueException("Expected primitive value for margin-bottom, found " + cssval.getCssText());
            styledecl.getParentRule().getStyleDeclarationErrorHandler().wrongValue("margin-bottom", e);
            box.marginBottom = 0.0f;
        }
        box.paddingTop = this.computePaddingSubproperty(styledecl, "padding-top", unitType);
        box.paddingRight = this.computePaddingSubproperty(styledecl, "padding-right", unitType);
        box.paddingBottom = this.computePaddingSubproperty(styledecl, "padding-bottom", unitType);
        box.paddingLeft = this.computePaddingSubproperty(styledecl, "padding-left", unitType);
        box.borderTopWidth = this.findBorderWidthProperty(styledecl, "border-top-width", styledecl.getCSSValue("border-top-width"), unitType);
        box.borderBottomWidth = this.findBorderWidthProperty(styledecl, "border-bottom-width", styledecl.getCSSValue("border-bottom-width"), unitType);
        box.borderLeftWidth = this.findBorderWidthProperty(styledecl, "border-left-width", styledecl.getCSSValue("border-left-width"), unitType);
        box.borderRightWidth = this.findBorderWidthProperty(styledecl, "border-right-width", styledecl.getCSSValue("border-right-width"), unitType);
    }

    void computeInlineBox(MyBoxValues box, short unitType) throws StyleDatabaseRequiredException {
        CSSElement elm;
        CSSPropertyValueException e;
        ComputedCSSStyle styledecl = this.getComputedStyle();
        AbstractCSSValue cssval = styledecl.getCSSValue("margin-right");
        while (cssval.getCssValueType() == 0 && (styledecl = (ComputedCSSStyle)styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCSSValue("margin-right");
        }
        if (styledecl == null) {
            box.marginRight = 0.0f;
        } else if (cssval.getCssValueType() == 1) {
            if (((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() != 21 || !"auto".equals(((CSSPrimitiveValue)((Object)cssval)).getStringValue())) {
                box.marginRight = this.computeMarginNumberValue(styledecl, "margin-right", (CSSPrimitiveValue)((Object)cssval), unitType);
            }
        } else {
            e = new CSSPropertyValueException("Expected primitive value for margin-right, found " + cssval.getCssText());
            styledecl.getParentRule().getStyleDeclarationErrorHandler().wrongValue("margin-right", e);
            box.marginRight = 0.0f;
        }
        styledecl = this.getComputedStyle();
        cssval = styledecl.getCSSValue("margin-left");
        while (cssval.getCssValueType() == 0 && (styledecl = (ComputedCSSStyle)styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCSSValue("margin-left");
        }
        if (styledecl == null) {
            box.marginLeft = 0.0f;
        } else if (cssval.getCssValueType() == 1) {
            if (((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() != 21 || !"auto".equals(((CSSPrimitiveValue)((Object)cssval)).getStringValue())) {
                box.marginLeft = this.computeMarginNumberValue(styledecl, "margin-left", (CSSPrimitiveValue)((Object)cssval), unitType);
            }
        } else {
            e = new CSSPropertyValueException("Expected primitive value for margin-left, found " + cssval.getCssText());
            styledecl.getParentRule().getStyleDeclarationErrorHandler().wrongValue("margin-left", e);
            box.marginLeft = 0.0f;
        }
        Node node = styledecl.getOwnerNode();
        if (node != null && node.getNodeType() == 1 && "img".equals((elm = (CSSElement)node).getTagName()) && elm.hasAttribute("width")) {
            try {
                box.width = Float.parseFloat(elm.getAttribute("width"));
            }
            catch (NumberFormatException e2) {
                elm.getOwnerDocument().getStyleSheet().getErrorHandler().computedStyleError(elm, "width", elm.getAttribute("width"), "Could not parse value of 'width' attribute for img element");
            }
            if (unitType != 5) {
                box.width = CSSNumberValue.floatValueConversion(box.width, (short)5, unitType);
            }
        }
    }

    public BoxValues getComputedBox(short unitType) throws DOMException, StyleDatabaseRequiredException {
        String display = this.getComputedStyle().getDisplay();
        if ("block".equals(display) || "list-item".equals(display)) {
            MyBoxValues box = new MyBoxValues();
            this.computeSharedBoxValues(box, unitType);
            this.computeBlockBox(box, unitType);
            return box;
        }
        if ("table".equals(display)) {
            MyTableBoxValues box = new MyTableBoxValues();
            this.computeSharedBoxValues(box, unitType);
            String tableLayout = this.getComputedStyle().getPropertyValue("table-layout");
            if ("auto".equals(tableLayout)) {
                this.computeTableBox(box, unitType);
                return box;
            }
            this.computeBlockBox(box, unitType);
            return box;
        }
        if ("table-cell".equals(display) || "table-row".equals(display)) {
            MyTableItemBoxValues box = new MyTableItemBoxValues();
            this.computeTableCellBox(box, unitType);
            return box;
        }
        MyBoxValues box = new MyBoxValues();
        this.computeSharedBoxValues(box, unitType);
        this.computeInlineBox(box, unitType);
        return box;
    }

    void computeBlockBox(MyBoxValues box, short unitType) throws StyleDatabaseRequiredException {
        boolean margin_right_auto = false;
        ComputedCSSStyle styledecl = this.getComputedStyle();
        AbstractCSSValue cssval = styledecl.getCSSValue("margin-right");
        while (cssval.getCssValueType() == 0 && (styledecl = (ComputedCSSStyle)styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCSSValue("margin-right");
        }
        if (cssval.getCssValueType() == 1) {
            boolean bl = margin_right_auto = ((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() == 21 && "auto".equals(((CSSPrimitiveValue)((Object)cssval)).getStringValue());
            if (!margin_right_auto) {
                box.marginRight = this.computeMarginNumberValue(styledecl, "margin-right", (CSSPrimitiveValue)((Object)cssval), unitType);
            }
        } else {
            CSSPropertyValueException e = new CSSPropertyValueException("Expected primitive value for margin-right, found " + cssval.getCssText());
            styledecl.getParentRule().getStyleDeclarationErrorHandler().wrongValue("margin-right", e);
            box.marginRight = 0.0f;
        }
        styledecl = this.getComputedStyle();
        boolean margin_left_auto = false;
        cssval = styledecl.getCSSValue("margin-left");
        while (cssval.getCssValueType() == 0 && (styledecl = (ComputedCSSStyle)styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCSSValue("margin-left");
        }
        if (cssval.getCssValueType() == 1) {
            boolean bl = margin_left_auto = ((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() == 21 && "auto".equals(((CSSPrimitiveValue)((Object)cssval)).getStringValue());
            if (!margin_left_auto) {
                box.marginLeft = this.computeMarginNumberValue(styledecl, "margin-left", (CSSPrimitiveValue)((Object)cssval), unitType);
            }
        } else {
            CSSPropertyValueException e = new CSSPropertyValueException("Expected primitive value for margin-left, found " + cssval.getCssText());
            styledecl.getParentRule().getStyleDeclarationErrorHandler().wrongValue("margin-left", e);
            box.marginLeft = 0.0f;
        }
        if ((cssval = (styledecl = this.getComputedStyle()).getCSSValue("width")) == null || "auto".equals(cssval.getCssText())) {
            ComputedCSSStyle contblockStyledecl;
            if (margin_right_auto) {
                box.marginRight = 0.0f;
            }
            if (margin_left_auto) {
                box.marginLeft = 0.0f;
            }
            float contBlockWidth = (contblockStyledecl = this.findContainingBlockStyle(styledecl)) == null ? this.deviceDocumentWidth("width is auto, and cannot find top block width.", "auto") : this.computeWidth(contblockStyledecl, unitType);
            box.width = contBlockWidth - (box.marginLeft + box.marginRight + box.borderLeftWidth + box.borderRightWidth + box.paddingLeft + box.paddingRight);
        } else {
            box.width = this.computeNonAutoWidth(styledecl, cssval, unitType);
            ComputedCSSStyle contblockStyledecl = this.findContainingBlockStyle(styledecl);
            float contBlockWidth = contblockStyledecl == null ? this.deviceDocumentWidth("width is auto, and cannot find top block width.", "auto") : this.computeWidth(styledecl, unitType);
            float remMargin = contBlockWidth - box.width;
            remMargin -= box.borderLeftWidth + box.borderRightWidth + box.paddingLeft + box.paddingRight;
            if (margin_right_auto) {
                if (remMargin < 0.0f) {
                    box.marginRight = 0.0f;
                    box.marginLeft = 0.0f;
                } else if (margin_left_auto) {
                    box.marginLeft = box.marginRight = remMargin / 2.0f;
                } else if (remMargin < box.marginLeft) {
                    box.marginLeft = remMargin;
                    box.marginRight = 0.0f;
                } else {
                    box.marginRight = remMargin - box.marginLeft;
                }
            } else if (margin_left_auto) {
                if (remMargin < 0.0f) {
                    box.marginRight = 0.0f;
                    box.marginLeft = 0.0f;
                } else if (remMargin < box.marginRight) {
                    box.marginRight = remMargin;
                    box.marginLeft = 0.0f;
                } else {
                    box.marginLeft = remMargin;
                }
            } else if ((remMargin -= box.marginLeft + box.marginRight) < 0.0f) {
                if ("ltr".equals(styledecl.getPropertyValue("direction"))) {
                    box.marginRight = (remMargin += box.marginRight) > 0.0f ? remMargin : 0.0f;
                } else {
                    box.marginLeft = (remMargin += box.marginLeft) > 0.0f ? remMargin : 0.0f;
                }
            }
        }
    }

    private void computeTableBox(MyTableBoxValues box, short unitType) {
        block25: {
            float mincw;
            float[] minrcw;
            int ncol;
            float capmin;
            block23: {
                boolean unset;
                float maxcw;
                float[] maxrcw;
                block26: {
                    block24: {
                        this.computeBlockBox(box, unitType);
                        capmin = this.computeCapmin(unitType);
                        ComputedCSSStyle style = this.getComputedStyle();
                        CSSElement tbl = (CSSElement)style.getOwnerNode();
                        NodeList nlist = tbl.getElementsByTagName("tbody");
                        nlist = nlist.getLength() > 0 ? nlist.item(0).getChildNodes() : tbl.getChildNodes();
                        ncol = 0;
                        int nrows = nlist.getLength();
                        for (int i = 0; i < nrows; ++i) {
                            int rowcols;
                            CSSElement elm;
                            Node node = nlist.item(i);
                            if (node.getNodeType() != 1 || !"tr".equals((elm = (CSSElement)node).getTagName().toLowerCase(Locale.US)) || (rowcols = elm.getChildNodes().getLength()) <= ncol) continue;
                            ncol = rowcols;
                        }
                        minrcw = new float[ncol];
                        maxrcw = new float[ncol];
                        float maxRowSpacing = 0.0f;
                        for (int i = 0; i < nrows; ++i) {
                            CSSElement elm;
                            Node node = nlist.item(i);
                            if (node.getNodeType() != 1 || !"tr".equals((elm = (CSSElement)node).getTagName().toLowerCase(Locale.US))) continue;
                            style = (ComputedCSSStyle)elm.getOwnerDocument().getStyleSheet().getComputedStyle(elm, null);
                            BoxValues colbox = style.getBoxValues(unitType);
                            float rowSpacing = colbox.getBorderLeftWidth() + colbox.getBorderRightWidth() + colbox.getMarginLeft() + colbox.getMarginRight() + colbox.getPaddingLeft() + colbox.getPaddingRight();
                            if (maxRowSpacing < rowSpacing) {
                                maxRowSpacing = rowSpacing;
                            }
                            NodeList columns = elm.getChildNodes();
                            int nrowcols = columns.getLength();
                            int k = 0;
                            for (int j = 0; j < nrowcols; ++j) {
                                float[] contw;
                                Node colnode = columns.item(j);
                                if (colnode.getNodeType() != 1) continue;
                                CSSElement col = (CSSElement)colnode;
                                style = (ComputedCSSStyle)elm.getOwnerDocument().getStyleSheet().getComputedStyle(col, null);
                                if (!"table-cell".equals(style.getPropertyValue("display"))) continue;
                                int colspan = 1;
                                String colspanStr = col.getAttribute("colspan");
                                if (colspanStr.length() != 0) {
                                    colspan = Integer.parseInt(colspanStr);
                                }
                                if ((contw = this.computeChildContentWidth(col, colspan, style, unitType))[0] > maxrcw[k]) {
                                    maxrcw[k] = contw[0];
                                }
                                if (contw[1] > minrcw[k]) {
                                    minrcw[k] = contw[1];
                                }
                                k += colspan;
                            }
                        }
                        mincw = maxRowSpacing += box.getBorderLeftWidth() + box.getBorderRightWidth() + box.getMarginLeft() + box.getMarginRight() + box.getPaddingLeft() + box.getPaddingRight();
                        maxcw = maxRowSpacing;
                        for (int i = 0; i < ncol; ++i) {
                            mincw += minrcw[i];
                            maxcw += maxrcw[i];
                        }
                        box.colwidth = new float[ncol];
                        AbstractCSSValue cssval = style.getCSSValue("width");
                        if (cssval != null && !"auto".equals(cssval.getCssText())) break block23;
                        if (!(capmin < box.getWidth()) || !(maxcw < box.getWidth())) break block24;
                        if (maxcw > capmin) {
                            box.width = maxcw;
                            for (int i = 0; i < ncol; ++i) {
                                box.colwidth[i] = maxrcw[i];
                            }
                        } else {
                            box.width = capmin;
                            float factor = capmin / maxcw;
                            for (int i = 0; i < ncol; ++i) {
                                box.colwidth[i] = maxrcw[i] * factor;
                            }
                        }
                        break block25;
                    }
                    unset = true;
                    if (mincw > box.width) {
                        box.width = mincw;
                        for (int i = 0; i < ncol; ++i) {
                            box.colwidth[i] = minrcw[i];
                        }
                        unset = false;
                    }
                    if (!(capmin > box.width)) break block26;
                    float factor = capmin / box.width;
                    box.width = capmin;
                    int i = 0;
                    while (i < ncol) {
                        int n = i++;
                        box.colwidth[n] = box.colwidth[n] * factor;
                    }
                    break block25;
                }
                if (!unset) break block25;
                for (int i = 0; i < ncol; ++i) {
                    box.colwidth[i] = maxrcw[i];
                }
                BoxModelHelper.shrinkTo(box, minrcw, mincw, maxcw, box.width);
                float width = 0.0f;
                for (int i = 0; i < ncol; ++i) {
                    width += box.colwidth[i];
                }
                box.width = width;
                break block25;
            }
            if (mincw > box.width) {
                box.width = mincw;
                for (int i = 0; i < ncol; ++i) {
                    box.colwidth[i] = minrcw[i];
                }
            } else {
                float factor = box.width / mincw;
                for (int i = 0; i < ncol; ++i) {
                    box.colwidth[i] = minrcw[i] * factor;
                }
            }
            if (capmin > box.width) {
                float factor = capmin / box.width;
                box.width = capmin;
                int i = 0;
                while (i < ncol) {
                    int n = i++;
                    box.colwidth[n] = box.colwidth[n] * factor;
                }
            }
        }
    }

    private float computeCapmin(short unitType) {
        CSSCanvas canvas = ((CSSDocument)this.getComputedStyle().getOwnerNode().getOwnerDocument()).getCanvas();
        ComputedCSSStyle style = this.getComputedStyle();
        CSSElement tbl = (CSSElement)style.getOwnerNode();
        NodeList nlist = tbl.getElementsByTagName("caption");
        float capmin = 0.0f;
        for (int i = 0; i < nlist.getLength(); ++i) {
            CSSElement elm = (CSSElement)nlist.item(i);
            NodeList chldlist = elm.getChildNodes();
            for (int j = 0; j < chldlist.getLength(); ++j) {
                String text;
                Node chldnode = chldlist.item(j);
                if (chldnode.getNodeType() == 1) {
                    CSSElement col = (CSSElement)chldnode;
                    style = (ComputedCSSStyle)col.getOwnerDocument().getStyleSheet().getComputedStyle(col, null);
                    if (!"inline".equals(style.getDisplay())) {
                        throw new DOMException(9, "Only inline elements are supported in caption");
                    }
                    text = chldnode.getTextContent();
                } else {
                    text = chldnode.getNodeType() == 3 || chldnode.getNodeType() == 4 ? chldnode.getTextContent() : null;
                }
                float minw = 0.0f;
                if (text != null) {
                    text = BoxModelHelper.contractSpaces(text.trim());
                    minw = canvas != null ? CSSNumberValue.floatValueConversion(canvas.stringWidth(text, style), (short)9, unitType) : BoxModelHelper.computeNodeMinimumWidth(text, style, unitType);
                }
                if (!(minw > capmin)) continue;
                capmin = minw;
            }
        }
        return capmin;
    }

    private float[] computeChildContentWidth(CSSElement col, int colspan, ComputedCSSStyle style, short unitType) {
        float[] contw = new float[]{0.0f, 0.0f};
        NodeList nlist = col.getChildNodes();
        int sz = nlist.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = nlist.item(i);
            if (node.getNodeType() == 3) {
                float[] nodew = this.computeTextWidth(node.getTextContent(), colspan, style, unitType);
                contw[0] = contw[0] + nodew[0];
                contw[1] = contw[1] + nodew[1];
                continue;
            }
            if (node.getNodeType() != 1) continue;
            CSSElement elm = (CSSElement)node;
            style = (ComputedCSSStyle)elm.getOwnerDocument().getStyleSheet().getComputedStyle(elm, null);
            float width = this.computeWidth(style, unitType);
            contw[0] = contw[0] + width;
            contw[1] = contw[1] + width;
        }
        return contw;
    }

    private float[] computeTextWidth(String text, int colspan, ComputedCSSStyle style, short unitType) {
        float[] contw = new float[]{0.0f, 0.0f};
        text = BoxModelHelper.contractSpaces(text.trim());
        CSSCanvas canvas = ((CSSDocument)this.getComputedStyle().getOwnerNode().getOwnerDocument()).getCanvas();
        contw[0] = canvas != null ? CSSNumberValue.floatValueConversion(canvas.stringWidth(text, style), (short)9, unitType) : BoxModelHelper.computeTextWidth(text, style, unitType);
        BoxValues colbox = style.getBoxValues(unitType);
        float spacing = colbox.getBorderLeftWidth() + colbox.getBorderRightWidth() + colbox.getMarginLeft() + colbox.getMarginRight() + colbox.getPaddingLeft() + colbox.getPaddingRight();
        contw[0] = contw[0] + spacing;
        contw[1] = canvas != null ? BoxModelHelper.computeNodeMinimumWidth(text, style, canvas, unitType) / (float)colspan + spacing : BoxModelHelper.computeNodeMinimumWidth(text, style, unitType) / (float)colspan + spacing;
        return contw;
    }

    private void computeTableCellBox(MyBoxValues colbox, short unitType) {
        this.computeSharedBoxValues(colbox, unitType);
        this.computeInlineBox(colbox, unitType);
    }

    private float deviceDocumentWidth(String failureReason, String value) throws StyleDatabaseRequiredException {
        CSSCanvas canvas;
        CSSDocument doc = (CSSDocument)this.getComputedStyle().getOwnerNode().getOwnerDocument();
        if (doc != null && (canvas = doc.getCanvas()) != null && canvas.getViewport() != null) {
            return canvas.getViewport().getViewportWidth();
        }
        if (this.getStyleDatabase() == null) {
            StyleDatabaseRequiredException pve = new StyleDatabaseRequiredException("No style database, " + failureReason);
            pve.setValueText(value);
            throw pve;
        }
        return this.getStyleDatabase().getDeviceWidth();
    }

    private float computeMarginNumberValue(ComputedCSSStyle styledecl, String propertyName, CSSPrimitiveValue cssval, short unitType) throws StyleDatabaseRequiredException {
        float margin;
        short declType = cssval.getPrimitiveType();
        float fv = cssval.getFloatValue(declType);
        if (fv == 0.0f) {
            return 0.0f;
        }
        if (declType == 2) {
            if ((styledecl = this.findContainingBlockStyle(styledecl)) == null) {
                return this.deviceDocumentWidth("no enclosing block, and value is percentage.", cssval.getCssText()) * cssval.getFloatValue((short)2) / 100.0f;
            }
            return this.computeWidth(styledecl, unitType) * cssval.getFloatValue((short)2) / 100.0f;
        }
        if (unitType == declType) {
            margin = cssval.getFloatValue(unitType);
        } else if (cssval instanceof CSSNumberValue) {
            if (unitType < 0) {
                if (this.getStyleDatabase() == null) {
                    StyleDatabaseRequiredException sdex = new StyleDatabaseRequiredException("Requested natural unit, but no style database was set.");
                    sdex.setValueText(cssval.getCssText());
                    throw sdex;
                }
                unitType = this.getStyleDatabase().getNaturalUnit();
            }
            margin = cssval.getFloatValue(declType);
            if (declType != unitType) {
                margin = CSSNumberValue.floatValueConversion(margin, declType, unitType);
            }
        } else {
            CSSPropertyValueException e = new CSSPropertyValueException("Expected number, found " + cssval.getCssText());
            styledecl.getParentRule().getStyleDeclarationErrorHandler().wrongValue(propertyName, e);
            margin = 0.0f;
        }
        return margin;
    }

    private ComputedCSSStyle findContainingBlockStyle(ComputedCSSStyle styledecl) {
        String position = styledecl.getPropertyValue("position");
        if ("fixed".equals(position)) {
            return null;
        }
        if ("absolute".equals(position)) {
            throw new DOMException(9, "position: absolute is not supported");
        }
        String display = styledecl.getPropertyValue("display");
        if ("table-cell".equals(display)) {
            while ((styledecl = (ComputedCSSStyle)styledecl.getParentComputedStyle()) != null && !"table".equals(display = styledecl.getPropertyValue("display"))) {
            }
        } else {
            while (!((styledecl = (ComputedCSSStyle)styledecl.getParentComputedStyle()) == null || "block".equals(display = styledecl.getPropertyValue("display")) || "list-item".equals(display) || "table".equals(display) || display.startsWith("table-"))) {
            }
        }
        return styledecl;
    }

    private float computeWidth(ComputedCSSStyle styledecl, short unitType) throws StyleDatabaseRequiredException {
        AbstractCSSValue cssval = styledecl.getCSSValue("width");
        short type = cssval.getCssValueType();
        if (cssval == null || "auto".equals(cssval.getCssText()) || type != 1 && type != 0) {
            float contBlockWidth;
            AbstractCSSValue cssMarginLeft = styledecl.getCSSValue("margin-left");
            AbstractCSSValue cssBorderLeftWidth = styledecl.getCSSValue("border-left-width");
            AbstractCSSValue cssMarginRight = styledecl.getCSSValue("margin-right");
            AbstractCSSValue cssBorderRightWidth = styledecl.getCSSValue("border-right-width");
            float marginLeft = this.findWidthautoBoxProperty(styledecl, "margin-left", cssMarginLeft, unitType);
            float borderLeftWidth = this.findBorderWidthProperty(styledecl, "border-left-width", cssBorderLeftWidth, unitType);
            float paddingLeft = this.computePaddingSubproperty(styledecl, "padding-left", unitType);
            float paddingRight = this.computePaddingSubproperty(styledecl, "padding-right", unitType);
            float borderRightWidth = this.findBorderWidthProperty(styledecl, "border-right-width", cssBorderRightWidth, unitType);
            float marginRight = this.findWidthautoBoxProperty(styledecl, "margin-right", cssMarginRight, unitType);
            ComputedCSSStyle contblockStyledecl = this.findContainingBlockStyle(styledecl);
            if (contblockStyledecl == null) {
                contBlockWidth = this.deviceDocumentWidth("width is auto, and cannot find top block width.", "auto");
            } else {
                String display = contblockStyledecl.getPropertyValue("display");
                if ("table".equals(display) || display.startsWith("table-")) {
                    cssval = contblockStyledecl.getCSSValue("width");
                    if (cssval == null || "auto".equals(cssval.getCssText()) || ((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() == 2) {
                        throw new DOMException(9, "Automatic tables not supported by this box model");
                    }
                    contBlockWidth = this.computeNonAutoWidth(contblockStyledecl, cssval, unitType);
                } else {
                    contBlockWidth = this.computeWidth(contblockStyledecl, unitType);
                }
            }
            return contBlockWidth - (marginLeft + marginRight + borderLeftWidth + borderRightWidth + paddingLeft + paddingRight);
        }
        return this.computeNonAutoWidth(styledecl, cssval, unitType);
    }

    private float computeNonAutoWidth(ComputedCSSStyle styledecl, CSSValue cssval, short unitType) throws StyleDatabaseRequiredException {
        short type = cssval.getCssValueType();
        if (type == 0) {
            if ((styledecl = this.findContainingBlockStyle(styledecl)) == null) {
                return this.deviceDocumentWidth("and width value is inherit.", cssval.getCssText());
            }
            return this.computeWidth(styledecl, unitType);
        }
        CSSPrimitiveValue cssWidth = (CSSPrimitiveValue)cssval;
        short declType = cssWidth.getPrimitiveType();
        float width = cssWidth.getFloatValue(type);
        if (declType == 2) {
            if ((styledecl = (ComputedCSSStyle)styledecl.getParentComputedStyle()) == null) {
                width = width * this.deviceDocumentWidth("width is a percentage, and enclosing block width could not be found.", cssval.getCssText()) / 100.0f;
                declType = this.getStyleDatabase().getNaturalUnit();
            } else {
                return this.computeWidth(styledecl, unitType) * cssWidth.getFloatValue(type) / 100.0f;
            }
        }
        if (unitType < 0) {
            if (this.getStyleDatabase() == null) {
                StyleDatabaseRequiredException pve = new StyleDatabaseRequiredException("No style database, and requested natural unit type for 'width'.");
                pve.setValueText(cssval.getCssText());
                throw pve;
            }
            unitType = this.getStyleDatabase().getNaturalUnit();
        }
        if (unitType != declType) {
            width = CSSNumberValue.floatValueConversion(width, declType, unitType);
        }
        return width;
    }

    private float findWidthautoBoxProperty(ComputedCSSStyle styledecl, String propertyName, CSSValue cssval, short unitType) throws StyleDatabaseRequiredException, DOMException {
        if (cssval != null && !"auto".equals(cssval.getCssText())) {
            CSSPrimitiveValue cssprim;
            while (cssval.getCssValueType() == 0) {
                if ((styledecl = this.findContainingBlockStyle(styledecl)) != null) {
                    cssval = styledecl.getCSSValue(propertyName);
                    continue;
                }
                cssval = null;
                break;
            }
            if ((cssprim = (CSSPrimitiveValue)cssval) != null) {
                return this.findNumericBoxProperty(styledecl, propertyName, cssprim, unitType);
            }
        }
        return 0.0f;
    }

    private float findBorderWidthProperty(ComputedCSSStyle styledecl, String propertyName, CSSValue cssval, short unitType) throws StyleDatabaseRequiredException, DOMException {
        if (cssval != null) {
            CSSPrimitiveValue cssprim;
            while (cssval.getCssValueType() == 0) {
                if ((styledecl = this.findContainingBlockStyle(styledecl)) != null) {
                    cssval = styledecl.getCSSValue(propertyName);
                    continue;
                }
                cssval = null;
                break;
            }
            if ((cssprim = (CSSPrimitiveValue)cssval) != null) {
                if (cssprim.getPrimitiveType() == 21) {
                    short declType;
                    float fval;
                    if (this.getStyleDatabase() == null) {
                        if (this.getComputedStyle().getParentRule().getParentStyleSheet().getStyleSheetFactory().getComplianceMode() != CSSStyleSheetFactory.ComplianceMode.LENIENT) {
                            StyleDatabaseRequiredException pve = new StyleDatabaseRequiredException("No style database, and " + propertyName + " value is an identifier.");
                            pve.setValueText(cssval.getCssText());
                            throw pve;
                        }
                        int sz = this.getComputedStyle().getComputedFontSize();
                        String sv = cssprim.getStringValue();
                        fval = sv.equals("thin") ? (float)Math.floor(1.0 + (double)sz * 0.05) : (sv.equals("thick") ? (float)Math.floor(4.0 + (double)sz * 0.15) : (float)Math.floor(2.0 + (double)sz * 0.1));
                        declType = 9;
                    } else {
                        declType = this.getStyleDatabase().getNaturalUnit();
                        fval = this.getStyleDatabase().getWidthSize(cssprim.getStringValue(), styledecl.getComputedFontSize());
                    }
                    if (declType == unitType) {
                        return fval;
                    }
                    return CSSNumberValue.floatValueConversion(fval, declType, unitType);
                }
                return this.findNumericBoxProperty(styledecl, propertyName, cssprim, unitType);
            }
        }
        return 0.0f;
    }

    private float findNumericBoxProperty(ComputedCSSStyle styledecl, String propertyName, CSSPrimitiveValue cssprim, short unitType) throws StyleDatabaseRequiredException {
        short declType = cssprim.getPrimitiveType();
        float fv = cssprim.getFloatValue(declType);
        if (fv == 0.0f) {
            return 0.0f;
        }
        if (declType == 2) {
            ComputedCSSStyle contblockStyledecl = this.findContainingBlockStyle(styledecl);
            return this.computeWidth(contblockStyledecl, unitType) * cssprim.getFloatValue((short)2) / 100.0f;
        }
        if (unitType != declType) {
            if (unitType < 0) {
                if (this.getStyleDatabase() == null) {
                    StyleDatabaseRequiredException pve = new StyleDatabaseRequiredException("No style database, and requested natural unit type for " + propertyName + '.');
                    pve.setValueText(cssprim.getCssText());
                    throw pve;
                }
                unitType = this.getStyleDatabase().getNaturalUnit();
            }
            fv = CSSNumberValue.floatValueConversion(fv, declType, unitType);
        }
        return fv;
    }

    private float computePaddingSubproperty(ComputedCSSStyle styledecl, String subpropertyName, short unitType) throws StyleDatabaseRequiredException {
        AbstractCSSValue cssval = styledecl.getCSSValue(subpropertyName);
        while (cssval != null && cssval.getCssValueType() == 0) {
            if ((styledecl = (ComputedCSSStyle)styledecl.getParentComputedStyle()) != null) {
                cssval = styledecl.getCSSValue(subpropertyName);
                continue;
            }
            this.getComputedStyle().getParentRule().getStyleDeclarationErrorHandler().noContainingBlock(this.getComputedStyle().getDisplay(), this.getComputedStyle().getOwnerNode());
            return 0.0f;
        }
        if (cssval == null) {
            return 0.0f;
        }
        CSSPrimitiveValue csspri = (CSSPrimitiveValue)((Object)cssval);
        short declType = csspri.getPrimitiveType();
        float fv = csspri.getFloatValue(declType);
        if (fv == 0.0f) {
            return 0.0f;
        }
        if (declType == 2) {
            String display = styledecl.getPropertyValue("display");
            if ("table-cell".equals(display)) {
                do {
                    if ((styledecl = (ComputedCSSStyle)styledecl.getParentComputedStyle()) == null) {
                        this.getComputedStyle().getParentRule().getStyleDeclarationErrorHandler().noContainingBlock("table-cell", this.getComputedStyle().getOwnerNode());
                        float padding = 0.0f;
                        continue;
                    }
                    display = styledecl.getPropertyValue("display");
                } while (!"table".equals(display));
            } else {
                do {
                    if ((styledecl = (ComputedCSSStyle)styledecl.getParentComputedStyle()) == null) {
                        this.getComputedStyle().getParentRule().getStyleDeclarationErrorHandler().noContainingBlock(display, this.getComputedStyle().getOwnerNode());
                        float padding = 0.0f;
                        continue;
                    }
                    display = styledecl.getPropertyValue("display");
                } while (!"block".equals(display) && !"list-item".equals(display));
            }
            float parentWidth = this.computeWidth(styledecl, unitType);
            return parentWidth * csspri.getFloatValue((short)2) / 100.0f;
        }
        if (!(csspri instanceof CSSNumberValue)) {
            CSSPropertyValueException e = new CSSPropertyValueException("Expected number, found " + csspri.getCssText());
            styledecl.getParentRule().getStyleDeclarationErrorHandler().wrongValue(subpropertyName, e);
            return 0.0f;
        }
        float padding = csspri.getFloatValue(declType);
        if (padding != 0.0f && declType != unitType) {
            if (unitType < 0) {
                if (this.getStyleDatabase() == null) {
                    StyleDatabaseRequiredException sdex = new StyleDatabaseRequiredException("Requested natural unit, but no style database was set.");
                    sdex.setValueText(csspri.getCssText());
                    throw sdex;
                }
                unitType = this.getStyleDatabase().getNaturalUnit();
            }
            padding = CSSNumberValue.floatValueConversion(padding, declType, unitType);
        }
        return padding;
    }

    static class MyTableBoxValues
    extends MyBoxValues
    implements BoxValues.TableBoxValues {
        float[] colwidth;

        MyTableBoxValues() {
        }

        @Override
        public float[] getColumnsContentWidth() {
            return this.colwidth;
        }
    }

    static class MyTableItemBoxValues
    extends MyBoxValues {
        MyTableItemBoxValues() {
        }

        @Override
        public float getWidth() {
            throw new DOMException(9, "Operation not supported by this box model. Please compute box for table and cast to TableBoxValues.");
        }
    }

    static class MyBoxValues
    implements BoxValues {
        float marginTop = 0.0f;
        float marginRight = 0.0f;
        float marginBottom = 0.0f;
        float marginLeft = 0.0f;
        float paddingTop = 0.0f;
        float paddingRight = 0.0f;
        float paddingBottom = 0.0f;
        float paddingLeft = 0.0f;
        float borderTopWidth = 0.0f;
        float borderBottomWidth = 0.0f;
        float borderRightWidth = 0.0f;
        float borderLeftWidth = 0.0f;
        float width = Float.MIN_VALUE;

        MyBoxValues() {
        }

        @Override
        public float getMarginTop() {
            return this.marginTop;
        }

        @Override
        public float getMarginRight() {
            return this.marginRight;
        }

        @Override
        public float getMarginBottom() {
            return this.marginBottom;
        }

        @Override
        public float getMarginLeft() {
            return this.marginLeft;
        }

        @Override
        public float getPaddingTop() {
            return this.paddingTop;
        }

        @Override
        public float getPaddingRight() {
            return this.paddingRight;
        }

        @Override
        public float getPaddingBottom() {
            return this.paddingBottom;
        }

        @Override
        public float getPaddingLeft() {
            return this.paddingLeft;
        }

        @Override
        public float getBorderTopWidth() {
            return this.borderTopWidth;
        }

        @Override
        public float getBorderRightWidth() {
            return this.borderRightWidth;
        }

        @Override
        public float getBorderBottomWidth() {
            return this.borderBottomWidth;
        }

        @Override
        public float getBorderLeftWidth() {
            return this.borderLeftWidth;
        }

        @Override
        public float getWidth() {
            return this.width;
        }
    }
}

