/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.CSSRuleListener;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleSheetList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DOMCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DOMCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.DOMNode;
import io.sf.carte.doc.style.css.om.DOMSelectorMatcher;
import io.sf.carte.doc.style.css.om.DOMUtil;
import io.sf.carte.doc.style.css.om.InlineStyle;
import io.sf.carte.doc.style.css.om.MediaQueryFactory;
import io.sf.carte.doc.style.css.om.OMMediaList;
import io.sf.carte.doc.style.css.om.OMStyleSheetList;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.ElementCSSInlineStyle;
import org.w3c.dom.stylesheets.LinkStyle;

public abstract class StylableDocumentWrapper
extends DOMNode
implements CSSDocument,
CSSRuleListener {
    private final Document document;
    private Map<Node, CSSNode> nodemap = new HashMap<Node, CSSNode>();
    private DocumentCSSStyleSheet mergedStyleSheet = null;
    Set<LinkStyleDefiner> linkedStyle = new LinkedHashSet<LinkStyleDefiner>(4);
    Set<LinkStyleDefiner> embeddedStyle = new LinkedHashSet<LinkStyleDefiner>(3);
    private final OMStyleSheetList sheets = new MyOMStyleSheetList(7);
    private String metaDefaultStyleSet = "";
    private String metaReferrerPolicy = "";
    private String lastStyleSheetSet = null;
    private String targetMedium = null;
    private final Map<String, CSSCanvas> canvases = new HashMap<String, CSSCanvas>(3);

    protected StylableDocumentWrapper(Document document) {
        super(document);
        this.document = document;
    }

    protected abstract DOMCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public CSSDocument getOwnerDocument() {
        return null;
    }

    @Override
    protected CSSNode getMappedCSSNode(Node node) {
        return this.nodemap.get(node);
    }

    @Override
    protected CSSNode getCSSNode(Node node) {
        CSSNode mynode = this.getMappedCSSNode(node);
        if (mynode == null) {
            switch (node.getNodeType()) {
                case 2: {
                    mynode = new MyAttr((Attr)node);
                    break;
                }
                case 1: {
                    Element el = (Element)node;
                    String name = el.getNodeName();
                    if (name != null) {
                        if ("link".equals(name = name.toLowerCase(Locale.US))) {
                            mynode = new LinkElement((Element)node);
                            this.onStyleModify();
                            break;
                        }
                        if ("style".equals(name)) {
                            mynode = new StyleElement((Element)node);
                            this.onStyleModify();
                            break;
                        }
                    }
                    mynode = new MyElement((Element)node);
                    break;
                }
                case 3: {
                    mynode = new MyText((Text)node);
                    break;
                }
                case 4: {
                    mynode = new MyCDATASection((CDATASection)node);
                    break;
                }
                case 8: {
                    mynode = new MyComment((Comment)node);
                    break;
                }
                case 10: {
                    mynode = new MyDocumentType((DocumentType)node);
                    break;
                }
                case 7: {
                    if ("xml-stylesheet".equals(node.getNodeName())) {
                        mynode = new MyStyleProcessingInstruction((ProcessingInstruction)node);
                        this.onStyleModify();
                        break;
                    }
                    mynode = new MyProcessingInstruction((ProcessingInstruction)node);
                    break;
                }
                case 5: {
                    mynode = new MyEntityReference((EntityReference)node);
                    break;
                }
                default: {
                    mynode = new MyNode(node);
                }
            }
            this.nodemap.put(node, mynode);
        }
        return mynode;
    }

    @Override
    public DocumentType getDoctype() {
        return (DocumentType)((Object)this.getCSSNode(this.document.getDoctype()));
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    @Override
    public boolean isVisitedURI(String href) {
        return false;
    }

    public abstract void setLoadingTime(long var1);

    @Override
    public CSSElement getDocumentElement() {
        Element elm = this.document.getDocumentElement();
        return elm != null ? (CSSElement)this.getCSSNode(elm) : null;
    }

    LinkStyleDefiner getEmbeddedStyleDefiner(CSSElement element) {
        if (element != null) {
            return this.getEmbeddedStyleDefiner(element.getId());
        }
        return null;
    }

    private MediaQueryList parseMediaList(String media) {
        MediaQueryList mediaList;
        if (media.length() == 0) {
            mediaList = OMMediaList.createMediaList();
        } else {
            mediaList = MediaQueryFactory.createMediaList(media);
            if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                this.getStyleSheetFactory().getErrorHandler().mediaQueryError(media);
                return null;
            }
        }
        return mediaList;
    }

    private DOMCSSStyleSheet parseEmbeddedStyleSheet(String styleText, String title, String media, Node ownerNode) {
        MediaQueryList mediaList = this.parseMediaList(media.trim());
        if (mediaList != null) {
            DOMCSSStyleSheet sheet = this.getStyleSheetFactory().createLinkedStyleSheet(ownerNode, title, mediaList);
            if (styleText.length() != 0) {
                sheet.setHref(this.getBaseURI());
                InputSource source = new InputSource();
                StringReader re = new StringReader(styleText);
                source.setCharacterStream((Reader)re);
                try {
                    sheet.parseCSSStyleSheet(source);
                }
                catch (Exception e) {
                    this.getStyleSheetFactory().getErrorHandler().onException(e, sheet);
                }
            }
            return sheet;
        }
        return null;
    }

    private DOMCSSStyleSheet loadStyleSheet(String href, String title, String media, Node ownerNode) {
        MediaQueryList mediaList = this.parseMediaList(media.trim());
        if (mediaList != null) {
            String referrerPolicy = this.getReferrerpolicyAttribute(ownerNode);
            DOMCSSStyleSheet sheet = this.getStyleSheetFactory().createLinkedStyleSheet(ownerNode, title, mediaList);
            try {
                URL url = this.getURL(href);
                sheet.setHref(url.toExternalForm());
                sheet.loadStyleSheet(url, referrerPolicy);
            }
            catch (Exception e) {
                this.getStyleSheetFactory().getErrorHandler().onException(e, sheet);
            }
            return sheet;
        }
        return null;
    }

    private String getReferrerpolicyAttribute(Node node) {
        Node rp;
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null && (rp = nnm.getNamedItem("referrerpolicy")) != null) {
            return rp.getNodeValue();
        }
        return "";
    }

    @Override
    public CSSElement createElement(String tagName) throws DOMException {
        return (CSSElement)this.getCSSNode(this.document.createElement(tagName));
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public Text createTextNode(String data) {
        return (Text)((Object)this.getCSSNode(this.document.createTextNode(data)));
    }

    @Override
    public Comment createComment(String data) {
        return (Comment)((Object)this.getCSSNode(this.document.createComment(data)));
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return (CDATASection)((Object)this.getCSSNode(this.document.createCDATASection(data)));
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return (Attr)((Object)this.getCSSNode(this.document.createAttribute(name)));
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        return (EntityReference)((Object)this.getCSSNode(this.document.createEntityReference(name)));
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public CSSElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return (CSSElement)this.getCSSNode(this.document.createElementNS(namespaceURI, qualifiedName));
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return (Attr)((Object)this.getCSSNode(this.document.createAttributeNS(namespaceURI, qualifiedName)));
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return new DOMNode.MyNodeList(this, this.document.getElementsByTagName(tagname));
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new DOMNode.MyNodeList(this, this.document.getElementsByTagNameNS(namespaceURI, localName));
    }

    @Override
    public CSSElement getElementById(String elementId) {
        Element elm = this.document.getElementById(elementId);
        return elm != null ? (CSSElement)this.getCSSNode(elm) : null;
    }

    @Override
    public String getInputEncoding() {
        return this.document.getInputEncoding();
    }

    @Override
    public String getXmlEncoding() {
        return this.document.getXmlEncoding();
    }

    @Override
    public boolean getXmlStandalone() {
        return this.document.getXmlStandalone();
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public String getXmlVersion() {
        return this.document.getXmlVersion();
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.document.getStrictErrorChecking();
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public String getDocumentURI() {
        return this.document.getDocumentURI();
    }

    @Override
    public void setDocumentURI(String documentURI) {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.document.getDomConfig();
    }

    @Override
    public void normalizeDocument() {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public StyleSheetList getStyleSheets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets;
    }

    void updateStyleLists() {
        this.linkedStyle.clear();
        this.embeddedStyle.clear();
        this.updateStyleFromProcessingInstructions();
        if (this.linkedStyle.isEmpty() && this.embeddedStyle.isEmpty() || this.isHTML()) {
            this.updateStyleFromHTMLElements();
        }
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            this.addLinkedSheet(links.next().getSheet());
        }
        Iterator<LinkStyleDefiner> embd = this.embeddedStyle.iterator();
        while (embd.hasNext()) {
            this.addLinkedSheet(embd.next().getSheet());
        }
        this.sheets.setNeedsUpdate(false);
        if (this.lastStyleSheetSet != null) {
            this.setSelectedStyleSheetSet(this.lastStyleSheetSet);
        } else if (this.metaDefaultStyleSet.length() > 0) {
            this.setSelectedStyleSheetSet(this.metaDefaultStyleSet);
        } else {
            this.setSelectedStyleSheetSet(this.sheets.getPreferredStyleSheetSet());
        }
        if (this.getCanvas() != null) {
            this.getCanvas().reloadStyleState();
        }
    }

    private void updateStyleFromProcessingInstructions() {
        NodeList child = this.document.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            Node node = child.item(i);
            short type = node.getNodeType();
            if (type == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction pi;
                String href;
                CSSNode mynode = this.getMappedCSSNode(node);
                if (mynode == null) {
                    mynode = new MyStyleProcessingInstruction((ProcessingInstruction)node);
                    this.nodemap.put(node, mynode);
                }
                if ((href = (pi = (LinkStyleProcessingInstruction)((Object)mynode)).getPseudoAttribute("href")).length() <= 1) continue;
                if (href.charAt(0) == '#') {
                    this.embeddedStyle.add(pi);
                    continue;
                }
                this.linkedStyle.add(pi);
                continue;
            }
            if (type == 1) break;
        }
    }

    private boolean isHTML() {
        Element docelm = this.document.getDocumentElement();
        return docelm != null && "html".equalsIgnoreCase(docelm.getTagName());
    }

    private void updateStyleFromHTMLElements() {
        CSSNode mynode;
        Node n;
        int i;
        NodeList nl = this.document.getElementsByTagName("link");
        int len = nl.getLength();
        for (i = 0; i < len; ++i) {
            LinkStyleDefiner link;
            n = nl.item(i);
            if (!this.linkedStyle.isEmpty() && this.isAlreadyLoaded(this.linkedStyle, ((Element)n).getAttribute("href"))) continue;
            mynode = this.getMappedCSSNode(n);
            if (mynode == null) {
                mynode = new LinkElement((Element)n);
                this.nodemap.put(n, mynode);
            }
            if ((link = (LinkStyleDefiner)((Object)mynode)).getSheet() == null) continue;
            this.linkedStyle.add(link);
        }
        nl = this.document.getElementsByTagName("style");
        len = nl.getLength();
        for (i = 0; i < len; ++i) {
            n = nl.item(i);
            if (!this.embeddedStyle.isEmpty() && this.isAlreadyLoaded(this.embeddedStyle, ((Element)n).getAttribute("id"))) continue;
            mynode = this.getMappedCSSNode(n);
            if (mynode == null) {
                mynode = new StyleElement((Element)n);
                this.nodemap.put(n, mynode);
            }
            this.embeddedStyle.add((LinkStyleDefiner)((Object)mynode));
        }
    }

    private boolean isAlreadyLoaded(Set<LinkStyleDefiner> definerSet, String href) {
        for (LinkStyleDefiner definer : definerSet) {
            if (!(definer instanceof LinkStyleProcessingInstruction) || !((LinkStyleProcessingInstruction)definer).isSameSheet(href)) continue;
            return true;
        }
        return false;
    }

    private void addLinkedSheet(CSSStyleSheet linkedSheet) {
        if (linkedSheet != null) {
            this.sheets.add(linkedSheet);
        }
    }

    private LinkStyleDefiner getEmbeddedStyleDefiner(String id) {
        NodeList child = this.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            Node node = child.item(i);
            short type = node.getNodeType();
            if (type == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction pi = (LinkStyleProcessingInstruction)node;
                String href = pi.getPseudoAttribute("href");
                if (href.length() <= 1 || href.charAt(0) != '#') continue;
                return pi;
            }
            if (type == 1) break;
        }
        return null;
    }

    @Override
    public DocumentCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        this.getStyleSheets();
        this.mergedStyleSheet = this.targetMedium == null ? this.getStyleSheetFactory().getDefaultStyleSheet().clone() : this.getStyleSheetFactory().getDefaultStyleSheet().clone(this.targetMedium);
        ((BaseDocumentCSSStyleSheet)this.mergedStyleSheet).setOwnerDocument(this);
        Iterator<CSSStyleSheet> it = this.sheets.iterator();
        while (it.hasNext()) {
            this.mergedStyleSheet.addStyleSheet((AbstractCSSStyleSheet)it.next());
        }
    }

    @Override
    public DOMStringList getStyleSheetSets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets.getStyleSheetSets();
    }

    @Override
    public String getSelectedStyleSheetSet() {
        String selectedSetName = "";
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equals(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        return selectedSetName;
    }

    @Override
    public void setSelectedStyleSheetSet(String name) {
        if (name == null || name.length() > 0 && !this.getStyleSheetSets().contains(name)) {
            return;
        }
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0) continue;
            if (title.equals(name)) {
                sheet.setDisabled(false);
                this.lastStyleSheetSet = name;
                continue;
            }
            sheet.setDisabled(true);
        }
    }

    @Override
    public String getLastStyleSheetSet() {
        return this.lastStyleSheetSet;
    }

    @Override
    public void enableStyleSheetsForSet(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || !title.equals(name)) continue;
            sheet.setDisabled(false);
        }
    }

    void onStyleModify() {
        if (this.mergedStyleSheet != null) {
            this.mergedStyleSheet = null;
            this.sheets.setNeedsUpdate(true);
        } else if (this.sheets != null) {
            this.sheets.setNeedsUpdate(true);
        }
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        if (elt instanceof MyElement) {
            return ((MyElement)elt).getOverrideStyle(pseudoElt);
        }
        return null;
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        StyleDatabase sdb = null;
        if (this.targetMedium != null) {
            sdb = this.getStyleSheetFactory().getDeviceFactory().getStyleDatabase(this.targetMedium);
        }
        return sdb;
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public void setTargetMedium(String medium) throws CSSMediaException {
        this.targetMedium = "all".equals(medium = medium.intern()) ? null : medium;
        this.onStyleModify();
    }

    @Override
    public CSSCanvas getCanvas() {
        if (this.targetMedium == null) {
            return null;
        }
        if (this.canvases.containsKey(this.targetMedium)) {
            return this.canvases.get(this.targetMedium);
        }
        CSSCanvas canvas = this.getStyleSheetFactory().getDeviceFactory().createCanvas(this.targetMedium, this);
        this.canvases.put(this.targetMedium, canvas);
        return canvas;
    }

    @Override
    public boolean hasStyleIssues() {
        return this.sheets.hasErrorsOrWarnings();
    }

    @Override
    public void onFontFaceRule(CSSFontFaceRule rule) {
        for (CSSCanvas canvas : this.canvases.values()) {
            if (canvas == null) continue;
            canvas.loadFontFace(rule);
        }
    }

    @Override
    public void onPageRule(CSSPageRule rule) {
    }

    @Override
    public URL getBaseURL() {
        String buri = this.getBaseURI();
        if (buri == null) {
            return null;
        }
        try {
            return new URL(buri);
        }
        catch (MalformedURLException e) {
            try {
                return new URL(this.document.getDocumentURI());
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    @Override
    public String getBaseURI() {
        String docuri;
        String buri = this.document.getBaseURI();
        buri = null;
        if (buri == null) {
            String s;
            NodeList nl;
            String attr;
            Element elm = this.getDocumentElement();
            if (elm != null && (attr = elm.getAttribute("xml:base")).length() != 0) {
                buri = attr;
            }
            if (buri == null && (nl = this.document.getElementsByTagName("base")).getLength() > 0 && (s = (elm = (Element)nl.item(0)).getAttribute("href").trim()).length() != 0) {
                buri = s;
            }
        }
        if (buri == null) {
            buri = this.document.getDocumentURI();
        } else if (buri.indexOf("://") == -1 && (docuri = this.document.getDocumentURI()) != null) {
            try {
                URL url = new URL(docuri);
                url = new URL(url, buri);
                buri = url.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return buri;
    }

    @Override
    public URL getURL(String uri) throws MalformedURLException {
        if (uri.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        URL url = uri.indexOf("://") < 0 ? new URL(this.getBaseURL(), uri) : new URL(uri);
        return url;
    }

    @Override
    public boolean isSafeOrigin(URL linkedURL) {
        URL base = this.getBaseURL();
        String docHost = base.getHost();
        int docPort = base.getPort();
        if (docPort == -1) {
            docPort = base.getDefaultPort();
        }
        String linkedHost = linkedURL.getHost();
        int linkedPort = linkedURL.getPort();
        if (linkedPort == -1) {
            linkedPort = linkedURL.getDefaultPort();
        }
        return (docHost.equalsIgnoreCase(linkedHost) || linkedHost.endsWith(docHost)) && docPort == linkedPort;
    }

    @Override
    public String getReferrerPolicy() {
        NodeList nl = this.document.getElementsByTagName("meta");
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            String policy;
            Element el = (Element)nl.item(i);
            if (!"referrer".equalsIgnoreCase(el.getAttribute("name")) || (policy = el.getAttribute("content")).length() == 0) continue;
            this.metaReferrerPolicy = policy;
            break;
        }
        return this.metaReferrerPolicy;
    }

    protected void setReferrerPolicyHeader(String policy) {
        if (this.metaReferrerPolicy.length() == 0) {
            this.metaReferrerPolicy = policy;
        }
    }

    class MyOMStyleSheetList
    extends OMStyleSheetList {
        protected MyOMStyleSheetList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected boolean hasErrorsOrWarnings() {
            boolean hasRuleErrors = false;
            Iterator<CSSStyleSheet> it = this.iterator();
            while (it.hasNext()) {
                AbstractCSSStyleSheet sheet = (AbstractCSSStyleSheet)it.next();
                SheetErrorHandler eh = sheet.getErrorHandler();
                if (!sheet.hasRuleErrorsOrWarnings() && !eh.hasSacErrors() && !eh.hasSacWarnings() && !eh.hasOMErrors()) continue;
                hasRuleErrors = true;
                break;
            }
            return hasRuleErrors;
        }

        @Override
        protected void update() {
            super.update();
            StylableDocumentWrapper.this.updateStyleLists();
        }
    }

    class StyleElement
    extends MyElement
    implements LinkStyleDefiner {
        private DOMCSSStyleSheet linkedSheet;

        StyleElement(Element element) {
            super(element);
            this.linkedSheet = null;
        }

        @Override
        public DOMCSSStyleSheet getSheet() {
            if (this.linkedSheet == null) {
                String type = this.getAttribute("type");
                if (!"text/css".equals(type)) {
                    return null;
                }
                this.linkedSheet = StylableDocumentWrapper.this.parseEmbeddedStyleSheet(this.getTextContent().trim(), this.getAttribute("title"), this.getAttribute("media"), this);
            }
            return this.linkedSheet;
        }

        @Override
        public void resetLinkedSheet() {
            this.linkedSheet = null;
            StylableDocumentWrapper.this.onStyleModify();
        }
    }

    class LinkElement
    extends MyElement
    implements LinkStyleDefiner {
        private DOMCSSStyleSheet linkedSheet;

        LinkElement(Element element) {
            super(element);
            this.linkedSheet = null;
        }

        @Override
        public DOMCSSStyleSheet getSheet() {
            if (this.linkedSheet == null) {
                String type = this.getAttribute("type");
                if (type.length() != 0 && !"text/css".equals(type)) {
                    return null;
                }
                String rel = this.getAttribute("rel");
                if (rel.length() > 0) {
                    String href;
                    String lcrel;
                    String title = this.getAttribute("title");
                    if (title.length() == 0) {
                        title = null;
                    }
                    if ((lcrel = rel.toLowerCase(Locale.US)).equals("stylesheet")) {
                        String href2 = this.getAttribute("href");
                        if (href2.length() > 0) {
                            this.linkedSheet = StylableDocumentWrapper.this.loadStyleSheet(href2, title, this.getAttribute("media"), this);
                        }
                    } else if (lcrel.equals("alternate stylesheet") && title != null && (href = this.getAttribute("href")).length() > 0) {
                        this.linkedSheet = StylableDocumentWrapper.this.loadStyleSheet(href, title, this.getAttribute("media"), this);
                        if (this.linkedSheet != null) {
                            this.linkedSheet.setDisabled(true);
                        }
                    }
                }
            }
            return this.linkedSheet;
        }

        @Override
        public void resetLinkedSheet() {
            this.linkedSheet = null;
            StylableDocumentWrapper.this.onStyleModify();
        }
    }

    class MyElement
    extends MyNode
    implements CSSElement,
    ElementCSSInlineStyle {
        private final Element element;
        WeakReference<SelectorMatcher> selectorMatcherRef;
        private Map<String, InlineStyle> overrideStyleSet;

        MyElement(Element element) {
            super(element);
            this.selectorMatcherRef = null;
            this.overrideStyleSet = null;
            this.element = element;
        }

        @Override
        public String getTagName() {
            return this.element.getTagName();
        }

        @Override
        public String getId() {
            return this.element.getAttribute("id");
        }

        @Override
        public String getAttribute(String name) {
            return this.element.getAttribute(name);
        }

        @Override
        public void setAttribute(String name, String value) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public void removeAttribute(String name) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public Attr getAttributeNode(String name) {
            Attr anode = this.element.getAttributeNode(name);
            if (anode == null) {
                return null;
            }
            return (Attr)((Object)this.getCSSNode(anode));
        }

        @Override
        public Attr setAttributeNode(Attr newAttr) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public NodeList getElementsByTagName(String name) {
            return new DOMNode.MyNodeList(this, this.element.getElementsByTagName(name));
        }

        @Override
        public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
            return this.element.getAttributeNS(namespaceURI, localName);
        }

        @Override
        public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
            return this.element.getAttributeNodeNS(namespaceURI, localName);
        }

        @Override
        public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
            return new DOMNode.MyNodeList(this, this.element.getElementsByTagNameNS(namespaceURI, localName));
        }

        @Override
        public boolean hasAttribute(String name) {
            return this.element.hasAttribute(name);
        }

        @Override
        public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
            return this.element.hasAttributeNS(namespaceURI, localName);
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return this.element.getSchemaTypeInfo();
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public SelectorMatcher getSelectorMatcher() {
            SelectorMatcher matcher = null;
            if (this.selectorMatcherRef != null) {
                matcher = (SelectorMatcher)this.selectorMatcherRef.get();
            }
            if (matcher == null) {
                matcher = new DOMSelectorMatcher(this);
                this.selectorMatcherRef = new WeakReference<SelectorMatcher>(matcher);
            }
            return matcher;
        }

        @Override
        public boolean matches(String selectorString, String pseudoElement) throws DOMException {
            SelectorList list;
            Parser parser = SACParserFactory.createSACParser();
            InputSource source = new InputSource((Reader)new StringReader(selectorString));
            try {
                list = parser.parseSelectors(source);
            }
            catch (Exception e) {
                throw new DOMException(12, "Unable to parse selector in: " + selectorString);
            }
            return this.matches(list, pseudoElement);
        }

        @Override
        public boolean matches(SelectorList selist, String pseudoElement) {
            SelectorMatcher matcher = this.getSelectorMatcher();
            matcher.setPseudoElement(pseudoElement);
            return matcher.matches(selist) != -1;
        }

        @Override
        public CSSStyleDeclaration getStyle() {
            InlineStyle styledecl = StylableDocumentWrapper.this.getStyleSheetFactory().createInlineStyle(this);
            String st = this.getAttribute("style");
            if (st.length() > 0) {
                try {
                    styledecl.setCssText(st);
                }
                catch (DOMException e) {
                    StylableDocumentWrapper.this.getStyleSheetFactory().getErrorHandler().onException((Exception)e, st);
                }
            }
            return styledecl;
        }

        @Override
        public boolean hasPresentationalHints() {
            return false;
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
        }

        boolean hasOverrideStyle(String pseudoElt) {
            if (this.overrideStyleSet == null) {
                return false;
            }
            return this.overrideStyleSet.containsKey(pseudoElt);
        }

        CSSStyleDeclaration getOverrideStyle(String pseudoElt) {
            InlineStyle overrideStyle = null;
            if (this.overrideStyleSet == null) {
                this.overrideStyleSet = new HashMap<String, InlineStyle>(1);
            } else {
                overrideStyle = this.overrideStyleSet.get(pseudoElt);
            }
            if (overrideStyle == null) {
                overrideStyle = StylableDocumentWrapper.this.getStyleSheetFactory().createInlineStyle(this);
                this.overrideStyleSet.put(pseudoElt, overrideStyle);
            }
            return overrideStyle;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append('<').append(this.getTagName());
            NamedNodeMap nodeMap = this.getAttributes();
            int len = nodeMap.getLength();
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    Node node = nodeMap.item(i);
                    buf.append(' ');
                    buf.append(node.getNodeName()).append("='").append(node.getNodeValue());
                }
            }
            if (this.hasChildNodes()) {
                buf.append('>');
                NodeList list = this.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    buf.append(list.item(i).toString());
                }
                buf.append("</").append(this.getTagName()).append('>').append('\n');
            } else {
                buf.append(" />");
            }
            return buf.toString();
        }
    }

    class MyAttr
    extends MyNode
    implements Attr {
        MyAttr(Attr attr) {
            super(attr);
        }

        @Override
        public String getName() {
            return ((Attr)this.rawnode).getName();
        }

        @Override
        public boolean getSpecified() {
            return ((Attr)this.rawnode).getSpecified();
        }

        @Override
        public String getValue() {
            return ((Attr)this.rawnode).getValue();
        }

        @Override
        public void setValue(String value) throws DOMException {
            ((Attr)this.rawnode).setValue(value);
        }

        @Override
        public CSSElement getOwnerElement() {
            Element elm = ((Attr)this.rawnode).getOwnerElement();
            if (elm == null) {
                return null;
            }
            return (CSSElement)this.getCSSNode(elm);
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return ((Attr)this.rawnode).getSchemaTypeInfo();
        }

        @Override
        public boolean isId() {
            return ((Attr)this.rawnode).isId();
        }

        public String toString() {
            return this.getName() + "=\"" + this.getValue() + '\"';
        }
    }

    class MyCDATASection
    extends MyText
    implements CDATASection {
        MyCDATASection(CDATASection cdata) {
            super(cdata);
        }

        @Override
        void onDOMChange() {
            LinkStyleDefiner definer = StylableDocumentWrapper.this.getEmbeddedStyleDefiner((CSSElement)this.getParentNode());
            if (definer != null) {
                definer.resetLinkedSheet();
            }
        }

        @Override
        public String toString() {
            return "<![CDATA[" + this.getData() + "]]>";
        }
    }

    class MyText
    extends MyCharacterData
    implements Text {
        MyText(Text text) {
            super(text);
        }

        @Override
        public Text splitText(int offset) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public boolean isElementContentWhitespace() {
            return ((Text)this.rawnode).isElementContentWhitespace();
        }

        @Override
        public String getWholeText() {
            return ((Text)this.rawnode).getWholeText();
        }

        @Override
        public Text replaceWholeText(String content) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        public String toString() {
            return this.getData();
        }

        @Override
        void onDOMChange() {
            LinkStyleDefiner definer = StylableDocumentWrapper.this.getEmbeddedStyleDefiner((CSSElement)this.getParentNode());
            if (definer != null) {
                definer.resetLinkedSheet();
            }
        }
    }

    class MyComment
    extends MyCharacterData
    implements Comment {
        MyComment(Comment cdata) {
            super(cdata);
        }

        public String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    class MyCharacterData
    extends MyNode
    implements CharacterData {
        MyCharacterData(CharacterData cdata) {
            super(cdata);
        }

        @Override
        public String getData() throws DOMException {
            return this.rawnode.getNodeValue();
        }

        @Override
        public void setData(String data) throws DOMException {
            ((CharacterData)this.rawnode).setData(data);
            this.onDOMChange();
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.setData(nodeValue);
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            this.setNodeValue(textContent);
        }

        @Override
        public int getLength() {
            return ((CharacterData)this.rawnode).getLength();
        }

        @Override
        public String substringData(int offset, int count) throws DOMException {
            return ((CharacterData)this.rawnode).substringData(offset, count);
        }

        @Override
        public void appendData(String arg) throws DOMException {
            ((CharacterData)this.rawnode).appendData(arg);
            this.onDOMChange();
        }

        @Override
        public void insertData(int offset, String arg) throws DOMException {
            ((CharacterData)this.rawnode).insertData(offset, arg);
            this.onDOMChange();
        }

        @Override
        public void deleteData(int offset, int count) throws DOMException {
            ((CharacterData)this.rawnode).deleteData(offset, count);
            this.onDOMChange();
        }

        @Override
        public void replaceData(int offset, int count, String arg) throws DOMException {
            ((CharacterData)this.rawnode).replaceData(offset, count, arg);
            this.onDOMChange();
        }

        void onDOMChange() {
        }
    }

    class MyEntityReference
    extends MyNode
    implements EntityReference {
        MyEntityReference(EntityReference node) {
            super(node);
        }
    }

    class MyStyleProcessingInstruction
    extends MyProcessingInstruction
    implements LinkStyleProcessingInstruction {
        private AbstractCSSStyleSheet linkedSheet;
        private final LinkedHashMap<String, String> pseudoAttrs;

        MyStyleProcessingInstruction(ProcessingInstruction node) {
            super(node);
            this.linkedSheet = null;
            this.pseudoAttrs = new LinkedHashMap();
            this.parseData();
        }

        @Override
        public void setData(String data) throws DOMException {
            this.rawnode.setNodeValue(data);
            this.parseData();
            this.resetLinkedSheet();
            if (this.getParentNode() != null) {
                StylableDocumentWrapper.this.onStyleModify();
            }
        }

        private void parseData() throws DOMException {
            DOMUtil.parsePseudoAttributes(this.getData(), this.pseudoAttrs);
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.setData(nodeValue);
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.linkedSheet == null) {
                boolean alternate;
                String type = this.getPseudoAttribute("type");
                if (type.length() != 0 && !"text/css".equals(type)) {
                    return null;
                }
                String title = this.getPseudoAttribute("title");
                if (title.length() == 0) {
                    title = null;
                }
                if ((alternate = "yes".equalsIgnoreCase(this.getPseudoAttribute("alternate"))) && title == null) {
                    StylableDocumentWrapper.this.getStyleSheetFactory().getErrorHandler().linkedStyleError(this, "Alternate sheet without title");
                    return null;
                }
                String href = this.getPseudoAttribute("href");
                int hreflen = href.length();
                if (hreflen > 1) {
                    if (href.charAt(0) != '#') {
                        this.linkedSheet = StylableDocumentWrapper.this.loadStyleSheet(href, title, this.getPseudoAttribute("media"), this);
                    } else {
                        String id = href.substring(1);
                        CSSElement elm = StylableDocumentWrapper.this.getElementById(id);
                        if (elm != null) {
                            String text = elm.getTextContent().trim();
                            this.linkedSheet = StylableDocumentWrapper.this.parseEmbeddedStyleSheet(text, title, this.getPseudoAttribute("media"), this);
                        } else {
                            StylableDocumentWrapper.this.getStyleSheetFactory().getErrorHandler().linkedStyleWarning(this, "Could not find element with id: " + id);
                        }
                    }
                    if (alternate && this.linkedSheet != null) {
                        this.linkedSheet.setDisabled(true);
                    }
                }
            }
            return this.linkedSheet;
        }

        @Override
        public String getPseudoAttribute(String attrname) {
            String value = this.pseudoAttrs.get(attrname);
            if (value == null) {
                value = "";
            }
            return value;
        }

        @Override
        public boolean isSameSheet(String idOrUri) {
            String href = this.getPseudoAttribute("href");
            int hreflen = href.length();
            if (hreflen > 1) {
                if (href.charAt(0) != '#') {
                    return href.equals(idOrUri);
                }
                return idOrUri.equals(href.substring(1));
            }
            return false;
        }

        @Override
        public void resetLinkedSheet() {
            this.linkedSheet = null;
            StylableDocumentWrapper.this.onStyleModify();
        }
    }

    static interface LinkStyleProcessingInstruction
    extends LinkStyleDefiner,
    ProcessingInstruction {
        public String getPseudoAttribute(String var1);

        public boolean isSameSheet(String var1);
    }

    static interface LinkStyleDefiner
    extends LinkStyle,
    Node {
        @Override
        public AbstractCSSStyleSheet getSheet();

        public void resetLinkedSheet();
    }

    class MyProcessingInstruction
    extends MyNode
    implements ProcessingInstruction {
        MyProcessingInstruction(ProcessingInstruction node) {
            super(node);
        }

        @Override
        public String getData() {
            return ((ProcessingInstruction)this.rawnode).getData();
        }

        @Override
        public String getTarget() {
            return ((ProcessingInstruction)this.rawnode).getTarget();
        }

        @Override
        public void setData(String data) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }
    }

    class MyDocumentType
    extends MyNode
    implements DocumentType {
        MyDocumentType(DocumentType node) {
            super(node);
        }

        @Override
        public String getName() {
            return ((DocumentType)this.rawnode).getName();
        }

        @Override
        public NamedNodeMap getEntities() {
            return ((DocumentType)this.rawnode).getEntities();
        }

        @Override
        public NamedNodeMap getNotations() {
            return ((DocumentType)this.rawnode).getNotations();
        }

        @Override
        public String getPublicId() {
            return ((DocumentType)this.rawnode).getPublicId();
        }

        @Override
        public String getSystemId() {
            return ((DocumentType)this.rawnode).getSystemId();
        }

        @Override
        public String getInternalSubset() {
            return ((DocumentType)this.rawnode).getInternalSubset();
        }
    }

    class MyNode
    extends DOMNode {
        MyNode(Node node) {
            super(node);
        }

        @Override
        public CSSDocument getOwnerDocument() {
            return StylableDocumentWrapper.this;
        }

        @Override
        protected CSSNode getCSSNode(Node node) {
            return StylableDocumentWrapper.this.getCSSNode(node);
        }

        @Override
        protected CSSNode getMappedCSSNode(Node node) {
            return StylableDocumentWrapper.this.getMappedCSSNode(node);
        }
    }
}

