/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class CSSUnknownValue
extends AbstractCSSPrimitiveValue {
    public CSSUnknownValue() {
        this.setCSSUnitType((short)0);
    }

    protected CSSUnknownValue(CSSUnknownValue copied) {
        super(copied);
        this.setCssText(copied.getCssText());
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write(this.getCssText());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSSUnknownValue other = (CSSUnknownValue)obj;
        return this.getCssText().equals(other.getCssText());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getCssText().hashCode();
        return result;
    }

    @Override
    AbstractCSSPrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    private String guessCssText(LexicalUnit lunit) {
        try {
            return lunit.getStringValue();
        }
        catch (DOMException dOMException) {
            String text = "";
            try {
                float fv = lunit.getFloatValue();
                text = Float.toString(fv);
            }
            catch (DOMException e1) {
                try {
                    int iv = lunit.getIntegerValue();
                    text = Integer.toString(iv);
                }
                catch (DOMException dOMException2) {
                    // empty catch block
                }
            }
            try {
                String unittext = lunit.getDimensionUnitText();
                if (unittext.length() != 0) {
                    text = text + unittext;
                }
            }
            catch (DOMException dOMException3) {
                // empty catch block
            }
            return text;
        }
    }

    @Override
    public CSSUnknownValue clone() {
        return new CSSUnknownValue(this);
    }

    class MyLexicalSetter
    extends AbstractCSSPrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(CSSUnknownValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            String text;
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
            switch (lunit.getLexicalUnitType()) {
                case 6: {
                    text = "^";
                    break;
                }
                case 10: {
                    text = ">=";
                    break;
                }
                case 8: {
                    text = ">";
                    break;
                }
                case 9: {
                    text = "<=";
                    break;
                }
                case 7: {
                    text = "<";
                    break;
                }
                case 2: {
                    text = "-";
                    break;
                }
                case 5: {
                    text = "%";
                    break;
                }
                case 3: {
                    text = "*";
                    break;
                }
                case 1: {
                    text = "+";
                    break;
                }
                case 11: {
                    text = "~";
                    break;
                }
                default: {
                    text = CSSUnknownValue.this.guessCssText(lunit);
                    if (text.length() != 0) break;
                    throw new DOMException(12, "Unsuitable value: " + lunit.toString());
                }
            }
            CSSUnknownValue.this.setPlainCssText(text);
        }
    }
}

