/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.Counter;

class OMCSSCounterValue
extends AbstractCSSPrimitiveValue {
    private CSSCounter counter = null;

    public OMCSSCounterValue() {
        super((short)23);
    }

    protected OMCSSCounterValue(OMCSSCounterValue copied) {
        super(copied);
        this.counter = new CSSCounter(copied.counter.identifier, copied.counter.listStyle, copied.counter.separator);
    }

    @Override
    public Counter getCounterValue() throws DOMException {
        return this.counter;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.counter == null ? 0 : this.counter.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSCounterValue other = (OMCSSCounterValue)obj;
        return !(this.counter == null ? other.counter != null : !this.counter.equals(other.counter));
    }

    @Override
    public OMCSSCounterValue clone() {
        return new OMCSSCounterValue(this);
    }

    @Override
    AbstractCSSPrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getCssText() {
        return this.counter != null ? this.counter.toString() : "";
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return this.counter != null ? this.counter.toMinifiedString() : "";
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        if (this.counter != null) {
            this.counter.writeCssText(wri);
        }
    }

    class CSSCounter
    implements Counter {
        private String identifier = null;
        private String listStyle = "decimal";
        private String separator = "";

        CSSCounter() {
        }

        CSSCounter(String identifier, String listStyle, String separator) {
            this.identifier = identifier;
            this.listStyle = listStyle;
            this.separator = separator;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public String getListStyle() {
            return this.listStyle;
        }

        @Override
        public String getSeparator() {
            return this.separator;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
            result = 31 * result + (this.listStyle == null ? 0 : this.listStyle.hashCode());
            result = 31 * result + (this.separator == null ? 0 : this.separator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CSSCounter other = (CSSCounter)obj;
            if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
                return false;
            }
            if (this.listStyle == null ? other.listStyle != null : !this.listStyle.equals(other.listStyle)) {
                return false;
            }
            return !(this.separator == null ? other.separator != null : !this.separator.equals(other.separator));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("counter(").append(this.identifier);
            if (!this.listStyle.equalsIgnoreCase("decimal")) {
                buf.append(',').append(' ').append(this.listStyle);
            }
            buf.append(')');
            if (this.separator.length() != 0) {
                buf.append(' ');
                this.quoteSeparator(buf);
            }
            return buf.toString();
        }

        public String toMinifiedString() {
            StringBuilder buf = new StringBuilder();
            buf.append("counter(").append(this.identifier);
            if (!this.listStyle.equalsIgnoreCase("decimal")) {
                buf.append(',').append(this.listStyle);
            }
            buf.append(')');
            if (this.separator.length() != 0) {
                buf.append(' ');
                this.quoteSeparator(buf);
            }
            return buf.toString();
        }

        private void quoteSeparator(StringBuilder buf) {
            if (!this.separator.contains("'")) {
                buf.append('\'').append(this.separator).append('\'');
            } else {
                buf.append('\"').append(this.separator).append('\"');
            }
        }

        public void writeCssText(SimpleWriter wri) throws IOException {
            wri.write("counter(");
            wri.write(this.identifier);
            if (!this.listStyle.equalsIgnoreCase("decimal")) {
                wri.write(',');
                wri.write(' ');
                wri.write(this.listStyle);
            }
            wri.write(')');
            if (this.separator.length() != 0) {
                wri.write(' ');
                if (!this.separator.contains("'")) {
                    wri.write('\'');
                    wri.write(this.separator);
                    wri.write('\'');
                } else {
                    wri.write('\"');
                    wri.write(this.separator);
                    wri.write('\"');
                }
            }
        }
    }

    class MyLexicalSetter
    extends AbstractCSSPrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(OMCSSCounterValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            super.setLexicalUnit(lunit);
            OMCSSCounterValue.this.counter = new CSSCounter();
            LexicalUnit lu = lunit.getParameters();
            OMCSSCounterValue.this.counter.identifier = lu.getStringValue();
            lu = lu.getNextLexicalUnit();
            if (lu != null) {
                if (lu.getLexicalUnitType() == 0 && (lu = lu.getNextLexicalUnit()) == null) {
                    throw new DOMException(12, "Bad counter syntax: " + lunit.toString());
                }
                OMCSSCounterValue.this.counter.listStyle = lu.getStringValue();
            }
            if ((lu = lunit.getNextLexicalUnit()) != null && lu.getLexicalUnitType() == 36) {
                OMCSSCounterValue.this.counter.separator = lu.getStringValue();
                lu = lu.getNextLexicalUnit();
            }
            this.nextLexicalUnit = lu;
        }
    }
}

