/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSCustomPropertyValue;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class OMCSSCustomPropertyValue
extends AbstractCSSPrimitiveValue
implements CSSCustomPropertyValue {
    private String name = null;

    OMCSSCustomPropertyValue() {
        super((short)128);
    }

    protected OMCSSCustomPropertyValue(OMCSSCustomPropertyValue copied) {
        super(copied);
        this.name = copied.name;
    }

    @Override
    public String getCssText() {
        return "var(" + this.name + ")";
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write("var(");
        wri.write(this.name);
        wri.write(')');
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "This value is read-only");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSCustomPropertyValue other = (OMCSSCustomPropertyValue)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    AbstractCSSPrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStringValue() {
        return this.name;
    }

    @Override
    public OMCSSCustomPropertyValue clone() {
        return new OMCSSCustomPropertyValue(this);
    }

    class MyLexicalSetter
    extends AbstractCSSPrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(OMCSSCustomPropertyValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            if (lu == null || lu.getLexicalUnitType() != 35) {
                throw new DOMException(17, "Variable name must be an identifier");
            }
            OMCSSCustomPropertyValue.this.name = lu.getStringValue();
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

