/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSEnvVariableValue;
import io.sf.carte.doc.style.css.ExtendedCSSValue;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class OMCSSEnvVariableValue
extends AbstractCSSPrimitiveValue
implements CSSEnvVariableValue {
    private String name = null;
    private AbstractCSSValue fallback = null;

    OMCSSEnvVariableValue() {
        super((short)129);
    }

    protected OMCSSEnvVariableValue(OMCSSEnvVariableValue copied) {
        super(copied);
        this.name = copied.name;
        this.fallback = copied.fallback;
    }

    @Override
    public String getCssText() {
        StringBuilder buf = new StringBuilder();
        buf.append("env(").append(this.name);
        if (this.fallback != null) {
            buf.append(", ").append(this.fallback.getCssText());
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        StringBuilder buf = new StringBuilder();
        buf.append("env(").append(this.name);
        if (this.fallback != null) {
            buf.append(',').append(this.fallback.getMinifiedCssText(propertyName));
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write("env(");
        wri.write(this.name);
        if (this.fallback != null) {
            wri.write(", ");
            this.fallback.writeCssText(wri);
        }
        wri.write(')');
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "This value is read-only");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fallback == null ? 0 : this.fallback.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSEnvVariableValue other = (OMCSSEnvVariableValue)obj;
        if (this.fallback == null ? other.fallback != null : !this.fallback.equals(other.fallback)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    AbstractCSSPrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStringValue() {
        return this.name;
    }

    @Override
    public ExtendedCSSValue getFallbackValue() {
        return this.fallback;
    }

    @Override
    public OMCSSEnvVariableValue clone() {
        return new OMCSSEnvVariableValue(this);
    }

    class MyLexicalSetter
    extends AbstractCSSPrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(OMCSSEnvVariableValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            if (lu == null || lu.getLexicalUnitType() != 35) {
                throw new DOMException(17, "Variable name must be an identifier");
            }
            OMCSSEnvVariableValue.this.name = lu.getStringValue();
            lu = lu.getNextLexicalUnit();
            if (lu != null) {
                short type = lu.getLexicalUnitType();
                lu = lu.getNextLexicalUnit();
                if (type != 0 || lu == null) {
                    throw new DOMException(5, "Unexpected character");
                }
                ValueFactory factory = new ValueFactory();
                OMCSSEnvVariableValue.this.fallback = factory.createCSSValue(lu);
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

