/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSPrimitiveValue2;
import io.sf.carte.doc.style.css.CSSUnicodeRangeValue;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.OMCSSUnicodeValue;
import io.sf.carte.doc.style.css.property.OMCSSUnicodeWildcardValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class OMCSSUnicodeRangeValue
extends AbstractCSSPrimitiveValue
implements CSSUnicodeRangeValue {
    private AbstractCSSPrimitiveValue value = null;
    private AbstractCSSPrimitiveValue endValue = null;

    OMCSSUnicodeRangeValue() {
        super((short)130);
    }

    protected OMCSSUnicodeRangeValue(OMCSSUnicodeRangeValue copied) {
        super(copied);
        this.value = copied.value;
        this.endValue = copied.endValue;
    }

    @Override
    public String getCssText() {
        if (this.endValue == null) {
            return this.value.getCssText();
        }
        String s1 = this.value.getCssText();
        StringBuilder buf = new StringBuilder(s1.length() * 2 + 16);
        buf.append(s1).append('-');
        if (this.endValue.getPrimitiveType() == 131) {
            buf.append(Integer.toHexString(((CSSUnicodeRangeValue.CSSUnicodeValue)((Object)this.endValue)).getCodePoint()));
        } else {
            buf.append(this.endValue.getStringValue());
        }
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        this.value.writeCssText(wri);
        if (this.endValue != null) {
            wri.write('-');
            if (this.endValue.getPrimitiveType() == 131) {
                wri.write(Integer.toHexString(((CSSUnicodeRangeValue.CSSUnicodeValue)((Object)this.endValue)).getCodePoint()));
            } else {
                wri.write(this.endValue.getStringValue());
            }
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "This value is read-only");
    }

    @Override
    public CSSPrimitiveValue2 getValue() {
        return this.value;
    }

    @Override
    public CSSPrimitiveValue2 getEndValue() {
        return this.endValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.endValue == null ? 0 : this.endValue.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSUnicodeRangeValue other = (OMCSSUnicodeRangeValue)obj;
        if (this.endValue == null ? other.endValue != null : !this.endValue.equals(other.endValue)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    AbstractCSSPrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public OMCSSUnicodeRangeValue clone() {
        return new OMCSSUnicodeRangeValue(this);
    }

    class MyLexicalSetter
    extends AbstractCSSPrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(OMCSSUnicodeRangeValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getSubValues();
            if (lu == null) {
                throw new DOMException(11, "Invalid (empty) range value");
            }
            OMCSSUnicodeRangeValue.this.value = this.readValue(lu);
            lu = lu.getNextLexicalUnit();
            if (lu != null) {
                OMCSSUnicodeRangeValue.this.endValue = this.readValue(lu);
            } else {
                OMCSSUnicodeRangeValue.this.endValue = null;
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private AbstractCSSPrimitiveValue readValue(LexicalUnit lu) {
            short type = lu.getLexicalUnitType();
            if (type == 13) {
                OMCSSUnicodeValue val = new OMCSSUnicodeValue();
                val.setCodePoint(lu.getIntegerValue());
                return val;
            }
            if (type == 70) {
                OMCSSUnicodeWildcardValue val = new OMCSSUnicodeWildcardValue();
                val.setWildcard(lu.getStringValue());
                return val;
            }
            throw new DOMException(17, "Wrong type for unicode range");
        }
    }
}

