/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.xml.dtd;

import io.sf.carte.doc.agent.AgentUtil;
import io.sf.carte.doc.xml.dtd.DocumentTypeDeclaration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class DefaultEntityResolver
implements EntityResolver2 {
    private final Map<String, String> dtdNameToFilename = new HashMap<String, String>(7);
    private final Map<String, String> systemIdToPublicId = new HashMap<String, String>(7);
    private ClassLoader loader = null;
    private HashSet<String> whitelist = null;

    public DefaultEntityResolver() {
        this.dtdNameToFilename.put("--", "w3c/xhtml5.ent");
        this.dtdNameToFilename.put("-//W3C//DTD XHTML 1.0 Strict//EN", "w3c/xhtml1-strict.dtd");
        this.dtdNameToFilename.put("-//W3C//DTD XHTML 1.0 Transitional//EN", "w3c/xhtml1-transitional.dtd");
        this.dtdNameToFilename.put("-//W3C//DTD XHTML 1.1//EN", "w3c/xhtml11.dtd");
        this.dtdNameToFilename.put("-//W3C//ENTITIES Latin 1 for XHTML//EN", "w3c/xhtml-lat1.ent");
        this.dtdNameToFilename.put("-//W3C//ENTITIES Symbols for XHTML//EN", "w3c/xhtml-symbol.ent");
        this.dtdNameToFilename.put("-//W3C//ENTITIES Special for XHTML//EN", "w3c/xhtml-special.ent");
        this.systemIdToPublicId.put("https://www.w3.org/TR/html5/entities.dtd", "--");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", "-//W3C//DTD XHTML 1.0 Strict//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", "-//W3C//DTD XHTML 1.0 Transitional//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd", "-//W3C//DTD XHTML 1.1//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-lat1.ent", "-//W3C//ENTITIES Latin 1 for XHTML//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-symbol.ent", "-//W3C//ENTITIES Symbols for XHTML//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-special.ent", "-//W3C//ENTITIES Special for XHTML//EN");
    }

    public void addHostToWhiteList(String fqdn) {
        if (fqdn != null) {
            if (this.whitelist == null) {
                this.whitelist = new HashSet();
            }
            this.whitelist.add(fqdn.toLowerCase(Locale.US));
        }
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        if ("html".equalsIgnoreCase(name)) {
            InputSource is = this.resolveEntity("[dtd]", "-//W3C//DTD XHTML 1.0 Transitional//EN", baseURI, null);
            is.setPublicId(null);
            is.setSystemId(null);
            return is;
        }
        return null;
    }

    @Override
    public final InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        String myPublicId = publicId;
        if (publicId == null) {
            myPublicId = this.systemIdToPublicId.get(systemId);
        }
        String fname = this.dtdNameToFilename.get(myPublicId);
        InputSource isrc = null;
        if (fname != null) {
            Reader re = this.loadDTDfromClasspath(fname);
            if (re != null) {
                isrc = new InputSource(re);
                isrc.setPublicId(publicId);
                if (systemId != null) {
                    isrc.setSystemId(systemId);
                }
            }
        } else if (systemId != null) {
            InputStream is;
            int sepidx;
            URL enturl;
            if (baseURI != null) {
                URL base = new URL(baseURI);
                enturl = new URL(base, systemId);
            } else {
                enturl = new URL(systemId);
            }
            if (this.isInvalidProtocol(enturl.getProtocol()) || this.isWhitelistEnabled() && !this.isWhitelistedHost(enturl.getHost())) {
                return null;
            }
            boolean invalidPath = this.isInvalidPath(enturl.getPath());
            String charset = "UTF-8";
            URLConnection con = enturl.openConnection();
            this.connect(con);
            String conType = con.getContentType();
            if (conType != null && (sepidx = conType.indexOf(59)) != -1 && sepidx < conType.length()) {
                conType = conType.substring(0, sepidx);
                charset = AgentUtil.findCharset(conType, sepidx + 1);
            }
            if (invalidPath && !this.isValidContentType(conType)) {
                return null;
            }
            isrc = new InputSource();
            isrc.setSystemId(enturl.toExternalForm());
            if (publicId != null) {
                isrc.setPublicId(publicId);
            }
            isrc.setEncoding(charset);
            try {
                is = con.getInputStream();
            }
            catch (FileNotFoundException e) {
                return null;
            }
            isrc.setCharacterStream(new InputStreamReader(is, charset));
        }
        return isrc;
    }

    protected boolean isInvalidPath(String path) {
        String ext;
        int len = path.length();
        return len < 5 || !(ext = path.substring(len - 4)).equalsIgnoreCase(".dtd") && !ext.equalsIgnoreCase(".ent") && !ext.equalsIgnoreCase(".mod");
    }

    protected boolean isWhitelistEnabled() {
        return this.whitelist != null;
    }

    protected boolean isInvalidProtocol(String protocol) {
        return !protocol.equals("http") && !protocol.equals("https");
    }

    protected boolean isWhitelistedHost(String host) {
        return this.whitelist.contains(host.toLowerCase(Locale.US));
    }

    protected void connect(final URLConnection con) throws IOException {
        con.setConnectTimeout(60000);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    con.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    protected boolean isValidContentType(String conType) {
        return conType != null && (conType.equals("application/xml-dtd") || conType.equals("text/xml-external-parsed-entity") || conType.equals("application/xml-external-parsed-entity"));
    }

    @Override
    public final InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    public InputSource resolveEntity(DocumentTypeDeclaration dtDecl) throws SAXException, IOException {
        return this.resolveEntity(dtDecl.getName(), dtDecl.getPublicId(), null, dtDecl.getSystemId());
    }

    public InputSource resolveEntity(DocumentType dtDecl) throws SAXException, IOException {
        return this.resolveEntity(dtDecl.getName(), dtDecl.getPublicId(), dtDecl.getBaseURI(), dtDecl.getSystemId());
    }

    public InputSource resolveEntity(String documentTypeDeclaration) throws SAXException, IOException {
        return this.resolveEntity(DocumentTypeDeclaration.parse(documentTypeDeclaration));
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    private Reader loadDTDfromClasspath(String dtdFilename) {
        if (dtdFilename.charAt(0) == '/') {
            throw new AccessControlException("Attempt to read " + dtdFilename);
        }
        String pkgPath = DefaultEntityResolver.class.getPackage().getName().replace('.', '/');
        StringBuilder buf = new StringBuilder(pkgPath.length() + dtdFilename.length() + 2);
        buf.append('/').append(pkgPath).append('/').append(dtdFilename);
        final String resPath = buf.toString();
        InputStream is = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                if (DefaultEntityResolver.this.loader != null) {
                    return DefaultEntityResolver.this.loader.getResourceAsStream(resPath);
                }
                return this.getClass().getResourceAsStream(resPath);
            }
        });
        InputStreamReader re = null;
        if (is != null) {
            try {
                re = new InputStreamReader(is, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                re = new InputStreamReader(is);
            }
        }
        return re;
    }
}

