/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.util;

import java.io.IOException;
import java.io.Reader;

public class TokenProducer {
    public static final byte ERR_UNEXPECTED_END_QUOTED = 1;
    public static final byte ERR_LASTCHAR_BACKSLASH = 2;
    public static final byte ERR_UNEXPECTED_END_COMMENTED = 3;
    public static final int CHAR_EXCLAMATION = 33;
    public static final int CHAR_NUMBER_SIGN = 35;
    public static final int CHAR_DOLLAR = 36;
    public static final int CHAR_PERCENT_SIGN = 37;
    public static final int CHAR_LEFT_PAREN = 40;
    public static final int CHAR_RIGHT_PAREN = 41;
    public static final int CHAR_ASTERISK = 42;
    public static final int CHAR_PLUS = 43;
    public static final int CHAR_COMMA = 44;
    public static final int CHAR_HYPHEN_MINUS = 45;
    public static final int CHAR_FULL_STOP = 46;
    public static final int CHAR_SLASH = 47;
    public static final int CHAR_COLON = 58;
    public static final int CHAR_SEMICOLON = 59;
    public static final int CHAR_LESS_THAN = 60;
    public static final int CHAR_EQUALS = 61;
    public static final int CHAR_GREATER_THAN = 62;
    public static final int CHAR_QUESTION_MARK = 63;
    public static final int CHAR_COMMERCIAL_AT = 64;
    public static final int CHAR_LEFT_SQ_BRACKET = 91;
    public static final int CHAR_RIGHT_SQ_BRACKET = 93;
    public static final int CHAR_CIRCUMFLEX_ACCENT = 94;
    public static final int CHAR_LEFT_CURLY_BRACKET = 123;
    public static final int CHAR_VERTICAL_LINE = 124;
    public static final int CHAR_RIGHT_CURLY_BRACKET = 125;
    public static final int CHAR_TILDE = 126;
    private final TokenHandler handler;
    private final CharacterCheck charCheck;
    private boolean handleAllSeparators = false;
    private boolean acceptNewlineEndingQuote = false;
    private boolean acceptEofEndingQuoted = false;

    public TokenProducer(TokenHandler handler) {
        this.handler = handler;
        this.charCheck = new DisallowCharacterCheck();
    }

    public TokenProducer(TokenHandler handler, CharacterCheck charCheck) {
        this.handler = handler;
        this.charCheck = charCheck;
    }

    public TokenProducer(TokenHandler handler, int[] allowInWords) {
        this.handler = handler;
        this.charCheck = new WhitelistCharacterCheck(allowInWords);
    }

    public void setHandleAllSeparators(boolean handleAllSeparators) {
        this.handleAllSeparators = handleAllSeparators;
    }

    public void setAcceptNewlineEndingQuote(boolean accept) {
        this.acceptNewlineEndingQuote = accept;
    }

    public void setAcceptEofEndingQuoted(boolean accept) {
        this.acceptEofEndingQuoted = accept;
    }

    public void parse(String string) {
        StringParser sp = new StringParser(string);
        sp.setCommentDelimiters("", "");
        try {
            sp.parse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parse(String string, String commentOpen, String commentClose) {
        StringParser sp = new StringParser(string);
        sp.setCommentDelimiters(commentOpen, commentClose);
        try {
            sp.parse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parse(Reader reader) throws IOException {
        ReaderParser sp = new ReaderParser(reader);
        sp.setCommentDelimiters("", "");
        sp.parse();
    }

    public void parse(Reader reader, int bufferCapacity) throws IOException {
        ReaderParser sp = new ReaderParser(reader, bufferCapacity);
        sp.setCommentDelimiters("", "");
        sp.parse();
    }

    public void parse(Reader reader, String commentOpen, String commentClose) throws IOException {
        ReaderParser sp = new ReaderParser(reader);
        sp.setCommentDelimiters(commentOpen, commentClose);
        sp.parse();
    }

    public void parseMultiComment(Reader reader, String[] opening, String[] closing) throws IOException {
        ReaderMultiCommentParser sp = new ReaderMultiCommentParser(reader);
        sp.setCommentDelimiters(opening, closing);
        sp.parse();
    }

    public static interface TokenHandler {
        public void tokenControl(TokenControl var1);

        public void word(int var1, String var2);

        public void separator(int var1, int var2);

        public void singleQuoted(int var1, String var2);

        public void doubleQuoted(int var1, String var2);

        public void quotedNewlineChar(int var1, int var2);

        public void openGroup(int var1, int var2);

        public void closeGroup(int var1, int var2);

        public void character(int var1, int var2);

        public void escaped(int var1, int var2);

        public void control(int var1, int var2);

        public void commented(int var1, int var2, String var3);

        public void endOfStream(int var1);

        public void error(int var1, byte var2, CharSequence var3);
    }

    public static interface TokenControl {
        public void enableAllComments();

        public void setAcceptNewlineEndingQuote(boolean var1);

        public void setAcceptEofEndingQuoted(boolean var1);

        public void disableAllComments();

        public void enableComments(int var1);

        public void disableComments(int var1);
    }

    class WhitelistCharacterCheck
    implements CharacterCheck {
        private final int[] allowInWords;

        WhitelistCharacterCheck(int[] allowInWords) {
            this.allowInWords = allowInWords;
        }

        @Override
        public boolean isAllowedCharacter(int codePoint, SequenceParser parser) {
            for (int i = 0; i < this.allowInWords.length; ++i) {
                if (codePoint != this.allowInWords[i]) continue;
                return true;
            }
            return false;
        }
    }

    class DisallowCharacterCheck
    implements CharacterCheck {
        DisallowCharacterCheck() {
        }

        @Override
        public boolean isAllowedCharacter(int codePoint, SequenceParser parser) {
            return false;
        }
    }

    public static interface CharacterCheck {
        public boolean isAllowedCharacter(int var1, SequenceParser var2);
    }

    class ReaderMultiCommentParser
    extends AbstractReaderParser {
        ReaderMultiCommentParser(Reader reader) {
            this(reader, 256);
        }

        ReaderMultiCommentParser(Reader reader, int bufferCapacity) {
            super(reader, bufferCapacity);
        }

        void setCommentDelimiters(String[] start, String[] end) {
            ((ReaderMultiCommentManager)this.commentManager).setCommentDelimiters(start, end);
        }

        @Override
        AbstractSequenceParser.MultiCommentManager createCommentManager() {
            return new ReaderMultiCommentManager();
        }

        class ReaderMultiCommentManager
        extends AbstractSequenceParser.MultiCommentManager {
            ReaderMultiCommentManager() {
            }

            @Override
            void parse() throws IOException {
                super.parse();
                int unprocessedIdx = -1;
                int[] unprocessed = new int[this.getMaxOpeningLength()];
                ReaderMultiCommentParser.this.rootIndex = 0;
                int cp = 0;
                while ((cp = ReaderMultiCommentParser.this.reader.read()) != -1) {
                    int ret;
                    if (unprocessedIdx == -2) {
                        unprocessedIdx = -1;
                        if (cp == 10) continue;
                    }
                    if ((ret = ReaderMultiCommentParser.this.processCodePoint(cp, false)) == 0) {
                        unprocessed[++unprocessedIdx] = cp;
                    } else if (ret == -1) {
                        for (int j = 0; j <= unprocessedIdx; ++j) {
                            ReaderMultiCommentParser.this.processCodePoint(unprocessed[j], true);
                        }
                        ReaderMultiCommentParser.this.processCodePoint(cp, true);
                        unprocessedIdx = -1;
                        if (ReaderMultiCommentParser.this.prevtype == 2 || ReaderMultiCommentParser.this.prevtype == 1) {
                            ReaderMultiCommentParser.this.buffer.append(Character.toChars(cp));
                        }
                    } else if (ret == 2) {
                        unprocessedIdx = this.closingEndsWithLF() ? -2 : -1;
                    } else if (ReaderMultiCommentParser.this.prevtype == 2 || ReaderMultiCommentParser.this.prevtype == 1) {
                        ReaderMultiCommentParser.this.buffer.append(Character.toChars(cp));
                    }
                    ++ReaderMultiCommentParser.this.rootIndex;
                }
                if (ReaderMultiCommentParser.this.buffer.length() != 0) {
                    TokenProducer.this.handler.word(ReaderMultiCommentParser.this.previdx, ReaderMultiCommentParser.this.currentSequence().toString());
                }
                TokenProducer.this.handler.endOfStream(ReaderMultiCommentParser.this.rootIndex);
            }

            @Override
            protected String commentedSequence() throws IOException {
                int ncp;
                boolean lastCp13 = false;
                int endIndex = 0;
                while ((ncp = ReaderMultiCommentParser.this.nextCodepoint()) != -1) {
                    if (ncp == 10 || ncp == 12 || ncp == 13) {
                        if (ncp != 10 || !lastCp13) {
                            TokenProducer.this.handler.control(ReaderMultiCommentParser.this.rootIndex, ncp);
                        }
                        lastCp13 = ncp == 13;
                    } else {
                        lastCp13 = false;
                    }
                    if (this.closingCodepointAt(endIndex) == ncp) {
                        if (++endIndex != this.closingLength()) continue;
                        return ReaderMultiCommentParser.this.buffer.toString();
                    }
                    if (endIndex != 0) {
                        if ((endIndex = this.commentEndIndex(endIndex, ncp)) != 0) continue;
                        ReaderMultiCommentParser.this.buffer.append(Character.toChars(ncp));
                        continue;
                    }
                    ReaderMultiCommentParser.this.buffer.append(Character.toChars(ncp));
                }
                if (!this.closingEndsWith(10)) {
                    ReaderMultiCommentParser.this.error(ReaderMultiCommentParser.this.rootIndex, (byte)3);
                }
                return ReaderMultiCommentParser.this.buffer.toString();
            }

            private int commentEndIndex(int endIndex, int ncp) {
                int endIndexm1 = endIndex - 1;
                if (this.closingCodepointAt(endIndexm1) != ncp || !this.repeatedEndCp(endIndexm1)) {
                    for (int j = 0; j < endIndex; ++j) {
                        ReaderMultiCommentParser.this.buffer.append(Character.toChars(this.closingCodepointAt(j)));
                    }
                    endIndex = 0;
                } else {
                    ReaderMultiCommentParser.this.buffer.append(Character.toChars(this.closingCodepointAt(0)));
                }
                return endIndex;
            }

            private boolean repeatedEndCp(int endIndexm1) {
                for (int i = endIndexm1; i > 0; --i) {
                    if (this.closingCodepointAt(i) == this.closingCodepointAt(i - 1)) continue;
                    return false;
                }
                return true;
            }
        }
    }

    class ReaderParser
    extends AbstractReaderParser {
        ReaderParser(Reader reader) {
            this(reader, 256);
        }

        ReaderParser(Reader reader, int bufferCapacity) {
            super(reader, bufferCapacity);
        }

        void setCommentDelimiters(String start, String end) {
            ((ReaderSingleCommentManager)this.commentManager).setCommentDelimiters(start, end);
        }

        @Override
        AbstractSequenceParser.CommentManager createCommentManager() {
            return new ReaderSingleCommentManager();
        }

        class ReaderSingleCommentManager
        extends AbstractSequenceParser.SingleCommentManager {
            ReaderSingleCommentManager() {
            }

            @Override
            void parse() throws IOException {
                super.parse();
                int unprocessedIdx = -1;
                int[] unprocessed = new int[this.commentStart.length];
                ReaderParser.this.rootIndex = 0;
                int cp = 0;
                while ((cp = ReaderParser.this.reader.read()) != -1) {
                    int ret;
                    if (unprocessedIdx == -2) {
                        unprocessedIdx = -1;
                        if (cp == 10) continue;
                    }
                    if ((ret = ReaderParser.this.processCodePoint(cp, false)) == 0) {
                        unprocessed[++unprocessedIdx] = cp;
                    } else if (ret == -1) {
                        for (int j = 0; j <= unprocessedIdx; ++j) {
                            ReaderParser.this.processCodePoint(unprocessed[j], true);
                        }
                        ReaderParser.this.processCodePoint(cp, true);
                        unprocessedIdx = -1;
                        if (ReaderParser.this.prevtype == 2 || ReaderParser.this.prevtype == 1) {
                            ReaderParser.this.buffer.append(Character.toChars(cp));
                        }
                    } else if (ret == 2) {
                        unprocessedIdx = this.commentEnd[this.commentEnd.length - 1] == 13 ? -2 : -1;
                    } else if (ReaderParser.this.prevtype == 2 || ReaderParser.this.prevtype == 1) {
                        ReaderParser.this.buffer.append(Character.toChars(cp));
                    }
                    ++ReaderParser.this.rootIndex;
                }
                if (ReaderParser.this.buffer.length() != 0) {
                    TokenProducer.this.handler.word(ReaderParser.this.previdx, ReaderParser.this.currentSequence().toString());
                }
                TokenProducer.this.handler.endOfStream(ReaderParser.this.rootIndex);
            }

            @Override
            protected String commentedSequence() throws IOException {
                int ncp;
                boolean lastCp13 = false;
                int endIndex = 0;
                while ((ncp = ReaderParser.this.nextCodepoint()) != -1) {
                    if (ncp == 10 || ncp == 12 || ncp == 13) {
                        if (ncp != 10 || !lastCp13) {
                            TokenProducer.this.handler.control(ReaderParser.this.rootIndex, ncp);
                        }
                        lastCp13 = ncp == 13;
                    } else {
                        lastCp13 = false;
                    }
                    if (this.commentEnd[endIndex] == ncp) {
                        if (++endIndex != this.commentEnd.length) continue;
                        return ReaderParser.this.buffer.toString();
                    }
                    if (endIndex != 0) {
                        if ((endIndex = this.commentEndIndex(endIndex, ncp)) != 0) continue;
                        ReaderParser.this.buffer.append(Character.toChars(ncp));
                        continue;
                    }
                    ReaderParser.this.buffer.append(Character.toChars(ncp));
                }
                if (!this.closingEndsWith(10)) {
                    ReaderParser.this.error(ReaderParser.this.rootIndex, (byte)3);
                }
                return ReaderParser.this.buffer.toString();
            }

            private int commentEndIndex(int endIndex, int ncp) {
                int endIndexm1 = endIndex - 1;
                if (this.commentEnd[endIndexm1] != ncp || !this.repeatedEndCp(endIndexm1)) {
                    for (int j = 0; j < endIndex; ++j) {
                        ReaderParser.this.buffer.append(Character.toChars(this.commentEnd[j]));
                    }
                    endIndex = 0;
                } else {
                    ReaderParser.this.buffer.append(Character.toChars(this.commentEnd[0]));
                }
                return endIndex;
            }

            private boolean repeatedEndCp(int endIndexm1) {
                for (int i = endIndexm1; i > 0; --i) {
                    if (this.commentEnd[i] == this.commentEnd[i - 1]) continue;
                    return false;
                }
                return true;
            }
        }
    }

    abstract class AbstractReaderParser
    extends AbstractSequenceParser {
        Reader reader;
        StringBuilder buffer;

        AbstractReaderParser(Reader reader, int bufferCapacity) {
            this.reader = reader;
            this.buffer = new StringBuilder(bufferCapacity);
        }

        @Override
        public CharSequence currentSequence() {
            return this.buffer;
        }

        @Override
        public void resetCurrentSequence() {
            this.buffer.setLength(0);
        }

        @Override
        protected int nextCodepoint() throws IOException {
            int ncp = this.reader.read();
            ++this.rootIndex;
            return ncp;
        }

        @Override
        protected String quotedSequence(int qcp) throws IOException {
            int ncp;
            boolean lastCpEscaped13 = false;
            int idx = this.rootIndex;
            int prevcp = -1;
            while ((ncp = this.nextCodepoint()) != -1) {
                if (ncp == qcp) {
                    if (prevcp != 92) {
                        return this.buffer.toString();
                    }
                    ++idx;
                    this.buffer.append(Character.toChars(qcp));
                } else {
                    if (ncp == 10 || ncp == 12 || ncp == 13) {
                        if (prevcp != 92) {
                            if (ncp != 10 || !lastCpEscaped13) {
                                String s = this.buffer.toString();
                                TokenProducer.this.handler.error(this.rootIndex, (byte)1, s);
                                TokenProducer.this.handler.control(idx, ncp);
                                this.buffer.setLength(0);
                                if (!TokenProducer.this.acceptNewlineEndingQuote) {
                                    return null;
                                }
                                return s;
                            }
                        } else {
                            this.buffer.setLength(this.buffer.length() - 1);
                            TokenProducer.this.handler.quotedNewlineChar(idx, ncp);
                        }
                        if (!lastCpEscaped13) {
                            this.buffer.append('\n');
                        }
                        lastCpEscaped13 = ncp == 13;
                        prevcp = ncp;
                        continue;
                    }
                    this.buffer.append(Character.toChars(ncp));
                    if (ncp == 92 && prevcp == 92) {
                        ncp = 65;
                    }
                    ++idx;
                }
                prevcp = ncp;
                lastCpEscaped13 = false;
            }
            this.error(this.rootIndex, (byte)1);
            if (TokenProducer.this.acceptEofEndingQuoted) {
                return this.buffer.toString();
            }
            return null;
        }

        @Override
        protected void word() {
            super.word();
            this.buffer.setLength(0);
        }

        @Override
        protected boolean singleQuoted() throws IOException {
            boolean result = super.singleQuoted();
            this.buffer.setLength(0);
            return result;
        }

        @Override
        protected boolean doubleQuoted() throws IOException {
            boolean result = super.doubleQuoted();
            this.buffer.setLength(0);
            return result;
        }

        @Override
        protected void error(int index, byte errCode) {
            TokenProducer.this.handler.error(index, errCode, this.buffer);
        }
    }

    class StringParser
    extends AbstractSequenceParser {
        String string;
        int len;

        StringParser(String string) {
            this.string = string;
            this.len = string.length();
        }

        @Override
        public CharSequence currentSequence() {
            return this.string.subSequence(this.previdx, this.rootIndex);
        }

        @Override
        public void resetCurrentSequence() {
            this.previdx = this.rootIndex;
        }

        @Override
        protected int nextCodepoint() throws IOException {
            ++this.rootIndex;
            if (this.rootIndex < this.len) {
                return this.string.codePointAt(this.rootIndex);
            }
            return -1;
        }

        @Override
        protected String quotedSequence(int qcp) {
            boolean lastCpEscaped13 = false;
            int initial = this.rootIndex + 1;
            int prevcp = -1;
            StringBuilder buffer = new StringBuilder(this.len - initial);
            for (int idx = initial; idx < this.len; ++idx) {
                int cp = this.string.codePointAt(idx);
                if (cp == qcp) {
                    if (prevcp != 92) {
                        this.rootIndex = idx;
                        return buffer.toString();
                    }
                    buffer.append(Character.toChars(qcp));
                } else {
                    if (cp == 10 || cp == 12 || cp == 13) {
                        if (prevcp != 92) {
                            if (cp != 10 || !lastCpEscaped13) {
                                String s = buffer.toString();
                                TokenProducer.this.handler.error(this.rootIndex, (byte)1, s);
                                TokenProducer.this.handler.control(idx, cp);
                                this.rootIndex = idx;
                                if (!TokenProducer.this.acceptNewlineEndingQuote) {
                                    return null;
                                }
                                return s;
                            }
                        } else {
                            buffer.setLength(buffer.length() - 1);
                            TokenProducer.this.handler.quotedNewlineChar(idx, cp);
                        }
                        if (!lastCpEscaped13) {
                            buffer.append('\n');
                        }
                        lastCpEscaped13 = cp == 13;
                        prevcp = cp;
                        continue;
                    }
                    buffer.append(Character.toChars(cp));
                    if (cp == 92 && prevcp == 92) {
                        cp = 65;
                    }
                }
                prevcp = cp;
                lastCpEscaped13 = false;
            }
            this.rootIndex = this.len;
            this.error(initial, (byte)1);
            if (TokenProducer.this.acceptEofEndingQuoted) {
                return buffer.toString();
            }
            return null;
        }

        @Override
        protected void error(int index, byte errCode) {
            int endIndex;
            int beginIndex = index - 16;
            if (beginIndex < 0) {
                beginIndex = 0;
            }
            if ((endIndex = index + 16) > this.string.length()) {
                endIndex = this.string.length();
            }
            TokenProducer.this.handler.error(index, errCode, this.string.substring(beginIndex, endIndex));
        }

        void setCommentDelimiters(String start, String end) {
            ((StringSingleCommentManager)this.commentManager).setCommentDelimiters(start, end);
        }

        @Override
        AbstractSequenceParser.SingleCommentManager createCommentManager() {
            return new StringSingleCommentManager();
        }

        class StringSingleCommentManager
        extends AbstractSequenceParser.SingleCommentManager {
            StringSingleCommentManager() {
            }

            @Override
            void parse() throws IOException {
                super.parse();
                int unprocessedIdx = -1;
                int[] unprocessed = new int[this.commentStart.length];
                StringParser.this.rootIndex = 0;
                while (StringParser.this.rootIndex < StringParser.this.len) {
                    block12: {
                        int ret;
                        int cp;
                        block11: {
                            cp = StringParser.this.string.codePointAt(StringParser.this.rootIndex);
                            if (unprocessedIdx != -2) break block11;
                            unprocessedIdx = -1;
                            if (cp == 10) break block12;
                        }
                        if ((ret = StringParser.this.processCodePoint(cp, false)) == 0) {
                            unprocessed[++unprocessedIdx] = cp;
                        } else if (ret == -1) {
                            StringParser.this.rootIndex = StringParser.this.rootIndex - unprocessedIdx - 1;
                            for (int j = 0; j <= unprocessedIdx; ++j) {
                                StringParser.this.processCodePoint(unprocessed[j], true);
                                ++StringParser.this.rootIndex;
                            }
                            StringParser.this.processCodePoint(cp, true);
                            unprocessedIdx = -1;
                        } else if (ret == 2) {
                            unprocessedIdx = this.commentEnd[this.commentEnd.length - 1] == 13 ? -2 : -1;
                        }
                    }
                    ++StringParser.this.rootIndex;
                }
                if (StringParser.this.previdx < StringParser.this.len) {
                    TokenProducer.this.handler.word(StringParser.this.previdx, StringParser.this.currentSequence().toString());
                }
                TokenProducer.this.handler.endOfStream(StringParser.this.len);
            }

            @Override
            protected String commentedSequence() throws IOException {
                boolean lastCp13 = false;
                int endIndex = 0;
                StringBuilder buffer = new StringBuilder(StringParser.this.len - StringParser.this.rootIndex);
                for (int idx = StringParser.this.rootIndex; idx < StringParser.this.len; ++idx) {
                    int cp = StringParser.this.string.codePointAt(idx);
                    if (cp == 10 || cp == 12 || cp == 13) {
                        if (cp != 10 || !lastCp13) {
                            TokenProducer.this.handler.control(StringParser.this.rootIndex, cp);
                        }
                        lastCp13 = cp == 13;
                    } else {
                        lastCp13 = false;
                    }
                    if (this.commentEnd[endIndex] == cp) {
                        if (++endIndex != this.commentEnd.length) continue;
                        StringParser.this.rootIndex = idx;
                        return buffer.toString();
                    }
                    if (endIndex != 0) {
                        for (int j = 0; j <= endIndex; ++j) {
                            buffer.append(this.commentEnd[j]);
                        }
                        endIndex = 0;
                    }
                    buffer.append(Character.toChars(cp));
                }
                StringParser.this.rootIndex = StringParser.this.len;
                if (!this.closingEndsWith(10)) {
                    StringParser.this.error(StringParser.this.rootIndex, (byte)3);
                }
                return buffer.toString();
            }
        }
    }

    abstract class AbstractSequenceParser
    implements SequenceParser {
        int prevtype = 12;
        int rootIndex = 0;
        int previdx = 0;
        CommentManager commentManager = this.createCommentManager();

        AbstractSequenceParser() {
        }

        /*
         * Enabled aggressive block sorting
         */
        int processCodePoint(int cp, boolean nocomment) throws IOException {
            int result;
            if (!nocomment && (result = this.commentManager.verifyComment(cp)) != 1) {
                return result;
            }
            int type = Character.getType(cp);
            switch (type) {
                case 12: 
                case 13: 
                case 14: {
                    if (TokenProducer.this.handleAllSeparators || this.prevtype != 12) {
                        if (this.isWordPreviousCodepoint()) {
                            this.word();
                        }
                        TokenProducer.this.handler.separator(this.rootIndex, cp);
                        this.prevtype = 12;
                    }
                    this.previdx = this.rootIndex + 1;
                    return 1;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 23: 
                case 28: {
                    this.prevtype = 2;
                    return 1;
                }
                case 15: {
                    if (this.isWordPreviousCodepoint()) {
                        this.word();
                    }
                    this.prevtype = 15;
                    TokenProducer.this.handler.control(this.rootIndex, cp);
                    this.previdx = this.rootIndex + 1;
                    return 1;
                }
                case 20: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 29: 
                case 30: {
                    if (TokenProducer.this.charCheck.isAllowedCharacter(cp, this)) {
                        this.prevtype = 1;
                        return 1;
                    }
                    if (this.isWordPreviousCodepoint()) {
                        this.word();
                    }
                    if (cp == 34) {
                        if (this.doubleQuoted()) break;
                        this.prevtype = 15;
                        break;
                    }
                    if (cp == 39) {
                        if (this.singleQuoted()) break;
                        this.prevtype = 15;
                        break;
                    }
                    if (cp == 40 || cp == 91 || cp == 123) {
                        TokenProducer.this.handler.openGroup(this.rootIndex, cp);
                        break;
                    }
                    if (cp == 41 || cp == 93 || cp == 125) {
                        TokenProducer.this.handler.closeGroup(this.rootIndex, cp);
                        break;
                    }
                    if (cp == 92) {
                        int ncp = this.nextCodepoint();
                        if (ncp != -1) {
                            TokenProducer.this.handler.escaped(this.rootIndex, ncp);
                            break;
                        }
                        this.error(this.rootIndex - 1, (byte)2);
                        break;
                    }
                    TokenProducer.this.handler.character(this.rootIndex, cp);
                }
            }
            this.previdx = this.rootIndex + 1;
            this.prevtype = 24;
            return 1;
        }

        boolean isWordPreviousCodepoint() {
            if (this.prevtype == 2) {
                return true;
            }
            if (this.isPreviousCpWCharacter()) {
                if (this.currentSequence().length() == 1) {
                    TokenProducer.this.handler.character(this.rootIndex, Character.codePointAt(this.currentSequence(), 0));
                    this.resetCurrentSequence();
                } else {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isPreviousCpWCharacter() {
            return this.prevtype == 1;
        }

        protected void word() {
            TokenProducer.this.handler.word(this.previdx, this.currentSequence().toString());
        }

        protected boolean singleQuoted() throws IOException {
            String seq = this.quotedSequence(39);
            if (seq == null) {
                return false;
            }
            TokenProducer.this.handler.singleQuoted(this.rootIndex, seq);
            return true;
        }

        protected boolean doubleQuoted() throws IOException {
            String seq = this.quotedSequence(34);
            if (seq == null) {
                return false;
            }
            TokenProducer.this.handler.doubleQuoted(this.rootIndex, seq);
            return true;
        }

        public void parse() throws IOException {
            this.commentManager.parse();
        }

        abstract CommentManager createCommentManager();

        protected abstract int nextCodepoint() throws IOException;

        protected abstract String quotedSequence(int var1) throws IOException;

        protected abstract void error(int var1, byte var2);

        abstract class MultiCommentManager
        extends CommentManager {
            int delimcount;
            int[][] commentStart;
            int[][] commentEnd;
            private boolean[] disabledComments;
            int commentClass;

            MultiCommentManager() {
                this.delimcount = 0;
                this.commentClass = -1;
            }

            @Override
            boolean matchesExpectedOpening(int cp) {
                if (this.isBeginningOfOpening()) {
                    for (int i = 0; i < this.delimcount; ++i) {
                        if (this.commentStart[i][0] != cp || this.disabledComments[i]) continue;
                        this.commentClass = i;
                        return true;
                    }
                    return false;
                }
                if (this.commentStart[this.commentClass][this.commentIndex] == cp && !this.disabledComments[this.commentClass]) {
                    return true;
                }
                block1: for (int i = this.commentClass + 1; i < this.delimcount; ++i) {
                    int len = this.commentStart[i].length;
                    if (this.commentIndex >= len || this.commentStart[i][this.commentIndex] != cp || this.disabledComments[i]) continue;
                    for (int j = this.commentIndex - 1; j != -1; --j) {
                        if (this.commentStart[i][j] != cp) continue block1;
                    }
                    this.commentClass = i;
                    return true;
                }
                return false;
            }

            @Override
            int expectedOpeningLength() {
                return this.commentIndex == 0 ? -1 : this.commentStart[this.commentClass].length;
            }

            boolean isBeginningOfOpening() {
                return this.commentIndex == 0;
            }

            @Override
            int getLastCommentClass() {
                return this.commentClass;
            }

            int getMaxOpeningLength() {
                int slen = this.commentStart[0].length;
                for (int i = 1; i < this.delimcount; ++i) {
                    int len = this.commentStart[i].length;
                    if (len <= slen) continue;
                    slen = len;
                }
                return slen;
            }

            @Override
            int closingLength() {
                return this.commentEnd[this.commentClass].length;
            }

            boolean closingEndsWithLF() {
                return this.closingEndsWith(13);
            }

            boolean closingEndsWith(int cp) {
                return this.closingCodepointAt(this.closingLength() - 1) == cp;
            }

            int closingCodepointAt(int idx) {
                return this.commentEnd[this.commentClass][idx];
            }

            void setCommentDelimiters(String[] start, String[] end) {
                this.delimcount = start.length;
                if (this.delimcount != end.length) {
                    throw new IllegalArgumentException("Unmatched begin/end comment delimiters");
                }
                this.disabledComments = new boolean[this.delimcount];
                int[][] commentStart = new int[this.delimcount][];
                int[][] commentEnd = new int[this.delimcount][];
                for (int i = 0; i < this.delimcount; ++i) {
                    int cp;
                    int j;
                    String s = start[i];
                    int len = s.length();
                    commentStart[i] = new int[len];
                    for (j = 0; j < len; ++j) {
                        commentStart[i][j] = cp = s.codePointAt(j);
                        if (cp != 92) continue;
                        throw new IllegalArgumentException("Not an allowed comment delimiter");
                    }
                    s = end[i];
                    len = s.length();
                    commentEnd[i] = new int[len];
                    for (j = 0; j < len; ++j) {
                        commentEnd[i][j] = cp = s.codePointAt(j);
                        if (cp != 92) continue;
                        throw new IllegalArgumentException("Not an allowed comment delimiter");
                    }
                }
                this.commentStart = commentStart;
                this.commentEnd = commentEnd;
            }

            @Override
            public void enableAllComments() {
                for (int i = 0; i < this.disabledComments.length; ++i) {
                    this.disabledComments[i] = false;
                }
            }

            @Override
            public void disableAllComments() {
                for (int i = 0; i < this.disabledComments.length; ++i) {
                    this.disabledComments[i] = true;
                }
            }

            @Override
            public void enableComments(int type) {
                this.disabledComments[type] = false;
            }

            @Override
            public void disableComments(int type) {
                this.disabledComments[type] = true;
            }
        }

        abstract class SingleCommentManager
        extends CommentManager {
            int[] commentStart;
            int[] commentEnd;
            private boolean disabledComments;

            SingleCommentManager() {
                this.disabledComments = false;
            }

            @Override
            boolean matchesExpectedOpening(int cp) {
                return this.commentStart[this.commentIndex] == cp && !this.disabledComments;
            }

            @Override
            int expectedOpeningLength() {
                return this.commentStart.length;
            }

            @Override
            int getLastCommentClass() {
                return 0;
            }

            @Override
            int closingLength() {
                return this.commentEnd.length;
            }

            boolean closingEndsWithLF() {
                return this.closingEndsWith(13);
            }

            boolean closingEndsWith(int cp) {
                return this.closingCodepointAt(this.closingLength() - 1) == cp;
            }

            int closingCodepointAt(int idx) {
                return this.commentEnd[idx];
            }

            void setCommentDelimiters(String start, String end) {
                int i;
                int slen = start.length();
                int elen = end.length();
                int[] commentStart = new int[slen];
                int[] commentEnd = new int[elen];
                for (i = 0; i < slen; ++i) {
                    commentStart[i] = start.codePointAt(i);
                    if (commentStart[i] != 92) continue;
                    throw new IllegalArgumentException("Not an allowed comment delimiter");
                }
                for (i = 0; i < elen; ++i) {
                    commentEnd[i] = end.codePointAt(i);
                    if (commentEnd[i] != 92) continue;
                    throw new IllegalArgumentException("Not an allowed comment delimiter");
                }
                this.commentStart = commentStart;
                this.commentEnd = commentEnd;
            }

            @Override
            public void enableAllComments() {
                this.disabledComments = false;
            }

            @Override
            public void disableAllComments() {
                this.disabledComments = true;
            }

            @Override
            public void enableComments(int type) {
                if (type == 0) {
                    this.disabledComments = false;
                }
            }

            @Override
            public void disableComments(int type) {
                if (type == 0) {
                    this.disabledComments = true;
                }
            }
        }

        abstract class ReaderCommentManager
        extends CommentManager {
            ReaderCommentManager() {
            }
        }

        abstract class CommentManager
        implements TokenControl {
            int commentIndex = 0;
            int commentprevtype = 0;

            CommentManager() {
            }

            void parse() throws IOException {
                TokenProducer.this.handler.tokenControl(this);
            }

            @Override
            public void setAcceptNewlineEndingQuote(boolean accept) {
                TokenProducer.this.setAcceptNewlineEndingQuote(accept);
            }

            @Override
            public void setAcceptEofEndingQuoted(boolean accept) {
                TokenProducer.this.setAcceptEofEndingQuoted(accept);
            }

            int verifyComment(int cp) throws IOException {
                if (this.matchesExpectedOpening(cp)) {
                    if (this.commentIndex == 0) {
                        this.commentprevtype = AbstractSequenceParser.this.prevtype;
                    }
                    ++this.commentIndex;
                    if (this.commentIndex == this.expectedOpeningLength()) {
                        AbstractSequenceParser.this.prevtype = this.commentprevtype;
                        if (AbstractSequenceParser.this.isWordPreviousCodepoint()) {
                            AbstractSequenceParser.this.word();
                        }
                        this.commentIndex = 0;
                        ++AbstractSequenceParser.this.rootIndex;
                        AbstractSequenceParser.this.previdx = AbstractSequenceParser.this.rootIndex;
                        String comment = this.commentedSequence();
                        TokenProducer.this.handler.commented(AbstractSequenceParser.this.previdx, this.getLastCommentClass(), comment);
                        AbstractSequenceParser.this.resetCurrentSequence();
                        return 2;
                    }
                    return 0;
                }
                if (this.commentIndex != 0) {
                    this.commentIndex = 0;
                    this.commentprevtype = 0;
                    return -1;
                }
                return 1;
            }

            abstract boolean matchesExpectedOpening(int var1);

            abstract int expectedOpeningLength();

            abstract int closingLength();

            abstract int getLastCommentClass();

            abstract String commentedSequence() throws IOException;
        }
    }

    public static interface SequenceParser {
        public CharSequence currentSequence();

        public boolean isPreviousCpWCharacter();

        public void resetCurrentSequence();
    }
}

