/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMTypeInfo;
import io.sf.carte.doc.dom.NamespacedNode;
import io.sf.carte.doc.style.css.CSSNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

abstract class DOMAttr
extends NamespacedNode
implements Attr {
    private TypeInfo schemaTypeInfo = null;
    boolean specified = true;
    private final String name;
    String value = null;

    private static String escapeAttributeEntities(String text) {
        StringBuilder buf = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                buf = DOMDocument.appendEntityToBuffer(buf, "lt", text, i, len);
                continue;
            }
            if (c == '>') {
                buf = DOMDocument.appendEntityToBuffer(buf, "gt", text, i, len);
                continue;
            }
            if (c == '\"') {
                buf = DOMDocument.appendEntityToBuffer(buf, "quot", text, i, len);
                continue;
            }
            if (c == '\'') {
                buf = DOMDocument.appendEntityToBuffer(buf, "apos", text, i, len);
                continue;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        if (buf != null) {
            text = buf.toString();
        }
        return text;
    }

    DOMAttr(String name, String namespaceURI) {
        super((short)2, namespaceURI);
        this.name = name;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        throw new DOMException(3, "Cannot append to attribute node");
    }

    @Override
    public String getLocalName() {
        return this.name;
    }

    @Override
    public String getName() {
        String name = this.getLocalName();
        String prefix = this.getPrefix();
        if (prefix != null) {
            name = prefix + ':' + name;
        }
        return name;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    @Override
    public DOMElement getOwnerElement() {
        return (DOMElement)super.getParentNode();
    }

    @Override
    public CSSNode getParentNode() throws DOMException {
        return null;
    }

    @Override
    void setParentNode(Node parentNode) throws DOMException {
        if (parentNode != null && parentNode.getNodeType() != 1) {
            throw new DOMException(3, "Attributes can only pertain to elements");
        }
        super.setParentNode(parentNode);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        if (this.schemaTypeInfo == null) {
            this.schemaTypeInfo = new AttributeTypeInfo();
        }
        return this.schemaTypeInfo;
    }

    @Override
    public boolean getSpecified() {
        return this.specified;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) throws DOMException {
        this.value = value;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        DOMElement owner;
        String namespaceURI = super.lookupNamespaceURI(prefix);
        if (namespaceURI == null && (owner = this.getOwnerElement()) != null) {
            namespaceURI = owner.lookupNamespaceURI(prefix);
        }
        return namespaceURI;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        if (namespaceURI.equals(this.getNamespaceURI())) {
            return this.getPrefix();
        }
        DOMElement parent = this.getOwnerElement();
        if (parent != null) {
            return parent.lookupPrefix(namespaceURI);
        }
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        if ("xmlns".equals(this.getLocalName()) || "xmlns".equals(prefix) && !"http://www.w3.org/2000/xmlns/".equals(this.getNamespaceURI())) {
            throw new DOMException(14, "Cannot set prefix to this node");
        }
        super.setPrefix(prefix);
    }

    public String toString() {
        String value;
        String escname = DOMDocument.escapeReservedChars(this.getLocalName());
        String prefix = this.getPrefix();
        if (prefix != null) {
            escname = prefix + ':' + escname;
        }
        if ((value = this.getValue()) != null) {
            StringBuilder buf = new StringBuilder(escname.length() + value.length() + 3);
            buf.append(escname);
            buf.append("=\"");
            buf.append(DOMAttr.escapeAttributeEntities(value));
            buf.append('\"');
            return buf.toString();
        }
        return escname;
    }

    private static class AttributeTypeInfo
    extends DOMTypeInfo {
        private AttributeTypeInfo() {
        }

        @Override
        public String getTypeNamespace() {
            return "https://www.w3.org/TR/xml/";
        }
    }
}

