/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMStringListImpl;
import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.agent.OriginPolicy;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.CSSDOMImplementation;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMElementList;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.HTMLDocument;
import io.sf.carte.doc.dom.ParentNode;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.CSSRuleListener;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.OMStyleSheetList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.LinkStyle;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public abstract class DOMDocument
extends DOMNode
implements CSSDocument,
ParentNode,
CSSRuleListener {
    static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    private String idAttrName = "id";
    private DOMConfiguration domConfig = new MyDOMConfiguration();
    private boolean xmlStandalone = false;
    private boolean strictErrorChecking = true;
    public DOMErrorHandler errorHandler = null;
    private String documentURI = null;
    static final AbstractDOMNode.DOMNodeList nvemptyNodeList = new AbstractDOMNode.NVEmptyNodeList();
    final Set<StyleDefinerElement> linkedStyle = new LinkedHashSet<StyleDefinerElement>(4);
    final Set<StyleDefinerElement> embeddedStyle = new LinkedHashSet<StyleDefinerElement>(3);
    private BaseDocumentCSSStyleSheet mergedStyleSheet = null;
    private final MyOMStyleSheetList sheets = new MyOMStyleSheetList(7);
    private String metaDefaultStyleSet = "";
    private String lastStyleSheetSet = null;
    private String targetMedium = null;
    private Map<String, CSSCanvas> canvases = new HashMap<String, CSSCanvas>(3);

    public DOMDocument(DocumentType documentType) {
        super((short)9);
        if (documentType != null && documentType.getOwnerDocument() == null) {
            this.child.add(documentType);
        }
    }

    @Override
    protected AbstractDOMNode.DOMNodeList createChildNodeList() {
        return new AbstractDOMNode.ChildNodeList();
    }

    @Override
    public DOMElement getDocumentElement() {
        int sz = this.child.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = this.child.get(i);
            if (node.getNodeType() != 1) continue;
            return (DOMElement)node;
        }
        return null;
    }

    @Override
    public DocumentType getDoctype() {
        int sz = this.child.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = this.child.get(i);
            if (node.getNodeType() != 10) continue;
            return (DocumentType)node;
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public DOMDocument getOwnerDocument() {
        return null;
    }

    @Override
    public CSSNode getParentNode() {
        return null;
    }

    @Override
    public boolean isVisitedURI(String href) {
        return false;
    }

    @Override
    public DOMDocument cloneNode(boolean deep) {
        DOMDocument doc = this.getImplementation().createDocument(this.getNamespaceURI(), this.getDocumentElementQName(), this.getDoctype());
        if (deep) {
            doc.appendChild(doc.adoptNode(this.getDocumentElement()));
        }
        this.callUserHandlers((short)1, this, doc);
        return doc;
    }

    @Override
    DOMDocument cloneNode(DOMDocument ownerDocument) {
        return ownerDocument.getImplementation().createDocument(this.getNamespaceURI(), this.getDocumentElementQName(), this.getDoctype());
    }

    private String getDocumentElementQName() {
        DOMElement docelm = this.getDocumentElement();
        String qname = docelm != null ? docelm.getTagName() : null;
        return qname;
    }

    @Override
    public abstract CSSDOMImplementation getImplementation();

    protected abstract CSSDOMImplementation getStyleSheetFactory();

    protected boolean isEmbeddedStyleDefiner(Node node) {
        return false;
    }

    protected boolean isRawTextElementName(String localName) {
        return false;
    }

    static String escapeCloseTag(String tagname, String data) {
        int idx = data.indexOf(60);
        if (idx == -1) {
            return data;
        }
        int tnidx = data.indexOf(tagname, 2);
        if (tnidx == -1) {
            return data;
        }
        StringBuilder buf = null;
        int tnlen = tagname.length();
        int lenm1 = data.length() - 1;
        while (idx < lenm1) {
            int i;
            char d;
            char c = data.charAt(idx);
            if (c == '<' && (d = data.charAt(i = idx + 1)) == '/' && lenm1 - i > tnlen) {
                ++i;
                if ((i = DOMDocument.skipIgnorableChars(i, data, lenm1)) < lenm1 && data.regionMatches(true, i, tagname, 0, tnlen) && (i = DOMDocument.skipIgnorableChars(i + tnlen, data, lenm1)) <= lenm1 && data.charAt(i) == '>') {
                    if (buf == null) {
                        buf = new StringBuilder(lenm1 + 4);
                        buf.append(data.subSequence(0, idx));
                    }
                    buf.append("&lt;");
                    buf.append(data.subSequence(idx + 1, i + 1));
                    idx = i + 1;
                    continue;
                }
            }
            if (buf != null) {
                buf.append(c);
            }
            ++idx;
        }
        if (buf != null && idx == lenm1) {
            buf.append(data.charAt(idx));
        }
        return buf == null ? data : buf.toString();
    }

    private static int skipIgnorableChars(int idx, String text, int lenm1) {
        while (idx < lenm1) {
            char c = text.charAt(idx);
            if (c != ' ' && c != '\t' && c != '\n') {
                if (c != '\r') break;
                int i = idx + 1;
                if (text.charAt(i) == '\n') {
                    idx = i;
                }
            }
            ++idx;
        }
        return idx;
    }

    private static String escapeLtGtEntities(String text) {
        StringBuilder buf = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                buf = DOMDocument.appendEntityToBuffer(buf, "lt", text, i, len);
                continue;
            }
            if (c == '>') {
                buf = DOMDocument.appendEntityToBuffer(buf, "gt", text, i, len);
                continue;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        if (buf != null) {
            text = buf.toString();
        }
        return text;
    }

    static StringBuilder appendEntityToBuffer(StringBuilder buf, String string, String text, int index, int inilen) {
        if (buf == null) {
            buf = new StringBuilder(inilen + string.length() + 2);
            buf.append(text.subSequence(0, index));
        }
        buf.append('&').append(string).append(';');
        return buf;
    }

    static String escapeReservedChars(String text) {
        StringBuilder buf = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                buf = DOMDocument.appendToBuffer(buf, "U000026", text, i, len);
                continue;
            }
            if (c == '<') {
                buf = DOMDocument.appendToBuffer(buf, "U00003C", text, i, len);
                continue;
            }
            if (c == '>') {
                buf = DOMDocument.appendToBuffer(buf, "U00003E", text, i, len);
                continue;
            }
            if (c == '=') {
                buf = DOMDocument.appendToBuffer(buf, "U00003D", text, i, len);
                continue;
            }
            if (c == '\"') {
                buf = DOMDocument.appendToBuffer(buf, "U000022", text, i, len);
                continue;
            }
            if (c == '\'') {
                buf = DOMDocument.appendToBuffer(buf, "U000027", text, i, len);
                continue;
            }
            if (c == '\\') {
                buf = DOMDocument.appendToBuffer(buf, "U00005C", text, i, len);
                continue;
            }
            if (c == ':') {
                buf = DOMDocument.appendToBuffer(buf, "U00003A", text, i, len);
                continue;
            }
            if (c == ';') {
                buf = DOMDocument.appendToBuffer(buf, "U00003B", text, i, len);
                continue;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        if (buf != null) {
            text = buf.toString();
        }
        return text;
    }

    private static StringBuilder appendToBuffer(StringBuilder buf, String string, String text, int index, int inilen) {
        if (buf == null) {
            buf = new StringBuilder(inilen + string.length());
            buf.append(text.subSequence(0, index));
        }
        buf.append(string);
        return buf;
    }

    @Override
    public DOMElement createElement(String tagName) throws DOMException {
        if (tagName == null) {
            throw new DOMException(5, "null tag name");
        }
        return this.createElementNS(null, tagName);
    }

    @Override
    public DOMElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName;
        if (qualifiedName == null) {
            throw new DOMException(5, "null qualified name");
        }
        String prefix = null;
        if (namespaceURI != null) {
            if (namespaceURI.length() == 0) {
                namespaceURI = null;
                localName = qualifiedName.toLowerCase(Locale.US);
            } else {
                namespaceURI = namespaceURI.intern();
                int idx = qualifiedName.indexOf(58);
                if (idx == -1) {
                    prefix = this.lookupPrefix(namespaceURI);
                    localName = qualifiedName;
                } else {
                    if (idx == qualifiedName.length() - 1) {
                        throw new DOMException(5, "Empty local name");
                    }
                    prefix = qualifiedName.substring(0, idx).intern();
                    localName = qualifiedName.substring(idx + 1);
                }
            }
        } else {
            localName = qualifiedName.toLowerCase(Locale.US);
        }
        localName = localName.intern();
        MyXMLElement myelem = new MyXMLElement(localName, namespaceURI);
        if (prefix != null) {
            myelem.setPrefix(prefix);
        }
        return myelem;
    }

    @Override
    public DOMDocumentFragment createDocumentFragment() {
        return new DOMDocumentFragment();
    }

    @Override
    public Text createTextNode(String data) {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyText text = new MyText();
        text.setData(data);
        return text;
    }

    @Override
    public Comment createComment(String data) {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyComment my = new MyComment();
        my.setData(data);
        return my;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyCDATASection my = new MyCDATASection();
        my.setData(data);
        return my;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (target == null) {
            throw new DOMException(5, "null target");
        }
        if (target.equalsIgnoreCase("xml")) {
            throw new DOMException(5, "An xml declaration is not a processing instruction");
        }
        if (target.indexOf(58) != -1) {
            throw new DOMException(5, "A processing instruction target cannot contain a ':'");
        }
        if (data.contains("?>")) {
            throw new DOMException(5, "A processing instruction data cannot contain a '?>'");
        }
        return new MyProcessingInstruction(target, data);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        if (name == null) {
            throw new DOMException(5, "null entity reference name");
        }
        return new MyEntityReference(name);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        if (name == null) {
            throw new DOMException(5, "null name");
        }
        return this.createAttributeNS(null, name.toLowerCase(Locale.US));
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (qualifiedName == null) {
            throw new DOMException(5, "null name");
        }
        String localName = qualifiedName;
        String prefix = null;
        if (namespaceURI != null) {
            if (namespaceURI.length() != 0) {
                namespaceURI = namespaceURI.intern();
                int idx = qualifiedName.indexOf(58);
                if (idx == -1) {
                    prefix = this.lookupPrefix(namespaceURI);
                } else {
                    if (idx == qualifiedName.length() - 1) {
                        throw new DOMException(5, "Empty local name");
                    }
                    prefix = qualifiedName.substring(0, idx).intern();
                    localName = qualifiedName.substring(idx + 1);
                }
            } else {
                namespaceURI = null;
            }
        }
        localName = localName.intern();
        Attr my = this.createAttributeNS(namespaceURI, prefix, localName);
        return my;
    }

    Attr createAttributeNS(String namespaceURI, String prefix, String localName) {
        MyAttr my = localName == "xmlns" ? new XmlnsAttr() : (localName == "class" ? new ClassAttr(namespaceURI) : new MyAttr(localName, namespaceURI));
        if (prefix != null) {
            my.setPrefix(prefix);
        }
        return my;
    }

    @Override
    public DOMElementList getElementsByTagName(String tagname) {
        return this.getDocumentElement().getElementsByTagName(tagname);
    }

    public DOMElementList getElementsByClassName(String names) {
        return this.getDocumentElement().getElementsByClassName(names);
    }

    @Override
    public DOMElementList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getDocumentElement().getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        DOMElement html = this.getDocumentElement();
        if (html == null) {
            return null;
        }
        return this.lookupPrefix(html, namespaceURI);
    }

    private String lookupPrefix(Node node, String namespaceURI) {
        if (node.getNamespaceURI() == namespaceURI) {
            String prefix = node.getPrefix();
            if (prefix != null) {
                return prefix;
            }
            return null;
        }
        NodeList list = node.getChildNodes();
        int sz = list.getLength();
        for (int i = 0; i < sz; ++i) {
            String prefix;
            Node cnode = list.item(i);
            if (cnode.getNodeType() != 1 || (prefix = this.lookupPrefix(cnode, namespaceURI)) == null) continue;
            return prefix;
        }
        return null;
    }

    @Override
    public DOMElement getElementById(String elementId) {
        return this.findElementById(this.getChildNodes(), elementId);
    }

    private DOMElement findElementById(NodeList nl, String elementId) {
        int sz = nl.getLength();
        for (int i = 0; i < sz; ++i) {
            DOMElement elm;
            String idValue;
            Node node = nl.item(i);
            if (node.getNodeType() == 1 && (idValue = (elm = (DOMElement)node).getAttribute(this.idAttrName)).equals(elementId)) {
                return elm;
            }
            elm = this.findElementById(node.getChildNodes(), elementId);
            if (elm == null) continue;
            return elm;
        }
        return null;
    }

    @Override
    public DOMElementList querySelectorAll(String selectors) {
        return DOMElement.querySelectorAll(selectors, this.getChildNodes());
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.xmlStandalone = xmlStandalone;
    }

    @Override
    public String getXmlVersion() {
        return null;
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    @Override
    public String getDocumentURI() {
        return this.documentURI;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        switch (importedNode.getNodeType()) {
            case 2: {
                Attr attr = this.createAttribute(importedNode.getNodeName());
                attr.setNodeValue(importedNode.getNodeValue());
                NodeList list = importedNode.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    attr.appendChild(this.importNode(list.item(i), true));
                }
                return attr;
            }
            case 1: {
                int i;
                DOMElement elm = this.createElement(importedNode.getNodeName());
                NamedNodeMap attributes = ((Element)importedNode).getAttributes();
                int count = attributes.getLength();
                for (i = 0; i < count; ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    if (!attr.getSpecified()) continue;
                    elm.setAttributeNode(attr);
                }
                if (deep) {
                    NodeList list = importedNode.getChildNodes();
                    for (i = 0; i < list.getLength(); ++i) {
                        elm.appendChild(this.importNode(list.item(i), true));
                    }
                }
                return elm;
            }
            case 3: {
                return this.createTextNode(importedNode.getNodeValue());
            }
            case 4: {
                return this.createCDATASection(importedNode.getNodeValue());
            }
            case 8: {
                return this.createComment(importedNode.getNodeValue());
            }
            case 11: {
                DOMDocumentFragment df = this.createDocumentFragment();
                if (deep) {
                    NodeList list = importedNode.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        df.appendChild(this.importNode(list.item(i), true));
                    }
                }
            }
            case 5: {
                return this.createEntityReference(importedNode.getNodeName());
            }
            case 7: {
                return this.createProcessingInstruction(importedNode.getNodeName(), importedNode.getNodeValue());
            }
        }
        throw new DOMException(9, "Cannot import this node type.");
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        switch (source.getNodeType()) {
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                throw new DOMException(9, "Adopting this node is not supported.");
            }
        }
        if (source.getOwnerDocument() == this) {
            return this.appendChild(source);
        }
        return this.adoptNode((DOMNode)source, true);
    }

    private DOMNode adoptNode(DOMNode source, boolean callHandler) {
        DOMNode adopted = (DOMNode)source.cloneNode(this);
        NodeList list = source.getChildNodes();
        block3: for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            switch (node.getNodeType()) {
                case 6: 
                case 9: 
                case 10: 
                case 12: {
                    continue block3;
                }
                default: {
                    adopted.appendChild(this.adoptNode((DOMNode)node, false));
                }
            }
        }
        if (callHandler && !source.userDataHandler.isEmpty()) {
            for (Map.Entry entry : source.userDataHandler.entrySet()) {
                String key = (String)entry.getKey();
                UserDataHandler handler = (UserDataHandler)entry.getValue();
                handler.handle((short)5, key, source.getUserData(key), source, adopted);
            }
        }
        return adopted;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        block2: {
            block3: {
                if (newChild.getNodeType() == refChild.getNodeType()) break block2;
                if (newChild.getNodeType() != 1) break block3;
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    if (this.child.get(i).getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block2;
            }
            if (newChild.getNodeType() != 10) break block2;
            int sz = this.child.getLength();
            for (int i = 0; i < sz; ++i) {
                if (this.child.get(i).getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
        return super.insertBefore(newChild, refChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        block2: {
            block3: {
                if (newChild.getNodeType() == oldChild.getNodeType()) break block2;
                if (newChild.getNodeType() != 1) break block3;
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    if (this.child.get(i).getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block2;
            }
            if (newChild.getNodeType() != 10) break block2;
            int sz = this.child.getLength();
            for (int i = 0; i < sz; ++i) {
                if (this.child.get(i).getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        block3: {
            block2: {
                if (newChild.getNodeType() != 1) break block2;
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    if (this.child.get(i).getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block3;
            }
            if (newChild.getNodeType() != 10) break block3;
            int sz = this.child.getLength();
            for (int i = 0; i < sz; ++i) {
                if (this.child.get(i).getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
        return super.appendChild(newChild);
    }

    @Override
    protected boolean checkDocumentOwner(Node newChild) {
        return newChild.getNodeType() == 10 || newChild.getOwnerDocument() == this;
    }

    @Override
    public DOMElementList getChildren() {
        return this.getDocumentElement().getChildren();
    }

    @Override
    public DOMElement getFirstElementChild() {
        return this.getDocumentElement().getFirstElementChild();
    }

    @Override
    public DOMElement getLastElementChild() {
        return this.getDocumentElement().getLastElementChild();
    }

    @Override
    public int getChildElementCount() {
        return this.getDocumentElement().getChildElementCount();
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "This operation is not supported.");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.domConfig;
    }

    @Override
    public void normalizeDocument() {
        this.getDocumentElement().normalize();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.getDocumentElement().lookupNamespaceURI(prefix);
    }

    @Override
    public StyleSheetList getStyleSheets() {
        if (this.sheets.needsUpdate()) {
            this.updateStyleLists();
        }
        return this.sheets;
    }

    void updateStyleLists() {
        int i;
        this.linkedStyle.clear();
        NodeList nl = this.getLinkedStyleNodeList();
        int len = nl.getLength();
        for (i = 0; i < len; ++i) {
            StyleDefinerElement link = (StyleDefinerElement)((Object)nl.item(i));
            if (link.getSheet() == null) continue;
            this.linkedStyle.add(link);
        }
        this.embeddedStyle.clear();
        nl = this.getEmbeddedStyleNodeList();
        len = nl.getLength();
        for (i = 0; i < len; ++i) {
            this.embeddedStyle.add((StyleDefinerElement)((Object)nl.item(i)));
        }
        Iterator<StyleDefinerElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            this.addLinkedSheet(links.next().getSheet());
        }
        Iterator<StyleDefinerElement> embd = this.embeddedStyle.iterator();
        while (embd.hasNext()) {
            this.addLinkedSheet(embd.next().getSheet());
        }
        this.sheets.setNeedsUpdate(false);
        if (this.lastStyleSheetSet != null) {
            this.setSelectedStyleSheetSet(this.lastStyleSheetSet);
        } else if (this.metaDefaultStyleSet.length() > 0) {
            this.setSelectedStyleSheetSet(this.metaDefaultStyleSet);
        } else {
            this.setSelectedStyleSheetSet(this.sheets.getPreferredStyleSheetSet());
        }
        if (this.getCanvas() != null) {
            this.getCanvas().reloadStyleState();
        }
    }

    private void addLinkedSheet(StyleSheet linkedSheet) {
        if (linkedSheet != null) {
            this.sheets.add(linkedSheet);
        }
    }

    protected NodeList getLinkedStyleNodeList() {
        return AbstractDOMNode.emptyNodeList;
    }

    protected NodeList getEmbeddedStyleNodeList() {
        return AbstractDOMNode.emptyNodeList;
    }

    @Override
    public DocumentCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        this.mergedStyleSheet = this.targetMedium == null ? this.getStyleSheetFactory().getDefaultStyleSheet().clone() : this.getStyleSheetFactory().getDefaultStyleSheet().clone(this.targetMedium);
        this.mergedStyleSheet.setOwnerDocument(this);
        this.getStyleSheets();
        Iterator<StyleSheet> it = this.sheets.iterator();
        while (it.hasNext()) {
            this.getStyleSheet().addStyleSheet((AbstractCSSStyleSheet)it.next());
        }
    }

    @Override
    public DOMStringList getStyleSheetSets() {
        if (this.sheets.needsUpdate()) {
            this.updateStyleLists();
        }
        return this.sheets.getStyleSheetSets();
    }

    @Override
    public String getSelectedStyleSheetSet() {
        String selectedSetName = "";
        Iterator<StyleDefinerElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equals(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        return selectedSetName;
    }

    @Override
    public void setSelectedStyleSheetSet(String name) {
        if (name == null || name.length() > 0 && !this.getStyleSheetSets().contains(name)) {
            return;
        }
        Iterator<StyleDefinerElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0) continue;
            if (title.equals(name)) {
                sheet.setDisabled(false);
                this.lastStyleSheetSet = name;
                continue;
            }
            sheet.setDisabled(true);
        }
    }

    @Override
    public String getLastStyleSheetSet() {
        return this.lastStyleSheetSet;
    }

    @Override
    public void enableStyleSheetsForSet(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        Iterator<StyleDefinerElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || !title.equals(name)) continue;
            sheet.setDisabled(false);
        }
    }

    void onEmbeddedStyleAdd(LinkStyle element) {
        if (element instanceof HTMLDocument.LinkElement) {
            this.linkedStyle.add((HTMLDocument.LinkElement)element);
        } else if (element instanceof HTMLDocument.StyleElement) {
            this.embeddedStyle.add((HTMLDocument.StyleElement)element);
        }
        this.onStyleModify();
    }

    void onEmbeddedStyleRemove(LinkStyle element) {
        String title;
        if (element instanceof HTMLDocument.LinkElement) {
            this.linkedStyle.remove(element);
        } else if (element instanceof HTMLDocument.StyleElement) {
            this.embeddedStyle.remove(element);
        }
        StyleSheet sheet = element.getSheet();
        if (sheet != null && (title = sheet.getTitle()) != null) {
            this.sheets.remove(title);
        }
        this.onStyleModify();
    }

    void onStyleModify() {
        if (this.mergedStyleSheet != null) {
            this.mergedStyleSheet = null;
            this.sheets.setNeedsUpdate(true);
        } else {
            this.sheets.setNeedsUpdate(true);
        }
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        return ((DOMElement)elt).getOverrideStyle(pseudoElt);
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        StyleDatabase sdb = null;
        if (this.targetMedium != null) {
            sdb = this.getStyleSheetFactory().getDeviceFactory().getStyleDatabase(this.targetMedium);
        }
        return sdb;
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public void setTargetMedium(String medium) throws CSSMediaException {
        this.targetMedium = "all".equals(medium = medium.intern()) ? null : medium;
        this.onStyleModify();
    }

    @Override
    public CSSCanvas getCanvas() {
        if (this.targetMedium == null) {
            return null;
        }
        if (this.canvases.containsKey(this.targetMedium)) {
            return this.canvases.get(this.targetMedium);
        }
        CSSCanvas canvas = this.getStyleSheetFactory().getDeviceFactory().createCanvas(this.targetMedium, this);
        this.canvases.put(this.targetMedium, canvas);
        return canvas;
    }

    @Override
    public boolean hasStyleIssues() {
        return this.sheets.hasErrorsOrWarnings();
    }

    @Override
    public void onFontFaceRule(CSSFontFaceRule rule) {
        for (CSSCanvas canvas : this.canvases.values()) {
            if (canvas == null) continue;
            canvas.loadFontFace(rule);
        }
    }

    @Override
    public void onPageRule(CSSPageRule rule) {
    }

    public void onMetaAdded(String name, String attribute) {
        if ("Default-Style".equals(name)) {
            this.metaDefaultStyleSet = attribute;
        }
    }

    public void onMetaRemoved(String name, String attribute) {
        if ("Default-Style".equals(name)) {
            this.metaDefaultStyleSet = "";
        }
    }

    @Override
    public URL getBaseURL() {
        URL baseURL;
        try {
            baseURL = new URL(this.getDocumentURI());
        }
        catch (MalformedURLException e) {
            baseURL = null;
        }
        return baseURL;
    }

    @Override
    public String getBaseURI() {
        return this.getDocumentURI();
    }

    @Override
    public URL getURL(String uri) throws MalformedURLException {
        if (uri.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        URL url = uri.indexOf("://") < 0 ? new URL(this.getBaseURL(), uri) : new URL(uri);
        return url;
    }

    @Override
    public boolean isSafeOrigin(URL linkedURL) {
        URL base = this.getBaseURL();
        String docHost = base.getHost();
        int docPort = base.getPort();
        if (docPort == -1) {
            docPort = base.getDefaultPort();
        }
        String linkedHost = linkedURL.getHost();
        int linkedPort = linkedURL.getPort();
        if (linkedPort == -1) {
            linkedPort = linkedURL.getDefaultPort();
        }
        return (docHost.equalsIgnoreCase(linkedHost) || linkedHost.endsWith(docHost)) && docPort == linkedPort;
    }

    public String toString() {
        return this.getChildNodes().toString();
    }

    public InputStream openStream(String uri) throws IOException {
        return this.openConnection(this.getURL(uri)).getInputStream();
    }

    private static InputStream openResourceStream(final String fileName) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return OriginPolicy.class.getResourceAsStream(fileName);
            }
        });
    }

    class MyOMStyleSheetList
    extends OMStyleSheetList {
        protected MyOMStyleSheetList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected boolean hasErrorsOrWarnings() {
            boolean hasRuleErrors = false;
            Iterator<StyleSheet> it = this.iterator();
            while (it.hasNext()) {
                AbstractCSSStyleSheet sheet = (AbstractCSSStyleSheet)it.next();
                SheetErrorHandler eh = sheet.getErrorHandler();
                if (!sheet.hasRuleErrorsOrWarnings() && !eh.hasSacErrors() && !eh.hasSacWarnings() && !eh.hasOMErrors()) continue;
                hasRuleErrors = true;
                break;
            }
            return hasRuleErrors;
        }

        @Override
        protected Iterator<StyleSheet> iterator() {
            return super.iterator();
        }

        @Override
        protected void clear() {
            super.clear();
        }

        @Override
        protected boolean needsUpdate() {
            return super.needsUpdate();
        }

        @Override
        protected void setNeedsUpdate(boolean needsUpdate) {
            super.setNeedsUpdate(needsUpdate);
        }

        @Override
        protected void update() {
            super.update();
            DOMDocument.this.updateStyleLists();
        }
    }

    class MyDOMConfiguration
    implements DOMConfiguration {
        private final Properties parameters = new Properties();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MyDOMConfiguration() {
            BufferedReader re = null;
            try {
                re = new BufferedReader(new InputStreamReader(DOMDocument.openResourceStream("/io/sf/carte/doc/dom/domconfig.properties"), "utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                this.parameters.load(re);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    re.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public boolean canSetParameter(String name, Object value) {
            return name.equals("error-handler") && value instanceof DOMErrorHandler;
        }

        @Override
        public Object getParameter(String name) throws DOMException {
            return this.parameters.getProperty(name);
        }

        @Override
        public DOMStringList getParameterNames() {
            String[] names = this.parameters.keySet().toArray(new String[0]);
            return new DOMStringListImpl(names);
        }

        @Override
        public void setParameter(String name, Object value) throws DOMException {
            if (name.equals("error-handler") && value instanceof DOMErrorHandler) {
                DOMDocument.this.errorHandler = (DOMErrorHandler)value;
            } else if (this.canSetParameter(name, value)) {
                this.parameters.setProperty(name, value.toString());
            }
        }
    }

    class MyXMLElement
    extends DOMElement {
        private String idAttrName;

        MyXMLElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
            this.idAttrName = "";
        }

        @Override
        boolean isIdAttributeNS(String namespaceURI, String localName) {
            return this.idAttrName.equals(localName);
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            if (isId) {
                this.idAttrName = name;
            } else if (name.equals(this.idAttrName)) {
                this.idAttrName = "";
            }
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            this.setIdAttribute(localName, isId);
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            if (idAttr == null) {
                throw new DOMException(8, "Null attribute");
            }
            this.idAttrName = idAttr.getName();
        }

        @Override
        public String getId() {
            return this.getAttribute(this.idAttrName);
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        protected BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMDocument.this.getStyleSheetFactory();
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public DOMElement cloneNode(boolean deep) {
            return this.cloneElementNode(new MyXMLElement(this.getLocalName(), this.getNamespaceURI()), deep);
        }

        DOMElement cloneElementNode(MyXMLElement my, boolean deep) {
            for (Attr attr : this.nodeMap.attributes.values()) {
                MyAttr myattr = new MyAttr(attr.getName(), attr.getNamespaceURI());
                myattr.setValue(attr.getValue());
                myattr.specified = false;
                my.setAttributeNode(myattr);
            }
            if (deep && this.hasChildNodes()) {
                NodeList list = this.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    my.appendChild(list.item(i).cloneNode(true));
                }
            }
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        DOMElement cloneNode(DOMDocument ownerDocument) {
            DOMElement my = ownerDocument.createElementNS(this.getLocalName(), this.getNamespaceURI());
            for (MyAttr attr : this.nodeMap.attributes.values()) {
                if (!attr.getSpecified()) continue;
                attr = (MyAttr)attr.cloneNode(ownerDocument);
                my.setAttributeNode(attr);
            }
            return my;
        }
    }

    static interface StyleDefinerElement
    extends LinkStyle {
        @Override
        public AbstractCSSStyleSheet getSheet();

        public void resetLinkedSheet();
    }

    class ClassAttr
    extends MyAttr {
        ClassAttr(String namespaceURI) {
            super("class", namespaceURI);
        }

        @Override
        void setParentNode(Node parentNode) throws DOMException {
            CSSNode parent;
            DOMElement owner;
            if (parentNode == null && (owner = this.getOwnerElement()) != null) {
                parent = owner.getParentNode();
                if (parent != null && parent.getNodeType() == 1) {
                    ((DOMElement)parent).updateClasslistsOnRemove(owner);
                }
                if (owner.classList != null) {
                    this.value = owner.classList.getValue();
                    owner.classList.clear();
                }
            }
            super.setParentNode(parentNode);
            if (parentNode != null) {
                owner = (DOMElement)parentNode;
                if (owner.classList != null) {
                    owner.classList.setValue(this.value);
                }
                if ((parent = owner.getParentNode()) != null && parent.getNodeType() == 1) {
                    ((DOMElement)parent).updateClasslists(owner);
                }
            }
        }

        @Override
        public String getValue() {
            DOMElement.ClassList list = this.getListValue();
            if (list == null) {
                return super.getValue();
            }
            return list.getValue();
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            DOMElement.ClassList list = this.getListValue();
            if (list != null) {
                list.setValue(value);
            }
        }

        DOMElement.ClassList getListValue() {
            DOMElement owner = this.getOwnerElement();
            if (owner == null) {
                return null;
            }
            return (DOMElement.ClassList)owner.getClassList();
        }
    }

    class StyleEventAttr
    extends MyAttr {
        StyleEventAttr(String name, String namespaceURI) {
            super(name, namespaceURI);
        }

        @Override
        void setParentNode(Node parentNode) {
            super.setParentNode(parentNode);
            this.onDOMChange(parentNode);
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            this.onDOMChange(this.getOwnerElement());
        }

        void onDOMChange(Node ownerNode) {
            if (ownerNode != null && ownerNode instanceof StyleDefinerElement) {
                ((StyleDefinerElement)((Object)ownerNode)).resetLinkedSheet();
            }
        }
    }

    class XmlnsAttr
    extends MyAttr {
        XmlnsAttr() {
            super("xmlns", null);
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
            throw new DOMException(14, "Cannot set prefix for xmlns attribute");
        }
    }

    class MyAttr
    extends DOMAttr {
        MyAttr(String name, String namespaceURI) {
            super(name, namespaceURI);
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public boolean isId() {
            DOMElement owner = this.getOwnerElement();
            return owner != null && owner.isIdAttributeNS(this.getNamespaceURI(), this.getLocalName());
        }

        @Override
        public Attr cloneNode(boolean deep) {
            MyAttr my = (MyAttr)this.getOwnerDocument().createAttributeNS(this.getNamespaceURI(), this.getName());
            my.setValue(this.getValue());
            my.specified = true;
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        Attr cloneNode(DOMDocument ownerDocument) {
            MyAttr attr = (MyAttr)ownerDocument.createAttributeNS(this.getNamespaceURI(), this.getName());
            attr.setValue(this.getValue());
            attr.specified = false;
            return attr;
        }
    }

    class MyCDATASection
    extends MyText
    implements CDATASection {
        MyCDATASection() {
            super((short)4);
        }

        @Override
        public String getNodeName() {
            return "#cdata-section";
        }

        @Override
        public CDATASection cloneNode(boolean deep) {
            MyCDATASection my = new MyCDATASection();
            my.setData(this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        Node cloneNode(DOMDocument ownerDocument) {
            return ownerDocument.createCDATASection(this.getData());
        }

        @Override
        public String toString() {
            return "<![CDATA[" + this.getData() + "]]>";
        }
    }

    class MyText
    extends MyCharacterData
    implements Text {
        boolean elementContentWhitespace;

        MyText() {
            super((short)3);
            this.elementContentWhitespace = false;
        }

        MyText(short nodeType) {
            super(nodeType);
            this.elementContentWhitespace = false;
        }

        @Override
        public void setData(String data) throws DOMException {
            super.setData(data);
            CSSNode parent = this.getParentNode();
            if (parent != null && DOMDocument.this.isEmbeddedStyleDefiner(parent)) {
                ((StyleDefinerElement)((Object)parent)).resetLinkedSheet();
            }
        }

        @Override
        public Text splitText(int offset) throws DOMException {
            Text newnode;
            CSSNode parent = this.getParentNode();
            try {
                String newdata = this.data.substring(0, offset);
                newnode = this.getOwnerDocument().createTextNode(this.data.substring(offset, this.data.length()));
                if (parent != null) {
                    parent.insertBefore(newnode, this.getNextSibling());
                }
                this.setData(newdata);
            }
            catch (IndexOutOfBoundsException e) {
                throw new DOMException(1, e.getMessage());
            }
            return newnode;
        }

        @Override
        public boolean isElementContentWhitespace() {
            if (this.data != null) {
                int dl = this.data.length();
                for (int i = 0; i < dl; ++i) {
                    if (Character.isWhitespace(this.data.charAt(i))) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public String getWholeText() {
            short type;
            short type2;
            Node node;
            Node firstnode = this;
            for (node = this.getPreviousSibling(); node != null && ((type2 = node.getNodeType()) == 3 || type2 == 5); node = node.getPreviousSibling()) {
                firstnode = node;
            }
            Node lastnode = this;
            for (node = this.getNextSibling(); node != null && ((type = node.getNodeType()) == 3 || type == 5); node = node.getNextSibling()) {
                lastnode = node;
            }
            if (firstnode == lastnode) {
                return this.getData();
            }
            StringBuilder buf = new StringBuilder(this.data.length() * 2);
            for (node = firstnode; node != lastnode; node = node.getNextSibling()) {
                buf.append(node.toString());
            }
            buf.append(lastnode.toString());
            return buf.toString();
        }

        @Override
        public Text replaceWholeText(String content) throws DOMException {
            if (content == null) {
                throw new DOMException(5, "null content (use empty string instead)");
            }
            CSSNode parent = this.getParentNode();
            if (parent != null) {
                Node sibling;
                short type;
                Node node = this.getPreviousSibling();
                while (node != null && ((type = node.getNodeType()) == 5 || type == 3)) {
                    sibling = node.getPreviousSibling();
                    parent.removeChild(node);
                    node = sibling;
                }
                node = this.getNextSibling();
                while (node != null && ((type = node.getNodeType()) == 5 || type == 3)) {
                    sibling = node.getNextSibling();
                    parent.removeChild(node);
                    node = sibling;
                }
            }
            this.setData(content);
            if (content.length() == 0) {
                if (parent != null) {
                    parent.removeChild(this);
                }
                return null;
            }
            return this;
        }

        @Override
        public String getNodeName() {
            return "#text";
        }

        @Override
        public Text cloneNode(boolean deep) {
            MyText my = new MyText();
            my.setData(this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        Node cloneNode(DOMDocument ownerDocument) {
            return ownerDocument.createTextNode(this.getData());
        }

        public String toString() {
            String parentLName;
            CSSNode node = this.getParentNode();
            String text = node != null && node.getNodeType() == 1 && DOMDocument.this.isRawTextElementName(parentLName = ((DOMElement)node).getLocalName()) ? DOMDocument.escapeCloseTag(parentLName, this.getData()) : DOMDocument.escapeLtGtEntities(this.getData());
            return text;
        }
    }

    class MyComment
    extends MyCharacterData
    implements Comment {
        MyComment() {
            super((short)8);
        }

        @Override
        public String getNodeName() {
            return "#comment";
        }

        @Override
        public void setData(String data) throws DOMException {
            if (data.contains("-->")) {
                throw new DOMException(5, "Comment cannot contain '--'");
            }
            super.setData(data);
        }

        @Override
        public Comment cloneNode(boolean deep) {
            MyComment my = new MyComment();
            my.setData(this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        Node cloneNode(DOMDocument ownerDocument) {
            return ownerDocument.createComment(this.getData());
        }

        public String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    abstract class MyCharacterData
    extends MyNode
    implements CharacterData {
        String data;

        MyCharacterData(short nodeType) {
            super(nodeType);
            this.data = null;
        }

        @Override
        public String getData() throws DOMException {
            return this.data;
        }

        @Override
        public void setData(String data) throws DOMException {
            this.data = data;
        }

        @Override
        public int getLength() {
            return this.data.length();
        }

        @Override
        public String substringData(int offset, int count) throws DOMException {
            try {
                return this.data.substring(offset, offset + count);
            }
            catch (IndexOutOfBoundsException e) {
                throw new DOMException(1, e.getMessage());
            }
        }

        @Override
        public void appendData(String arg) throws DOMException {
            StringBuilder buf = new StringBuilder(this.data.length() + arg.length());
            buf.append(this.data).append(arg);
            this.setData(buf.toString());
        }

        @Override
        public void insertData(int offset, String arg) throws DOMException {
            int dl = this.data.length();
            StringBuilder buf = new StringBuilder(dl + arg.length());
            try {
                buf.append(this.data.subSequence(0, offset)).append(arg).append(this.data.subSequence(offset, dl));
            }
            catch (IndexOutOfBoundsException e) {
                throw new DOMException(1, e.getMessage());
            }
            this.setData(buf.toString());
        }

        @Override
        public void deleteData(int offset, int count) throws DOMException {
            int dl = this.data.length();
            StringBuilder buf = new StringBuilder(dl - count);
            try {
                buf.append(this.data.subSequence(0, offset)).append(this.data.subSequence(offset + count, dl));
            }
            catch (IndexOutOfBoundsException e) {
                throw new DOMException(1, e.getMessage());
            }
            this.setData(buf.toString());
        }

        @Override
        public void replaceData(int offset, int count, String arg) throws DOMException {
            int dl = this.data.length();
            StringBuilder buf = new StringBuilder(dl + arg.length() - count);
            try {
                buf.append(this.data.subSequence(0, offset)).append(arg).append(this.data.subSequence(offset + count, dl));
            }
            catch (IndexOutOfBoundsException e) {
                throw new DOMException(1, e.getMessage());
            }
            this.setData(buf.toString());
        }

        @Override
        public String getNodeValue() {
            return this.getData();
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            throw new DOMException(3, "Cannot append the node to text/comment/cdatasection");
        }
    }

    class MyProcessingInstruction
    extends MyNode
    implements ProcessingInstruction {
        String data;
        private final String target;

        MyProcessingInstruction(String target, String data) {
            super((short)7);
            this.target = target;
            this.data = data;
        }

        @Override
        public String getNodeName() {
            return this.getTarget();
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public String getTarget() {
            return this.target;
        }

        @Override
        public void setData(String data) throws DOMException {
            this.data = data;
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getData();
        }

        @Override
        public ProcessingInstruction cloneNode(boolean deep) {
            MyProcessingInstruction my = new MyProcessingInstruction(this.getTarget(), this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        Node cloneNode(DOMDocument ownerDocument) {
            return ownerDocument.createProcessingInstruction(this.getTarget(), this.getData());
        }

        public String toString() {
            return "<?" + this.getTarget() + " " + this.getData() + "?>";
        }
    }

    class MyEntityReference
    extends MyNode
    implements EntityReference {
        private final String name;

        MyEntityReference(String name) {
            super((short)5);
            this.name = name;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            this.checkAppendNode(newChild);
            throw new DOMException(9, "This implementation does not support appending nodes to an entity reference.");
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return null;
        }

        @Override
        EntityReference cloneNode(DOMDocument ownerDocument) {
            EntityReference my = ownerDocument.createEntityReference(this.name);
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            return '&' + this.name + ';';
        }
    }

    public class DOMDocumentFragment
    extends MyNode
    implements DocumentFragment,
    ParentNode {
        WeakReference<DOMElementList> childElementRef;

        DOMDocumentFragment() {
            super((short)11);
            this.childElementRef = null;
        }

        @Override
        protected AbstractDOMNode.DOMNodeList createChildNodeList() {
            return new AbstractDOMNode.ChildNodeList();
        }

        @Override
        public String getNodeName() {
            return "#document-fragment";
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return null;
        }

        @Override
        public DOMElementList getChildren() {
            DOMElementList list = null;
            if (this.childElementRef != null) {
                list = (DOMElementList)this.childElementRef.get();
            }
            if (list == null) {
                list = new AbstractDOMNode.ChildElementList(this);
                this.childElementRef = new WeakReference<DOMElementList>(list);
            }
            return list;
        }

        @Override
        public DOMElement getFirstElementChild() {
            return (DOMElement)super.getFirstElementChild();
        }

        @Override
        public DOMElement getLastElementChild() {
            return (DOMElement)super.getLastElementChild();
        }

        @Override
        public int getChildElementCount() {
            return super.getChildElementCount();
        }

        @Override
        public DOMElementList querySelectorAll(String selectors) {
            return DOMElement.querySelectorAll(selectors, this.getChildNodes());
        }

        @Override
        public DOMDocumentFragment cloneNode(boolean deep) {
            DOMDocumentFragment my = new DOMDocumentFragment();
            if (deep && my.hasChildNodes()) {
                NodeList list = my.getChildNodes();
                int sz = list.getLength();
                for (int i = 0; i < sz; ++i) {
                    my.appendChild(list.item(i).cloneNode(true));
                }
            }
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        DocumentFragment cloneNode(DOMDocument ownerDocument) {
            return ownerDocument.createDocumentFragment();
        }

        public String toString() {
            NodeList list = this.getChildNodes();
            int sz = list.getLength();
            StringBuilder buf = new StringBuilder(64 + sz * 32);
            for (int i = 0; i < sz; ++i) {
                buf.append(list.item(i).toString());
            }
            return buf.toString();
        }
    }

    abstract class MyNode
    extends DOMNode {
        MyNode(short nodeType) {
            super(nodeType);
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            if (newChild.getNodeType() == 10) {
                throw new DOMException(3, "Doctype must be added to document.");
            }
            return super.appendChild(newChild);
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public Node cloneNode(boolean deep) {
            return this;
        }
    }
}

