/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

class DocumentTypeImpl
extends AbstractDOMNode
implements DocumentType {
    private String qualifiedName;
    private String publicId;
    private String systemId;
    final AbstractDOMNode.DOMNamedNodeMap<Entity> entityMap;
    final AbstractDOMNode.DOMNamedNodeMap<Notation> notationMap;

    public DocumentTypeImpl(String qualifiedName, String publicId, String systemId) {
        super((short)10);
        this.qualifiedName = qualifiedName;
        this.publicId = publicId;
        this.systemId = systemId;
        this.entityMap = new AbstractDOMNode.DOMNamedNodeMap(6);
        this.notationMap = new AbstractDOMNode.DOMNamedNodeMap(12);
    }

    @Override
    public String getBaseURI() {
        Document doc = this.getOwnerDocument();
        if (doc != null) {
            return doc.getBaseURI();
        }
        return null;
    }

    @Override
    public NamedNodeMap getEntities() {
        return this.entityMap;
    }

    @Override
    public String getInternalSubset() {
        return null;
    }

    @Override
    public String getName() {
        return this.qualifiedName;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public NamedNodeMap getNotations() {
        return this.notationMap;
    }

    @Override
    public Document getOwnerDocument() {
        return (Document)this.getParentNode();
    }

    void setOwnerDocument(Document ownerDocument) {
        this.setParentNode(ownerDocument);
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public Node cloneNode(boolean deep) {
        return new DocumentTypeImpl(this.qualifiedName, this.publicId, this.systemId);
    }

    @Override
    Node cloneNode(DOMDocument ownerDocument) {
        return ownerDocument.getImplementation().createDocumentType(this.qualifiedName, this.publicId, this.systemId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("<!DOCTYPE ").append(this.qualifiedName);
        if (this.publicId != null) {
            buf.append(" PUBLIC \"").append(this.publicId).append('\"');
        }
        if (this.systemId != null) {
            buf.append(" \"").append(this.systemId).append('\"');
        }
        buf.append('>');
        return buf.toString();
    }
}

