/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMElementList;
import io.sf.carte.doc.dom.HTMLElement;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.MediaQueryFactory;
import io.sf.carte.doc.style.css.om.OMMediaList;
import io.sf.carte.doc.style.css.property.AttributeToStyle;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

public abstract class HTMLDocument
extends DOMDocument {
    public static final String HTML_NAMESPACE_URI = "http://www.w3.org/1999/xhtml";
    private URL baseURL = null;
    private String idAttrName = "id";

    public HTMLDocument(DocumentType documentType) {
        super(documentType);
    }

    @Override
    public HTMLElement getDocumentElement() {
        return (HTMLElement)super.getDocumentElement();
    }

    @Override
    public HTMLDocument getOwnerDocument() {
        return null;
    }

    @Override
    public HTMLDocument cloneNode(boolean deep) {
        HTMLDocument doc = (HTMLDocument)this.getImplementation().createDocument(HTML_NAMESPACE_URI, "html", this.getDoctype());
        if (deep) {
            doc.appendChild(doc.adoptNode(this.getDocumentElement()));
        }
        this.callUserHandlers((short)1, this, doc);
        return doc;
    }

    @Override
    DOMDocument cloneNode(DOMDocument ownerDocument) {
        return ownerDocument.getImplementation().createDocument(HTML_NAMESPACE_URI, "html", this.getDoctype());
    }

    @Override
    public DOMElement createElement(String tagName) throws DOMException {
        if (tagName == null) {
            throw new DOMException(5, "null tag name");
        }
        return this.createElementNS(HTML_NAMESPACE_URI, tagName);
    }

    @Override
    public DOMElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName;
        String prefix;
        if (qualifiedName == null) {
            throw new DOMException(5, "null qualified name");
        }
        if (namespaceURI != null && !namespaceURI.equals(HTML_NAMESPACE_URI) && namespaceURI.length() != 0) {
            namespaceURI = namespaceURI.intern();
            int idx = qualifiedName.indexOf(58);
            if (idx == -1) {
                prefix = this.lookupPrefix(namespaceURI);
                localName = qualifiedName;
            } else {
                if (idx == qualifiedName.length() - 1) {
                    throw new DOMException(5, "Empty local name");
                }
                prefix = qualifiedName.substring(0, idx).intern();
                localName = qualifiedName.substring(idx + 1);
            }
        } else {
            namespaceURI = HTML_NAMESPACE_URI;
            localName = qualifiedName.toLowerCase(Locale.US);
            prefix = null;
        }
        localName = localName.intern();
        DOMElement myelem = namespaceURI == HTML_NAMESPACE_URI ? ("link" == localName ? new LinkElement() : ("style" == localName ? new StyleElement() : ("meta" == localName ? new MetaElement() : ("base" == localName ? new BaseElement() : ("title" == localName ? new MetacontentElement(localName) : ("html" == localName ? new HtmlRootElement() : ("img" == localName ? new ImgElement() : ("font" == localName ? new FontElement() : ("table" == localName ? new TableElement() : ("tr" == localName ? new TableRowElement() : ("td" == localName ? new TableCellElement(localName) : ("th" == localName ? new TableCellElement(localName) : new MyHTMLElement(localName, namespaceURI))))))))))))) : new DOMDocument.MyXMLElement(localName, namespaceURI);
        if (prefix != null) {
            myelem.setPrefix(prefix);
        }
        return myelem;
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (qualifiedName == null) {
            throw new DOMException(5, "null name");
        }
        String localName = qualifiedName;
        String prefix = null;
        if (namespaceURI != null) {
            if (namespaceURI.length() != 0) {
                if (!(namespaceURI = namespaceURI.intern()).equals(HTML_NAMESPACE_URI)) {
                    int idx = qualifiedName.indexOf(58);
                    if (idx == -1) {
                        prefix = this.lookupPrefix(namespaceURI);
                    } else {
                        if (idx == qualifiedName.length() - 1) {
                            throw new DOMException(5, "Empty local name");
                        }
                        prefix = qualifiedName.substring(0, idx).intern();
                        localName = qualifiedName.substring(idx + 1);
                    }
                }
            } else {
                namespaceURI = null;
            }
        }
        localName = localName.intern();
        DOMDocument.MyAttr my = namespaceURI == null || namespaceURI == HTML_NAMESPACE_URI ? (localName == "class" ? new DOMDocument.ClassAttr(namespaceURI) : (localName == "href" ? new HrefEventAttr(namespaceURI) : (localName == "media" ? new DOMDocument.StyleEventAttr("media", namespaceURI) : new DOMDocument.MyAttr(localName, namespaceURI)))) : (localName == "xmlns" ? new DOMDocument.XmlnsAttr() : new DOMDocument.MyAttr(localName, namespaceURI));
        if (prefix != null) {
            my.setPrefix(prefix);
        }
        return my;
    }

    @Override
    public String getXmlVersion() {
        return null;
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new DOMException(9, "This is an HTML document.");
    }

    @Override
    public URL getBaseURL() {
        if (this.baseURL == null) {
            Element elm;
            String s;
            String buri = this.getDocumentURI();
            DOMElementList nl = this.getElementsByTagName("base");
            if (nl.getLength() > 0 && (s = (elm = (Element)nl.item(0)).getAttribute("href")).length() > 0) {
                if (buri != null && s.startsWith("//")) {
                    try {
                        URL url = new URL(buri);
                        url = new URL(url, s);
                        buri = url.toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else {
                    buri = s;
                }
            }
            try {
                this.baseURL = new URL(buri);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.baseURL;
    }

    @Override
    public String getBaseURI() {
        URL url = this.getBaseURL();
        if (url != null) {
            return url.toExternalForm();
        }
        return null;
    }

    @Override
    protected boolean isEmbeddedStyleDefiner(Node node) {
        return node.getNodeName() == "style";
    }

    @Override
    protected boolean isRawTextElementName(String localName) {
        return localName.equals("style") || localName.equals("script");
    }

    @Override
    protected NodeList getLinkedStyleNodeList() {
        return this.getElementsByTagName("link");
    }

    @Override
    protected NodeList getEmbeddedStyleNodeList() {
        return this.getElementsByTagName("style");
    }

    class HrefEventAttr
    extends DOMDocument.MyAttr {
        HrefEventAttr(String namespaceURI) {
            super("href", namespaceURI);
        }

        @Override
        void setParentNode(Node parentNode) {
            super.setParentNode(parentNode);
            if (parentNode != null) {
                this.onDOMChange((DOMElement)parentNode);
            }
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            DOMElement owner = this.getOwnerElement();
            if (owner != null) {
                this.onDOMChange(owner);
            }
        }

        void onDOMChange(DOMElement owner) {
            String tagname = owner.getTagName();
            if (tagname == "link") {
                ((LinkElement)owner).resetLinkedSheet();
            } else if (tagname == "base") {
                HTMLDocument doc = (HTMLDocument)this.getOwnerDocument();
                if (this.value != null) {
                    URL base;
                    try {
                        base = new URL(this.value);
                    }
                    catch (MalformedURLException e) {
                        if (doc != null) {
                            doc.baseURL = null;
                        }
                        return;
                    }
                    if (doc != null) {
                        doc.baseURL = base;
                    }
                } else if (doc != null) {
                    doc.baseURL = null;
                }
            }
        }
    }

    class TableCellElement
    extends MyHTMLElement {
        TableCellElement(String localName) {
            super(localName);
        }

        TableCellElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("bgcolor") || this.hasAttribute("width") || this.hasAttribute("height");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.bgcolor(this.getAttribute("bgcolor"), style);
            AttributeToStyle.width(this.getAttribute("width"), style);
            AttributeToStyle.height(this.getAttribute("height"), style);
        }
    }

    class TableRowElement
    extends MyHTMLElement {
        TableRowElement() {
            super("tr");
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("bgcolor");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.bgcolor(this.getAttribute("bgcolor"), style);
        }
    }

    class TableElement
    extends MyHTMLElement {
        TableElement() {
            super("table");
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("bgcolor");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.bgcolor(this.getAttribute("bgcolor"), style);
        }
    }

    class FontElement
    extends MyHTMLElement {
        FontElement() {
            super("font");
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("face") || this.hasAttribute("size") || this.hasAttribute("color");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.face(this.getAttribute("face"), style);
            AttributeToStyle.size(this.getAttribute("size"), style);
            AttributeToStyle.color(this.getAttribute("color"), style);
        }
    }

    class ImgElement
    extends MyHTMLElement {
        ImgElement() {
            super("img");
        }

        @Override
        protected AbstractDOMNode.DOMNodeList createChildNodeList() {
            return DOMDocument.nvemptyNodeList;
        }

        @Override
        boolean isVoid() {
            return true;
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("width") || this.hasAttribute("height");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.width(this.getAttribute("width"), style);
            AttributeToStyle.height(this.getAttribute("height"), style);
        }
    }

    class MetaElement
    extends MyHTMLElement {
        MetaElement() {
            super("meta");
        }

        @Override
        protected AbstractDOMNode.DOMNodeList createChildNodeList() {
            return DOMDocument.nvemptyNodeList;
        }

        @Override
        boolean isVoid() {
            return true;
        }

        @Override
        void setParentNode(Node parentNode) throws DOMException {
            if (parentNode == null) {
                String name = this.getAttribute("http-equiv");
                if (name.length() == 0) {
                    name = this.getAttribute("name");
                }
                this.getOwnerDocument().onMetaRemoved(name, this.getAttribute("content"));
                super.setParentNode(null);
            } else {
                short type = parentNode.getNodeType();
                if (type != 11 && (type != 1 || parentNode.getNodeName() != "head" && parentNode.getNodeName() != "noscript" && this.hasAttributes() && (this.hasAttribute("charset") || this.hasAttribute("http-equiv")))) {
                    String msg = "A <meta> tag can occur only in the head or noscript element, not in " + parentNode.getNodeName();
                    throw new DOMException(3, msg);
                }
                super.setParentNode(parentNode);
                String name = this.getAttribute("http-equiv");
                if (name.length() == 0) {
                    name = this.getAttribute("name");
                }
                this.getOwnerDocument().onMetaAdded(name, this.getAttribute("content"));
            }
        }
    }

    class StyleElement
    extends MyHTMLElement
    implements DOMDocument.StyleDefinerElement {
        private AbstractCSSStyleSheet containedSheet;

        StyleElement() {
            super("style");
            this.containedSheet = null;
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.containedSheet == null) {
                MediaQueryList mediaList;
                String type = this.getAttribute("type");
                if (!"text/css".equals(type)) {
                    return null;
                }
                String media = this.getAttribute("media");
                if ((media = media.trim()).length() == 0) {
                    mediaList = OMMediaList.createMediaList();
                } else {
                    mediaList = MediaQueryFactory.createMediaList(media);
                    if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                        this.getStyleSheetFactory().getErrorHandler().mediaQueryError(media);
                    }
                }
                AbstractCSSStyleSheet sheet = this.getStyleSheetFactory().createLinkedStyleSheet(this, this.getAttribute("title"), mediaList);
                String styleText = this.getTextContent().trim();
                if (styleText.length() != 0) {
                    sheet.setHref(this.getBaseURI());
                    InputSource source = new InputSource();
                    StringReader re = new StringReader(styleText);
                    source.setCharacterStream((Reader)re);
                    try {
                        sheet.parseCSSStyleSheet(source);
                    }
                    catch (Exception e) {
                        this.getStyleSheetFactory().getErrorHandler().onException(e, sheet);
                    }
                }
                this.containedSheet = sheet;
            }
            return this.containedSheet;
        }

        @Override
        public void resetLinkedSheet() {
            this.containedSheet = null;
            this.getOwnerDocument().onStyleModify();
        }

        @Override
        void setParentNode(Node parentNode) throws DOMException {
            super.setParentNode(parentNode);
            HTMLDocument.this.onStyleModify();
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            Node retChild = super.appendChild(newChild);
            this.resetLinkedSheet();
            return retChild;
        }

        @Override
        public Node insertBefore(Node newChild, Node refChild) throws DOMException {
            Node retChild = super.insertBefore(newChild, refChild);
            this.resetLinkedSheet();
            return retChild;
        }

        @Override
        public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
            Node retChild = super.replaceChild(newChild, oldChild);
            this.resetLinkedSheet();
            return retChild;
        }

        @Override
        public Node removeChild(Node oldChild) throws DOMException {
            Node retChild = super.removeChild(oldChild);
            this.resetLinkedSheet();
            return retChild;
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            super.setTextContent(textContent);
            this.resetLinkedSheet();
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new StyleElement(), deep);
        }
    }

    class LinkElement
    extends MyHTMLElement
    implements DOMDocument.StyleDefinerElement {
        private AbstractCSSStyleSheet linkedSheet;

        LinkElement() {
            super("link");
            this.linkedSheet = null;
        }

        @Override
        protected AbstractDOMNode.DOMNodeList createChildNodeList() {
            return DOMDocument.nvemptyNodeList;
        }

        @Override
        boolean isVoid() {
            return true;
        }

        @Override
        void setParentNode(Node parentNode) throws DOMException {
            short type;
            if (parentNode != null && (type = parentNode.getNodeType()) != 11 && (type != 1 || parentNode.getNodeName() != "head" && parentNode.getNodeName() != "noscript" && this.hasAttributes() && this.failAttributeCheck())) {
                String msg = "A <link> tag without the allowed attributes can occur only in the head or noscript element, not in " + parentNode.getNodeName();
                throw new DOMException(3, msg);
            }
            super.setParentNode(parentNode);
            HTMLDocument.this.onStyleModify();
        }

        private boolean failAttributeCheck() {
            NamedNodeMap attributes = this.getAttributes();
            int sz = attributes.getLength();
            for (int i = 0; i < sz; ++i) {
                String value;
                Attr attr = (Attr)attributes.item(i);
                String name = attr.getName();
                if ("itemprop".equals(name)) {
                    return false;
                }
                if (!"rel".equals(name) || (value = attr.getValue()) == null || !value.equals("stylesheet") && !value.equals("pingback") && !value.equals("preconnect") && !value.equals("preload") && !value.equals("prerender") && !value.endsWith("prefetch")) continue;
                return false;
            }
            return true;
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.linkedSheet == null) {
                String type = this.getAttribute("type");
                if (type.length() != 0 && !"text/css".equals(type)) {
                    return null;
                }
                String rel = this.getAttribute("rel");
                if (rel.length() > 0) {
                    String href;
                    String lcrel;
                    String title = this.getAttribute("title");
                    if (title.length() == 0) {
                        title = null;
                    }
                    if ((lcrel = rel.toLowerCase(Locale.US)).equals("stylesheet")) {
                        String href2 = this.getAttribute("href");
                        if (href2.length() > 0) {
                            this.loadStyleSheet(href2, title);
                        }
                    } else if (lcrel.equals("alternate stylesheet") && title != null && (href = this.getAttribute("href")).length() > 0) {
                        this.loadStyleSheet(href, title);
                        if (this.linkedSheet != null) {
                            this.linkedSheet.setDisabled(true);
                        }
                    }
                }
            }
            return this.linkedSheet;
        }

        private void loadStyleSheet(String href, String title) {
            MediaQueryList mediaList;
            String media = this.getAttribute("media");
            if ((media = media.trim()).length() == 0) {
                mediaList = OMMediaList.createMediaList();
            } else {
                mediaList = MediaQueryFactory.createMediaList(media);
                if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                    this.getStyleSheetFactory().getErrorHandler().mediaQueryError(media);
                }
            }
            BaseCSSStyleSheet sheet = (BaseCSSStyleSheet)this.getStyleSheetFactory().createLinkedStyleSheet(this, title, mediaList);
            try {
                URL url = this.getOwnerDocument().getURL(href);
                sheet.setHref(url.toExternalForm());
                sheet.loadStyleSheet(url);
            }
            catch (Exception e) {
                this.getStyleSheetFactory().getErrorHandler().onException(e, sheet);
            }
            this.linkedSheet = sheet;
        }

        @Override
        public void resetLinkedSheet() {
            this.linkedSheet = null;
            this.getOwnerDocument().onStyleModify();
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new LinkElement(), deep);
        }
    }

    class BaseElement
    extends MetacontentElement {
        BaseElement() {
            super("base");
        }

        @Override
        protected AbstractDOMNode.DOMNodeList createChildNodeList() {
            return DOMDocument.nvemptyNodeList;
        }

        @Override
        boolean isVoid() {
            return true;
        }

        @Override
        void setParentNode(Node parentNode) throws DOMException {
            if (parentNode != null) {
                super.setParentNode(parentNode);
                if (parentNode.getNodeType() == 1) {
                    NodeList nl = parentNode.getChildNodes();
                    int sz = nl.getLength();
                    for (int i = 0; i < sz; ++i) {
                        Node node = nl.item(i);
                        if (node.getNodeType() != 1 || node.getNodeName() != "base" || node == this) continue;
                        throw new DOMException(3, "A document can have only one base element.");
                    }
                }
            }
            super.setParentNode(parentNode);
        }
    }

    class MetacontentElement
    extends MyHTMLElement {
        MetacontentElement(String tagName) {
            super(tagName);
        }

        @Override
        void setParentNode(Node parentNode) throws DOMException {
            short type;
            if (parentNode != null && (type = parentNode.getNodeType()) != 11 && (type != 1 || parentNode.getNodeName() != "head" && parentNode.getNodeName() != "noscript")) {
                String msg = "A <" + this.getNodeName() + "> tag can occur only in a head or noscript element, not in " + parentNode.toString();
                throw new DOMException(3, msg);
            }
            super.setParentNode(parentNode);
        }
    }

    class HtmlRootElement
    extends MyHTMLElement {
        HtmlRootElement() {
            super("html");
        }

        @Override
        void setParentNode(Node parentNode) throws DOMException {
            short type;
            if (parentNode != null && (type = parentNode.getNodeType()) != 9 && type != 11) {
                throw new DOMException(3, "A <html> tag cannot be added here.");
            }
            super.setParentNode(parentNode);
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            String nname;
            if (newChild.getNodeType() == 1 && ((nname = newChild.getNodeName()) == "head" || nname == "body")) {
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    Node node = this.child.get(i);
                    if (node.getNodeType() != 1 || node.getNodeName() != nname) continue;
                    throw new DOMException(3, "<html> already has a " + nname + " child.");
                }
            }
            return super.appendChild(newChild);
        }
    }

    class MyHTMLElement
    extends HTMLElement {
        MyHTMLElement(String localName) {
            this(localName, HTMLDocument.HTML_NAMESPACE_URI);
        }

        MyHTMLElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        boolean isIdAttributeNS(String namespaceURI, String localName) {
            return HTMLDocument.this.idAttrName.equals(localName);
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            if (!isId || !"id".equalsIgnoreCase(name)) {
                throw new DOMException(7, "Id attribute is always 'id'");
            }
            HTMLDocument.this.idAttrName = name;
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            if (namespaceURI != null && namespaceURI.length() > 0 && !namespaceURI.equals(HTMLDocument.HTML_NAMESPACE_URI)) {
                return;
            }
            if (!isId || !"id".equalsIgnoreCase(localName)) {
                throw new DOMException(7, "Id attribute is always 'id'");
            }
            HTMLDocument.this.idAttrName = localName;
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            if (!isId || idAttr == null || !"id".equalsIgnoreCase(idAttr.getName())) {
                throw new DOMException(7, "Id attribute is always 'id'");
            }
            HTMLDocument.this.idAttrName = idAttr.getName();
        }

        @Override
        public void setId(String id) {
            this.setIdAttribute(id, true);
        }

        @Override
        public String getId() {
            return this.getAttribute(HTMLDocument.this.idAttrName);
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return HTMLDocument.this;
        }

        @Override
        protected BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return HTMLDocument.this.getStyleSheetFactory();
        }

        @Override
        public String getBaseURI() {
            return HTMLDocument.this.getBaseURI();
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new MyHTMLElement(this.getLocalName(), this.getNamespaceURI()), deep);
        }

        HTMLElement cloneElementNode(MyHTMLElement my, boolean deep) {
            for (Attr attr : this.nodeMap.attributes.values()) {
                DOMDocument.MyAttr myattr = new DOMDocument.MyAttr(attr.getName(), attr.getNamespaceURI());
                myattr.setValue(attr.getValue());
                myattr.specified = false;
                my.setAttributeNode(myattr);
            }
            if (deep && this.hasChildNodes()) {
                NodeList list = this.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    my.appendChild(list.item(i).cloneNode(true));
                }
            }
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        DOMElement cloneNode(DOMDocument ownerDocument) {
            DOMElement my = ownerDocument.createElementNS(this.getLocalName(), this.getNamespaceURI());
            for (DOMDocument.MyAttr attr : this.nodeMap.attributes.values()) {
                if (!attr.getSpecified()) continue;
                attr = (DOMDocument.MyAttr)attr.cloneNode(ownerDocument);
                my.setAttributeNode(attr);
            }
            return my;
        }
    }
}

