/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMNode;
import org.w3c.dom.DOMException;

abstract class NamespacedNode
extends DOMNode {
    private final String namespaceUri;
    private String prefix = null;

    public NamespacedNode(short nodeType, String namespaceUri) {
        super(nodeType);
        this.namespaceUri = namespaceUri;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceUri;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        if (this.getNamespaceURI() != null && "http://www.w3.org/1999/xhtml" != this.getNamespaceURI()) {
            if ("xml".equals(prefix) && "http://www.w3.org/XML/1998/namespace" != this.getNamespaceURI()) {
                throw new DOMException(14, "Wrong namespace for prefix xml");
            }
            this.prefix = prefix;
        } else if (prefix != null && prefix.length() != 0) {
            throw new DOMException(14, "Cannot put a prefix to default namespace.");
        }
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        if (prefix == null) {
            return "http://www.w3.org/1999/xhtml";
        }
        if (prefix.equals(this.prefix)) {
            return this.getNamespaceURI();
        }
        return null;
    }
}

