/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DocumentTypeImpl;
import java.io.IOException;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XMLDocumentBuilder
extends DocumentBuilder {
    private final DOMImplementation domImpl;
    private EntityResolver resolver = null;
    private ErrorHandler errorHandler = null;
    private boolean strictErrorChecking = true;

    public XMLDocumentBuilder(DOMImplementation domImpl) {
        this.domImpl = domImpl;
    }

    @Override
    public Document parse(InputSource is) throws SAXException, IOException {
        SAXParser saxParser;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        try {
            saxParser = spf.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        XMLReader xmlReader = saxParser.getXMLReader();
        if (this.resolver != null) {
            xmlReader.setEntityResolver(this.resolver);
        }
        MyContentHandler handler = new MyContentHandler();
        xmlReader.setContentHandler(handler);
        xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        if (this.errorHandler != null) {
            xmlReader.setErrorHandler(this.errorHandler);
        } else {
            xmlReader.setErrorHandler(handler);
        }
        xmlReader.parse(is);
        return handler.getDocument();
    }

    @Override
    public boolean isNamespaceAware() {
        return true;
    }

    @Override
    public boolean isValidating() {
        return false;
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
        this.resolver = er;
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    @Override
    public Document newDocument() {
        return this.createDocument(null, null, null);
    }

    private Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        if (doctype != null && "html".equals(doctype.getName()) && namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        Document document = this.domImpl.createDocument(namespaceURI, qualifiedName, doctype);
        if (!this.strictErrorChecking) {
            document.setStrictErrorChecking(false);
        }
        return document;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.domImpl;
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    private static class MockProcessingInstruction
    extends MockNode {
        String target = null;

        MockProcessingInstruction(String target, String data) {
            super(data);
            this.target = target;
        }

        @Override
        short getNodeType() {
            return 7;
        }

        String getTarget() {
            return this.target;
        }
    }

    private static class MockCommentNode
    extends MockNode {
        MockCommentNode(String data) {
            super(data);
        }

        @Override
        short getNodeType() {
            return 8;
        }
    }

    static abstract class MockNode {
        String data = null;

        MockNode(String data) {
            this.data = data;
        }

        abstract short getNodeType();

        String getData() {
            return this.data;
        }
    }

    private class MyContentHandler
    implements ContentHandler,
    LexicalHandler,
    ErrorHandler {
        private Document document = null;
        private DocumentType documentType = null;
        private LinkedList<MockNode> preDocTypeNodes = null;
        private LinkedList<MockNode> preDocElementNodes = null;
        private Node currentNode = null;
        private Locator lastLocator = null;
        private boolean cdata = false;
        private boolean endDTD = true;

        MyContentHandler() {
        }

        Document getDocument() {
            return this.document;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.lastLocator = locator;
        }

        @Override
        public void startDocument() throws SAXException {
            this.document = null;
        }

        @Override
        public void endDocument() throws SAXException {
            this.currentNode = null;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.document == null) {
                Element element;
                if (!"html".equalsIgnoreCase(localName) && ("http://www.w3.org/1999/xhtml".equals(uri) || this.documentType != null && "html".equals(this.documentType.getName()))) {
                    String deQname = "html";
                    if (!qName.equalsIgnoreCase(localName)) {
                        int idx = qName.indexOf(58, 1);
                        if (idx != -1) {
                            deQname = qName.substring(0, idx) + ":html";
                        } else {
                            this.error("Bad qName: " + qName);
                        }
                    }
                    this.document = XMLDocumentBuilder.this.createDocument(uri, deQname, this.documentType);
                    element = this.document.createElementNS(uri, qName);
                    this.setAttributes(element, atts);
                    this.currentNode = this.document.getDocumentElement().appendChild(element);
                } else {
                    this.document = XMLDocumentBuilder.this.createDocument(uri, qName, this.documentType);
                    element = this.document.getDocumentElement();
                    this.currentNode = element;
                    this.setAttributes(element, atts);
                }
                if (this.documentType instanceof DocumentTypeImpl) {
                    ((DocumentTypeImpl)this.documentType).setOwnerDocument(this.document);
                }
                if (this.preDocTypeNodes != null) {
                    Node refNode = this.documentType;
                    if (refNode == null) {
                        refNode = this.document.getDocumentElement();
                    }
                    for (MockNode mock : this.preDocTypeNodes) {
                        this.insertMockNode(mock, refNode);
                    }
                }
                if (this.preDocElementNodes != null) {
                    Element docElm = this.document.getDocumentElement();
                    for (MockNode mock : this.preDocElementNodes) {
                        this.insertMockNode(mock, docElm);
                    }
                }
            } else {
                Element element = this.document.createElementNS(uri, qName);
                this.setAttributes(element, atts);
                this.appendChild(element);
                this.currentNode = element;
            }
        }

        private void setAttributes(Element element, Attributes atts) throws SAXException {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attrQName = atts.getQName(i);
                Attr attr = this.document.createAttributeNS(atts.getURI(i), attrQName);
                attr.setValue(atts.getValue(i));
                element.getAttributes().setNamedItem(attr);
            }
        }

        private void insertMockNode(MockNode mock, Node refNode) {
            if (mock.getNodeType() == 8) {
                this.document.insertBefore(this.document.createComment(mock.getData()), refNode);
            } else {
                this.document.insertBefore(this.document.createProcessingInstruction(((MockProcessingInstruction)mock).getTarget(), mock.getData()), refNode);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.currentNode = this.currentNode.getParentNode();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentNode == null) {
                this.error("Text outside of root element");
            }
            String s = new String(ch, start, length);
            Node node = this.currentNode.getLastChild();
            int type = node == null ? -1 : (int)node.getNodeType();
            if (!this.cdata && type == 3 || this.cdata && type == 4) {
                Text text = (Text)node;
                text.appendData(s);
            } else if (!this.cdata) {
                this.appendChild(this.document.createTextNode(s));
            } else {
                this.appendChild(this.document.createCDATASection(s));
            }
        }

        private void appendChild(Node node) throws SAXException {
            try {
                this.currentNode.appendChild(node);
            }
            catch (DOMException e) {
                this.error("Error appending child", e);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (this.currentNode != null) {
                this.appendChild(this.document.createProcessingInstruction(target, data));
            } else if (this.document != null) {
                this.document.appendChild(this.document.createProcessingInstruction(target, data));
            } else if (this.endDTD) {
                if (this.documentType == null) {
                    if (this.preDocTypeNodes == null) {
                        this.preDocTypeNodes = new LinkedList();
                    }
                    this.preDocTypeNodes.add(new MockProcessingInstruction(target, data));
                } else {
                    if (this.preDocElementNodes == null) {
                        this.preDocElementNodes = new LinkedList();
                    }
                    this.preDocElementNodes.add(new MockProcessingInstruction(target, data));
                }
            }
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (this.documentType != null || this.document != null) {
                this.error("DTD must be the first node in a document (except PIs and comments)");
            }
            this.documentType = XMLDocumentBuilder.this.domImpl.createDocumentType(name, publicId, systemId);
            this.endDTD = false;
        }

        @Override
        public void endDTD() throws SAXException {
            this.endDTD = true;
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
            this.cdata = true;
        }

        @Override
        public void endCDATA() throws SAXException {
            this.cdata = false;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            String comment = new String(ch, start, length);
            if (this.currentNode != null) {
                this.appendChild(this.document.createComment(comment));
            } else if (this.document != null) {
                this.document.appendChild(this.document.createComment(comment));
            } else if (this.endDTD) {
                if (this.documentType == null) {
                    if (this.preDocTypeNodes == null) {
                        this.preDocTypeNodes = new LinkedList();
                    }
                    this.preDocTypeNodes.add(new MockCommentNode(comment));
                } else {
                    if (this.preDocElementNodes == null) {
                        this.preDocElementNodes = new LinkedList();
                    }
                    this.preDocElementNodes.add(new MockCommentNode(comment));
                }
            }
        }

        private void error(String message) throws SAXException {
            if (this.lastLocator == null) {
                throw new SAXException(message);
            }
            throw new SAXParseException(message, this.lastLocator);
        }

        private void error(String message, Exception ex) throws SAXException {
            if (this.lastLocator == null) {
                throw new SAXException(message, ex);
            }
            throw new SAXParseException(message, this.lastLocator, ex);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

