/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.css.CSSPrimitiveValue;

class BackgroundBuilder
extends ShorthandBuilder {
    private AbstractCSSValue bgimage;
    private AbstractCSSValue bgposition;
    private AbstractCSSValue bgsize;
    private AbstractCSSValue bgrepeat;
    private AbstractCSSValue bgattachment;
    private AbstractCSSValue bgclip;
    private AbstractCSSValue bgorigin;
    private boolean appended = false;

    BackgroundBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("background", parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 8;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        buf.append(this.getShorthandName()).append(':');
        this.bgimage = this.getCSSValue("background-image");
        this.bgposition = this.computeMultipleSubproperty("background-image", "background-position");
        this.bgsize = this.computeMultipleSubproperty("background-image", "background-size");
        this.bgrepeat = this.computeMultipleSubproperty("background-image", "background-repeat");
        this.bgattachment = this.computeMultipleSubproperty("background-image", "background-attachment");
        this.bgclip = this.computeMultipleSubproperty("background-image", "background-clip");
        this.bgorigin = this.computeMultipleSubproperty("background-image", "background-origin");
        short type = this.bgimage.getCssValueType();
        if (type == 2 && ((OMCSSValueList)this.bgimage).isCommaSeparated()) {
            if (!this.appendLayeredBackground(buf, declaredSet, ((OMCSSValueList)this.bgimage).getLength())) {
                return false;
            }
        } else {
            byte inheritcheck = this.checkForInherit();
            if (inheritcheck == 1) {
                buf.append("inherit");
                this.appendPriority(buf, important);
                return true;
            }
            if (inheritcheck == 2) {
                return false;
            }
            byte check = this.checkForUnset(buf);
            if (check == 1) {
                buf.append("unset");
                this.appendPriority(buf, important);
                return true;
            }
            if (check == 2) {
                return false;
            }
            if (!this.appendBackgroundImage(buf, this.bgimage)) {
                return false;
            }
            if (!this.appendSingleLayer(buf, declaredSet)) {
                return false;
            }
            if (!this.appended) {
                buf.append("none");
            }
        }
        this.appendPriority(buf, important);
        return true;
    }

    private AbstractCSSValue computeMultipleSubproperty(String masterProperty, String propertyName) {
        return this.getParentStyle().computeBoundProperty(masterProperty, propertyName, this.getCSSValue(propertyName));
    }

    private byte checkForInherit() {
        return this.checkForInherit(this.bgimage, this.bgposition, this.bgsize, this.bgrepeat, this.bgattachment, this.bgclip, this.bgorigin, this.getCSSValue("background-color"));
    }

    private byte checkForInherit(AbstractCSSValue bimg, AbstractCSSValue bpos, AbstractCSSValue bsize, AbstractCSSValue brepeat, AbstractCSSValue battach, AbstractCSSValue bclip, AbstractCSSValue borigin, AbstractCSSValue bcolor) {
        byte check = this.checkForInherit(bimg, bpos, bsize, brepeat, battach, bclip, borigin);
        if (check == 2) {
            return 2;
        }
        if (this.isInherit(bcolor) ? check == 0 : check == 1) {
            return 2;
        }
        return check;
    }

    private byte checkForInherit(AbstractCSSValue bimg, AbstractCSSValue bpos, AbstractCSSValue bsize, AbstractCSSValue brepeat, AbstractCSSValue battach, AbstractCSSValue bclip, AbstractCSSValue borigin) {
        int count = 0;
        if (this.isInherit(bimg)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(bpos)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(bsize)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(brepeat)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(battach)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(bclip)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(borigin)) {
            count = (byte)(count + 1);
        }
        switch (count) {
            case 0: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private byte checkForInherit(StringBuilder buf, int layerIdx, int lastIndex) {
        if (layerIdx != lastIndex) {
            return this.checkForInherit(((OMCSSValueList)this.bgimage).item(layerIdx), ((OMCSSValueList)this.bgposition).item(layerIdx), ((OMCSSValueList)this.bgsize).item(layerIdx), ((OMCSSValueList)this.bgrepeat).item(layerIdx), ((OMCSSValueList)this.bgattachment).item(layerIdx), ((OMCSSValueList)this.bgclip).item(layerIdx), ((OMCSSValueList)this.bgorigin).item(layerIdx));
        }
        return this.checkForInherit(((OMCSSValueList)this.bgimage).item(layerIdx), ((OMCSSValueList)this.bgposition).item(layerIdx), ((OMCSSValueList)this.bgsize).item(layerIdx), ((OMCSSValueList)this.bgrepeat).item(layerIdx), ((OMCSSValueList)this.bgattachment).item(layerIdx), ((OMCSSValueList)this.bgclip).item(layerIdx), ((OMCSSValueList)this.bgorigin).item(layerIdx), this.getCSSValue("background-color"));
    }

    private byte checkForUnset(StringBuilder buf) {
        return this.checkForCssKeyword("unset", buf);
    }

    private byte checkForCssKeyword(String keyword, StringBuilder buf) {
        int ucount = 0;
        if (this.isCssKeywordValue(keyword, this.bgposition)) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue(keyword, this.bgsize)) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue(keyword, this.bgrepeat)) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue(keyword, this.bgattachment)) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue(keyword, this.bgclip)) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue(keyword, this.bgorigin)) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue(keyword, this.getCSSValue("background-color"))) {
            ucount = (byte)(ucount + 1);
        }
        switch (ucount) {
            case 0: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private byte checkForUnset(StringBuilder buf, int layerIdx, int lastIndex) {
        return this.checkForCssKeyword("unset", buf, layerIdx, lastIndex);
    }

    private byte checkForCssKeyword(String keyword, StringBuilder buf, int layerIdx, int lastIndex) {
        int fullset;
        int ucount = 0;
        if (this.isCssKeywordValue(keyword, ((OMCSSValueList)this.bgposition).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue(keyword, ((OMCSSValueList)this.bgsize).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue(keyword, ((OMCSSValueList)this.bgrepeat).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue(keyword, ((OMCSSValueList)this.bgattachment).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue(keyword, ((OMCSSValueList)this.bgclip).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue(keyword, ((OMCSSValueList)this.bgorigin).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (layerIdx != lastIndex) {
            fullset = 6;
        } else {
            fullset = 7;
            if (this.isCssKeywordValue(keyword, this.getCSSValue("background-color"))) {
                ucount = (byte)(ucount + 1);
            }
        }
        if (ucount == 0) {
            return 0;
        }
        if (ucount == fullset) {
            return 1;
        }
        return 2;
    }

    private boolean isUnsetValue(AbstractCSSValue cssValue) {
        return this.isCssKeywordValue("unset", cssValue);
    }

    private void appendText(StringBuilder buf, String text) {
        if (this.appended) {
            buf.append(' ');
        } else {
            this.appended = true;
        }
        buf.append(text);
    }

    private boolean appendLayeredBackground(StringBuilder buf, Set<String> declaredSet, int listlen) {
        int szm1 = listlen - 1;
        if (!this.appendLayer(buf, declaredSet, 0, szm1)) {
            return false;
        }
        for (int i = 1; i <= szm1; ++i) {
            this.appended = false;
            buf.append(',');
            if (this.appendLayer(buf, declaredSet, i, szm1)) continue;
            return false;
        }
        return true;
    }

    private boolean appendLayer(StringBuilder buf, Set<String> declaredSet, int index, int lastIndex) {
        AbstractCSSValue clip;
        AbstractCSSValue origin;
        AbstractCSSValue sizeval;
        byte check = this.checkForInherit(buf, index, lastIndex);
        if (check == 1) {
            this.appendText(buf, "inherit");
            return true;
        }
        if (check == 2) {
            return false;
        }
        check = this.checkForUnset(buf, index, lastIndex);
        if (check == 1) {
            this.appendText(buf, "unset");
            return true;
        }
        if (check == 2) {
            return false;
        }
        if (declaredSet.contains("background-image") && !this.appendBackgroundImage(buf, ((OMCSSValueList)this.bgimage).item(index))) {
            return false;
        }
        OMCSSValueList list = (OMCSSValueList)this.bgposition;
        AbstractCSSValue posval = declaredSet.contains("background-position") ? list.item(index) : null;
        if (!this.appendBackgroundPositionSize(buf, posval, sizeval = declaredSet.contains("background-size") ? ((OMCSSValueList)this.bgsize).item(index) : null)) {
            return false;
        }
        if (declaredSet.contains("background-repeat") && !this.appendBackgroundRepeat(buf, ((OMCSSValueList)this.bgrepeat).item(index))) {
            return false;
        }
        if (declaredSet.contains("background-attachment") && !this.appendBackgroundAttachment(buf, (list = (OMCSSValueList)this.bgattachment).item(index))) {
            return false;
        }
        boolean bcset = declaredSet.contains("background-clip");
        if ((declaredSet.contains("background-origin") || bcset) && !this.appendBackgroundOriginClip(buf, origin = ((OMCSSValueList)this.bgorigin).item(index), clip = bcset ? ((OMCSSValueList)this.bgclip).item(index) : null)) {
            return false;
        }
        if (declaredSet.contains("background-color") && index == lastIndex && !this.appendBackgroundColor(buf, this.getCSSValue("background-color"))) {
            return false;
        }
        int buflen = buf.length();
        if (buflen == 11 || buf.charAt(buflen - 1) == ',') {
            buf.append("none");
        }
        return true;
    }

    private boolean appendSingleLayer(StringBuilder buf, Set<String> declaredSet) {
        AbstractCSSValue clip;
        AbstractCSSValue origin;
        AbstractCSSValue sizeval;
        AbstractCSSValue posval = declaredSet.contains("background-position") ? this.valueOrFirstItem(this.bgposition) : null;
        if (!this.appendBackgroundPositionSize(buf, posval, sizeval = declaredSet.contains("background-size") ? this.valueOrFirstItem(this.bgsize) : null)) {
            return false;
        }
        if (declaredSet.contains("background-repeat") && !this.appendBackgroundRepeat(buf, this.valueOrFirstItem(this.bgrepeat))) {
            return false;
        }
        if (declaredSet.contains("background-attachment") && !this.appendBackgroundAttachment(buf, this.valueOrFirstItem(this.bgattachment))) {
            return false;
        }
        boolean bcset = declaredSet.contains("background-clip");
        if ((declaredSet.contains("background-origin") || bcset) && !this.appendBackgroundOriginClip(buf, origin = this.valueOrFirstItem(this.bgorigin), clip = bcset ? this.valueOrFirstItem(this.bgclip) : null)) {
            return false;
        }
        if (declaredSet.contains("background-color")) {
            AbstractCSSValue value = this.getCSSValue("background-color");
            if (value.getCssValueType() == 2) {
                return false;
            }
            if (!this.appendBackgroundColor(buf, value)) {
                return false;
            }
        }
        return true;
    }

    private AbstractCSSValue valueOrFirstItem(AbstractCSSValue value) {
        OMCSSValueList list;
        if (value.getCssValueType() == 2 && (list = (OMCSSValueList)value).isCommaSeparated()) {
            return list.item(0);
        }
        return value;
    }

    private boolean appendBackgroundImage(StringBuilder buf, AbstractCSSValue value) {
        if (!this.isUnsetValue(value) && this.possibleBackgroundImage(value)) {
            this.appended = this.appendRelativeURI(buf, this.appended, value);
            return true;
        }
        return false;
    }

    private boolean possibleBackgroundImage(AbstractCSSValue value) {
        if (value.getCssValueType() == 1) {
            AbstractCSSPrimitiveValue primi = (AbstractCSSPrimitiveValue)value;
            short type = primi.getPrimitiveType();
            if (type == 21) {
                return "none".equalsIgnoreCase(primi.getStringValue());
            }
            if (type == 20 || type == 126 || type == 127 || type == 128) {
                return true;
            }
        }
        return false;
    }

    private boolean appendBackgroundPositionSize(StringBuilder buf, AbstractCSSValue posvalue, AbstractCSSValue sizevalue) {
        boolean appended = false;
        if (posvalue != null) {
            short type = posvalue.getCssValueType();
            String text = posvalue.getCssText().toLowerCase(Locale.US);
            if (this.isUnsetValue(posvalue)) {
                return false;
            }
            if (type == 1) {
                this.appendText(buf, text);
                appended = true;
            } else if (type == 2) {
                OMCSSValueList list = (OMCSSValueList)posvalue;
                if (list.isCommaSeparated()) {
                    return false;
                }
                if (!("0% 0%".equals(text) || "left top".equals(text) || "top left".equals(text) || "initial".equals(text))) {
                    if (list.getLength() != 2 || !"center".equals(list.item(1).getCssText())) {
                        this.appendText(buf, text);
                    } else {
                        this.appendText(buf, list.item(0).getCssText());
                    }
                    appended = true;
                }
            }
        }
        if (sizevalue != null) {
            if (!this.isUnsetValue(sizevalue) && !this.isUnknownIdentifier("background-size", sizevalue)) {
                String text = sizevalue.getMinifiedCssText("background-size").toLowerCase(Locale.US);
                if (!("auto".equals(text) || "auto auto".equals(text) || "initial".equals(text))) {
                    if (!appended) {
                        if (posvalue == null) {
                            posvalue = this.getCSSValue("background-position");
                        }
                        this.appendText(buf, posvalue.getMinifiedCssText("background-position"));
                    }
                    buf.append('/').append(text);
                    appended = true;
                }
            } else {
                return false;
            }
        }
        if (appended) {
            this.appended = true;
        }
        return true;
    }

    private boolean appendBackgroundRepeat(StringBuilder buf, AbstractCSSValue value) {
        short type = value.getCssValueType();
        String text = value.getCssText().toLowerCase(Locale.US);
        if (this.isUnsetValue(value)) {
            return false;
        }
        if (type == 1) {
            if (!"repeat".equals(text) && !"initial".equals(text)) {
                this.appendText(buf, text);
            }
        } else if (type == 2) {
            OMCSSValueList list = (OMCSSValueList)value;
            if (list.isCommaSeparated()) {
                return false;
            }
            if (!"repeat repeat".equals(text)) {
                if ("no-repeat no-repeat".equals(text)) {
                    this.appendText(buf, "no-repeat");
                } else if ("space space".equals(text)) {
                    this.appendText(buf, "space");
                } else if ("round round".equals(text)) {
                    this.appendText(buf, "round");
                } else if ("repeat no-repeat".equals(text)) {
                    this.appendText(buf, "repeat-x");
                } else if ("no-repeat repeat".equals(text)) {
                    this.appendText(buf, "repeat-y");
                } else {
                    this.appendText(buf, text);
                }
            }
        }
        return true;
    }

    private boolean appendBackgroundAttachment(StringBuilder buf, AbstractCSSValue value) {
        if (!this.isUnsetValue(value) && !this.isUnknownIdentifier("background-attachment", value)) {
            String text = value.getMinifiedCssText("background-attachment").toLowerCase(Locale.US);
            if (!"scroll".equals(text) && !"initial".equals(text)) {
                this.appendText(buf, text);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean appendBackgroundOriginClip(StringBuilder buf, AbstractCSSValue origin, AbstractCSSValue clip) {
        boolean clipIsInitial = false;
        String cliptext = clip.getMinifiedCssText("background-clip").toLowerCase(Locale.US);
        if ("border-box".equals(cliptext) || "initial".equals(cliptext)) {
            clipIsInitial = true;
        }
        if (!this.isUnsetValue(origin) && !this.isUnknownIdentifier("background-origin", origin)) {
            String text = origin.getCssText().toLowerCase(Locale.US);
            if (clip != null && !clipIsInitial || !"padding-box".equals(text) && !"initial".equals(text)) {
                this.appendText(buf, text);
            }
        } else {
            return false;
        }
        if (!this.isUnsetValue(clip) && !this.isUnknownIdentifier("background-clip", clip)) {
            if (!clipIsInitial) {
                this.appendText(buf, cliptext);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean appendBackgroundColor(StringBuilder buf, AbstractCSSValue value) {
        if (!this.isUnsetValue(value) && !this.isPrimitiveType(value, (short)20)) {
            String text = value.getMinifiedCssText("background-color").toLowerCase(Locale.US);
            if (!("transparent".equals(text) || "rgba(0,0,0,0)".equals(text) || "rgb(0,0,0,0)".equals(text) || "initial".equals(text) || "none".equals(text))) {
                this.appendText(buf, text);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isPrimitiveType(AbstractCSSValue value, short type) {
        return value.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)value)).getPrimitiveType() == type;
    }
}

