/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseBoxShorthandBuilder;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BorderImageBuilder;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class BorderBuilder
extends BaseBoxShorthandBuilder {
    private Set<String> unusedSet = new HashSet<String>();

    BorderBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("border", parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 3;
    }

    @Override
    protected void appendIndividualProperties(StringBuilder buf) {
        super.appendIndividualProperties(buf);
        if (this.isAnyBorderImagePropertySet()) {
            BorderImageBuilder builder = this.createBorderImageBuilder();
            builder.appendCssText(buf);
        }
    }

    @Override
    protected void appendMinifiedIndividualProperties(StringBuilder buf) {
        super.appendMinifiedIndividualProperties(buf);
        if (this.isAnyBorderImagePropertySet()) {
            BorderImageBuilder builder = this.createBorderImageBuilder();
            builder.appendMinifiedCssText(buf);
        }
    }

    private BorderImageBuilder createBorderImageBuilder() {
        BaseCSSStyleDeclaration style = this.getParentStyle();
        BorderImageBuilder builder = new BorderImageBuilder(style);
        if (style.isPropertySet("border-image-source")) {
            builder.addAssignedProperty("border-image-source", style.isPropertyImportant("border-image-source"));
        }
        if (style.isPropertySet("border-image-slice")) {
            builder.addAssignedProperty("border-image-slice", style.isPropertyImportant("border-image-slice"));
        }
        if (style.isPropertySet("border-image-width")) {
            builder.addAssignedProperty("border-image-width", style.isPropertyImportant("border-image-width"));
        }
        if (style.isPropertySet("border-image-outset")) {
            builder.addAssignedProperty("border-image-outset", style.isPropertyImportant("border-image-outset"));
        }
        if (style.isPropertySet("border-image-repeat")) {
            builder.addAssignedProperty("border-image-repeat", style.isPropertyImportant("border-image-repeat"));
        }
        return builder;
    }

    byte checkValuesForInherit(Set<String> declaredSet, boolean biset) {
        byte wcheck = this.checkValuesForInherit("border-width", declaredSet);
        byte scheck = this.checkValuesForInherit("border-style", declaredSet);
        byte ccheck = this.checkValuesForInherit("border-color", declaredSet);
        if (wcheck == 1 && scheck == 1 && ccheck == 1 && biset) {
            return 1;
        }
        if (wcheck == 2 || scheck == 2 || ccheck == 2) {
            return 2;
        }
        return wcheck == 1 || scheck == 1 || ccheck == 1 ? (byte)3 : 0;
    }

    byte checkValuesForKeyword(String keyword, Set<String> declaredSet, boolean biset) {
        byte wcheck = this.checkValuesForKeyword(keyword, "border-width", declaredSet);
        byte scheck = this.checkValuesForKeyword(keyword, "border-style", declaredSet);
        byte ccheck = this.checkValuesForKeyword(keyword, "border-color", declaredSet);
        if (wcheck == 1 && scheck == 1 && ccheck == 1 && biset) {
            return 1;
        }
        if (wcheck == 2 || scheck == 2 || ccheck == 2) {
            return 2;
        }
        return wcheck == 1 || scheck == 1 || ccheck == 1 ? (byte)3 : 0;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        boolean biset = this.isBorderImageSet(important);
        if (declaredSet.size() == 12 || !important && this.getTotalSetSize() == 12) {
            byte icheck = this.checkValuesForInherit(declaredSet, biset);
            if (icheck == 1) {
                buf.append("border:inherit");
                this.appendPriority(buf, important);
                return true;
            }
            if (icheck == 2) {
                return false;
            }
            byte ucheck = this.checkValuesForKeyword("unset", declaredSet, biset);
            if (ucheck == 1) {
                buf.append("border:unset");
                this.appendPriority(buf, important);
                return true;
            }
            if (ucheck == 2) {
                return false;
            }
            boolean mixedCase = false;
            PropertyValueScore score = new PropertyValueScore();
            score.score();
            byte live_state = this.bestState(score);
            int effectiveScore = score.getScore(live_state);
            if (effectiveScore == -1) {
                mixedCase = true;
                score.setEquivalentScores();
                live_state = this.bestState(score);
                effectiveScore = score.getScore(live_state);
                this.buildUnusedSet(declaredSet);
            }
            if (biset) {
                boolean ret = this.appendFullSet(buf, declaredSet, score, effectiveScore, live_state, important);
                if (mixedCase) {
                    this.appendUnused(buf, important);
                }
                if (ret) {
                    return true;
                }
            }
            this.appendBorderWidthText(buf, declaredSet, false, score, score.getSameWidthScore(), null, important);
            this.appendBorderStyleText(buf, declaredSet, false, score, score.getSameStyleScore(), null, important);
            this.appendBorderColorText(buf, declaredSet, false, score, score.getSameColorScore(), null, important);
            if (biset) {
                BorderImageBuilder builder = this.createBorderImageBuilder();
                builder.appendMinifiedCssText(buf);
            }
            return true;
        }
        if (biset) {
            BorderImageBuilder builder = this.createBorderImageBuilder();
            builder.appendMinifiedCssText(buf);
        }
        PropertyCount counter = new PropertyCount();
        counter.count(declaredSet, important);
        if (declaredSet.size() < 3 && (important || !this.isInShadowedSet(declaredSet, counter))) {
            return false;
        }
        PropertyValueScore score = new PropertyValueScore();
        score.score(counter);
        return this.appendPartialShorthands(buf, declaredSet, score, counter, important);
    }

    private boolean isInShadowedSet(Set<String> declaredSet, PropertyCount counter) {
        for (String property : declaredSet) {
            if (this.isInShadowedSet(property, counter)) continue;
            return false;
        }
        return true;
    }

    private boolean isInShadowedSet(String property, PropertyCount counter) {
        BaseCSSStyleDeclaration style = this.getParentStyle();
        return "border-top-width".equals(property) ? counter.countBWidth == 4 || style.isPropertySet("border-top-style") && style.isPropertySet("border-top-color") : ("border-top-style".equals(property) ? counter.countBStyle == 4 || style.isPropertySet("border-top-width") && style.isPropertySet("border-top-color") : ("border-top-color".equals(property) ? counter.countBColor == 4 || style.isPropertySet("border-top-width") && style.isPropertySet("border-top-style") : ("border-right-width".equals(property) ? counter.countBWidth == 4 || style.isPropertySet("border-right-style") && style.isPropertySet("border-right-color") : ("border-right-style".equals(property) ? counter.countBStyle == 4 || style.isPropertySet("border-right-width") && style.isPropertySet("border-right-color") : ("border-right-color".equals(property) ? counter.countBColor == 4 || style.isPropertySet("border-right-width") && style.isPropertySet("border-right-style") : ("border-bottom-width".equals(property) ? counter.countBWidth == 4 || style.isPropertySet("border-bottom-style") && style.isPropertySet("border-bottom-color") : ("border-bottom-style".equals(property) ? counter.countBStyle == 4 || style.isPropertySet("border-bottom-width") && style.isPropertySet("border-bottom-color") : ("border-bottom-color".equals(property) ? counter.countBColor == 4 || style.isPropertySet("border-bottom-width") && style.isPropertySet("border-bottom-style") : ("border-left-width".equals(property) ? counter.countBWidth == 4 || style.isPropertySet("border-left-style") && style.isPropertySet("border-left-color") : ("border-left-style".equals(property) ? counter.countBStyle == 4 || style.isPropertySet("border-left-width") && style.isPropertySet("border-left-color") : "border-left-color".equals(property) && (counter.countBColor == 4 || style.isPropertySet("border-left-width") && style.isPropertySet("border-left-style"))))))))))));
    }

    private byte bestState(PropertyValueScore score) {
        int best_state = 0;
        int keyword_state = score.getWidthState().getBestState() + score.getStyleState().getBestState() + score.getColorState().getBestState();
        int inherit_count = keyword_state % 5;
        if (inherit_count > 1) {
            best_state = 1;
        } else if (keyword_state > 7) {
            best_state = 5;
        }
        return (byte)best_state;
    }

    private boolean appendFullSet(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, int effectiveScore, byte live_state, boolean important) {
        if (effectiveScore == 63) {
            Set<String> equivWidthSet = score.getEquivWidthSet(score.getSameWidthScore());
            Set<String> equivStyleSet = score.getEquivStyleSet(score.getSameStyleScore());
            Set<String> equivColorSet = score.getEquivColorSet(score.getSameColorScore());
            this.appendFullBorderText(buf, declaredSet, score, live_state, equivWidthSet, equivStyleSet, equivColorSet, important);
            if (!this.isBorderImageSetToInitial()) {
                BorderImageBuilder builder = this.createBorderImageBuilder();
                builder.appendMinifiedCssText(buf);
            }
            return true;
        }
        if (score.getSameStyleScore() == score.getSameWidthScore() && score.getSameColorScore() == score.getSameWidthScore()) {
            if (score.getSameWidthScore() == 21) {
                this.appendFullBorderWithWidthStyleColor(buf, declaredSet, score, live_state, important);
                return true;
            }
            if (this.appendFullBorderPlusSide(buf, declaredSet, score, live_state, important)) {
                return true;
            }
        }
        this.appendFullBorderPlusMore(buf, declaredSet, score, live_state, important);
        if (!this.isBorderImageSetToInitial()) {
            BorderImageBuilder builder = this.createBorderImageBuilder();
            builder.appendMinifiedCssText(buf);
        }
        return true;
    }

    private void appendFullBorderWithWidthStyleColor(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, byte live_state, boolean important) {
        Set<String> equivWidthSet = score.getEquivWidthSet(score.getSameWidthScore());
        Set<String> equivStyleSet = score.getEquivStyleSet(score.getSameStyleScore());
        Set<String> equivColorSet = score.getEquivColorSet(score.getSameColorScore());
        int size = equivWidthSet.size();
        if (size == 3 || size == 2) {
            equivWidthSet = null;
        }
        if ((size = equivStyleSet.size()) == 3 || size == 2) {
            equivStyleSet = null;
        }
        if ((size = equivColorSet.size()) == 3 || size == 2) {
            equivColorSet = null;
        }
        this.appendFullBorderText(buf, declaredSet, score, live_state, equivWidthSet, equivStyleSet, equivColorSet, important);
        if (score.getWidthState().getBestState() != live_state || score.getSameWidthScore() != 21) {
            this.appendBorderWidthText(buf, declaredSet, false, score, score.getSameWidthScore(), null, important);
        }
        if (score.getStyleState().getBestState() != live_state || score.getSameStyleScore() != 21) {
            this.appendBorderStyleText(buf, declaredSet, false, score, score.getSameStyleScore(), null, important);
        }
        if (score.getColorState().getBestState() != live_state || score.getSameColorScore() != 21) {
            this.appendBorderColorText(buf, declaredSet, false, score, score.getSameColorScore(), null, important);
        }
        if (!this.isBorderImageSetToInitial()) {
            BorderImageBuilder builder = this.createBorderImageBuilder();
            builder.appendMinifiedCssText(buf);
        }
    }

    private boolean appendFullBorderPlusSide(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, byte live_state, boolean important) {
        int samescore = score.getSameWidthScore();
        if (samescore == 17) {
            Set<String> equivWidthSet = score.getEquivWidthSet(samescore);
            Set<String> equivStyleSet = score.getEquivStyleSet(samescore);
            Set<String> equivColorSet = score.getEquivColorSet(samescore);
            this.appendFullBorderText(buf, declaredSet, score, live_state, equivWidthSet, equivStyleSet, equivColorSet, important);
            this.appendBorderBottomText(buf, declaredSet, score, live_state, important);
            if (!this.isBorderImageSetToInitial()) {
                BorderImageBuilder builder = this.createBorderImageBuilder();
                builder.appendMinifiedCssText(buf);
            }
            return true;
        }
        if (samescore == 5) {
            Set<String> equivWidthSet = score.getEquivWidthSet(samescore);
            Set<String> equivStyleSet = score.getEquivStyleSet(samescore);
            Set<String> equivColorSet = score.getEquivColorSet(samescore);
            this.appendFullBorderText(buf, declaredSet, score, live_state, equivWidthSet, equivStyleSet, equivColorSet, important);
            this.appendBorderRightText(buf, declaredSet, score, live_state, important);
            if (!this.isBorderImageSetToInitial()) {
                BorderImageBuilder builder = this.createBorderImageBuilder();
                builder.appendMinifiedCssText(buf);
            }
            return true;
        }
        if (samescore == 16) {
            Set<String> equivWidthSet;
            if (score.equivalentProperties("border-right-width", "border-bottom-width", score.getWidthState().getBestState()) && score.equivalentProperties("border-right-style", "border-bottom-style", score.getStyleState().getBestState()) && score.equivalentProperties("border-right-color", "border-bottom-color", score.getColorState().getBestState())) {
                equivWidthSet = new HashSet<String>();
                equivWidthSet.add("border-right-width");
                equivWidthSet.add("border-left-width");
                HashSet<String> equivStyleSet = new HashSet<String>();
                equivStyleSet.add("border-right-style");
                equivStyleSet.add("border-left-style");
                HashSet<String> equivColorSet = new HashSet<String>();
                equivColorSet.add("border-right-color");
                equivColorSet.add("border-left-color");
                this.appendFullBorderText(buf, declaredSet, score, live_state, equivWidthSet, equivStyleSet, equivColorSet, important);
                this.appendBorderTopText(buf, declaredSet, score, live_state, important);
            } else {
                equivWidthSet = score.getEquivWidthSet(samescore);
                Set<String> equivStyleSet = score.getEquivStyleSet(samescore);
                Set<String> equivColorSet = score.getEquivColorSet(samescore);
                this.appendFullBorderText(buf, declaredSet, score, live_state, equivWidthSet, equivStyleSet, equivColorSet, important);
                this.appendBorderTopText(buf, declaredSet, score, live_state, important);
                this.appendBorderBottomText(buf, declaredSet, score, live_state, important);
            }
            if (!this.isBorderImageSetToInitial()) {
                BorderImageBuilder builder = this.createBorderImageBuilder();
                builder.appendMinifiedCssText(buf);
            }
            return true;
        }
        if (samescore == 4) {
            Set<String> equivWidthSet;
            if (score.equivalentProperties("border-right-width", "border-bottom-width", score.getWidthState().getBestState()) && score.equivalentProperties("border-right-style", "border-bottom-style", score.getStyleState().getBestState()) && score.equivalentProperties("border-right-color", "border-bottom-color", score.getColorState().getBestState())) {
                equivWidthSet = new HashSet<String>();
                equivWidthSet.add("border-top-width");
                equivWidthSet.add("border-bottom-width");
                HashSet<String> equivStyleSet = new HashSet<String>();
                equivStyleSet.add("border-top-style");
                equivStyleSet.add("border-bottom-style");
                HashSet<String> equivColorSet = new HashSet<String>();
                equivColorSet.add("border-top-color");
                equivColorSet.add("border-bottom-color");
                this.appendFullBorderText(buf, declaredSet, score, live_state, equivWidthSet, equivStyleSet, equivColorSet, important);
                this.appendBorderLeftText(buf, declaredSet, score, live_state, important);
            } else {
                equivWidthSet = score.getEquivWidthSet(samescore);
                Set<String> equivStyleSet = score.getEquivStyleSet(samescore);
                Set<String> equivColorSet = score.getEquivColorSet(samescore);
                this.appendFullBorderText(buf, declaredSet, score, live_state, equivWidthSet, equivStyleSet, equivColorSet, important);
                this.appendBorderRightText(buf, declaredSet, score, live_state, important);
                this.appendBorderLeftText(buf, declaredSet, score, live_state, important);
            }
            if (!this.isBorderImageSetToInitial()) {
                BorderImageBuilder builder = this.createBorderImageBuilder();
                builder.appendMinifiedCssText(buf);
            }
            return true;
        }
        if (samescore == 1) {
            Set<String> equivWidthSet = score.getEquivWidthSet(samescore);
            Set<String> equivStyleSet = score.getEquivStyleSet(samescore);
            Set<String> equivColorSet = score.getEquivColorSet(samescore);
            this.appendFullBorderText(buf, declaredSet, score, live_state, equivWidthSet, equivStyleSet, equivColorSet, important);
            this.appendBorderRightText(buf, declaredSet, score, live_state, important);
            this.appendBorderBottomText(buf, declaredSet, score, live_state, important);
            if (!this.isBorderImageSetToInitial()) {
                BorderImageBuilder builder = this.createBorderImageBuilder();
                builder.appendMinifiedCssText(buf);
            }
            return true;
        }
        if (score.equivalentProperties("border-right-width", "border-top-width", score.getWidthState().getBestState()) && score.equivalentProperties("border-right-style", "border-top-style", score.getStyleState().getBestState()) && score.equivalentProperties("border-right-color", "border-top-color", score.getColorState().getBestState())) {
            HashSet<String> equivWidthSet = new HashSet<String>();
            equivWidthSet.add("border-top-width");
            equivWidthSet.add("border-right-width");
            HashSet<String> equivStyleSet = new HashSet<String>();
            equivStyleSet.add("border-top-style");
            equivStyleSet.add("border-right-style");
            HashSet<String> equivColorSet = new HashSet<String>();
            equivColorSet.add("border-top-color");
            equivColorSet.add("border-right-color");
            this.appendFullBorderText(buf, declaredSet, score, live_state, equivWidthSet, equivStyleSet, equivColorSet, important);
            this.appendBorderBottomText(buf, declaredSet, score, live_state, important);
            this.appendBorderLeftText(buf, declaredSet, score, live_state, important);
            if (!this.isBorderImageSetToInitial()) {
                BorderImageBuilder builder = this.createBorderImageBuilder();
                builder.appendMinifiedCssText(buf);
            }
            return true;
        }
        if (score.equivalentProperties("border-left-width", "border-bottom-width", score.getWidthState().getBestState()) && score.equivalentProperties("border-left-style", "border-bottom-style", score.getStyleState().getBestState()) && score.equivalentProperties("border-left-color", "border-bottom-color", score.getColorState().getBestState())) {
            HashSet<String> equivWidthSet = new HashSet<String>();
            equivWidthSet.add("border-bottom-width");
            equivWidthSet.add("border-left-width");
            HashSet<String> equivStyleSet = new HashSet<String>();
            equivStyleSet.add("border-bottom-style");
            equivStyleSet.add("border-left-style");
            HashSet<String> equivColorSet = new HashSet<String>();
            equivColorSet.add("border-bottom-color");
            equivColorSet.add("border-left-color");
            this.appendFullBorderText(buf, declaredSet, score, live_state, equivWidthSet, equivStyleSet, equivColorSet, important);
            this.appendBorderTopText(buf, declaredSet, score, live_state, important);
            this.appendBorderRightText(buf, declaredSet, score, live_state, important);
            return true;
        }
        return false;
    }

    private void appendBorderTopText(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, byte live_state, boolean important) {
        if (declaredSet.contains("border-top-width") && declaredSet.contains("border-top-style") && declaredSet.contains("border-top-color")) {
            buf.append("border-top:");
            this.appendBorderSideText(buf, declaredSet, score, live_state, "border-top-width", "border-top-style", "border-top-color", important);
        }
    }

    private void appendBorderRightText(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, byte live_state, boolean important) {
        if (declaredSet.contains("border-right-width") && declaredSet.contains("border-right-style") && declaredSet.contains("border-right-color")) {
            buf.append("border-right:");
            this.appendBorderSideText(buf, declaredSet, score, live_state, "border-right-width", "border-right-style", "border-right-color", important);
        }
    }

    private void appendBorderBottomText(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, byte live_state, boolean important) {
        if (declaredSet.contains("border-bottom-width") && declaredSet.contains("border-bottom-style") && declaredSet.contains("border-bottom-color")) {
            buf.append("border-bottom:");
            this.appendBorderSideText(buf, declaredSet, score, live_state, "border-bottom-width", "border-bottom-style", "border-bottom-color", important);
        }
    }

    private void appendBorderLeftText(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, byte live_state, boolean important) {
        if (declaredSet.contains("border-left-width") && declaredSet.contains("border-left-style") && declaredSet.contains("border-left-color")) {
            buf.append("border-left:");
            this.appendBorderSideText(buf, declaredSet, score, live_state, "border-left-width", "border-left-style", "border-left-color", important);
        }
    }

    private void buildUnusedSet(Set<String> declaredSet) {
        for (String property : declaredSet) {
            this.unusedSet.add(property);
        }
    }

    private boolean isAnyBorderImagePropertySet() {
        BaseCSSStyleDeclaration style = this.getParentStyle();
        return style.isPropertySet("border-image-source") || style.isPropertySet("border-image-slice") || style.isPropertySet("border-image-width") || style.isPropertySet("border-image-outset") || style.isPropertySet("border-image-repeat");
    }

    private boolean isBorderImageSet(boolean important) {
        return this.isPropertyAssigned("border-image-source", important) && this.isPropertyAssigned("border-image-slice", important) && this.isPropertyAssigned("border-image-width", important) && this.isPropertyAssigned("border-image-outset", important) && this.isPropertyAssigned("border-image-repeat", important);
    }

    private boolean isBorderImageSetToInitial() {
        return this.isInitialValue("border-image-source") && this.isInitialValue("border-image-slice") && this.isInitialValue("border-image-width") && this.isInitialValue("border-image-outset") && this.isInitialValue("border-image-repeat");
    }

    private boolean appendPartialShorthands(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, PropertyCount counter, boolean important) {
        boolean ret;
        if (score.hasMixedStates()) {
            score.setEquivalentScores();
        }
        this.appendSideProperties(buf, !(ret = this.appendPartialProperties(buf, declaredSet, score, false, counter, important)), counter, important);
        this.appendUnused(buf, important);
        return true;
    }

    private boolean appendPartialProperties(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, boolean appendOnlyUnused, PropertyCount counter, boolean important) {
        boolean ret = false;
        if (counter.countBColor == 4) {
            this.appendBorderColorText(buf, declaredSet, appendOnlyUnused, score, score.getSameColorScore(), counter, important);
            ret = true;
        }
        if (counter.countBStyle == 4) {
            this.appendBorderStyleText(buf, declaredSet, appendOnlyUnused, score, score.getSameStyleScore(), counter, important);
            ret = true;
        }
        if (counter.countBWidth == 4) {
            this.appendBorderWidthText(buf, declaredSet, appendOnlyUnused, score, score.getSameWidthScore(), counter, important);
            ret = true;
        }
        return ret;
    }

    private void appendSideProperties(StringBuilder buf, boolean appendOnlyUnused, PropertyCount counter, boolean important) {
        if (counter.countBTop == 3 && this.appendBorderTopText(buf, appendOnlyUnused)) {
            this.appendPriority(buf, important);
        }
        if (counter.countBRight == 3 && this.appendBorderRightText(buf, appendOnlyUnused)) {
            this.appendPriority(buf, important);
        }
        if (counter.countBBottom == 3 && this.appendBorderBottomText(buf, appendOnlyUnused)) {
            this.appendPriority(buf, important);
        }
        if (counter.countBLeft == 3 && this.appendBorderLeftText(buf, appendOnlyUnused)) {
            this.appendPriority(buf, important);
        }
    }

    private void appendUnused(StringBuilder buf, boolean important) {
        if (!this.unusedSet.isEmpty()) {
            for (String unusedPty : this.unusedSet) {
                buf.append(unusedPty).append(':').append(this.getCSSValue(unusedPty).getMinifiedCssText(unusedPty));
                this.appendPriority(buf, important);
            }
        }
    }

    private void appendFullBorderPlusMore(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, byte live_state, boolean important) {
        int wscore = score.getSameWidthScore();
        int sscore = score.getSameStyleScore();
        int cscore = score.getSameColorScore();
        boolean appendBWidth = wscore != 21 || score.getWidthState().getBestState() != live_state;
        boolean appendBStyle = sscore != 21 || score.getStyleState().getBestState() != live_state;
        boolean appendBColor = cscore != 21 || score.getColorState().getBestState() != live_state;
        Set<String> equivWidthSet = appendBWidth ? null : score.getEquivWidthSet(wscore);
        Set<String> equivStyleSet = appendBStyle ? null : score.getEquivStyleSet(sscore);
        Set<String> equivColorSet = appendBColor ? null : score.getEquivColorSet(cscore);
        StringBuilder trailbuf = new StringBuilder(80);
        if (appendBWidth) {
            if (wscore == 17) {
                this.appendStandAlonePropertyAndPriority(trailbuf, declaredSet, important, "border-bottom-width");
                equivWidthSet = score.getEquivWidthSet(17);
            } else if (wscore == 16 && score.equivalentProperties("border-right-width", "border-bottom-width", score.getWidthState().getBestState())) {
                this.appendStandAlonePropertyAndPriority(trailbuf, declaredSet, important, "border-top-width");
                equivWidthSet = score.getEquivWidthSet(15);
            } else if (wscore == 5) {
                this.appendStandAlonePropertyAndPriority(trailbuf, declaredSet, important, "border-right-width");
                equivWidthSet = score.getEquivWidthSet(5);
            } else if (wscore == 4 && score.equivalentProperties("border-top-width", "border-right-width", score.getWidthState().getBestState())) {
                this.appendStandAlonePropertyAndPriority(trailbuf, declaredSet, important, "border-left-width");
                equivWidthSet = score.getEquivWidthSet(4);
            } else {
                this.appendBorderWidthText(trailbuf, declaredSet, false, score, wscore, null, important);
            }
        }
        if (appendBStyle) {
            if (sscore == 17) {
                this.appendStandAlonePropertyAndPriority(trailbuf, declaredSet, important, "border-bottom-style");
                equivStyleSet = score.getEquivStyleSet(17);
            } else if (sscore == 16 && score.equivalentProperties("border-right-style", "border-bottom-style", score.getStyleState().getBestState())) {
                this.appendStandAlonePropertyAndPriority(trailbuf, declaredSet, important, "border-top-style");
                equivStyleSet = score.getEquivStyleSet(15);
            } else if (sscore == 5) {
                this.appendStandAlonePropertyAndPriority(trailbuf, declaredSet, important, "border-right-style");
                equivStyleSet = score.getEquivStyleSet(5);
            } else if (sscore == 4 && score.equivalentProperties("border-top-style", "border-right-style", score.getStyleState().getBestState())) {
                this.appendStandAlonePropertyAndPriority(trailbuf, declaredSet, important, "border-left-style");
                equivStyleSet = score.getEquivStyleSet(4);
            } else {
                this.appendBorderStyleText(trailbuf, declaredSet, false, score, sscore, null, important);
            }
        }
        if (appendBColor) {
            if (cscore == 17) {
                this.appendStandAlonePropertyAndPriority(trailbuf, declaredSet, important, "border-bottom-color");
                equivColorSet = score.getEquivColorSet(17);
            } else if (cscore == 16 && score.equivalentProperties("border-right-color", "border-bottom-color", score.getColorState().getBestState())) {
                this.appendStandAlonePropertyAndPriority(trailbuf, declaredSet, important, "border-top-color");
                equivColorSet = score.getEquivColorSet(15);
            } else if (cscore == 5) {
                this.appendStandAlonePropertyAndPriority(trailbuf, declaredSet, important, "border-right-color");
                equivColorSet = score.getEquivColorSet(5);
            } else if (cscore == 4 && score.equivalentProperties("border-top-color", "border-right-color", score.getColorState().getBestState())) {
                this.appendStandAlonePropertyAndPriority(trailbuf, declaredSet, important, "border-left-color");
                equivColorSet = score.getEquivColorSet(4);
            } else {
                this.appendBorderColorText(trailbuf, declaredSet, false, score, cscore, null, important);
            }
        }
        this.appendFullBorderText(buf, declaredSet, score, live_state, equivWidthSet, equivStyleSet, equivColorSet, important);
        buf.append((CharSequence)trailbuf);
    }

    private void appendFullBorderText(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, byte live_state, Set<String> equivWidthSet, Set<String> equivStyleSet, Set<String> equivColorSet, boolean important) {
        AbstractCSSValue colorVal;
        String colorProperty;
        AbstractCSSValue styleVal;
        String styleProperty;
        AbstractCSSValue widthVal;
        String widthProperty;
        if (equivWidthSet != null) {
            widthProperty = this.liveMember(equivWidthSet, score, live_state);
            widthVal = this.getCSSValue(widthProperty);
        } else {
            widthProperty = "border-top-width";
            widthVal = null;
        }
        if (equivStyleSet != null) {
            styleProperty = this.liveMember(equivStyleSet, score, live_state);
            styleVal = this.getCSSValue(styleProperty);
        } else {
            styleProperty = "border-top-style";
            styleVal = null;
        }
        if (equivColorSet != null) {
            colorProperty = this.liveMember(equivColorSet, score, live_state);
            colorVal = this.getCSSValue(colorProperty);
        } else {
            colorProperty = "border-top-color";
            colorVal = null;
        }
        buf.append("border:");
        this.appendBorderText(buf, declaredSet, score, live_state, widthProperty, widthVal, styleProperty, styleVal, colorProperty, colorVal, important);
        this.removeFromUnused(equivWidthSet);
        this.removeFromUnused(equivStyleSet);
        this.removeFromUnused(equivColorSet);
    }

    private void removeFromUnused(Set<String> equivSet) {
        if (equivSet != null) {
            Iterator<String> it = equivSet.iterator();
            while (it.hasNext()) {
                this.unusedSet.remove(it.next());
            }
        }
    }

    private String liveMember(Set<String> equivSet, PropertyValueScore score, byte live_state) {
        for (String property : equivSet) {
            if (!score.isLiveProperty(property, live_state)) continue;
            return property;
        }
        return null;
    }

    private void appendBorderSideText(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, byte live_state, String widthProperty, String styleProperty, String colorProperty, boolean important) {
        HashSet<String> localSet = new HashSet<String>(3);
        if (declaredSet.contains(widthProperty)) {
            localSet.add(widthProperty);
        }
        if (declaredSet.contains(styleProperty)) {
            localSet.add(styleProperty);
        }
        if (declaredSet.contains(colorProperty)) {
            localSet.add(colorProperty);
        }
        AbstractCSSValue widthVal = this.getCSSValue(widthProperty);
        AbstractCSSValue styleVal = this.getCSSValue(styleProperty);
        AbstractCSSValue colorVal = this.getCSSValue(colorProperty);
        this.appendBorderText(buf, localSet, score, live_state, widthProperty, widthVal, styleProperty, styleVal, colorProperty, colorVal, important);
    }

    private void appendBorderText(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, byte live_state, String widthProperty, AbstractCSSValue widthVal, String styleProperty, AbstractCSSValue styleVal, String colorProperty, AbstractCSSValue colorVal, boolean important) {
        this.appendBorderTextTriplet(buf, declaredSet, score, live_state, widthProperty, widthVal, styleProperty, styleVal, colorProperty, colorVal);
        this.appendPriority(buf, important);
    }

    private void appendBorderTextTriplet(StringBuilder buf, Set<String> declaredSet, PropertyValueScore score, byte live_state, String widthProperty, AbstractCSSValue widthVal, String styleProperty, AbstractCSSValue styleVal, String colorProperty, AbstractCSSValue colorVal) {
        boolean appended = false;
        if (widthProperty != null && declaredSet.contains(widthProperty) && this.isNotInitialValue(widthVal, widthProperty) && score.isLiveState(widthVal, live_state)) {
            String widthTxt = widthVal.getMinifiedCssText(widthProperty);
            buf.append(widthTxt);
            appended = true;
        }
        if (styleProperty != null && declaredSet.contains(styleProperty) && this.isNotInitialValue(styleVal, styleProperty) && score.isLiveState(styleVal, live_state)) {
            if (appended) {
                if (live_state != 0) {
                    return;
                }
                buf.append(' ');
            }
            buf.append(styleVal.getMinifiedCssText(styleProperty));
            appended = true;
        }
        if (colorProperty != null && declaredSet.contains(colorProperty) && this.isNotInitialValue(colorVal, colorProperty) && score.isLiveState(colorVal, live_state)) {
            if (appended) {
                if (live_state != 0) {
                    return;
                }
                buf.append(' ');
            }
            buf.append(colorVal.getMinifiedCssText(colorProperty));
            appended = true;
        }
        if (!appended) {
            buf.append("none");
        }
    }

    private void appendStandAlonePropertyAndPriority(StringBuilder buf, Set<String> declaredSet, boolean important, String standAlonePty) {
        if (declaredSet.contains(standAlonePty)) {
            buf.append(standAlonePty).append(':').append(this.getCSSValue(standAlonePty).getCssText());
            this.appendPriority(buf, important);
        }
    }

    private boolean appendBorderWidthText(StringBuilder buf, Set<String> declaredSet, boolean checkUnused, PropertyValueScore score, int sameBWidthScore, PropertyCount counter, boolean important) {
        return this.appendBorderPropertyBoxText(buf, declaredSet, checkUnused, score, sameBWidthScore, score.getWidthState().getBestState(), counter, "border-width:", "border-top-width", "border-right-width", "border-bottom-width", "border-left-width", "medium", important);
    }

    private boolean appendBorderStyleText(StringBuilder buf, Set<String> declaredSet, boolean checkUnused, PropertyValueScore score, int sameBStyleScore, PropertyCount counter, boolean important) {
        return this.appendBorderPropertyBoxText(buf, declaredSet, checkUnused, score, sameBStyleScore, score.getStyleState().getBestState(), counter, "border-style:", "border-top-style", "border-right-style", "border-bottom-style", "border-left-style", "none", important);
    }

    private boolean appendBorderColorText(StringBuilder buf, Set<String> declaredSet, boolean checkUnused, PropertyValueScore score, int sameBColorScore, PropertyCount counter, boolean important) {
        return this.appendBorderPropertyBoxText(buf, declaredSet, checkUnused, score, sameBColorScore, score.getColorState().getBestState(), counter, "border-color:", "border-top-color", "border-right-color", "border-bottom-color", "border-left-color", "currentcolor", important);
    }

    private boolean appendBorderPropertyBoxText(StringBuilder buf, Set<String> declaredSet, boolean checkUnused, PropertyValueScore score, int sameScore, byte live_state, PropertyCount counter, String pnameStr, String borderTopPty, String borderRightPty, String borderBottomPty, String borderLeftPty, String initialString, boolean important) {
        if (!(declaredSet.contains(borderTopPty) || declaredSet.contains(borderRightPty) || declaredSet.contains(borderBottomPty) || declaredSet.contains(borderLeftPty))) {
            return false;
        }
        if (!(!checkUnused || this.unusedSet.contains(borderTopPty) || this.unusedSet.contains(borderRightPty) || this.unusedSet.contains(borderBottomPty) || this.unusedSet.contains(borderLeftPty))) {
            return false;
        }
        if (counter != null) {
            if (sameScore == 16) {
                if (counter.countBTop == 3 && counter.countBBottom == 3) {
                    sameScore = 21;
                    borderTopPty = null;
                    borderBottomPty = null;
                } else if (score.equivalentProperties(borderBottomPty, borderRightPty, live_state)) {
                    if (counter.countBTop == 3) {
                        sameScore = 21;
                        borderTopPty = null;
                    }
                } else if (counter.countBTop == 3) {
                    sameScore = 20;
                    borderTopPty = null;
                } else if (counter.countBBottom == 3) {
                    sameScore = 20;
                    borderBottomPty = null;
                }
            } else if (sameScore == 17) {
                if (counter.countBBottom == 3) {
                    sameScore = 21;
                    borderBottomPty = null;
                }
            } else if (sameScore == 20) {
                if (counter.countBTop == 3 && counter.countBBottom == 3) {
                    sameScore = 21;
                    borderTopPty = null;
                    borderBottomPty = null;
                } else if (counter.countBRight == 3 && counter.countBLeft == 3) {
                    sameScore = 21;
                    borderRightPty = null;
                    borderLeftPty = null;
                }
            } else if (sameScore == 5) {
                if (counter.countBRight == 3) {
                    sameScore = 21;
                    borderRightPty = null;
                }
            } else if (sameScore == 4) {
                if (counter.countBRight == 3 && counter.countBLeft == 3) {
                    sameScore = 21;
                    borderRightPty = null;
                    borderLeftPty = null;
                } else if (score.equivalentProperties(borderTopPty, borderRightPty, live_state)) {
                    if (counter.countBLeft == 3) {
                        sameScore = 21;
                        borderLeftPty = null;
                    }
                } else if (counter.countBRight == 3) {
                    sameScore = 20;
                    borderRightPty = null;
                } else if (counter.countBLeft == 3) {
                    sameScore = 20;
                    borderLeftPty = null;
                }
            } else if (sameScore == 1) {
                if (score.equivalentProperties(borderBottomPty, borderRightPty, live_state)) {
                    if (counter.countBTop == 3 && counter.countBLeft == 3) {
                        sameScore = 21;
                        borderTopPty = null;
                        borderLeftPty = null;
                    } else if (counter.countBLeft == 3) {
                        sameScore = 16;
                        borderLeftPty = null;
                    }
                }
                if (sameScore < 21) {
                    if (counter.countBRight == 3 && counter.countBBottom == 3) {
                        sameScore = 21;
                        borderRightPty = null;
                        borderBottomPty = null;
                    } else if (counter.countBRight == 3) {
                        sameScore = 16;
                        borderRightPty = null;
                    }
                }
            }
            if (sameScore >= 0 && sameScore < 20) {
                if (score.equivalentProperties(borderTopPty, borderRightPty, live_state)) {
                    if (counter.countBBottom == 3 && counter.countBLeft == 3) {
                        sameScore = 21;
                        borderBottomPty = null;
                        borderLeftPty = null;
                    } else if (counter.countBTop == 3 && counter.countBRight == 3) {
                        sameScore = 20;
                        borderTopPty = null;
                        borderRightPty = null;
                    } else if (counter.countBLeft == 3) {
                        sameScore = 16;
                        borderLeftPty = null;
                    }
                }
                if (sameScore < 21) {
                    if (score.equivalentProperties(borderBottomPty, borderLeftPty, live_state)) {
                        if (counter.countBTop == 3 && counter.countBRight == 3) {
                            sameScore = 21;
                            borderTopPty = null;
                            borderRightPty = null;
                        } else if (sameScore < 20 && counter.countBBottom == 3 && counter.countBLeft == 3) {
                            sameScore = 20;
                            borderBottomPty = null;
                            borderLeftPty = null;
                        } else if (sameScore < 16 && counter.countBRight == 3) {
                            sameScore = 16;
                            borderRightPty = null;
                        }
                    }
                    if (sameScore < 20) {
                        if (counter.countBTop == 3 && counter.countBRight == 3) {
                            sameScore = 20;
                            borderTopPty = null;
                            borderRightPty = null;
                        } else if (counter.countBBottom == 3 && counter.countBLeft == 3) {
                            sameScore = 20;
                            borderBottomPty = null;
                            borderLeftPty = null;
                        } else if (sameScore < 16) {
                            if (counter.countBRight == 3) {
                                sameScore = 16;
                                borderRightPty = null;
                            } else if (counter.countBLeft == 3) {
                                sameScore = 16;
                                borderLeftPty = null;
                            }
                        }
                    }
                }
            }
        }
        boolean appended = false;
        buf.append(pnameStr);
        switch (sameScore) {
            case 21: {
                String property = borderTopPty;
                if (this.isBoxLiveProperty(score, borderTopPty, live_state)) {
                    this.unusedSet.remove(borderTopPty);
                }
                if (this.isBoxLiveProperty(score, borderBottomPty, live_state)) {
                    this.unusedSet.remove(borderBottomPty);
                    property = borderBottomPty;
                }
                if (this.isBoxLiveProperty(score, borderLeftPty, live_state)) {
                    this.unusedSet.remove(borderLeftPty);
                    property = borderLeftPty;
                }
                if (this.isBoxLiveProperty(score, borderRightPty, live_state)) {
                    this.unusedSet.remove(borderRightPty);
                    property = borderRightPty;
                }
                if (appended = this.appendValueIfNotInitial(buf, property, false)) break;
                buf.append(initialString);
                break;
            }
            case 20: {
                String property = this.isBoxLiveProperty(score, borderTopPty, live_state) ? borderTopPty : borderBottomPty;
                appended = this.appendValueIfNotInitial(buf, property, false);
                if (!appended) {
                    buf.append(initialString);
                }
                buf.append(' ');
                String property2 = this.isBoxLiveProperty(score, borderLeftPty, live_state) ? borderLeftPty : borderRightPty;
                appended = this.appendValueIfNotInitial(buf, property2, false);
                if (!appended) {
                    buf.append(initialString);
                }
                if (this.isBoxLiveProperty(score, borderTopPty, live_state)) {
                    this.unusedSet.remove(borderTopPty);
                }
                if (this.isBoxLiveProperty(score, borderBottomPty, live_state)) {
                    this.unusedSet.remove(borderBottomPty);
                }
                if (this.isBoxLiveProperty(score, borderLeftPty, live_state)) {
                    this.unusedSet.remove(borderLeftPty);
                }
                if (!this.isBoxLiveProperty(score, borderRightPty, live_state)) break;
                this.unusedSet.remove(borderRightPty);
                break;
            }
            case 16: 
            case 17: {
                appended = this.appendValueIfNotInitial(buf, borderTopPty, false);
                if (!appended) {
                    buf.append(initialString);
                }
                buf.append(' ');
                String property = this.isBoxLiveProperty(score, borderLeftPty, live_state) ? borderLeftPty : borderRightPty;
                appended = this.appendValueIfNotInitial(buf, property, false);
                if (!appended) {
                    buf.append(initialString);
                }
                buf.append(' ');
                appended = this.appendValueIfNotInitial(buf, borderBottomPty, false);
                if (!appended) {
                    buf.append(initialString);
                }
                this.unusedSet.remove(borderTopPty);
                this.unusedSet.remove(borderBottomPty);
                if (this.isBoxLiveProperty(score, borderLeftPty, live_state)) {
                    this.unusedSet.remove(borderLeftPty);
                }
                if (!this.isBoxLiveProperty(score, borderRightPty, live_state)) break;
                this.unusedSet.remove(borderRightPty);
                break;
            }
            default: {
                appended = this.appendValueIfNotInitial(buf, borderTopPty, false);
                if (!appended) {
                    buf.append(initialString);
                }
                buf.append(' ');
                appended = this.appendValueIfNotInitial(buf, borderRightPty, false);
                if (!appended) {
                    buf.append(initialString);
                }
                buf.append(' ');
                appended = this.appendValueIfNotInitial(buf, borderBottomPty, false);
                if (!appended) {
                    buf.append(initialString);
                }
                buf.append(' ');
                appended = this.appendValueIfNotInitial(buf, borderLeftPty, false);
                if (!appended) {
                    buf.append(initialString);
                }
                this.unusedSet.remove(borderTopPty);
                this.unusedSet.remove(borderRightPty);
                this.unusedSet.remove(borderBottomPty);
                this.unusedSet.remove(borderLeftPty);
            }
        }
        this.appendPriority(buf, important);
        return true;
    }

    private boolean isBoxLiveProperty(PropertyValueScore score, String property, byte live_state) {
        return property != null && score.isLiveProperty(property, live_state);
    }

    private boolean appendBorderTopText(StringBuilder buf, boolean onlyUnused) {
        return this.getTopKeywordState() != -1 && this.appendBorderSideText(buf, "border-top:", "border-top-width", "border-top-style", "border-top-color", onlyUnused);
    }

    private boolean appendBorderRightText(StringBuilder buf, boolean onlyUnused) {
        return this.getRightKeywordState() != -1 && this.appendBorderSideText(buf, "border-right:", "border-right-width", "border-right-style", "border-right-color", onlyUnused);
    }

    private boolean appendBorderBottomText(StringBuilder buf, boolean onlyUnused) {
        return this.getBottomKeywordState() != -1 && this.appendBorderSideText(buf, "border-bottom:", "border-bottom-width", "border-bottom-style", "border-bottom-color", onlyUnused);
    }

    private boolean appendBorderLeftText(StringBuilder buf, boolean onlyUnused) {
        return this.getLeftKeywordState() != -1 && this.appendBorderSideText(buf, "border-left:", "border-left-width", "border-left-style", "border-left-color", onlyUnused);
    }

    private boolean appendBorderSideText(StringBuilder buf, String bSidePtyStr, String bWidthPty, String bStylePty, String bColorPty, boolean appendOnlyUnused) {
        if (this.unusedSet.contains(bWidthPty) || this.unusedSet.contains(bStylePty) || this.unusedSet.contains(bColorPty)) {
            buf.append(bSidePtyStr);
            boolean appended = false;
            if (!appendOnlyUnused || this.unusedSet.contains(bWidthPty)) {
                appended = this.appendValueIfNotInitial(buf, bWidthPty, false);
            }
            if (!appendOnlyUnused || this.unusedSet.contains(bStylePty)) {
                appended = this.appendValueIfNotInitial(buf, bStylePty, appended);
            }
            if (!appendOnlyUnused || this.unusedSet.contains(bColorPty)) {
                appended = this.appendValueIfNotInitial(buf, bColorPty, appended);
            }
            if (!appended) {
                buf.append("none");
            }
            this.unusedSet.remove(bWidthPty);
            this.unusedSet.remove(bStylePty);
            this.unusedSet.remove(bColorPty);
            return true;
        }
        return false;
    }

    private byte getTopKeywordState() {
        AbstractCSSValue width = this.getCSSValue("border-top-width");
        AbstractCSSValue style = this.getCSSValue("border-top-style");
        AbstractCSSValue color = this.getCSSValue("border-top-color");
        return this.getSideKeywordState(width, style, color);
    }

    private byte getRightKeywordState() {
        AbstractCSSValue width = this.getCSSValue("border-right-width");
        AbstractCSSValue style = this.getCSSValue("border-right-style");
        AbstractCSSValue color = this.getCSSValue("border-right-color");
        return this.getSideKeywordState(width, style, color);
    }

    private byte getBottomKeywordState() {
        AbstractCSSValue width = this.getCSSValue("border-bottom-width");
        AbstractCSSValue style = this.getCSSValue("border-bottom-style");
        AbstractCSSValue color = this.getCSSValue("border-bottom-color");
        return this.getSideKeywordState(width, style, color);
    }

    private byte getLeftKeywordState() {
        AbstractCSSValue width = this.getCSSValue("border-left-width");
        AbstractCSSValue style = this.getCSSValue("border-left-style");
        AbstractCSSValue color = this.getCSSValue("border-left-color");
        return this.getSideKeywordState(width, style, color);
    }

    private byte getSideKeywordState(AbstractCSSValue width, AbstractCSSValue style, AbstractCSSValue color) {
        byte keyword_state_color;
        byte keyword_state_style;
        byte keyword_state_width = this.keywordState(width);
        int keyword_state = keyword_state_width + (keyword_state_style = this.keywordState(style)) + (keyword_state_color = this.keywordState(color));
        int state = keyword_state == 0 ? 0 : (keyword_state == 3 ? 1 : (keyword_state == 15 ? 2 : -1));
        return (byte)state;
    }

    private class PropertyCount {
        int countBTop = 0;
        int countBRight = 0;
        int countBBottom = 0;
        int countBLeft = 0;
        int countBColor = 0;
        int countBStyle = 0;
        int countBWidth = 0;

        PropertyCount() {
        }

        void count(Set<String> declaredSet, boolean important) {
            BorderBuilder.this.unusedSet.addAll(declaredSet);
            if (declaredSet.contains("border-top-width")) {
                ++this.countBTop;
                ++this.countBWidth;
            }
            if (declaredSet.contains("border-top-style")) {
                ++this.countBTop;
                ++this.countBStyle;
            }
            if (declaredSet.contains("border-top-color")) {
                ++this.countBTop;
                ++this.countBColor;
            }
            if (declaredSet.contains("border-right-width")) {
                ++this.countBRight;
                ++this.countBWidth;
            }
            if (declaredSet.contains("border-right-style")) {
                ++this.countBRight;
                ++this.countBStyle;
            }
            if (declaredSet.contains("border-right-color")) {
                ++this.countBRight;
                ++this.countBColor;
            }
            if (declaredSet.contains("border-bottom-width")) {
                ++this.countBBottom;
                ++this.countBWidth;
            }
            if (declaredSet.contains("border-bottom-style")) {
                ++this.countBBottom;
                ++this.countBStyle;
            }
            if (declaredSet.contains("border-bottom-color")) {
                ++this.countBBottom;
                ++this.countBColor;
            }
            if (declaredSet.contains("border-left-width")) {
                ++this.countBLeft;
                ++this.countBWidth;
            }
            if (declaredSet.contains("border-left-style")) {
                ++this.countBLeft;
                ++this.countBStyle;
            }
            if (declaredSet.contains("border-left-color")) {
                ++this.countBLeft;
                ++this.countBColor;
            }
            if (!important) {
                BaseCSSStyleDeclaration style = BorderBuilder.this.getParentStyle();
                if (this.isShadowed(style, declaredSet, "border-top-width")) {
                    ++this.countBTop;
                    if (this.countBWidth != 0) {
                        ++this.countBWidth;
                    }
                }
                if (this.isShadowed(style, declaredSet, "border-top-style")) {
                    ++this.countBTop;
                    if (this.countBStyle != 0) {
                        ++this.countBStyle;
                    }
                }
                if (this.isShadowed(style, declaredSet, "border-top-color")) {
                    ++this.countBTop;
                    if (this.countBColor != 0) {
                        ++this.countBColor;
                    }
                }
                if (this.isShadowed(style, declaredSet, "border-right-width")) {
                    ++this.countBRight;
                    if (this.countBWidth != 0) {
                        ++this.countBWidth;
                    }
                }
                if (this.isShadowed(style, declaredSet, "border-right-style")) {
                    ++this.countBRight;
                    if (this.countBStyle != 0) {
                        ++this.countBStyle;
                    }
                }
                if (this.isShadowed(style, declaredSet, "border-right-color")) {
                    ++this.countBRight;
                    if (this.countBColor != 0) {
                        ++this.countBColor;
                    }
                }
                if (this.isShadowed(style, declaredSet, "border-bottom-width")) {
                    ++this.countBBottom;
                    if (this.countBWidth != 0) {
                        ++this.countBWidth;
                    }
                }
                if (this.isShadowed(style, declaredSet, "border-bottom-style")) {
                    ++this.countBBottom;
                    if (this.countBStyle != 0) {
                        ++this.countBStyle;
                    }
                }
                if (this.isShadowed(style, declaredSet, "border-bottom-color")) {
                    ++this.countBBottom;
                    if (this.countBColor != 0) {
                        ++this.countBColor;
                    }
                }
                if (this.isShadowed(style, declaredSet, "border-left-width")) {
                    ++this.countBLeft;
                    if (this.countBWidth != 0) {
                        ++this.countBWidth;
                    }
                }
                if (this.isShadowed(style, declaredSet, "border-left-style")) {
                    ++this.countBLeft;
                    if (this.countBStyle != 0) {
                        ++this.countBStyle;
                    }
                }
                if (this.isShadowed(style, declaredSet, "border-left-color")) {
                    ++this.countBLeft;
                    if (this.countBColor != 0) {
                        ++this.countBColor;
                    }
                }
            }
        }

        private boolean isShadowed(BaseCSSStyleDeclaration style, Set<String> declaredSet, String property) {
            return !declaredSet.contains(property) && style.isPropertySet(property);
        }
    }

    class PropertyState {
        int score = 0;
        int keyword_state = 0;
        private byte best_state = 0;

        PropertyState() {
        }

        private byte getBestState() {
            return this.best_state;
        }

        private int sameValueScore(String ptyTop, String ptyRight, String ptyBottom, String ptyLeft) {
            AbstractCSSValue top = BorderBuilder.this.getCSSValue(ptyTop);
            AbstractCSSValue bottom = BorderBuilder.this.getCSSValue(ptyBottom);
            AbstractCSSValue left = BorderBuilder.this.getCSSValue(ptyLeft);
            AbstractCSSValue right = BorderBuilder.this.getCSSValue(ptyRight);
            byte keyword_state_top = BorderBuilder.this.keywordState(top);
            byte keyword_state_bottom = BorderBuilder.this.keywordState(bottom);
            byte keyword_state_left = BorderBuilder.this.keywordState(left);
            byte keyword_state_right = BorderBuilder.this.keywordState(right);
            this.score = 0;
            if (BorderBuilder.this.valueEquals(left, right)) {
                this.score = 16;
            }
            if (BorderBuilder.this.valueEquals(top, bottom)) {
                this.score += 4;
            }
            if (BorderBuilder.this.valueEquals(top, left)) {
                ++this.score;
            }
            this.keyword_state = keyword_state_top + keyword_state_bottom + keyword_state_left + keyword_state_right;
            if (this.keyword_state != 0 && this.keyword_state != 4 && this.keyword_state != 20) {
                this.score = -1;
            } else {
                this.best_state = (byte)(this.keyword_state / 4);
            }
            return this.score;
        }

        private int equivalentValueScore(String ptyTop, String ptyRight, String ptyBottom, String ptyLeft) {
            AbstractCSSValue top = BorderBuilder.this.getCSSValue(ptyTop);
            AbstractCSSValue bottom = BorderBuilder.this.getCSSValue(ptyBottom);
            AbstractCSSValue left = BorderBuilder.this.getCSSValue(ptyLeft);
            AbstractCSSValue right = BorderBuilder.this.getCSSValue(ptyRight);
            byte keyword_state_top = BorderBuilder.this.keywordState(top);
            byte keyword_state_bottom = BorderBuilder.this.keywordState(bottom);
            byte keyword_state_left = BorderBuilder.this.keywordState(left);
            byte keyword_state_right = BorderBuilder.this.keywordState(right);
            this.keyword_state = keyword_state_top + keyword_state_bottom + keyword_state_left + keyword_state_right;
            this.best_state = 0;
            int inherit_count = this.keyword_state % 5;
            if (inherit_count == 3 || inherit_count == 4) {
                this.best_state = 1;
            } else if (this.keyword_state > 10) {
                this.best_state = (byte)5;
            }
            this.score = 0;
            if (BorderBuilder.this.valueEquals(left, right) || keyword_state_left != this.best_state || keyword_state_right != this.best_state) {
                this.score += 16;
            }
            if (BorderBuilder.this.valueEquals(top, bottom) || keyword_state_top != this.best_state || keyword_state_bottom != this.best_state) {
                this.score += 4;
            }
            if (BorderBuilder.this.valueEquals(top, left) || keyword_state_top != this.best_state || keyword_state_left != this.best_state) {
                ++this.score;
            }
            return this.score;
        }
    }

    private class PropertyValueScore {
        final PropertyState widthState;
        final PropertyState styleState;
        final PropertyState colorState;

        PropertyValueScore() {
            this.widthState = new PropertyState();
            this.styleState = new PropertyState();
            this.colorState = new PropertyState();
        }

        boolean isLiveProperty(String property, byte live_state) {
            return this.isLiveState(BorderBuilder.this.getCSSValue(property), live_state);
        }

        public PropertyState getWidthState() {
            return this.widthState;
        }

        public PropertyState getStyleState() {
            return this.styleState;
        }

        public PropertyState getColorState() {
            return this.colorState;
        }

        public int getSameWidthScore() {
            return this.widthState.score;
        }

        public int getSameStyleScore() {
            return this.styleState.score;
        }

        public int getSameColorScore() {
            return this.colorState.score;
        }

        public boolean isMixed() {
            return this.widthState.keyword_state != this.styleState.keyword_state || this.styleState.keyword_state != this.colorState.keyword_state;
        }

        boolean equivalentProperties(String property1, String property2, byte live_state) {
            AbstractCSSValue value2;
            AbstractCSSValue value1 = BorderBuilder.this.getCSSValue(property1);
            return BorderBuilder.this.valueEquals(value1, value2 = BorderBuilder.this.getCSSValue(property2)) || BorderBuilder.this.keywordState(value1) != live_state || BorderBuilder.this.keywordState(value2) != live_state;
        }

        boolean isLiveState(AbstractCSSValue value, byte live_state) {
            return BorderBuilder.this.keywordState(value) == live_state;
        }

        void score() {
            this.widthState.sameValueScore("border-top-width", "border-right-width", "border-bottom-width", "border-left-width");
            this.styleState.sameValueScore("border-top-style", "border-right-style", "border-bottom-style", "border-left-style");
            this.colorState.sameValueScore("border-top-color", "border-right-color", "border-bottom-color", "border-left-color");
        }

        public void score(PropertyCount counter) {
            if (counter.countBWidth == 4) {
                this.widthState.sameValueScore("border-top-width", "border-right-width", "border-bottom-width", "border-left-width");
            }
            if (counter.countBStyle == 4) {
                this.styleState.sameValueScore("border-top-style", "border-right-style", "border-bottom-style", "border-left-style");
            }
            if (counter.countBColor == 4) {
                this.colorState.sameValueScore("border-top-color", "border-right-color", "border-bottom-color", "border-left-color");
            }
        }

        boolean hasMixedStates() {
            return this.getSameWidthScore() == -1 || this.getSameStyleScore() == -1 || this.getSameColorScore() == -1;
        }

        int getScore(byte live_state) {
            int score = 0;
            if (!this.hasMixedStates()) {
                score = 0;
                if (this.widthState.keyword_state == live_state) {
                    score += this.getSameWidthScore();
                }
                if (this.styleState.keyword_state == live_state) {
                    score += this.getSameStyleScore();
                }
                if (this.colorState.keyword_state == live_state) {
                    score += this.getSameColorScore();
                }
            } else {
                score = -1;
            }
            return score;
        }

        void setEquivalentScores() {
            this.widthState.equivalentValueScore("border-top-width", "border-right-width", "border-bottom-width", "border-left-width");
            this.styleState.equivalentValueScore("border-top-style", "border-right-style", "border-bottom-style", "border-left-style");
            this.colorState.equivalentValueScore("border-top-color", "border-right-color", "border-bottom-color", "border-left-color");
        }

        void setEquivalentScores(PropertyCount counter) {
            if (counter.countBWidth == 4) {
                this.widthState.equivalentValueScore("border-top-width", "border-right-width", "border-bottom-width", "border-left-width");
            }
            if (counter.countBStyle == 4) {
                this.styleState.equivalentValueScore("border-top-style", "border-right-style", "border-bottom-style", "border-left-style");
            }
            if (counter.countBColor == 4) {
                this.colorState.equivalentValueScore("border-top-color", "border-right-color", "border-bottom-color", "border-left-color");
            }
        }

        Set<String> getEquivWidthSet(int propertyScore) {
            HashSet<String> equivWidthSet = new HashSet<String>();
            switch (propertyScore) {
                case 21: {
                    equivWidthSet.add("border-top-width");
                    equivWidthSet.add("border-right-width");
                    equivWidthSet.add("border-left-width");
                    equivWidthSet.add("border-bottom-width");
                    break;
                }
                case 17: {
                    equivWidthSet.add("border-top-width");
                    equivWidthSet.add("border-right-width");
                    equivWidthSet.add("border-left-width");
                    break;
                }
                case 16: {
                    equivWidthSet.add("border-right-width");
                    equivWidthSet.add("border-left-width");
                    break;
                }
                case 15: {
                    equivWidthSet.add("border-right-width");
                    equivWidthSet.add("border-left-width");
                    equivWidthSet.add("border-bottom-width");
                    break;
                }
                case 5: {
                    equivWidthSet.add("border-left-width");
                    equivWidthSet.add("border-top-width");
                    equivWidthSet.add("border-bottom-width");
                    break;
                }
                case 4: {
                    equivWidthSet.add("border-top-width");
                    equivWidthSet.add("border-bottom-width");
                    break;
                }
                case 3: {
                    equivWidthSet.add("border-top-width");
                    equivWidthSet.add("border-right-width");
                    equivWidthSet.add("border-bottom-width");
                    break;
                }
                case 1: {
                    equivWidthSet.add("border-top-width");
                    equivWidthSet.add("border-left-width");
                }
            }
            return equivWidthSet;
        }

        Set<String> getEquivStyleSet(int propertyScore) {
            HashSet<String> equivStyleSet = new HashSet<String>();
            switch (propertyScore) {
                case 21: {
                    equivStyleSet.add("border-top-style");
                    equivStyleSet.add("border-right-style");
                    equivStyleSet.add("border-left-style");
                    equivStyleSet.add("border-bottom-style");
                    break;
                }
                case 17: {
                    equivStyleSet.add("border-top-style");
                    equivStyleSet.add("border-right-style");
                    equivStyleSet.add("border-left-style");
                    break;
                }
                case 16: {
                    equivStyleSet.add("border-right-style");
                    equivStyleSet.add("border-left-style");
                    break;
                }
                case 15: {
                    equivStyleSet.add("border-right-style");
                    equivStyleSet.add("border-left-style");
                    equivStyleSet.add("border-bottom-style");
                    break;
                }
                case 5: {
                    equivStyleSet.add("border-left-style");
                    equivStyleSet.add("border-top-style");
                    equivStyleSet.add("border-bottom-style");
                    break;
                }
                case 4: {
                    equivStyleSet.add("border-top-style");
                    equivStyleSet.add("border-bottom-style");
                    break;
                }
                case 3: {
                    equivStyleSet.add("border-top-style");
                    equivStyleSet.add("border-right-style");
                    equivStyleSet.add("border-bottom-style");
                    break;
                }
                case 1: {
                    equivStyleSet.add("border-top-style");
                    equivStyleSet.add("border-left-style");
                }
            }
            return equivStyleSet;
        }

        Set<String> getEquivColorSet(int propertyScore) {
            HashSet<String> equivColorSet = new HashSet<String>();
            switch (propertyScore) {
                case 21: {
                    equivColorSet.add("border-top-color");
                    equivColorSet.add("border-right-color");
                    equivColorSet.add("border-left-color");
                    equivColorSet.add("border-bottom-color");
                    break;
                }
                case 17: {
                    equivColorSet.add("border-top-color");
                    equivColorSet.add("border-right-color");
                    equivColorSet.add("border-left-color");
                    break;
                }
                case 16: {
                    equivColorSet.add("border-right-color");
                    equivColorSet.add("border-left-color");
                    break;
                }
                case 15: {
                    equivColorSet.add("border-right-color");
                    equivColorSet.add("border-left-color");
                    equivColorSet.add("border-bottom-color");
                    break;
                }
                case 5: {
                    equivColorSet.add("border-left-color");
                    equivColorSet.add("border-top-color");
                    equivColorSet.add("border-bottom-color");
                    break;
                }
                case 4: {
                    equivColorSet.add("border-top-color");
                    equivColorSet.add("border-bottom-color");
                    break;
                }
                case 3: {
                    equivColorSet.add("border-top-color");
                    equivColorSet.add("border-right-color");
                    equivColorSet.add("border-bottom-color");
                    break;
                }
                case 1: {
                    equivColorSet.add("border-top-color");
                    equivColorSet.add("border-left-color");
                }
            }
            return equivColorSet;
        }
    }
}

