/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.css.CSSPrimitiveValue;

class BorderImageBuilder
extends ShorthandBuilder {
    private StringBuilder bibuf = new StringBuilder(64);
    private boolean noslice = true;

    BorderImageBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("border-image", parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 5;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        buf.append(this.getShorthandName()).append(':');
        AbstractCSSValue biSource = this.getCSSValue("border-image-source");
        AbstractCSSValue biSlice = this.getCSSValue("border-image-slice");
        AbstractCSSValue biWidth = this.getCSSValue("border-image-width");
        AbstractCSSValue biOutset = this.getCSSValue("border-image-outset");
        AbstractCSSValue biRepeat = this.getCSSValue("border-image-repeat");
        byte inheritcheck = this.checkValuesForInherit(declaredSet, biSource, biSlice, biWidth, biOutset, biRepeat);
        if (inheritcheck == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return true;
        }
        if (inheritcheck == 2) {
            return false;
        }
        if (this.allValuesAreInitial(declaredSet, biSource, biSlice, biWidth, biOutset, biRepeat)) {
            buf.append("none");
            this.appendPriority(buf, important);
            return true;
        }
        byte unsetcheck = this.checkValuesForUnset(declaredSet, biSource, biSlice, biWidth, biOutset, biRepeat);
        if (unsetcheck == 1) {
            buf.append("unset");
            this.appendPriority(buf, important);
            return true;
        }
        if (unsetcheck == 2) {
            return false;
        }
        if (declaredSet.contains("border-image-source")) {
            this.appendBorderImageSource(biSource);
        }
        if (declaredSet.contains("border-image-slice") && !this.appendBorderImageSlice(biSlice)) {
            return false;
        }
        if (declaredSet.contains("border-image-width") && !this.appendBorderImageWidth(biWidth)) {
            return false;
        }
        if (declaredSet.contains("border-image-outset") && !this.appendBorderImageOutset(biOutset)) {
            return false;
        }
        if (declaredSet.contains("border-image-repeat") && !this.appendBorderImageRepeat(biRepeat)) {
            return false;
        }
        if (this.bibuf.length() == 0) {
            this.bibuf.append("none");
        }
        if (important) {
            this.bibuf.append("!important");
        }
        buf.append((CharSequence)this.bibuf).append(';');
        return true;
    }

    private byte checkValuesForInherit(Set<String> declaredSet, AbstractCSSValue biSource, AbstractCSSValue biSlice, AbstractCSSValue biWidth, AbstractCSSValue biOutset, AbstractCSSValue biRepeat) {
        byte ucount = 0;
        byte total = (byte)declaredSet.size();
        if (declaredSet.contains("border-image-source") && this.isInherit(biSource)) {
            ucount = (byte)(ucount + 1);
        }
        if (declaredSet.contains("border-image-slice") && this.isInherit(biSlice)) {
            ucount = (byte)(ucount + 1);
        }
        if (declaredSet.contains("border-image-width") && this.isInherit(biWidth)) {
            ucount = (byte)(ucount + 1);
        }
        if (declaredSet.contains("border-image-outset") && this.isInherit(biOutset)) {
            ucount = (byte)(ucount + 1);
        }
        if (declaredSet.contains("border-image-repeat") && this.isInherit(biRepeat)) {
            ucount = (byte)(ucount + 1);
        }
        if (ucount == 0) {
            return 0;
        }
        if (ucount == total) {
            return 1;
        }
        return 2;
    }

    private boolean allValuesAreInitial(Set<String> declaredSet, AbstractCSSValue biSource, AbstractCSSValue biSlice, AbstractCSSValue biWidth, AbstractCSSValue biOutset, AbstractCSSValue biRepeat) {
        if (declaredSet.contains("border-image-source") && !this.isCssKeywordValue("initial", biSource) && this.isNotInitialValue(biSource, "border-image-source")) {
            return false;
        }
        if (declaredSet.contains("border-image-slice") && !this.isCssKeywordValue("initial", biSlice) && this.isNotInitialValue(biSlice, "border-image-slice")) {
            return false;
        }
        if (declaredSet.contains("border-image-width") && !this.isCssKeywordValue("initial", biWidth) && this.isNotInitialValue(biWidth, "border-image-width")) {
            return false;
        }
        if (declaredSet.contains("border-image-outset") && !this.isCssKeywordValue("initial", biOutset) && this.isNotInitialValue(biOutset, "border-image-outset")) {
            return false;
        }
        return !declaredSet.contains("border-image-repeat") || this.isCssKeywordValue("initial", biRepeat) || !this.isNotInitialValue(biRepeat, "border-image-repeat");
    }

    private byte checkValuesForUnset(Set<String> declaredSet, AbstractCSSValue biSource, AbstractCSSValue biSlice, AbstractCSSValue biWidth, AbstractCSSValue biOutset, AbstractCSSValue biRepeat) {
        byte ucount = 0;
        byte total = (byte)declaredSet.size();
        if (declaredSet.contains("border-image-source") && this.isCssKeywordValue("unset", biSource)) {
            ucount = (byte)(ucount + 1);
        }
        if (declaredSet.contains("border-image-slice") && this.isCssKeywordValue("unset", biSlice)) {
            ucount = (byte)(ucount + 1);
        }
        if (declaredSet.contains("border-image-width") && this.isCssKeywordValue("unset", biWidth)) {
            ucount = (byte)(ucount + 1);
        }
        if (declaredSet.contains("border-image-outset") && this.isCssKeywordValue("unset", biOutset)) {
            ucount = (byte)(ucount + 1);
        }
        if (declaredSet.contains("border-image-repeat") && this.isCssKeywordValue("unset", biRepeat)) {
            ucount = (byte)(ucount + 1);
        }
        if (ucount == 0) {
            return 0;
        }
        if (ucount == total) {
            return 1;
        }
        return 2;
    }

    private boolean appendValueIfNotInitial(String propertyName, AbstractCSSValue cssVal) {
        String text = this.getValueTextIfNotInitial(propertyName, cssVal);
        if (text != null) {
            this.appendText(text);
            return true;
        }
        return false;
    }

    private void appendText(CharSequence text) {
        BorderImageBuilder.appendText(text, this.bibuf);
    }

    private static void appendText(CharSequence text, StringBuilder buf) {
        if (buf.length() != 0) {
            buf.append(' ');
        }
        buf.append(text);
    }

    private void appendBorderImageSource(AbstractCSSValue biSource) {
        if (this.isNotInitialValue(biSource, "border-image-source")) {
            this.appendRelativeURI(this.bibuf, false, biSource);
        }
    }

    private boolean appendBorderImageSlice(AbstractCSSValue value) {
        short type = value.getCssValueType();
        if (type == 1) {
            this.appendBorderImageSide1Value(this.bibuf, "100%", value);
        } else if (type == 2) {
            OMCSSValueList list = (OMCSSValueList)value;
            if (list.isCommaSeparated()) {
                return false;
            }
            boolean fill = false;
            int sides = list.getLength();
            AbstractCSSValue lastval = list.item(sides - 1);
            if (lastval.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)lastval)).getPrimitiveType() == 21) {
                if ("fill".equals(((CSSPrimitiveValue)((Object)lastval)).getStringValue().toLowerCase(Locale.US))) {
                    --sides;
                    fill = true;
                } else {
                    return false;
                }
            }
            if (sides > 4) {
                return false;
            }
            boolean slicesAppended = this.appendBorderImageSides(this.bibuf, "100%", list, sides);
            if (slicesAppended || fill) {
                this.noslice = false;
            }
            if (fill) {
                this.appendText("fill");
            }
        }
        return true;
    }

    private boolean appendBorderImageWidth(AbstractCSSValue value) {
        StringBuilder buf = new StringBuilder();
        short type = value.getCssValueType();
        if (type == 1) {
            this.appendBorderImageSide1Value(buf, "1", value);
        } else if (type == 2) {
            OMCSSValueList list = (OMCSSValueList)value;
            if (list.isCommaSeparated()) {
                return false;
            }
            int sides = list.getLength();
            if (sides > 4) {
                return false;
            }
            this.appendBorderImageSides(buf, "1", list, sides);
        }
        if (buf.length() != 0) {
            if (this.noslice) {
                this.bibuf.append(this.getInitialPropertyValue("border-image-slice").getMinifiedCssText(""));
            }
            this.bibuf.append('/').append((CharSequence)buf);
        }
        return true;
    }

    private boolean appendBorderImageOutset(AbstractCSSValue value) {
        StringBuilder buf = new StringBuilder();
        short type = value.getCssValueType();
        if (type == 1) {
            this.appendBorderImageSide1Value(buf, "0", value);
        } else if (type == 2) {
            OMCSSValueList list = (OMCSSValueList)value;
            if (list.isCommaSeparated()) {
                return false;
            }
            this.appendBorderImageSides(buf, "0", list, list.getLength());
        }
        if (buf.length() != 0) {
            this.bibuf.append('/').append((CharSequence)buf);
        }
        return true;
    }

    private boolean appendBorderImageSides(StringBuilder buf, String initialText, OMCSSValueList list, int sides) {
        switch (sides) {
            case 1: {
                return this.appendBorderImageSide1Value(buf, initialText, list.item(0));
            }
            case 2: {
                return this.appendBorderImageSide2Values(buf, initialText, list.item(0), list.item(1));
            }
            case 3: {
                return this.appendBorderImageSide3Values(buf, initialText, list.item(0), list.item(1), list.item(2));
            }
            case 4: {
                return this.appendBorderImageSide4Values(buf, initialText, list.item(0), list.item(1), list.item(2), list.item(3));
            }
        }
        return false;
    }

    private boolean appendBorderImageSide1Value(StringBuilder buf, String initialText, AbstractCSSValue value) {
        String text = value.getMinifiedCssText("");
        if (!initialText.equals(text)) {
            BorderImageBuilder.appendText(text, buf);
            return true;
        }
        return false;
    }

    private boolean appendBorderImageSide2Values(StringBuilder buf, String initialText, AbstractCSSValue v0, AbstractCSSValue v1) {
        if (v0.equals(v1)) {
            return this.appendBorderImageSide1Value(buf, initialText, v0);
        }
        BorderImageBuilder.appendText(v0.getMinifiedCssText(""), buf);
        buf.append(' ');
        buf.append(v1.getMinifiedCssText(""));
        return true;
    }

    private boolean appendBorderImageSide3Values(StringBuilder buf, String initialText, AbstractCSSValue v0, AbstractCSSValue v1, AbstractCSSValue v2) {
        if (v0.equals(v2)) {
            return this.appendBorderImageSide2Values(buf, initialText, v0, v1);
        }
        BorderImageBuilder.appendText(v0.getMinifiedCssText(""), buf);
        BorderImageBuilder.appendText(v1.getMinifiedCssText(""), buf);
        BorderImageBuilder.appendText(v2.getMinifiedCssText(""), buf);
        return true;
    }

    private boolean appendBorderImageSide4Values(StringBuilder buf, String initialText, AbstractCSSValue v0, AbstractCSSValue v1, AbstractCSSValue v2, AbstractCSSValue v3) {
        if (v1.equals(v3)) {
            return this.appendBorderImageSide3Values(buf, initialText, v0, v1, v2);
        }
        BorderImageBuilder.appendText(v0.getMinifiedCssText(""), buf);
        BorderImageBuilder.appendText(v1.getMinifiedCssText(""), buf);
        BorderImageBuilder.appendText(v2.getMinifiedCssText(""), buf);
        BorderImageBuilder.appendText(v3.getMinifiedCssText(""), buf);
        return true;
    }

    private boolean appendBorderImageRepeat(AbstractCSSValue value) {
        short type = value.getCssValueType();
        if (type == 1) {
            this.appendValueIfNotInitial("border-image-repeat", value);
        } else if (type == 2) {
            AbstractCSSValue v1;
            OMCSSValueList list = (OMCSSValueList)value;
            if (list.isCommaSeparated() || list.getLength() != 2) {
                return false;
            }
            AbstractCSSValue v0 = list.item(0);
            if (v0.equals(v1 = list.item(1))) {
                this.appendValueIfNotInitial("border-image-repeat", v0);
            } else {
                this.appendText(v0.getCssText());
                this.bibuf.append(v1.getCssText());
            }
        }
        return true;
    }
}

