/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import java.util.Set;

class BorderRadiusBuilder
extends ShorthandBuilder {
    BorderRadiusBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("border-radius", parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 4;
    }

    private int sameValueScore(Set<String> declaredSet, AbstractCSSValue topLeftValue, AbstractCSSValue topRightValue, AbstractCSSValue bottomRightValue, AbstractCSSValue bottomLeftValue) {
        int score = 0;
        if (bottomLeftValue.equals(topRightValue)) {
            score += 16;
        } else if (!declaredSet.contains("border-bottom-left-radius")) {
            bottomLeftValue = topRightValue;
            score += 16;
        } else if (!declaredSet.contains("border-top-right-radius")) {
            topRightValue = bottomLeftValue;
            score += 16;
        }
        if (topLeftValue.equals(bottomRightValue)) {
            score += 4;
        } else if (!declaredSet.contains("border-bottom-right-radius")) {
            bottomRightValue = topLeftValue;
            score += 4;
        } else if (!declaredSet.contains("border-top-left-radius")) {
            topLeftValue = bottomRightValue;
            score += 4;
        }
        if (topLeftValue.equals(topRightValue) || !declaredSet.contains("border-bottom-right-radius") && !declaredSet.contains("border-top-left-radius") || !declaredSet.contains("border-top-right-radius") && !declaredSet.contains("border-bottom-left-radius")) {
            ++score;
        }
        return score;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        AbstractCSSValue bottomLeftValue1;
        AbstractCSSValue bottomLeftValue0;
        AbstractCSSValue bottomRightValue1;
        AbstractCSSValue bottomRightValue0;
        AbstractCSSValue topRightValue1;
        AbstractCSSValue topRightValue0;
        AbstractCSSValue topLeftValue1;
        AbstractCSSValue topLeftValue0;
        buf.append(this.getShorthandName()).append(':');
        byte inheritcheck = this.checkDeclaredValuesForInherit(declaredSet);
        if (inheritcheck == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return true;
        }
        if (inheritcheck == 2) {
            return false;
        }
        byte unsetcheck = this.checkDeclaredValuesForKeyword("unset", declaredSet);
        if (unsetcheck == 1) {
            buf.append("unset");
            this.appendPriority(buf, important);
            return true;
        }
        if (unsetcheck == 2) {
            return false;
        }
        AbstractCSSValue topLeftValue = this.getCSSValue("border-top-left-radius");
        AbstractCSSValue topRightValue = this.getCSSValue("border-top-right-radius");
        AbstractCSSValue bottomRightValue = this.getCSSValue("border-bottom-right-radius");
        AbstractCSSValue bottomLeftValue = this.getCSSValue("border-bottom-left-radius");
        boolean slash = false;
        if (topLeftValue != null && topLeftValue.getCssValueType() == 2) {
            topLeftValue0 = ((OMCSSValueList)topLeftValue).item(0);
            topLeftValue1 = ((OMCSSValueList)topLeftValue).item(1);
            slash = true;
        } else {
            topLeftValue0 = topLeftValue;
            topLeftValue1 = null;
        }
        if (topRightValue != null && topRightValue.getCssValueType() == 2) {
            topRightValue0 = ((OMCSSValueList)topRightValue).item(0);
            topRightValue1 = ((OMCSSValueList)topRightValue).item(1);
            slash = true;
        } else {
            topRightValue0 = topRightValue;
            topRightValue1 = null;
        }
        if (bottomRightValue != null && bottomRightValue.getCssValueType() == 2) {
            bottomRightValue0 = ((OMCSSValueList)bottomRightValue).item(0);
            bottomRightValue1 = ((OMCSSValueList)bottomRightValue).item(1);
            slash = true;
        } else {
            bottomRightValue0 = bottomRightValue;
            bottomRightValue1 = null;
        }
        if (bottomLeftValue != null && bottomLeftValue.getCssValueType() == 2) {
            bottomLeftValue0 = ((OMCSSValueList)bottomLeftValue).item(0);
            bottomLeftValue1 = ((OMCSSValueList)bottomLeftValue).item(1);
            slash = true;
        } else {
            bottomLeftValue0 = bottomLeftValue;
            bottomLeftValue1 = null;
        }
        this.appendBorderRadiusSide(buf, declaredSet, topLeftValue0, topRightValue0, bottomRightValue0, bottomLeftValue0, important);
        if (slash) {
            buf.append('/');
            this.appendBorderRadiusSide(buf, declaredSet, topLeftValue1, topRightValue1, bottomRightValue1, bottomLeftValue1, important);
        }
        this.appendPriority(buf, important);
        return true;
    }

    void appendBorderRadiusSide(StringBuilder buf, Set<String> declaredSet, AbstractCSSValue topLeftValue, AbstractCSSValue topRightValue, AbstractCSSValue bottomRightValue, AbstractCSSValue bottomLeftValue, boolean important) {
        switch (this.sameValueScore(declaredSet, topLeftValue, topRightValue, bottomRightValue, bottomLeftValue)) {
            case 21: {
                AbstractCSSValue value = declaredSet.contains("border-top-left-radius") ? topLeftValue : (declaredSet.contains("border-bottom-right-radius") ? bottomRightValue : (declaredSet.contains("border-top-right-radius") ? topRightValue : bottomLeftValue));
                this.appendValue(buf, value);
                break;
            }
            case 20: {
                if (declaredSet.contains("border-top-left-radius")) {
                    this.appendValue(buf, topLeftValue);
                } else if (declaredSet.contains("border-bottom-right-radius")) {
                    this.appendValue(buf, bottomRightValue);
                } else {
                    buf.append('0');
                }
                buf.append(' ');
                if (declaredSet.contains("border-top-right-radius")) {
                    this.appendValue(buf, topRightValue);
                    break;
                }
                if (declaredSet.contains("border-bottom-left-radius")) {
                    this.appendValue(buf, bottomLeftValue);
                    break;
                }
                buf.append('0');
                break;
            }
            case 16: 
            case 17: {
                if (declaredSet.contains("border-top-left-radius")) {
                    this.appendValue(buf, topLeftValue);
                } else {
                    buf.append('0');
                }
                buf.append(' ');
                if (declaredSet.contains("border-top-right-radius")) {
                    this.appendValue(buf, topRightValue);
                } else if (declaredSet.contains("border-bottom-left-radius")) {
                    this.appendValue(buf, bottomLeftValue);
                } else {
                    buf.append('0');
                }
                buf.append(' ');
                if (declaredSet.contains("border-bottom-right-radius")) {
                    this.appendValue(buf, bottomRightValue);
                    break;
                }
                buf.append('0');
                break;
            }
            default: {
                if (declaredSet.contains("border-top-left-radius")) {
                    this.appendValue(buf, topLeftValue);
                } else {
                    buf.append('0');
                }
                buf.append(' ');
                if (declaredSet.contains("border-top-right-radius")) {
                    this.appendValue(buf, topRightValue);
                } else {
                    buf.append('0');
                }
                buf.append(' ');
                if (declaredSet.contains("border-bottom-right-radius")) {
                    this.appendValue(buf, bottomRightValue);
                } else {
                    buf.append('0');
                }
                buf.append(' ');
                if (declaredSet.contains("border-bottom-left-radius")) {
                    this.appendValue(buf, bottomLeftValue);
                    break;
                }
                buf.append('0');
            }
        }
    }

    private void appendValue(StringBuilder buf, AbstractCSSValue cssVal) {
        if (this.isNotInitialValue(cssVal, "border-top-left-radius")) {
            buf.append(cssVal.getMinifiedCssText("border-radius"));
        } else {
            buf.append('0');
        }
    }
}

