/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.ValueFactory;

class BorderRadiusShorthandSetter
extends ShorthandSetter {
    BorderRadiusShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "border-radius");
    }

    @Override
    public boolean assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return true;
        }
        if (kwscan == 2) {
            return false;
        }
        AbstractCSSValue topLeftValue = this.createBorderRadiusValue(null);
        AbstractCSSValue topRightValue = this.createBorderRadiusValue(topLeftValue);
        AbstractCSSValue bottomRightValue = this.createBorderRadiusValue(topLeftValue);
        AbstractCSSValue bottomLeftValue = this.createBorderRadiusValue(topRightValue);
        if (topRightValue == null || bottomRightValue == null || bottomLeftValue == null) {
            return false;
        }
        if (this.currentValue != null) {
            if (this.currentValue.getLexicalUnitType() == 4) {
                this.nextCurrentValue();
                AbstractCSSValue topLeftValue2 = this.createBorderRadiusValue(null);
                AbstractCSSValue topRightValue2 = this.createBorderRadiusValue(topLeftValue2);
                AbstractCSSValue bottomRightValue2 = this.createBorderRadiusValue(topLeftValue2);
                AbstractCSSValue bottomLeftValue2 = this.createBorderRadiusValue(topRightValue2);
                if (topRightValue2 == null || bottomRightValue2 == null || bottomLeftValue2 == null) {
                    return false;
                }
                topLeftValue = this.valuesToList(topLeftValue, topLeftValue2);
                topRightValue = this.valuesToList(topRightValue, topRightValue2);
                bottomRightValue = this.valuesToList(bottomRightValue, bottomRightValue2);
                bottomLeftValue = this.valuesToList(bottomLeftValue, bottomLeftValue2);
            } else {
                return false;
            }
        }
        this.setSubpropertyValue("border-top-left-radius", topLeftValue);
        this.setSubpropertyValue("border-top-right-radius", topRightValue);
        this.setSubpropertyValue("border-bottom-right-radius", bottomRightValue);
        this.setSubpropertyValue("border-bottom-left-radius", bottomLeftValue);
        this.flush();
        return true;
    }

    private AbstractCSSValue valuesToList(AbstractCSSValue value, AbstractCSSValue value2) {
        OMCSSValueList list = OMCSSValueList.createWSValueList();
        list.add(value);
        list.add(value2);
        return list;
    }

    private AbstractCSSValue createBorderRadiusValue(AbstractCSSValue defval) {
        if (this.currentValue == null) {
            return defval;
        }
        if (this.currentValue.getLexicalUnitType() == 4) {
            return defval;
        }
        if (ValueFactory.isSizeSACUnit(this.currentValue)) {
            AbstractCSSValue value = this.createCSSValue(this.getShorthandName(), this.currentValue);
            this.nextCurrentValue();
            return value;
        }
        StyleDeclarationErrorHandler errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
        if (errHandler != null) {
            errHandler.shorthandError(this.getShorthandName(), "Wrong border-radius value: " + this.currentValue.toString());
        }
        return null;
    }
}

