/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DocumentException;
import io.sf.carte.doc.agent.AbstractUserAgent;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.CSSStyleSheetFactory;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.LogErrorHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DOMCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.DOMCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DOMDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.InlineStyle;
import io.sf.carte.doc.style.css.om.StylableDocumentWrapper;
import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSRule;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMCSSStyleSheetFactory
extends BaseCSSStyleSheetFactory {
    private DocumentCSSStyleSheet defStyleSheet = null;
    private DocumentCSSStyleSheet uaStyleSheet = null;
    private EntityResolver resolver = this.createEntityResolver();
    private WrapperUserAgent myUserAgent = null;
    private final ErrorHandler errorHandler = this.createErrorHandler();

    public DOMCSSStyleSheetFactory() {
        this(CSSStyleSheetFactory.ComplianceMode.LENIENT);
    }

    public DOMCSSStyleSheetFactory(CSSStyleSheetFactory.ComplianceMode complianceMode) {
        super(complianceMode);
    }

    @Override
    public DOMDocumentCSSStyleSheet createDocumentStyleSheet(byte origin) {
        return new MyDOMDocumentCSSStyleSheet(null, origin);
    }

    @Override
    public DOMCSSStyleSheet createRuleStyleSheet(AbstractCSSRule ownerRule, String title, MediaQueryList mediaList) {
        return new MyDOMCSSStyleSheet(title, null, mediaList, ownerRule, ownerRule.getOrigin());
    }

    @Override
    public DOMCSSStyleSheet createLinkedStyleSheet(CSSElement ownerNode, String title, MediaQueryList mediaList) {
        Node titleattr;
        if (title == null && ownerNode != null && (titleattr = ownerNode.getAttributes().getNamedItem("title")) != null) {
            title = titleattr.getNodeValue();
        }
        return new MyDOMCSSStyleSheet(title, ownerNode, mediaList, null, 8);
    }

    @Override
    public DocumentCSSStyleSheet getUserAgentStyleSheet() {
        if (this.uaStyleSheet == null) {
            this.uaStyleSheet = this.createDocumentStyleSheet((byte)16);
        }
        return this.uaStyleSheet;
    }

    @Override
    protected DocumentCSSStyleSheet getDefaultStyleSheet() {
        if (this.defStyleSheet == null) {
            this.mergeUserSheets();
        }
        return this.defStyleSheet;
    }

    @Override
    public void setDefaultHTMLUserAgentSheet() {
        try {
            this.setUserAgentStyleSheet(this.htmlDefaultSheet());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read the default style sheet", e);
        }
    }

    private void setUserAgentStyleSheet(DocumentCSSStyleSheet styleSheet) {
        this.uaStyleSheet = styleSheet;
        this.defStyleSheet = null;
    }

    private void mergeUserSheets() {
        this.defStyleSheet = this.getUserAgentStyleSheet().clone();
        if (this.getUserNormalStyleSheet() != null) {
            this.defStyleSheet.addStyleSheet(this.getUserNormalStyleSheet());
        }
    }

    public WrapperUserAgent getUserAgent() {
        if (this.myUserAgent == null) {
            this.myUserAgent = new WrapperUserAgent();
        }
        return this.myUserAgent;
    }

    public StylableDocumentWrapper createCSSDocument(Document document) {
        return new MyStylableDocumentWrapper(document);
    }

    @Override
    public AbstractCSSStyleDeclaration createAnonymousStyleDeclaration(Node node, CSSElement parent) {
        MyDOMCSSStyleDeclaration style = new MyDOMCSSStyleDeclaration();
        style.setOwnerNode(node);
        style.setStyleDatabase(parent.getOwnerDocument().getStyleDatabase());
        return style;
    }

    @Override
    protected InlineStyle createInlineStyle(Node owner) {
        MyInlineStyle style = new MyInlineStyle();
        style.setOwnerNode(owner);
        return style;
    }

    protected EntityResolver createEntityResolver() {
        return new DefaultEntityResolver();
    }

    @Override
    protected ErrorHandler createErrorHandler() {
        return new LogErrorHandler();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    private class MyStylableDocumentWrapper
    extends StylableDocumentWrapper {
        private long loadingTime;

        public MyStylableDocumentWrapper(Document document) {
            super(document);
        }

        @Override
        protected DOMCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public URLConnection openConnection(URL url) throws IOException {
            return DOMCSSStyleSheetFactory.this.getUserAgent().openConnection(url, this.loadingTime);
        }

        @Override
        public void setLoadingTime(long time) {
            this.loadingTime = time;
        }
    }

    public class WrapperUserAgent
    extends AbstractUserAgent {
        DocumentBuilder docbuilder = null;

        WrapperUserAgent() {
        }

        public void setDocumentBuilder(DocumentBuilder docbuilder) {
            this.docbuilder = docbuilder;
            docbuilder.setEntityResolver(DOMCSSStyleSheetFactory.this.resolver);
        }

        @Override
        public CSSDocument readURL(URL url) throws IOException, DocumentException {
            if (this.docbuilder == null) {
                throw new IllegalStateException("Must set a DocumentBuilder first");
            }
            if (this.getOriginPolicy() == null) {
                throw new IllegalStateException("Must set an origin policy first");
            }
            long time = System.currentTimeMillis();
            URLConnection con = this.openConnection(url, time);
            con.connect();
            String conType = con.getContentType();
            InputStream is = null;
            Document xdoc = null;
            try {
                is = con.getInputStream();
                InputSource source = new InputSource(this.inputStreamToReader(is, conType));
                xdoc = this.docbuilder.parse(source);
            }
            catch (IOException e) {
                throw e;
            }
            catch (SAXException e) {
                throw new DocumentException("Error parsing XML document at " + url.toExternalForm(), e);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            xdoc.getDocumentElement().normalize();
            xdoc.setDocumentURI(url.toExternalForm());
            StylableDocumentWrapper wrapper = DOMCSSStyleSheetFactory.this.createCSSDocument(xdoc);
            wrapper.setLoadingTime(time);
            String defStyle = con.getHeaderField("Default-Style");
            NodeList list = xdoc.getElementsByTagName("meta");
            int listL = list.getLength();
            for (int i = listL - 1; i >= 0; --i) {
                String metaDefStyle;
                if (!"Default-Style".equalsIgnoreCase(((Element)list.item(i)).getAttribute("http-equiv")) || (metaDefStyle = ((Element)list.item(i)).getAttribute("content")).length() != 0) continue;
                defStyle = metaDefStyle;
            }
            if (defStyle != null) {
                wrapper.setSelectedStyleSheetSet(defStyle);
            }
            if (con instanceof HttpURLConnection) {
                HttpURLConnection hcon = (HttpURLConnection)con;
                this.readCookies(hcon, time);
                hcon.disconnect();
            }
            return wrapper;
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
            DOMCSSStyleSheetFactory.this.resolver = resolver;
            if (this.docbuilder != null) {
                this.docbuilder.setEntityResolver(resolver);
            }
        }

        @Override
        public URLConnection openConnection(URL url, long creationDate) throws IOException {
            return super.openConnection(url, creationDate);
        }
    }

    class MyDOMCSSStyleSheet
    extends DOMCSSStyleSheet {
        MyDOMCSSStyleSheet(String title, CSSNode ownerNode, MediaQueryList media, CSSRule ownerRule, byte origin) {
            super(title, ownerNode, media, ownerRule, origin);
        }

        @Override
        protected DOMCSSStyleSheet createCSSStyleSheet(String title, CSSNode ownerNode, MediaQueryList media, CSSRule ownerRule, byte origin) {
            return new MyDOMCSSStyleSheet(title, ownerNode, media, ownerRule, origin);
        }

        @Override
        public DOMCSSStyleDeclaration createComputedCSSStyle() {
            return new MyDOMCSSStyleDeclaration();
        }

        @Override
        public DOMCSSStyleDeclaration createComputedCSSStyle(BaseCSSStyleSheet parentSheet) {
            return new MyDOMCSSStyleDeclaration(parentSheet);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }
    }

    private class MyDOMDocumentCSSStyleSheet
    extends DOMDocumentCSSStyleSheet {
        MyDOMDocumentCSSStyleSheet(String medium, byte origin) {
            super(medium, origin);
        }

        @Override
        protected DOMDocumentCSSStyleSheet createDocumentStyleSheet(String medium, byte origin) {
            return new MyDOMDocumentCSSStyleSheet(medium, origin);
        }

        @Override
        public DOMCSSStyleDeclaration createComputedCSSStyle(BaseCSSStyleSheet parentSheet) {
            return new MyDOMCSSStyleDeclaration(parentSheet);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }
    }

    class MyDOMCSSStyleDeclaration
    extends DOMCSSStyleDeclaration {
        public MyDOMCSSStyleDeclaration() {
        }

        public MyDOMCSSStyleDeclaration(BaseCSSStyleSheet parentSheet) {
            super(parentSheet);
        }

        public MyDOMCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
            super(copiedObject);
        }

        @Override
        protected CSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public ComputedCSSStyle clone() {
            MyDOMCSSStyleDeclaration styleClone = new MyDOMCSSStyleDeclaration(this);
            styleClone.setOwnerNode(this.getOwnerNode());
            return styleClone;
        }
    }

    class MyInlineStyle
    extends InlineStyle {
        public MyInlineStyle() {
        }

        public MyInlineStyle(InlineStyle copiedObject) {
            super(copiedObject);
        }

        @Override
        protected void setOwnerNode(Node node) {
            super.setOwnerNode(node);
        }

        @Override
        public boolean hasOverrideStyle(String pseudoElt) {
            Node node = this.getOwnerNode();
            if (node != null) {
                return ((StylableDocumentWrapper.MyElement)node).hasOverrideStyle(pseudoElt);
            }
            return false;
        }

        @Override
        protected CSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public InlineStyle clone() {
            MyInlineStyle styleClone = new MyInlineStyle(this);
            styleClone.setOwnerNode(this.getOwnerNode());
            return styleClone;
        }
    }
}

