/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.Node;

public class DefaultStyleDeclarationErrorHandler
implements StyleDeclarationErrorHandler {
    private List<String> malformedURIs = null;
    private List<String> noDefault = null;
    private LinkedHashMap<String, String> seShorthands = null;
    private List<String> unassigned = null;
    private List<String> wrongCount = null;
    private List<String> missingReq = null;
    private List<Node> noContainer = null;
    private Map<String, String> unknownIdent = null;
    private Map<String, String> wrongValue = null;
    private LinkedList<String> valueWarnings = null;
    private Map<String, String> unassignedValue = null;
    private List<Short> sacWarnings = null;
    private List<Short> sacErrors = null;
    private List<Short> sacFatalErrors = null;

    @Override
    public void malformedURIValue(String uri) {
        if (this.malformedURIs == null) {
            this.malformedURIs = new LinkedList<String>();
        }
        this.malformedURIs.add(uri);
    }

    @Override
    public void shorthandError(String shorthandName, String message) {
        if (this.seShorthands == null) {
            this.seShorthands = new LinkedHashMap();
        }
        this.seShorthands.put(shorthandName, message);
    }

    @Override
    public void shorthandSyntaxError(String shorthandName, String message) {
        this.shorthandError(shorthandName, message);
    }

    @Override
    public void shorthandWarning(String shorthandName, String valueText) {
        this.shorthandError(shorthandName, "Unsafe shorthand value: " + valueText);
    }

    @Override
    public void unassignedShorthandValues(String shorthandName, String[] unassignedProperties, LexicalUnit[] unassignedValues) {
        if (this.unassigned == null) {
            this.unassigned = new LinkedList<String>();
        }
        for (int i = 0; i < unassignedValues.length; ++i) {
            LexicalUnit lu = unassignedValues[i];
            this.unassigned.add(lu.toString());
        }
    }

    @Override
    public void wrongSubpropertyCount(String shorthandName, int count) {
        if (this.wrongCount == null) {
            this.wrongCount = new LinkedList<String>();
        }
        this.wrongCount.add(shorthandName);
    }

    @Override
    public void unknownIdentifier(String propertyName, String ident) {
        if (this.unknownIdent == null) {
            this.unknownIdent = new HashMap<String, String>();
        }
        this.unknownIdent.put(propertyName, ident);
    }

    @Override
    public void missingRequiredProperty(String propertyName) {
        if (this.missingReq == null) {
            this.missingReq = new LinkedList<String>();
        }
        this.missingReq.add(propertyName);
    }

    @Override
    public void wrongValue(String propertyName, CSSPropertyValueException e) {
        if (this.wrongValue == null) {
            this.wrongValue = new HashMap<String, String>();
        }
        this.wrongValue.put(propertyName, e.getValueText());
    }

    @Override
    public void syntaxWarning(String message) {
        if (this.valueWarnings == null) {
            this.valueWarnings = new LinkedList();
        }
        this.valueWarnings.add(message);
    }

    @Override
    public void noContainingBlock(String containedNode, Node ownerNode) {
        if (this.noContainer == null) {
            this.noContainer = new LinkedList<Node>();
        }
        this.noContainer.add(ownerNode);
    }

    @Override
    public void unassignedShorthandValue(String shorthandName, String valueCss) {
        if (this.unassignedValue == null) {
            this.unassignedValue = new HashMap<String, String>();
        }
        this.unassignedValue.put(shorthandName, valueCss);
    }

    @Override
    public boolean hasErrors() {
        return this.malformedURIs != null || this.noDefault != null || this.seShorthands != null || this.wrongCount != null || this.missingReq != null || this.unknownIdent != null || this.wrongValue != null || this.unassignedValue != null || this.sacErrors != null || this.sacFatalErrors != null;
    }

    @Override
    public boolean hasWarnings() {
        return this.sacWarnings != null || this.valueWarnings != null;
    }

    public List<String> getMalformedURIs() {
        return this.malformedURIs;
    }

    public List<String> getPropertiesWithoutDefault() {
        return this.noDefault;
    }

    public Map<String, String> getShorthandsWithErrors() {
        return this.seShorthands;
    }

    public List<String> getUnassignedSubproperties() {
        return this.unassigned;
    }

    public List<String> getWrongSubpropertyCount() {
        return this.wrongCount;
    }

    public List<String> getMissingRequiredValues() {
        return this.missingReq;
    }

    public Map<String, String> getUnknownIdentifiers() {
        return this.unknownIdent;
    }

    public Map<String, String> getWrongValues() {
        return this.wrongValue;
    }

    public List<Node> getNoContainingBlock() {
        return this.noContainer;
    }

    public Map<String, String> getUnassignedValues() {
        return this.unassignedValue;
    }

    @Override
    public void reset() {
        this.malformedURIs = null;
        this.noDefault = null;
        this.seShorthands = null;
        this.unassigned = null;
        this.wrongCount = null;
        this.missingReq = null;
        this.unknownIdent = null;
        this.wrongValue = null;
        this.noContainer = null;
        this.unassignedValue = null;
        this.sacWarnings = null;
        this.sacErrors = null;
        this.sacFatalErrors = null;
    }

    @Override
    public void sacWarning(CSSParseException exception, int previousIndex) {
        if (this.sacWarnings == null) {
            this.sacWarnings = new LinkedList<Short>();
        }
        switch (exception.getCode()) {
            case 1: {
                this.sacWarnings.add((short)1);
                break;
            }
            case 2: {
                this.sacWarnings.add((short)2);
                break;
            }
            default: {
                this.sacWarnings.add((short)0);
            }
        }
    }

    @Override
    public void sacError(CSSParseException exception, int previousIndex) {
        if (this.sacErrors == null) {
            this.sacErrors = new LinkedList<Short>();
        }
        switch (exception.getCode()) {
            case 1: {
                this.sacErrors.add((short)1);
                break;
            }
            case 2: {
                this.sacErrors.add((short)2);
                break;
            }
            default: {
                this.sacErrors.add((short)0);
            }
        }
    }

    @Override
    public void sacFatalError(CSSParseException exception, int previousIndex) {
        if (this.sacFatalErrors == null) {
            this.sacFatalErrors = new LinkedList<Short>();
        }
        switch (exception.getCode()) {
            case 1: {
                this.sacFatalErrors.add((short)1);
                break;
            }
            case 2: {
                this.sacFatalErrors.add((short)2);
                break;
            }
            default: {
                this.sacFatalErrors.add((short)0);
            }
        }
    }

    public List<Short> getSACWarnings() {
        return this.sacWarnings;
    }

    public List<Short> getSACErrors() {
        return this.sacErrors;
    }

    public List<Short> getSACFatalErrors() {
        return this.sacFatalErrors;
    }

    public String toString() {
        Iterator<Object> it;
        StringBuilder buf = null;
        if (this.hasErrors()) {
            buf = new StringBuilder(256);
            if (this.malformedURIs != null && !this.malformedURIs.isEmpty()) {
                buf.append("Malformed URIs:");
                it = this.malformedURIs.iterator();
                while (it.hasNext()) {
                    buf.append(' ').append(it.next());
                }
                buf.append('\n');
            }
            if (this.noDefault != null && !this.noDefault.isEmpty()) {
                buf.append("Properties without default:");
                it = this.noDefault.iterator();
                while (it.hasNext()) {
                    buf.append(' ').append((String)it.next());
                }
                buf.append('\n');
            }
            if (this.seShorthands != null && !this.seShorthands.isEmpty()) {
                buf.append("Shorthands with syntax error:");
                for (Map.Entry entry : this.seShorthands.entrySet()) {
                    buf.append(' ').append((String)entry.getKey()).append(" (").append((String)entry.getValue()).append(')');
                }
                buf.append('\n');
            }
            if (this.wrongCount != null && !this.wrongCount.isEmpty()) {
                buf.append("Wrong subproperty count:");
                it = this.wrongCount.iterator();
                while (it.hasNext()) {
                    buf.append(' ').append((String)it.next());
                }
                buf.append('\n');
            }
            if (this.missingReq != null && !this.missingReq.isEmpty()) {
                buf.append("Missing required value(s) for property:");
                it = this.missingReq.iterator();
                while (it.hasNext()) {
                    buf.append(' ').append((String)it.next());
                }
                buf.append('\n');
            }
            if (this.unknownIdent != null && !this.unknownIdent.isEmpty()) {
                buf.append("Unknown identifiers:");
                for (Map.Entry entry : this.unknownIdent.entrySet()) {
                    buf.append(' ').append((String)entry.getKey()).append(':').append(' ').append((String)entry.getValue());
                }
                buf.append('\n');
            }
            if (this.wrongValue != null && !this.wrongValue.isEmpty()) {
                buf.append("Wrong values:");
                for (Map.Entry entry : this.wrongValue.entrySet()) {
                    buf.append(' ').append((String)entry.getKey()).append(':').append(' ').append((String)entry.getValue());
                }
                buf.append('\n');
            }
            if (this.noContainer != null && !this.noContainer.isEmpty()) {
                buf.append("There were ").append(this.noContainer.size()).append(" nodes without containing block.\n");
            }
            if (this.unassignedValue != null) {
                buf.append("Shorthands with unassigned values:\n");
                for (Map.Entry entry : this.unassignedValue.entrySet()) {
                    buf.append(' ').append((String)entry.getKey()).append(':').append(' ').append((String)entry.getValue());
                }
                buf.append('\n');
            }
            if (this.sacErrors != null) {
                buf.append("There were ").append(this.sacErrors.size()).append(" SAC errors.\n");
            }
            if (this.sacFatalErrors != null) {
                buf.append("There were ").append(this.sacFatalErrors.size()).append(" SAC fatal errors.\n");
            }
        }
        if (this.hasWarnings()) {
            if (buf == null) {
                buf = new StringBuilder(80);
            }
            if (this.sacWarnings != null) {
                buf.append("There were ").append(this.sacWarnings.size()).append(" SAC warnings.\n");
            }
            if (this.valueWarnings != null) {
                buf.append("There were ").append(this.valueWarnings.size()).append(" value warnings:\n");
                it = this.valueWarnings.iterator();
                while (it.hasNext()) {
                    buf.append("- ").append((String)it.next()).append('\n');
                }
            }
        } else if (buf == null) {
            return "No errors";
        }
        return buf.toString();
    }
}

