/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import java.util.Locale;
import java.util.Set;

class GenericShorthandBuilder
extends ShorthandBuilder {
    final String initialvalue;
    final PropertyDatabase pdb = PropertyDatabase.getInstance();

    GenericShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle, String initialvalue) {
        super(shorthandName, parentStyle);
        this.initialvalue = initialvalue;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        check = this.checkValuesForKeyword("unset", declaredSet);
        if (check == 1) {
            buf.append("unset");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        boolean appended = false;
        String[] subp = this.getLonghandProperties();
        for (int i = 0; i < subp.length; ++i) {
            String property = subp[i];
            if (!declaredSet.contains(property)) continue;
            AbstractCSSValue cssVal = this.getCSSValue(property);
            if (cssVal.getCssValueType() == 2 && ((OMCSSValueList)cssVal).isCommaSeparated() || this.invalidValueClash(declaredSet, property, cssVal)) {
                return false;
            }
            appended = this.appendValueText(buf, property, appended);
        }
        if (!appended) {
            buf.append(this.initialvalue);
        }
        this.appendPriority(buf, important);
        return true;
    }

    boolean invalidValueClash(Set<String> declaredSet, String property, AbstractCSSValue cssVal) {
        if (cssVal.getCssValueType() == 2) {
            OMCSSValueList list = (OMCSSValueList)cssVal;
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                if (!this.invalidValueClash(declaredSet, property, list.item(i))) continue;
                return true;
            }
        } else {
            if (cssVal.getCssValueType() == 1) {
                return this.invalidPrimitiveValueClash(declaredSet, property, (AbstractCSSPrimitiveValue)cssVal);
            }
            return true;
        }
        return false;
    }

    boolean invalidPrimitiveValueClash(Set<String> declaredSet, String propertyName, AbstractCSSPrimitiveValue primi) {
        String ident;
        if (primi.getPrimitiveType() == 21 && !this.pdb.isIdentifierValue(propertyName, ident = primi.getStringValue().toLowerCase(Locale.US))) {
            for (String property : declaredSet) {
                if (!this.pdb.hasKnownIdentifierValues(property) || !this.pdb.isIdentifierValue(property, ident)) continue;
                return true;
            }
        }
        return false;
    }

    boolean appendValueText(StringBuilder buf, String property, boolean appended) {
        return this.appendValueIfNotInitial(buf, property, appended);
    }
}

