/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import java.util.Set;
import org.w3c.dom.css.CSSPrimitiveValue;

class GridPlacementShorthandBuilder
extends ShorthandBuilder {
    GridPlacementShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle) {
        super(shorthandName, parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 2;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        check = this.checkValuesForKeyword("unset", declaredSet);
        if (check == 1) {
            buf.append("unset");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        String[] subp = this.getSubproperties();
        AbstractCSSValue cssVal1 = this.getCSSValue(subp[0]);
        if (cssVal1.getCssValueType() == 2 && ((OMCSSValueList)cssVal1).isCommaSeparated()) {
            return false;
        }
        this.appendValueText(buf, cssVal1);
        for (int i = 1; i < subp.length; ++i) {
            AbstractCSSValue cssVal = this.getCSSValue(subp[i]);
            if (this.isIdentifier(cssVal) && this.valueEquals(cssVal1, cssVal) || !this.isNotInitialValue(cssVal, subp[i])) continue;
            buf.append('/');
            this.appendValueText(buf, cssVal);
            cssVal1 = cssVal;
        }
        this.appendPriority(buf, important);
        return true;
    }

    @Override
    protected boolean isNotInitialValue(AbstractCSSValue cssVal, String propertyName) {
        return cssVal != null && !GridPlacementShorthandBuilder.isInitialIdentifier(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    private void appendValueText(StringBuilder buf, AbstractCSSValue cssVal) {
        buf.append(cssVal.getMinifiedCssText(this.getShorthandName()));
    }

    private boolean isIdentifier(AbstractCSSValue cssVal) {
        return cssVal.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)cssVal)).getPrimitiveType() == 21;
    }
}

