/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSMarginRule;
import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPageRule;

public class OMCSSPageRule
extends CSSStyleDeclarationRule
implements CSSPageRule,
ExtendedCSSRule {
    LinkedList<CSSMarginRule> marginRules = null;

    public OMCSSPageRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)6, origin);
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(30 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("@page");
        if (this.getSelectorText().length() > 0) {
            buf.append(' ').append(this.getSelectorText());
        }
        String styleText = this.getStyle().getMinifiedCssText();
        buf.append('{').append(styleText);
        if (this.marginRules != null) {
            if (styleText.length() != 0) {
                buf.append(';');
            }
            Iterator it = this.marginRules.iterator();
            while (it.hasNext()) {
                buf.append(((ExtendedCSSRule)it.next()).getMinifiedCssText());
            }
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        context.startRule(wri);
        wri.write("@page");
        if (this.getSelectorText().length() != 0) {
            wri.write(' ');
            wri.write(this.getSelectorText());
        }
        context.updateContext(this);
        context.writeLeftCurlyBracket(wri);
        context.startStyleDeclaration(wri);
        this.getStyle().writeCssText(wri, context);
        context.endCurrentContext(this);
        context.endStyleDeclaration(wri);
        if (this.marginRules != null) {
            context.updateContext(this);
            for (ExtendedCSSRule extendedCSSRule : this.marginRules) {
                extendedCSSRule.writeCssText(wri, context);
            }
            context.endCurrentContext(this);
            context.endRuleList(wri);
        }
        context.writeRightCurlyBracket(wri);
        context.endRule(wri);
    }

    @Override
    public String getSelectorText() {
        return super.getSelectorText();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        cssText = cssText.trim();
        int len = cssText.length();
        int idx = cssText.indexOf(123);
        if (len < 10 || idx == -1) {
            throw new DOMException(12, "Invalid @page rule: " + cssText);
        }
        if (!ParseHelper.startsWithIgnoreCase(cssText, "@page")) {
            throw new DOMException(12, "Not a @page rule: " + cssText);
        }
        String body = cssText.substring(5, len);
        super.setCssText(body);
    }

    void addMarginRule(CSSMarginRule marginRule) {
        if (this.marginRules == null) {
            this.marginRules = new LinkedList();
        }
        this.marginRules.add(marginRule);
    }

    public LinkedList<CSSMarginRule> getMarginRules() {
        return this.marginRules;
    }

    @Override
    public OMCSSPageRule clone(AbstractCSSStyleSheet parentSheet) {
        return (OMCSSPageRule)super.clone(parentSheet);
    }
}

