/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.SupportsCondition;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.Parser2;
import io.sf.carte.doc.style.css.parser.AnBExpression;
import io.sf.carte.doc.style.css.parser.FontFeatureValuesHandler;
import io.sf.carte.doc.style.css.parser.KeyframesHandler;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.NSACSelectorFactory;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.SupportsConditionImpl;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.TokenProducer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;

public class CSSParser
implements Parser2 {
    DocumentHandler handler = null;
    ErrorHandler errorHandler = null;
    private final EnumSet<Parser2.Flag> parserFlags = EnumSet.noneOf(Parser2.Flag.class);

    public void setLocale(Locale locale) throws CSSException {
        if (!Locale.US.equals(locale)) {
            throw new CSSException("Locale not supported");
        }
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.handler = handler;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        throw new IllegalArgumentException();
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        throw new IllegalArgumentException();
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void setFlag(Parser2.Flag flag) {
        this.parserFlags.add(flag);
    }

    @Override
    public void unsetFlag(Parser2.Flag flag) {
        this.parserFlags.remove((Object)flag);
    }

    public void parseStyleSheet(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        String[] opening = new String[]{"/*", "<!--"};
        String[] closing = new String[]{"*/", "-->"};
        SheetTokenHandler handler = new SheetTokenHandler(source, null);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.setAcceptEofEndingQuoted(true);
        Reader re = source.getCharacterStream();
        if (re == null) {
            throw new IllegalArgumentException("Null character stream");
        }
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        this.handler.startDocument(source);
        tp.parseMultiComment(re, opening, closing);
    }

    public void parseStyleSheet(String uri) throws CSSException, IOException {
        PushbackReader re;
        int iread;
        int idx;
        URL url = new URL(uri);
        URLConnection ucon = url.openConnection();
        ucon.connect();
        InputStream is = ucon.getInputStream();
        String charset = null;
        String conType = ucon.getContentType();
        if (conType == null) {
            try {
                conType = URLConnection.guessContentTypeFromStream(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (conType != null && (idx = conType.indexOf("charset=")) >= 0) {
            charset = conType.substring(idx + 8).replace('\"', ' ').replace('\'', ' ').trim().toUpperCase(Locale.US);
        }
        if ((iread = (re = charset != null ? new PushbackReader(new InputStreamReader(is, charset), 1) : new PushbackReader(new InputStreamReader(is, "UTF-8"), 1)).read()) != -1 && iread == 0xEFBBBF) {
            charset = "UTF-8";
        } else {
            re.unread(iread);
        }
        InputSource source = new InputSource((Reader)re);
        source.setURI(uri);
        SheetTokenHandler handler = new SheetTokenHandler(source, null);
        int[] allowInWords = new int[]{45, 95};
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.setAcceptEofEndingQuoted(true);
        this.handler.startDocument(source);
        tp.parse(re, "/*", "*/");
        re.close();
    }

    public void parseStyleDeclaration(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        DeclarationTokenHandler handler = new DeclarationTokenHandler(source);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(source.getCharacterStream(), "/*", "*/");
    }

    public void parseRule(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleTokenHandler handler = new RuleTokenHandler(source, null);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        Reader re = source.getCharacterStream();
        if (re == null) {
            throw new IllegalArgumentException("Null character stream");
        }
        tp.parse(re, "/*", "*/");
    }

    @Override
    public void parseRule(InputSource source, Parser2.NamespaceMap nsmap) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleTokenHandler handler = new RuleTokenHandler(source, nsmap);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        Reader re = source.getCharacterStream();
        if (re == null) {
            throw new IllegalArgumentException("Null character stream");
        }
        tp.parse(re, "/*", "*/");
    }

    public void parseKeyFramesBody(String blockList) {
        int[] allowInWords = new int[]{45, 95};
        KeyFrameBlockListTH handler = new KeyFrameBlockListTH(0, blockList.length());
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(blockList, "/*", "*/");
    }

    public void parseFontFeatureValuesBody(String blockList) {
        int[] allowInWords = new int[]{45, 95};
        FontFeatureValuesTH handler = new FontFeatureValuesTH(0, blockList.length());
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(blockList, "/*", "*/");
    }

    public SupportsCondition parseSupportsCondition(String conditionText, ExtendedCSSRule rule) throws CSSParseException {
        int[] allowInWords = new int[]{45, 46};
        SupportsTokenHandler handler = new SupportsTokenHandler();
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(conditionText, "/*", "*/");
        if (handler.errorCode == 0) {
            SupportsCondition condition = handler.currentCond;
            while (condition.getParentCondition() != null) {
                condition = condition.getParentCondition();
            }
            return condition;
        }
        if (rule == null) {
            throw handler.errorException;
        }
        rule.getParentStyleSheet().getErrorHandler().ruleParsingError(rule, handler.errorException);
        return null;
    }

    public String getParserVersion() {
        return "http://www.w3.org/TR/REC-CSS2";
    }

    public SelectorList parseSelectors(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        SelectorTokenHandler handler = new SelectorTokenHandler(source, null);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(source.getCharacterStream(), "/*", "*/");
        return handler.getSelectorList();
    }

    public SelectorList parseSelectors(String seltext) throws CSSException {
        int[] allowInWords = new int[]{45, 95};
        SelectorTokenHandler handler = new SelectorTokenHandler();
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(seltext, "/*", "*/");
        return handler.getSelectorList();
    }

    private SelectorList parseSelectors(String seltext, NSACSelectorFactory factory) throws CSSException {
        int[] allowInWords = new int[]{45, 95};
        SelectorTokenHandler handler = new SelectorTokenHandler(factory);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(seltext, "/*", "*/");
        return handler.getSelectorList();
    }

    public LexicalUnit parsePropertyValue(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        PropertyTokenHandler handler = new PropertyTokenHandler(source);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(source.getCharacterStream(), "/*", "*/");
        return handler.getLexicalUnit();
    }

    public boolean parsePriority(InputSource source) throws CSSException, IOException {
        Reader re = source.getCharacterStream();
        int cp = re.read();
        if (cp != -1) {
            int count = 0;
            StringBuilder buf = new StringBuilder(9);
            int parsingWord = 0;
            if (CSSParser.isNotSeparator(cp)) {
                buf.append(Character.toChars(cp));
                parsingWord = 1;
                count = 1;
            }
            while ((cp = re.read()) != -1 && parsingWord != 2) {
                if (CSSParser.isNotSeparator(cp)) {
                    buf.append(Character.toChars(cp));
                    count = (short)(count + 1);
                    if (count == 10) {
                        return false;
                    }
                    parsingWord = 1;
                    continue;
                }
                if (parsingWord != 1) continue;
                parsingWord = 2;
            }
            if ("important".equals(buf.toString().toLowerCase(Locale.US))) {
                return true;
            }
        }
        return false;
    }

    public static boolean bufferEndsWithEscapedChar(StringBuilder buffer) {
        int bufCp;
        int len = buffer.length();
        if (len != 0 && CSSParser.isHexCodePoint(bufCp = buffer.codePointAt(len - 1))) {
            for (int i = 2; i <= 6; ++i) {
                bufCp = buffer.codePointAt(len - i);
                if (CSSParser.isHexCodePoint(bufCp)) continue;
                if (bufCp != 92) break;
                return true;
            }
        }
        return false;
    }

    static boolean isHexCodePoint(int codePoint) {
        return codePoint >= 48 && codePoint <= 57 || codePoint >= 65 && codePoint <= 70 || codePoint >= 97 && codePoint <= 102;
    }

    private static boolean isNotSeparator(int cp) {
        return cp != 32 && cp != 9 && cp != 10 && cp != 12 && cp != 13;
    }

    static SACMediaList parseMediaList(String media) {
        return new MySACMediaList(media.split(","));
    }

    static class LocatorImpl
    implements Locator {
        int line;
        int column;
        String uri;

        LocatorImpl(int line, int column, String uri) {
            this.line = line;
            this.column = column;
            this.uri = uri;
        }

        public String getURI() {
            return this.uri;
        }

        public int getLineNumber() {
            return this.line;
        }

        public int getColumnNumber() {
            return this.column;
        }
    }

    abstract class CSSTokenHandler
    implements TokenProducer.TokenHandler {
        int line = 1;
        int prevlinelength = 0;
        int prevcp = 32;
        int endcp = -1;
        short parendepth = 0;
        boolean parseError = false;
        private InputSource source;

        CSSTokenHandler(InputSource source) {
            this.source = source;
        }

        @Override
        public void tokenControl(TokenProducer.TokenControl control) {
        }

        @Override
        public void control(int index, int codepoint) {
            if (codepoint == 10) {
                this.separator(index, codepoint);
                if (this.prevcp != 13) {
                    ++this.line;
                    this.prevlinelength = index;
                }
            } else if (codepoint == 12) {
                this.separator(index, codepoint);
                ++this.line;
                this.prevlinelength = index;
            } else if (codepoint == 13) {
                ++this.line;
                this.prevlinelength = index;
                this.prevcp = codepoint;
            } else if (codepoint == 9) {
                this.separator(index, codepoint);
            }
        }

        @Override
        public void quotedNewlineChar(int index, int codepoint) {
            if (codepoint == 10) {
                if (this.prevcp != 13) {
                    ++this.line;
                    this.prevlinelength = index;
                }
            } else if (codepoint == 12) {
                ++this.line;
                this.prevlinelength = index;
            } else if (codepoint == 13) {
                ++this.line;
                this.prevlinelength = index;
                this.prevcp = codepoint;
            }
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (commentType == 0) {
                CSSParser.this.handler.comment(comment);
            }
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            this.handleError(index, errCode, "Syntax error near " + context);
        }

        protected void handleError(int index, byte errCode, String message) {
            if (!this.parseError) {
                if (CSSParser.this.errorHandler != null) {
                    if (this.prevcp == this.endcp) {
                        CSSParser.this.errorHandler.fatalError(this.createException(index, errCode, "Expected end of file"));
                    } else {
                        CSSParser.this.errorHandler.error(this.createException(index, errCode, message));
                    }
                }
                this.parseError = true;
            }
        }

        protected void unexpectedCharError(int index, int codepoint) {
            this.handleError(index, (byte)4, "Unexpected '" + new String(Character.toChars(codepoint)) + "'");
        }

        protected String getSourceURI() {
            if (this.source != null) {
                return this.source.getURI();
            }
            return null;
        }

        CSSParseException createException(int index, byte errCode, String message) {
            LocatorImpl locator = new LocatorImpl(this.line, index - this.prevlinelength, this.getSourceURI());
            if (errCode == 15) {
                return new CSSNamespaceParseException(message, locator);
            }
            return new CSSParseException(message, (Locator)locator);
        }

        void endDocument() {
            if (CSSParser.this.handler != null) {
                CSSParser.this.handler.endDocument(this.source);
            }
        }
    }

    class DeclarationTokenHandler
    extends CSSTokenHandler {
        private LexicalUnitImpl lunit;
        private LexicalUnitImpl currentlu;
        StringBuilder buffer;
        private boolean escapedToken;
        String propertyName;
        private boolean hexColor;
        private boolean readPriority;
        boolean priorityImportant;
        private int curlyBracketDepth;
        private int squareBracketDepth;
        boolean functionToken;

        DeclarationTokenHandler(InputSource source) {
            super(source);
            this.lunit = null;
            this.currentlu = null;
            this.buffer = new StringBuilder(128);
            this.escapedToken = false;
            this.propertyName = null;
            this.hexColor = false;
            this.readPriority = false;
            this.priorityImportant = false;
            this.curlyBracketDepth = 1;
            this.functionToken = false;
        }

        LexicalUnit getLexicalUnit() {
            return this.parseError ? null : this.lunit;
        }

        @Override
        public void word(int index, String word) {
            if (!this.parseError) {
                String lctoken = word.toLowerCase(Locale.US);
                if ("inherit".equals(lctoken)) {
                    LexicalUnitImpl lu = this.newLexicalUnit((short)12);
                    lu.value = "inherit";
                } else if (this.readPriority && "important".equals(lctoken)) {
                    this.priorityImportant = true;
                } else {
                    this.buffer.append(word);
                }
            }
            this.prevcp = 65;
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (codepoint == 40) {
                this.parendepth = (short)(this.parendepth + 1);
                if (!this.parseError) {
                    if (this.prevcp != 65) {
                        if (!this.functionToken) {
                            this.unexpectedCharError(index, codepoint);
                            this.prevcp = codepoint;
                        } else if (this.buffer.length() == 0) {
                            this.newLexicalUnit((short)40);
                        } else {
                            this.handleError(index, (byte)9, "Unexpected token: " + this.buffer.toString());
                            this.buffer.setLength(0);
                        }
                    } else {
                        String name = this.unescapeBuffer();
                        LexicalUnitImpl lu = "url".equals(name) ? this.newLexicalUnit((short)24) : ("rgb".equals(name) ? this.newLexicalUnit((short)27) : ("attr".equals(name) ? this.newLexicalUnit((short)37) : ("rect".equals(name) ? this.newLexicalUnit((short)38) : ("counter".equals(name) ? this.newLexicalUnit((short)25) : ("counters".equals(name) ? this.newLexicalUnit((short)26) : this.newLexicalUnit((short)41))))));
                        lu.value = name;
                        this.functionToken = true;
                    }
                }
            } else if (codepoint == 123) {
                ++this.curlyBracketDepth;
                this.unexpectedCharError(index, codepoint);
            } else if (codepoint == 91) {
                ++this.squareBracketDepth;
                if (!this.parseError) {
                    if (this.propertyName != null) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)68);
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                }
            }
            this.prevcp = codepoint;
        }

        private LexicalUnitImpl newLexicalUnit(short unitType) {
            LexicalUnitImpl lu;
            if (this.functionToken) {
                if (this.currentlu.getLexicalUnitType() == 24) {
                    lu = this.currentlu;
                } else {
                    lu = new LexicalUnitImpl(unitType);
                    this.currentlu.addFunctionParameter(lu);
                    if (ParseHelper.isFunctionUnitType(unitType) || unitType == 40) {
                        this.currentlu = lu;
                    }
                }
            } else {
                lu = new LexicalUnitImpl(unitType);
                if (this.currentlu != null) {
                    this.currentlu.nextLexicalUnit = lu;
                    lu.previousLexicalUnit = this.currentlu;
                }
                this.currentlu = lu;
                if (this.lunit == null) {
                    this.lunit = lu;
                }
            }
            return lu;
        }

        @Override
        public void closeGroup(int index, int codepoint) {
            if (codepoint == 41) {
                this.processBuffer(index);
                this.parendepth = (short)(this.parendepth - 1);
                if (this.functionToken) {
                    if (this.currentlu.ownerLexicalUnit != null) {
                        this.currentlu = this.currentlu.ownerLexicalUnit;
                    } else {
                        this.functionToken = false;
                    }
                }
            } else if (codepoint == 125) {
                --this.curlyBracketDepth;
                if (this.parendepth == 0 && this.squareBracketDepth == 0) {
                    if (this.curlyBracketDepth == 0) {
                        this.endOfPropertyDeclaration(index);
                        this.handleRightCurlyBracket(index);
                    } else if (this.curlyBracketDepth == 1) {
                        this.buffer.setLength(0);
                        this.parseError = false;
                    } else {
                        this.parseError = true;
                    }
                }
            } else if (codepoint == 93) {
                --this.squareBracketDepth;
                if (!this.parseError) {
                    if (this.propertyName != null) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)69);
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                }
            }
            this.prevcp = codepoint;
        }

        protected void handleRightCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '}'");
        }

        @Override
        public void character(int index, int codepoint) {
            if (this.functionToken && this.currentlu != null && this.currentlu.getLexicalUnitType() == 24) {
                this.buffer.append(Character.toChars(codepoint));
            } else if (codepoint == 59) {
                this.handleSemicolon(index);
            } else if (!this.parseError) {
                if (codepoint == 58) {
                    this.handleColon(index);
                } else if (codepoint == 64) {
                    this.handleAtKeyword(index);
                } else if (codepoint == 45) {
                    if (this.functionToken) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)2);
                    } else {
                        this.buffer.append('-');
                        codepoint = 65;
                    }
                } else if (codepoint == 95) {
                    this.buffer.append('_');
                    codepoint = 65;
                } else {
                    if (this.propertyName == null) {
                        this.badPropertyName(index, codepoint);
                        return;
                    }
                    if (codepoint == 44) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)0);
                    } else if (codepoint == 46) {
                        this.handleFullStop(index);
                    } else if (codepoint == 37) {
                        if (this.prevcp == 65 && Character.isDigit(this.buffer.charAt(this.buffer.length() - 1))) {
                            this.buffer.append('%');
                        } else {
                            this.processBuffer(index);
                            this.newLexicalUnit((short)5);
                        }
                    } else if (codepoint == 35) {
                        if (this.buffer.length() != 0) {
                            if (this.functionToken) {
                                this.buffer.append(Character.toChars(codepoint));
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                        } else {
                            this.hexColor = true;
                        }
                    } else if (codepoint == 33) {
                        this.processBuffer(index);
                        this.readPriority = true;
                    } else if (codepoint == 43) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)1);
                    } else if (codepoint == 42) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)3);
                    } else if (codepoint == 47) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)4);
                    } else if (codepoint == 94) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)6);
                    } else if (codepoint == 126) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)11);
                    } else if (codepoint == 60) {
                        this.handleLessThanSign(index);
                    } else if (codepoint == 61) {
                        this.handleEqualsSign(index);
                    } else if (codepoint == 62) {
                        this.handleGreaterThanSign(index);
                    } else {
                        this.processBuffer(index);
                    }
                }
            }
            this.prevcp = codepoint;
        }

        protected void handleLessThanSign(int index) {
            this.newLexicalUnit((short)7);
        }

        protected void handleEqualsSign(int index) {
            if (this.prevcp == 60) {
                this.currentlu.setUnitType((short)9);
            } else if (this.prevcp == 62) {
                this.currentlu.setUnitType((short)10);
            } else if (this.prevcp == 65 || this.prevcp == 32) {
                this.buffer.append('=');
            } else {
                this.handleError(index, (byte)4, "Unexpected '='");
            }
        }

        protected void handleGreaterThanSign(int index) {
            this.newLexicalUnit((short)8);
        }

        protected void handleFullStop(int index) {
            this.buffer.append('.');
        }

        protected void handleColon(int index) {
            if (this.buffer.length() != 0) {
                if (this.propertyName == null) {
                    this.propertyName = this.unescapeBuffer();
                } else if (!"progid".equals(this.buffer.toString())) {
                    this.handleError(index, (byte)4, "Unexpected ':'");
                } else {
                    this.buffer.append(':');
                }
            } else if (this.propertyName == null) {
                this.handleError(index, (byte)4, "Unexpected ':'");
            }
        }

        protected void handleAtKeyword(int index) {
            if (this.propertyName == null) {
                this.unexpectedCharError(index, 64);
            } else {
                this.buffer.append('@');
            }
        }

        protected void handleSemicolon(int index) {
            if (this.curlyBracketDepth == 1 && this.parendepth == 0 && this.squareBracketDepth == 0) {
                this.endOfPropertyDeclaration(index);
            } else {
                this.handleError(index, (byte)4, "Unexpected ';'");
            }
        }

        protected void badPropertyName(int index, int codepoint) {
            this.unexpectedCharError(index, codepoint);
        }

        protected void endOfPropertyDeclaration(int index) {
            if (this.propertyName != null) {
                this.processBuffer(index);
                if (this.lunit != null) {
                    CSSParser.this.handler.property(this.propertyName, (LexicalUnit)this.lunit, this.priorityImportant);
                } else {
                    this.handleError(index, (byte)32, "Found property name (" + this.propertyName + ") but no value");
                }
                this.propertyName = null;
            }
            this.lunit = null;
            this.currentlu = null;
            this.priorityImportant = false;
            this.prevcp = 32;
            this.readPriority = false;
            this.functionToken = false;
            this.hexColor = false;
            this.parseError = false;
            this.parendepth = 0;
            this.buffer.setLength(0);
        }

        private String rawBuffer() {
            this.escapedToken = false;
            String s = this.buffer.toString();
            this.buffer.setLength(0);
            return s;
        }

        private String unescapeBuffer() {
            String s = ParseHelper.unescapeStringValue(this.buffer.toString());
            this.buffer.setLength(0);
            this.escapedToken = false;
            return s;
        }

        protected void processBuffer(int index) {
            if (this.parseError) {
                this.buffer.setLength(0);
                return;
            }
            int buflen = this.buffer.length();
            if (buflen != 0) {
                if (this.hexColor) {
                    if (!this.parseHexColor(buflen)) {
                        this.handleError(index - buflen, (byte)5, "Wrong color value " + this.buffer);
                    }
                    this.buffer.setLength(0);
                    this.hexColor = false;
                } else if (this.readPriority && "important".equals(this.buffer.toString())) {
                    this.priorityImportant = true;
                    this.buffer.setLength(0);
                } else if (this.propertyName == null) {
                    this.propertyName = this.unescapeBuffer();
                } else if (this.currentlu != null && this.functionToken && this.currentlu.getLexicalUnitType() == 24) {
                    this.currentlu.value = this.rawBuffer();
                } else {
                    int i;
                    String s = this.unescapeBuffer();
                    int len = s.length();
                    for (i = len - 1; i >= 0; --i) {
                        int cp = s.codePointAt(i);
                        if (Character.isLetter(cp) || cp == 37) continue;
                        if (cp >= 48 && cp <= 57 && this.parseNumber(index, s, i + 1)) break;
                        this.newLexicalUnit((short)35).value = s;
                        break;
                    }
                    if (i == -1) {
                        String lcs = s.toLowerCase(Locale.US);
                        if (lcs.equals("inherit")) {
                            this.newLexicalUnit((short)12).value = "inherit";
                        } else {
                            this.newLexicalUnit((short)35).value = lcs.equals("initial") || lcs.equals("unset") ? lcs : s;
                        }
                    }
                }
            }
        }

        private boolean parseNumber(int index, String s, int i) {
            String strnum;
            short unitType;
            String unit = null;
            if (i != s.length()) {
                unit = s.substring(i);
                unit = unit.trim().toLowerCase(Locale.US).intern();
                unitType = ParseHelper.unitFromString(unit);
                strnum = s.substring(0, i);
            } else {
                unitType = s.lastIndexOf(46, i) == -1 ? (short)13 : 14;
                strnum = s;
            }
            if (unitType == 13) {
                try {
                    int intval = Integer.parseInt(strnum);
                    LexicalUnitImpl lu = this.newLexicalUnit(unitType);
                    lu.intValue = intval;
                }
                catch (NumberFormatException e) {
                    if (this.functionToken) {
                        return false;
                    }
                    this.newLexicalUnit((short)35).value = s;
                }
            } else {
                try {
                    float flval = Float.parseFloat(strnum);
                    if (unitType == 14 && flval == 0.0f) {
                        LexicalUnitImpl lu = this.newLexicalUnit((short)13);
                        lu.intValue = (int)flval;
                    } else {
                        LexicalUnitImpl lu = this.newLexicalUnit(unitType);
                        lu.floatValue = flval;
                        if (unit != null) {
                            lu.dimensionUnitText = unit;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    if (this.functionToken) {
                        return false;
                    }
                    this.newLexicalUnit((short)35).value = s;
                }
            }
            return true;
        }

        private boolean parseHexColor(int buflen) {
            block10: {
                try {
                    if (buflen == 3) {
                        this.newLexicalUnit((short)27);
                        this.currentlu.value = "rgb";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 1, true);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(1, 2, true);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(2, 3, true);
                        if (this.currentlu.ownerLexicalUnit != null) {
                            this.currentlu = this.currentlu.ownerLexicalUnit;
                        }
                        this.functionToken = prevft;
                        break block10;
                    }
                    if (buflen == 6) {
                        this.newLexicalUnit((short)27);
                        this.currentlu.value = "rgb";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 2, false);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(2, 4, false);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(4, 6, false);
                        if (this.currentlu.ownerLexicalUnit != null) {
                            this.currentlu = this.currentlu.ownerLexicalUnit;
                        }
                        this.functionToken = prevft;
                        break block10;
                    }
                    if (buflen == 8) {
                        this.newLexicalUnit((short)27);
                        this.currentlu.value = "rgba";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 2, false);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(2, 4, false);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(4, 6, false);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(6, 8, false);
                        if (this.currentlu.ownerLexicalUnit != null) {
                            this.currentlu = this.currentlu.ownerLexicalUnit;
                        }
                        this.functionToken = prevft;
                        break block10;
                    }
                    if (buflen == 4) {
                        this.newLexicalUnit((short)27);
                        this.currentlu.value = "rgba";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 1, true);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(1, 2, true);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(2, 3, true);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(3, 4, true);
                        if (this.currentlu.ownerLexicalUnit != null) {
                            this.currentlu = this.currentlu.ownerLexicalUnit;
                        }
                        this.functionToken = prevft;
                        break block10;
                    }
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        }

        private void parseHexComponent(int start, int end, boolean doubleDigit) {
            int comp;
            String s;
            if (doubleDigit) {
                CharSequence seq = this.buffer.subSequence(start, end);
                s = new StringBuilder(2).append(seq).append(seq).toString();
            } else {
                s = this.buffer.substring(start, end);
            }
            this.newLexicalUnit((short)13).intValue = comp = Integer.parseInt(s, 16);
        }

        @Override
        public void singleQuoted(int index, String quoted) {
            this.processBuffer(index);
            this.newLexicalUnit((short)36).value = ParseHelper.unescapeStringValue(quoted);
            this.prevcp = 65;
        }

        @Override
        public void doubleQuoted(int index, String quoted) {
            this.processBuffer(index);
            this.newLexicalUnit((short)36).value = ParseHelper.unescapeStringValue(quoted);
            this.prevcp = 65;
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (!this.parseError) {
                if (codepoint >= 48 && codepoint <= 57 || codepoint >= 65 && codepoint <= 70 || codepoint >= 97 && codepoint <= 102) {
                    this.escapedToken = true;
                    this.buffer.append('\\');
                }
                this.buffer.append(Character.toChars(codepoint));
            }
            this.prevcp = codepoint;
        }

        @Override
        public void separator(int index, int codepoint) {
            if (this.escapedToken && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                this.buffer.append(' ');
                return;
            }
            if (!this.parseError && this.buffer.length() != 0) {
                this.processBuffer(index);
            }
            this.prevcp = 32;
        }

        @Override
        public void endOfStream(int len) {
            if (this.parendepth != 0) {
                this.handleError(len, (byte)6, "Unmatched parenthesis");
            } else if (this.propertyName != null) {
                this.processBuffer(len);
                this.endOfPropertyDeclaration(len);
            } else if (this.buffer.length() != 0) {
                this.handleError(len, (byte)9, "Unexpected token: " + this.buffer);
            }
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            super.error(index, errCode, context);
            this.lunit = null;
        }
    }

    class PropertyTokenHandler
    extends DeclarationTokenHandler {
        PropertyTokenHandler(InputSource source) {
            super(source);
            this.propertyName = "";
        }

        @Override
        protected void handleFullStop(int index) {
            if (this.prevcp == 65) {
                this.buffer.append('.');
            } else if (this.buffer.length() == 0) {
                this.buffer.append('0').append('.');
            } else {
                this.handleError(index, (byte)4, "Unexpected '.'");
            }
        }

        @Override
        protected void handleAtKeyword(int index) {
            throw this.createException(index, (byte)4, "Unexpected '@'");
        }

        @Override
        protected void handleSemicolon(int index) {
            this.handleError(index, (byte)4, "Unexpected ';'");
        }

        @Override
        public void endOfStream(int len) {
            if (this.parendepth != 0) {
                this.handleError(len, (byte)6, "Unmatched parenthesis");
            } else if (this.buffer.length() != 0) {
                this.processBuffer(len);
            } else if (this.getLexicalUnit() == null) {
                this.handleError(len, (byte)32, "No value found");
            }
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (this.prevcp == this.endcp && this.endcp != -1) {
                throw this.createException(index, errCode, "Expected end of file, found " + new String(Character.toChars(this.prevcp)));
            }
            throw this.createException(index, errCode, message);
        }
    }

    static class SelectorListImpl
    extends LinkedList<Selector>
    implements SelectorList {
        private static final long serialVersionUID = 1L;

        SelectorListImpl() {
        }

        @Override
        public boolean add(Selector sel) {
            if (!this.contains(sel)) {
                return super.add(sel);
            }
            return false;
        }

        @Override
        public void addLast(Selector sel) {
            if (!this.contains(sel)) {
                super.addLast(sel);
            }
        }

        public int getLength() {
            return this.size();
        }

        public Selector item(int index) {
            if (index < 0 || index >= this.size()) {
                return null;
            }
            return (Selector)this.get(index);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            Iterator it = this.iterator();
            if (it.hasNext()) {
                buf.append(((Selector)it.next()).toString());
                while (it.hasNext()) {
                    buf.append(',').append(((Selector)it.next()).toString());
                }
            }
            return buf.toString();
        }
    }

    class SelectorTokenHandler
    extends CSSTokenHandler {
        NSACSelectorFactory factory;
        Parser2.NamespaceMap nsMap;
        SelectorListImpl selist;
        Selector currentsel;
        private String namespacePrefix;
        StringBuilder buffer;
        private boolean escapedToken;
        byte stage;
        private boolean functionToken;
        private static final byte STAGE_COMBINATOR_OR_END = 2;
        private static final byte STAGE_ATTR_START = 4;
        private static final byte STAGE_ATTR_EXPECT_SYMBOL_OR_CLOSE = 7;
        private static final byte STAGE_ATTR_SYMBOL = 5;
        private static final byte STAGE_ATTR_POST_SYMBOL = 6;
        private static final byte STAGE_EXPECT_ID_OR_CLASSNAME = 8;
        private static final byte STAGE_EXPECT_PSEUDOELEM_NAME = 9;
        private static final byte STAGE_EXPECT_PSEUDOCLASS_NAME = 10;
        private static final byte STAGE_EXPECT_PSEUDOCLASS_ARGUMENT = 11;

        SelectorTokenHandler() {
            this(new NSACSelectorFactory());
        }

        SelectorTokenHandler(InputSource source, Parser2.NamespaceMap nsMap) {
            super(source);
            this.selist = new SelectorListImpl();
            this.currentsel = null;
            this.namespacePrefix = null;
            this.buffer = new StringBuilder();
            this.escapedToken = false;
            this.stage = 0;
            this.factory = new NSACSelectorFactory();
            this.nsMap = nsMap == null ? this.factory : nsMap;
        }

        SelectorTokenHandler(NSACSelectorFactory factory) {
            super(null);
            this.selist = new SelectorListImpl();
            this.currentsel = null;
            this.namespacePrefix = null;
            this.buffer = new StringBuilder();
            this.escapedToken = false;
            this.stage = 0;
            this.factory = factory;
            this.nsMap = factory;
        }

        SelectorList getSelectorList() {
            return this.selist;
        }

        @Override
        public void word(int index, String word) {
            if (this.buffer.length() != 0 && this.prevcp == 32) {
                this.buffer.append(' ');
            }
            if (this.stage == 4 && this.prevcp != 65 && this.prevcp != 124) {
                this.handleError(index, (byte)9, "Unexpected token: <" + word + ">");
            } else {
                this.buffer.append(word);
                if (this.stage == 0) {
                    this.stage = 1;
                } else if (this.stage == 2) {
                    this.newDescendantSelector((short)10);
                    this.stage = 1;
                } else if (this.stage == 6 && this.prevcp == 32) {
                    if ("i".equals(word)) {
                        this.setCaseInsensitiveCondition();
                        this.buffer.setLength(0);
                    } else {
                        this.handleError(index, (byte)9, "Expected 'i', found: <" + word + ">");
                    }
                } else if (this.stage == 7) {
                    this.handleError(index, (byte)9, "Unexpected token: <" + word + ">");
                }
            }
            this.prevcp = 65;
        }

        @Override
        public void separator(int index, int codepoint) {
            if (this.escapedToken && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                this.buffer.append(' ');
                return;
            }
            if (this.stage == 5) {
                if (this.buffer.length() != 0) {
                    this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                    this.stage = (byte)6;
                }
            } else if (this.stage == 1 || this.stage == 8 || this.stage == 9 || this.stage == 10) {
                this.processBuffer(index, false);
                if (this.prevcp == 65 || this.prevcp == 42 || this.prevcp == 41 || this.prevcp == 93) {
                    this.stage = (byte)2;
                }
            } else if (this.stage == 4) {
                if (this.buffer.length() != 0) {
                    this.stage = (byte)7;
                }
                return;
            }
            if (this.prevcp != 44) {
                this.prevcp = 32;
            }
        }

        @Override
        public void singleQuoted(int index, String quoted) {
            this.quotedString(index, quoted, false);
        }

        private void quotedString(int index, String quoted, boolean doubleQuoted) {
            if (this.stage == 5 && this.currentsel != null) {
                this.setAttributeSelectorValue(index, quoted);
                this.stage = (byte)6;
            } else if (this.stage == 11) {
                if (this.prevcp == 32 && this.buffer.length() != 0) {
                    this.buffer.append(' ');
                }
                if (doubleQuoted) {
                    this.buffer.append('\"').append(quoted).append('\"');
                } else {
                    this.buffer.append('\'').append(quoted).append('\'');
                }
            } else {
                this.handleError(index, (byte)9, "Unexpected: " + quoted);
            }
            this.prevcp = 65;
        }

        private void setAttributeSelectorValue(int index, String value) {
            NSACSelectorFactory.AttributeConditionImpl attrcond;
            SimpleSelector simple;
            Condition cond = null;
            if (this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl) {
                simple = ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector();
                if (!(simple instanceof NSACSelectorFactory.ConditionalSelectorImpl)) {
                    throw new IllegalStateException("Descendant selector has no conditional simple selector");
                }
                cond = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).condition;
            } else if (this.currentsel instanceof NSACSelectorFactory.SiblingSelectorImpl) {
                simple = ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).getSiblingSelector();
                if (!(simple instanceof NSACSelectorFactory.ConditionalSelectorImpl)) {
                    throw new IllegalStateException("Descendant selector has no conditional simple selector");
                }
                cond = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).condition;
            } else if (this.currentsel instanceof NSACSelectorFactory.ConditionalSelectorImpl) {
                cond = ((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).condition;
            }
            if (cond instanceof NSACSelectorFactory.CombinatorConditionImpl) {
                cond = ((NSACSelectorFactory.CombinatorConditionImpl)cond).getSecondCondition();
            }
            if (cond instanceof NSACSelectorFactory.AttributeConditionImpl && (attrcond = (NSACSelectorFactory.AttributeConditionImpl)cond) != null) {
                if (attrcond.value == null) {
                    attrcond.value = value;
                } else {
                    StringBuilder buf = new StringBuilder(attrcond.value.length() + value.length() + 1);
                    buf.append(attrcond.value);
                    if (this.prevcp == 32) {
                        buf.append(' ');
                    }
                    attrcond.value = buf.append(value).toString();
                }
                return;
            }
            this.handleError(index, (byte)9, "Unexpected token in selector: <" + value + ">");
        }

        private void setCaseInsensitiveCondition() {
            SimpleSelector simple;
            if (this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl) {
                simple = ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector();
                if (simple == null) {
                    throw new IllegalStateException("Descendant selector has no simple selector");
                }
            } else {
                if (this.currentsel.getSelectorType() == 0) {
                    Condition cond = ((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).getCondition();
                    if (cond.getConditionType() == 0) {
                        cond = ((CombinatorCondition)cond).getSecondCondition();
                    }
                    if (cond.getConditionType() != 4) {
                        throw new IllegalStateException("Processing attribute modifier of non-attribute conditional selector");
                    }
                    ((NSACSelectorFactory.AttributeConditionImpl)cond).caseSensitive = false;
                    return;
                }
                simple = this.currentsel;
            }
            ((NSACSelectorFactory.AttributeConditionImpl)((NSACSelectorFactory.ConditionalSelectorImpl)simple).condition).caseSensitive = false;
        }

        @Override
        public void doubleQuoted(int index, String quoted) {
            this.quotedString(index, quoted, true);
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (codepoint == 123) {
                this.handleLeftCurlyBracket(index);
            } else {
                if (this.stage == 11) {
                    this.buffer.append(Character.toChars(codepoint));
                    this.prevcp = codepoint;
                    if (codepoint == 40) {
                        this.parendepth = (short)(this.parendepth + 1);
                    }
                    return;
                }
                if (codepoint == 40) {
                    if (this.prevcp != 65 || this.buffer.length() == 0) {
                        this.unexpectedCharError(index, codepoint);
                    } else {
                        if (this.stage == 10) {
                            this.newConditionalSelector((short)10);
                            this.stage = (byte)11;
                        }
                        this.functionToken = true;
                    }
                    this.parendepth = (short)(this.parendepth + 1);
                } else if (codepoint == 91) {
                    if (this.prevcp != 65 && this.prevcp != 42 && this.prevcp != 44 && this.prevcp != 32 && this.prevcp != 93 && this.prevcp != 41 && this.prevcp != 43 && this.prevcp != 62 && this.prevcp != 125 && this.prevcp != 126 && this.prevcp != 124) {
                        this.unexpectedCharError(index, codepoint);
                    } else {
                        this.processBuffer(index, false);
                        this.stage = (byte)4;
                        this.prevcp = 65;
                        return;
                    }
                }
            }
            this.prevcp = codepoint;
        }

        protected void handleLeftCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '{'");
        }

        protected void handleRightCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '}'");
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void closeGroup(int index, int codepoint) {
            block35: {
                block36: {
                    block39: {
                        block37: {
                            block38: {
                                void var3_6;
                                if (codepoint != 41) break block36;
                                this.parendepth = (short)(this.parendepth - 1);
                                if (this.stage != 11) break block37;
                                if (this.parendepth != 0) {
                                    this.buffer.append(Character.toChars(codepoint));
                                    this.prevcp = codepoint;
                                    return;
                                }
                                if (this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl) {
                                    SimpleSelector simpleSelector = ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector();
                                } else if (this.currentsel instanceof NSACSelectorFactory.SiblingSelectorImpl) {
                                    SimpleSelector simpleSelector = ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).getSiblingSelector();
                                } else {
                                    Selector selector = this.currentsel;
                                }
                                if (var3_6.getSelectorType() != 0) break block38;
                                Condition cond = ((NSACSelectorFactory.ConditionalSelectorImpl)var3_6).condition;
                                if (this.buffer.length() != 0) {
                                    String arg;
                                    while (cond.getConditionType() == 0) {
                                        cond = ((NSACSelectorFactory.CombinatorConditionImpl)cond).getSecondCondition();
                                    }
                                    if (cond.getConditionType() == 6) {
                                        ((NSACSelectorFactory.LangConditionImpl)cond).lang = this.unescapeBuffer(index);
                                    } else if (cond.getConditionType() == 10) {
                                        ((NSACSelectorFactory.AttributeConditionImpl)cond).value = this.unescapeBuffer(index);
                                    } else if (cond.getConditionType() == 17) {
                                        CSSParser parser = new CSSParser();
                                        try {
                                            ((NSACSelectorFactory.SelectorArgumentConditionImpl)cond).arguments = parser.parseSelectors(this.rawBuffer(), this.factory);
                                        }
                                        catch (CSSParseException e) {
                                            byte errCode = ((Object)((Object)e)).getClass() == CSSNamespaceParseException.class ? (byte)15 : 32;
                                            CSSParseException ex = this.createException(index, errCode, e.getMessage());
                                            if (CSSParser.this.errorHandler == null) {
                                                throw ex;
                                            }
                                            CSSParser.this.errorHandler.error(ex);
                                            this.parseError = true;
                                            this.stage = (byte)127;
                                        }
                                    } else if (cond.getConditionType() == 3 && ((NSACSelectorFactory.PositionalConditionImpl)cond).needsArgument && !this.parsePositionalArgument((NSACSelectorFactory.PositionalConditionImpl)cond, arg = this.rawBuffer())) {
                                        this.handleError(index, (byte)32, "Wrong subexpression: " + arg);
                                    }
                                    this.buffer.setLength(0);
                                    this.stage = 1;
                                    break block39;
                                } else if (cond.getConditionType() == 6 || cond.getConditionType() == 17 || cond.getConditionType() == 3) {
                                    this.unexpectedCharError(index, codepoint);
                                }
                                break block39;
                            }
                            this.unexpectedCharError(index, codepoint);
                            break block39;
                        }
                        this.buffer.append(Character.toChars(codepoint));
                        this.processBuffer(index, false);
                    }
                    if (this.functionToken) {
                        this.functionToken = false;
                    }
                    break block35;
                }
                if (codepoint == 125) {
                    this.handleRightCurlyBracket(index);
                } else {
                    if (this.stage == 11) {
                        this.buffer.append(Character.toChars(codepoint));
                        this.prevcp = codepoint;
                        return;
                    }
                    if (codepoint == 93) {
                        if (this.stage == 6) {
                            if (this.buffer.length() != 0) {
                                this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                            }
                            this.stage = 1;
                        } else if (this.stage == 4 || this.stage == 7) {
                            if (this.buffer.length() != 0) {
                                this.newConditionalSelector((short)4);
                                this.stage = 1;
                            } else {
                                this.handleError(index, (byte)4, "Unexpected ']', expected attribute name");
                            }
                        } else if (this.stage == 5) {
                            if (this.buffer.length() != 0) {
                                this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                                this.stage = 1;
                            } else {
                                this.handleError(index, (byte)4, "Unexpected ']', expected attribute value");
                            }
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    }
                }
            }
            this.prevcp = codepoint;
        }

        private String rawBuffer() {
            this.escapedToken = false;
            String s = this.buffer.toString();
            this.buffer.setLength(0);
            return s;
        }

        private String unescapeBuffer(int index) {
            String s = ParseHelper.unescapeStringValue(this.buffer.toString());
            this.buffer.setLength(0);
            this.escapedToken = false;
            if (this.namespacePrefix != null) {
                this.handleError(index - this.namespacePrefix.length() - 1, (byte)9, "Unexpected token: " + this.namespacePrefix);
                this.namespacePrefix = null;
            }
            return s;
        }

        private void processBuffer(int index, boolean lastStage) {
            if (this.prevcp == 42) {
                if (this.currentsel == null || this.currentsel.getSelectorType() != 1) {
                    this.setSimpleSelector(index, (SimpleSelector)this.factory.getUniversalSelector(this.namespacePrefix));
                }
            } else if (this.stage == 2) {
                if (!lastStage) {
                    this.newDescendantSelector((short)10);
                    if (this.buffer.length() != 0) {
                        NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                        sel.localName = this.unescapeBuffer(index);
                        this.stage = 1;
                    }
                }
            } else if (this.buffer.length() != 0) {
                if (this.stage == 1) {
                    NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                    if (this.namespacePrefix != null) {
                        if (this.namespacePrefix.length() != 0) {
                            sel.namespaceUri = this.getNamespaceURI(this.namespacePrefix);
                            if (sel.namespaceUri == null) {
                                if (this.namespacePrefix.length() == 0) {
                                    sel.namespaceUri = "";
                                } else if (!this.namespacePrefix.equals("*")) {
                                    this.handleError(index, (byte)15, "Unknown namespace prefix: " + this.namespacePrefix);
                                    return;
                                }
                            }
                        } else {
                            sel.namespaceUri = "";
                        }
                        this.namespacePrefix = null;
                    } else {
                        sel.namespaceUri = this.getNamespaceURI("");
                    }
                    sel.localName = this.unescapeBuffer(index);
                } else if (this.stage == 8) {
                    this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                    this.stage = 1;
                } else if (this.stage == 10) {
                    this.newConditionalSelector((short)10);
                    this.stage = 1;
                } else if (this.stage == 9) {
                    this.newConditionalSelector((short)18);
                    this.stage = 1;
                } else if (this.stage != 11) {
                    if (this.stage == 6) {
                        this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                    } else {
                        this.handleError(index, (byte)9, "Unexpected: <" + this.buffer + ">");
                        this.buffer.setLength(0);
                    }
                }
            } else if (this.namespacePrefix != null) {
                this.handleError(index - this.namespacePrefix.length() - 1, (byte)9, "Unexpected: " + this.namespacePrefix + "|");
                this.namespacePrefix = null;
            }
        }

        @Override
        public void character(int index, int codepoint) {
            if (!this.parseError) {
                if (this.stage == 11) {
                    if (this.prevcp == 32) {
                        this.buffer.append(' ');
                    }
                    this.buffer.append(Character.toChars(codepoint));
                } else if (codepoint == 42) {
                    if (this.stage == 0) {
                        this.stage = 1;
                    } else if (this.stage == 2) {
                        this.newDescendantSelector((short)10);
                        ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector = this.factory.getUniversalSelector(this.namespacePrefix);
                        if (this.namespacePrefix != null) {
                            this.namespacePrefix = null;
                        }
                        this.stage = 1;
                    } else if (this.stage == 1 && this.namespacePrefix != null) {
                        this.setSimpleSelector(index, (SimpleSelector)this.factory.createUniversalSelector(this.getNamespaceURI(this.namespacePrefix)));
                        this.namespacePrefix = null;
                    } else if (this.stage != 4 && this.stage != 7) {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else if (codepoint == 46) {
                    this.processBuffer(index, false);
                    this.newConditionalSelector((short)9);
                    this.stage = (byte)8;
                } else if (codepoint == 35) {
                    this.newConditionalSelector((short)5);
                    this.stage = (byte)8;
                } else if (codepoint == 58) {
                    if (this.prevcp == 58) {
                        this.stage = (byte)9;
                    } else {
                        this.processBuffer(index, false);
                        this.stage = (byte)10;
                    }
                } else if (codepoint == 62) {
                    if (this.prevcp != 62) {
                        if (this.stage == 2) {
                            this.stage = 1;
                        }
                        this.processBuffer(index, false);
                        this.newDescendantSelector((short)11);
                    } else {
                        ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).setSelectorType((short)10);
                    }
                } else if (codepoint == 43) {
                    if (this.stage == 2) {
                        this.stage = 1;
                    }
                    this.processBuffer(index, false);
                    this.newSiblingSelector((short)12);
                } else if (codepoint == 61) {
                    if (this.prevcp == 124 && this.namespacePrefix != null && this.buffer.length() == 0) {
                        this.buffer.append(this.namespacePrefix);
                        this.namespacePrefix = null;
                    }
                    if ((this.stage == 4 || this.stage == 7) && this.buffer.length() != 0) {
                        if (this.prevcp == 124) {
                            this.newConditionalSelector((short)8);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 126) {
                            this.newConditionalSelector((short)7);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 36) {
                            this.newConditionalSelector((short)15);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 94) {
                            this.newConditionalSelector((short)14);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 42) {
                            this.newConditionalSelector((short)16);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 65) {
                            this.newConditionalSelector((short)4);
                            this.stage = (byte)5;
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else if (codepoint == 126 && this.stage != 4 && this.stage != 7) {
                    if (this.stage == 2) {
                        this.stage = 1;
                    } else {
                        this.processBuffer(index, false);
                    }
                    this.newSiblingSelector((short)13);
                } else if (codepoint == 124) {
                    if (this.prevcp == 124 && this.stage == 1) {
                        if (this.currentsel == null) {
                            NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                            if (this.namespacePrefix != null) {
                                sel.localName = this.namespacePrefix;
                                this.namespacePrefix = null;
                            } else if (this.buffer.length() != 0) {
                                sel.localName = this.unescapeBuffer(index);
                            } else {
                                this.unexpectedCharError(index, codepoint);
                                return;
                            }
                        }
                        this.newDescendantSelector((short)14);
                    } else if (this.stage == 8 || this.stage == 10 || this.stage == 9) {
                        this.processBuffer(index, false);
                    } else if (this.stage == 2) {
                        this.stage = 1;
                    } else if ((this.stage == 1 || this.stage == 4) && this.namespacePrefix == null) {
                        this.readNamespacePrefix(index, codepoint);
                    } else if (this.stage == 0 && this.namespacePrefix == null && this.buffer.length() == 0) {
                        this.namespacePrefix = "";
                    } else if (this.stage != 7) {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else if (codepoint == 36 || codepoint == 94) {
                    if (this.stage != 4 && this.stage != 7) {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else if (codepoint == 44) {
                    if (this.functionToken) {
                        if (this.prevcp == 44) {
                            this.unexpectedCharError(index, codepoint);
                        } else {
                            this.buffer.append(',');
                        }
                    } else {
                        this.processBuffer(index, true);
                        if (!this.parseError) {
                            if (this.addCurrentSelector()) {
                                this.stage = 0;
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                        }
                    }
                } else if (codepoint == 64) {
                    this.handleAtKeyword(index);
                } else if (codepoint == 45) {
                    this.buffer.append('-');
                } else if (codepoint == 95) {
                    this.buffer.append('_');
                } else if (codepoint != 126) {
                    this.unexpectedCharError(index, codepoint);
                }
            }
            this.prevcp = codepoint;
        }

        private void readNamespacePrefix(int index, int codepoint) {
            if (this.prevcp == 65) {
                this.namespacePrefix = this.unescapeBuffer(index);
            } else if (this.prevcp == 42 && this.buffer.length() == 0) {
                this.namespacePrefix = "*";
            } else {
                this.unexpectedCharError(index, codepoint);
            }
        }

        protected void handleAtKeyword(int index) {
            this.unexpectedCharError(index, 64);
        }

        private void newConditionalSelector(short condtype) {
            Condition condition;
            String name = this.rawBuffer();
            String lcname = name.toLowerCase(Locale.US).intern();
            if (condtype == 10) {
                if ("lang".equals(lcname)) {
                    condition = this.factory.createCondition((short)6);
                } else if ("first-child".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                } else if ("nth-child".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).needsArgument = true;
                } else if ("last-child".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).offset = 1;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).forwardCondition = false;
                } else if ("nth-last-child".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).offset = 1;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).forwardCondition = false;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).needsArgument = true;
                } else if ("first-of-type".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).oftype = true;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).offset = 1;
                } else if ("last-of-type".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).oftype = true;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).offset = 1;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).forwardCondition = false;
                } else if ("nth-of-type".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).oftype = true;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).needsArgument = true;
                } else if ("nth-last-of-type".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).oftype = true;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).forwardCondition = false;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).needsArgument = true;
                } else if ("not".equals(lcname) || "matches".equals(lcname) || "has".equals(lcname)) {
                    condition = this.factory.createCondition((short)17);
                    ((NSACSelectorFactory.SelectorArgumentConditionImpl)condition).setName(lcname);
                } else {
                    if ("first-line".equals(lcname) || "first-letter".equals(lcname) || "before".equals(lcname) || "after".equals(lcname)) {
                        condtype = (short)18;
                    }
                    condition = this.factory.createCondition(condtype);
                }
            } else {
                condition = this.factory.createCondition(condtype);
            }
            if (name.length() != 0 && condition instanceof NSACSelectorFactory.AttributeConditionImpl) {
                switch (condition.getConditionType()) {
                    case 4: 
                    case 7: 
                    case 8: 
                    case 14: 
                    case 15: 
                    case 16: {
                        if (this.namespacePrefix != null) {
                            ((NSACSelectorFactory.AttributeConditionImpl)condition).namespaceURI = this.namespacePrefix.length() != 0 ? this.getNamespaceURI(this.namespacePrefix) : "";
                            this.namespacePrefix = null;
                        }
                    }
                    case 10: 
                    case 18: {
                        ((NSACSelectorFactory.AttributeConditionImpl)condition).localName = ParseHelper.unescapeStringValue(name);
                        break;
                    }
                    default: {
                        ((NSACSelectorFactory.AttributeConditionImpl)condition).value = lcname;
                    }
                }
            }
            if (this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl) {
                SimpleSelector simple = ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector();
                if (simple != null && simple.getSelectorType() == 0) {
                    NSACSelectorFactory.CombinatorConditionImpl andcond = (NSACSelectorFactory.CombinatorConditionImpl)this.factory.createCondition((short)0);
                    andcond.first = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).getCondition();
                    andcond.second = condition;
                    ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.ConditionalSelectorImpl)simple).getSimpleSelector(), (Condition)andcond);
                } else {
                    ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector, condition);
                }
            } else if (this.currentsel instanceof NSACSelectorFactory.SiblingSelectorImpl) {
                SimpleSelector simple = ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).getSiblingSelector();
                if (simple != null && simple.getSelectorType() == 0) {
                    NSACSelectorFactory.CombinatorConditionImpl andcond = (NSACSelectorFactory.CombinatorConditionImpl)this.factory.createCondition((short)0);
                    andcond.first = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).getCondition();
                    andcond.second = condition;
                    ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).siblingSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.ConditionalSelectorImpl)simple).getSimpleSelector(), (Condition)andcond);
                } else {
                    ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).siblingSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).siblingSelector, condition);
                }
            } else if (this.currentsel != null && this.currentsel.getSelectorType() == 0) {
                NSACSelectorFactory.CombinatorConditionImpl andcond = (NSACSelectorFactory.CombinatorConditionImpl)this.factory.createCondition((short)0);
                andcond.first = ((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).getCondition();
                andcond.second = condition;
                this.currentsel = this.factory.createConditionalSelector(((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).getSimpleSelector(), (Condition)andcond);
            } else {
                this.currentsel = this.factory.createConditionalSelector((SimpleSelector)this.currentsel, condition);
            }
        }

        private boolean parsePositionalArgument(NSACSelectorFactory.PositionalConditionImpl cond, String expression) {
            MyAnBExpression expr = new MyAnBExpression();
            try {
                expr.parse(expression);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            cond.offset = expr.getOffset();
            cond.slope = expr.getStep();
            cond.ofList = expr.getSelectorList();
            return true;
        }

        private String getNamespaceURI(String nsPrefix) {
            String uri = this.nsMap.getNamespaceURI(nsPrefix);
            if (uri != null && this.factory != this.nsMap) {
                this.factory.registerNamespacePrefix(nsPrefix, uri);
            }
            return uri;
        }

        private NSACSelectorFactory.ElementSelectorImpl newElementSelector(int index) {
            NSACSelectorFactory.ElementSelectorImpl elemsel = this.factory.createElementSelector();
            this.setSimpleSelector(index, (SimpleSelector)elemsel);
            return elemsel;
        }

        private void setSimpleSelector(int index, SimpleSelector simple) {
            if (this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl) {
                ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector = simple;
            } else if (this.currentsel instanceof NSACSelectorFactory.SiblingSelectorImpl) {
                ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).siblingSelector = simple;
            } else if (this.currentsel != null) {
                this.handleError(index, (byte)9, "Unexpected token after '" + this.currentsel.toString() + "': " + simple.toString());
            } else {
                this.currentsel = simple;
            }
        }

        private void newDescendantSelector(short type) {
            this.currentsel = this.factory.createDescendantSelector(type, this.currentsel);
            this.stage = 0;
        }

        private void newSiblingSelector(short type) {
            this.currentsel = this.factory.createSiblingSelector(type, this.currentsel);
            this.stage = 0;
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (codepoint >= 48 && codepoint <= 57 || codepoint >= 65 && codepoint <= 70 || codepoint >= 97 && codepoint <= 102) {
                this.escapedToken = true;
                this.buffer.append('\\');
            }
            this.buffer.append(Character.toChars(codepoint));
            if (this.stage == 0) {
                this.stage = 1;
            }
            this.prevcp = 65;
        }

        @Override
        public void endOfStream(int len) {
            this.processBuffer(len, true);
            if (!this.parseError && !this.addCurrentSelector()) {
                this.handleError(len, (byte)10, "Unexpected end of stream");
            }
        }

        boolean addCurrentSelector() {
            if (this.currentsel != null) {
                if (this.isValidCurrentSelector()) {
                    this.selist.add(this.currentsel);
                    this.currentsel = null;
                    return true;
                }
                this.selist.clear();
                this.currentsel = null;
            }
            return false;
        }

        private boolean isValidCurrentSelector() {
            SimpleSelector last = null;
            switch (this.currentsel.getSelectorType()) {
                case 10: 
                case 11: 
                case 14: {
                    last = ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector();
                    break;
                }
                case 12: 
                case 13: {
                    last = ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).getSiblingSelector();
                    break;
                }
                case 0: {
                    Condition cond = ((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).getCondition();
                    short condtype = cond.getConditionType();
                    while (condtype == 0) {
                        if ((cond = ((NSACSelectorFactory.CombinatorConditionImpl)cond).getSecondCondition()) == null) {
                            return false;
                        }
                        condtype = cond.getConditionType();
                    }
                    switch (condtype) {
                        case 4: 
                        case 10: 
                        case 18: {
                            if (((NSACSelectorFactory.AttributeConditionImpl)cond).getLocalName() != null) break;
                            return false;
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 14: 
                        case 15: 
                        case 16: {
                            if (((NSACSelectorFactory.AttributeConditionImpl)cond).getValue() != null) break;
                            return false;
                        }
                        case 6: {
                            if (((NSACSelectorFactory.LangConditionImpl)cond).getLang() != null) break;
                            return false;
                        }
                        case 17: {
                            if (((NSACSelectorFactory.SelectorArgumentConditionImpl)cond).getSelectors() != null) break;
                            return false;
                        }
                    }
                }
                default: {
                    return true;
                }
            }
            return last != null;
        }

        protected boolean isValidSelectorList() {
            return !this.selist.isEmpty() && this.currentsel == null;
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            super.error(index, errCode, context);
            this.selist.clear();
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (!this.parseError) {
                this.stage = (byte)127;
                if (this.prevcp == this.endcp && this.endcp != -1) {
                    throw this.createException(index, errCode, "Expected end of file, found " + new String(Character.toChars(this.prevcp)));
                }
                throw this.createException(index, errCode, message);
            }
        }

        class MyAnBExpression
        extends AnBExpression {
            MyAnBExpression() {
            }

            @Override
            protected SelectorList parseSelector(String selText) {
                CSSParser parser = new CSSParser();
                return parser.parseSelectors(selText, SelectorTokenHandler.this.factory);
            }
        }
    }

    class SheetTokenHandler
    extends CSSTokenHandler {
        TokenProducer.TokenHandler contextHandler;
        DeclarationTokenHandler declarationHandler;
        SelectorTokenHandler selectorHandler;
        private String ruleFirstPart;
        private String ruleSecondPart;
        private String marginRule;
        private StringBuilder buffer;
        private int curlyBracketDepth;
        private byte ruleType;
        private final byte MEDIA_RULE = 4;
        private final byte FONT_FACE_RULE = 5;
        private final byte PAGE_RULE = 6;
        private final byte MARGIN_RULE = 9;
        private byte stage;
        private SACMediaListWrapper medialist;

        SheetTokenHandler(InputSource source, Parser2.NamespaceMap nsMap) {
            super(source);
            this.ruleFirstPart = null;
            this.ruleSecondPart = null;
            this.marginRule = null;
            this.buffer = new StringBuilder(512);
            this.curlyBracketDepth = 0;
            this.ruleType = 0;
            this.MEDIA_RULE = (byte)4;
            this.FONT_FACE_RULE = (byte)5;
            this.PAGE_RULE = (byte)6;
            this.MARGIN_RULE = (byte)9;
            this.stage = 0;
            this.medialist = null;
            this.declarationHandler = new MyDeclarationTokenHandler(source);
            this.selectorHandler = new MySelectorTokenHandler(source, nsMap);
            this.contextHandler = this.selectorHandler;
        }

        @Override
        public void word(int index, String word) {
            if (this.contextHandler != null) {
                this.contextHandler.word(index, word);
            } else {
                if (this.prevcp == 64) {
                    String ruleName = word.toLowerCase(Locale.US);
                    if (this.stage == 0) {
                        if ("charset".equals(ruleName)) {
                            this.stage = (byte)32;
                            if (index != 1) {
                                this.handleError(index, (byte)4, "@charset rules must be at the beginning of the sheet");
                            }
                            this.buffer.setLength(0);
                        } else if ("import".equals(ruleName)) {
                            this.stage = (byte)38;
                            this.buffer.setLength(0);
                        } else if ("namespace".equals(ruleName)) {
                            this.stage = (byte)34;
                            this.buffer.setLength(0);
                        } else if ("media".equals(ruleName)) {
                            this.ruleType = (byte)4;
                            this.stage = (byte)2;
                            this.buffer.setLength(0);
                        } else if ("font-face".equals(ruleName)) {
                            this.ruleType = (byte)5;
                            this.stage = (byte)2;
                            this.buffer.setLength(0);
                        } else if ("page".equals(ruleName)) {
                            this.ruleType = (byte)6;
                            this.stage = (byte)2;
                            this.buffer.setLength(0);
                        } else {
                            this.buffer.append(ruleName);
                            this.stage = (byte)5;
                        }
                    } else if (this.stage == 2) {
                        if (this.ruleType == 6) {
                            if (this.isMarginRuleName(ruleName)) {
                                this.ruleType = (byte)9;
                                this.marginRule = ruleName;
                                CSSParser.this.handler.startPage(ruleName, null);
                            }
                        } else if (this.ruleType == 4 && "page".equals(ruleName)) {
                            this.ruleType = (byte)6;
                            this.stage = (byte)8;
                            this.buffer.setLength(0);
                        } else if (this.ruleType == 4 && "media".equals(ruleName)) {
                            this.buffer.setLength(0);
                        } else {
                            this.stage = (byte)7;
                            this.buffer.append(word);
                        }
                    } else {
                        this.buffer.append(word);
                    }
                } else if (this.ruleType == 6 && this.buffer.length() != 1 && this.ruleFirstPart != null) {
                    this.handleError(index, (byte)9, "Expecting pseudo-page, got " + word);
                } else {
                    this.buffer.append(word);
                }
                this.prevcp = 65;
            }
        }

        private boolean isMarginRuleName(String ruleName) {
            StringTokenizer st = new StringTokenizer(ruleName, "-");
            while (st.hasMoreElements()) {
                String s = st.nextToken();
                if ("top".equals(s) || "left".equals(s) || "center".equals(s) || "right".equals(s) || "corner".equals(s) || "bottom".equals(s) || "middle".equals(s)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void separator(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.separator(index, codepoint);
            } else {
                if (this.stage == 34) {
                    if (this.ruleFirstPart == null) {
                        if (this.buffer.length() != 0) {
                            this.ruleFirstPart = this.buffer.toString();
                            this.buffer.setLength(0);
                            this.stage = (byte)35;
                        }
                    } else {
                        this.stage = (byte)35;
                    }
                } else {
                    if (this.stage == 2 && this.ruleType == 6 || this.stage == 8) {
                        this.processBufferPageRule(index);
                        if (this.prevcp != 44) {
                            this.prevcp = 32;
                        }
                        return;
                    }
                    if (this.buffer.length() != 0 && this.prevcp != 32) {
                        this.buffer.append(' ');
                    }
                }
                this.prevcp = 32;
            }
        }

        @Override
        public void singleQuoted(int index, String quoted) {
            if (this.contextHandler != null) {
                this.contextHandler.singleQuoted(index, quoted);
            } else if (this.stage == 5) {
                this.buffer.append('\'').append(quoted).append('\'');
            } else {
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = quoted;
                    if (this.stage == 38) {
                        this.stage = (byte)40;
                    }
                } else if (this.ruleSecondPart == null) {
                    this.ruleSecondPart = quoted;
                } else {
                    this.buffer.append(quoted);
                }
                this.prevcp = 65;
            }
        }

        @Override
        public void doubleQuoted(int index, String quoted) {
            if (this.contextHandler != null) {
                this.contextHandler.doubleQuoted(index, quoted);
            } else if (this.stage == 5) {
                this.buffer.append('\"').append(quoted).append('\"');
            } else {
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = quoted;
                    if (this.stage == 38) {
                        this.stage = (byte)40;
                    }
                } else if (this.ruleSecondPart == null) {
                    this.ruleSecondPart = quoted;
                } else {
                    this.buffer.append(quoted);
                }
                this.prevcp = 65;
            }
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.openGroup(index, codepoint);
            } else {
                if (codepoint == 123) {
                    ++this.curlyBracketDepth;
                    if (this.stage == 2) {
                        if (this.ruleType == 4) {
                            if (this.parendepth == 0) {
                                if (this.buffer.length() != 0) {
                                    this.medialist = this.newMediaList(this.buffer.toString());
                                    this.buffer.setLength(0);
                                } else {
                                    this.medialist = this.newMediaListAll();
                                }
                                CSSParser.this.handler.startMedia(this.medialist.getMediaList());
                                this.contextHandler = this.selectorHandler;
                                this.selectorHandler.prevcp = 32;
                            } else {
                                this.handleError(index - this.buffer.length(), (byte)9, "Bad media query at @media rule: <" + this.buffer.toString() + ">");
                                if (this.medialist != null) {
                                    this.medialist = this.medialist.getParent();
                                }
                                if (this.medialist == null) {
                                    this.ruleType = 0;
                                    this.stage = 0;
                                }
                                --this.curlyBracketDepth;
                                this.parendepth = 0;
                                this.contextHandler = new IgnoredDeclarationTokenHandler();
                            }
                        } else if (this.curlyBracketDepth == 1) {
                            if (this.ruleType == 5) {
                                if (this.buffer.length() != 0) {
                                    this.handleError(index - this.buffer.length(), (byte)9, "Unexpected token in @font-face rule: " + this.buffer.toString());
                                } else {
                                    CSSParser.this.handler.startFontFace();
                                    this.declarationHandler.curlyBracketDepth = 1;
                                    this.contextHandler = this.declarationHandler;
                                    --this.curlyBracketDepth;
                                }
                            } else if (this.ruleType == 6) {
                                this.processBufferPageRule(index);
                                CSSParser.this.handler.startPage(this.ruleFirstPart, this.ruleSecondPart);
                                this.declarationHandler.curlyBracketDepth = 1;
                                this.contextHandler = this.declarationHandler;
                                --this.curlyBracketDepth;
                            } else if (this.ruleType == 9) {
                                if (this.buffer.length() != 0) {
                                    this.handleError(index - this.buffer.length(), (byte)9, "Unexpected token in margin rule: " + this.buffer.toString());
                                } else {
                                    this.declarationHandler.curlyBracketDepth = 1;
                                    this.contextHandler = this.declarationHandler;
                                }
                                --this.curlyBracketDepth;
                            }
                            this.buffer.setLength(0);
                        }
                    } else if (this.stage == 8 && this.curlyBracketDepth == 2) {
                        this.processBufferPageRule(index);
                        CSSParser.this.handler.startPage(this.ruleFirstPart, this.ruleSecondPart);
                        this.declarationHandler.curlyBracketDepth = 1;
                        this.contextHandler = this.declarationHandler;
                        --this.curlyBracketDepth;
                    } else {
                        this.buffer.append('{');
                    }
                } else if (codepoint == 40) {
                    this.parendepth = (short)(this.parendepth + 1);
                    if (this.stage == 35) {
                        if (this.bufferEquals("url")) {
                            this.stage = (byte)36;
                        } else {
                            this.handleError(index, (byte)4, "Unexpected '(' after " + this.buffer.toString());
                        }
                    } else if (this.stage == 38) {
                        if (this.bufferEquals("url")) {
                            this.stage = (byte)39;
                        } else {
                            this.handleError(index, (byte)4, "Unexpected '(' after " + this.buffer.toString());
                        }
                    } else if (this.stage == 34) {
                        if (this.bufferEquals("url")) {
                            this.ruleFirstPart = "";
                            this.stage = (byte)36;
                        } else {
                            this.handleError(index, (byte)4, "Unexpected '(' after " + this.buffer.toString());
                        }
                    } else {
                        this.buffer.append('(');
                    }
                } else {
                    this.buffer.append(Character.toChars(codepoint));
                }
                this.prevcp = codepoint;
            }
        }

        @Override
        public void closeGroup(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.closeGroup(index, codepoint);
            } else {
                if (codepoint == 125) {
                    --this.curlyBracketDepth;
                    this.buffer.append('}');
                    if (this.curlyBracketDepth == 0) {
                        CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                        this.buffer.setLength(0);
                        this.stage = 0;
                        this.endRuleBody();
                    } else if (this.curlyBracketDepth == 1 && this.stage == 7) {
                        CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                        this.buffer.setLength(0);
                        this.stage = (byte)2;
                        this.switchContextToStage2();
                    }
                } else if (codepoint == 41) {
                    this.parendepth = (short)(this.parendepth - 1);
                    if (this.stage == 36) {
                        this.processBuffer(index);
                        this.stage = (byte)37;
                    } else if (this.stage == 39) {
                        this.processBuffer(index);
                        this.stage = (byte)40;
                    } else {
                        this.buffer.append(')');
                    }
                } else {
                    this.buffer.append(Character.toChars(codepoint));
                }
                this.prevcp = codepoint;
            }
        }

        protected void endRuleBody() {
            this.contextHandler = this.selectorHandler;
            this.selectorHandler.prevcp = 32;
        }

        private void switchContextToStage2() {
            if (this.ruleType == 4) {
                this.contextHandler = this.selectorHandler;
                this.selectorHandler.prevcp = 32;
            } else if (this.ruleType == 5) {
                this.declarationHandler.curlyBracketDepth = 1;
                this.contextHandler = this.declarationHandler;
            } else if (this.ruleType == 6) {
                this.declarationHandler.curlyBracketDepth = 1;
                this.contextHandler = this.declarationHandler;
            } else if (this.ruleType == 9) {
                this.declarationHandler.curlyBracketDepth = 1;
                this.contextHandler = this.declarationHandler;
            }
        }

        @Override
        public void character(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.character(index, codepoint);
            } else {
                if (codepoint == 59) {
                    if (this.curlyBracketDepth == 0) {
                        if (this.parendepth == 0) {
                            this.endOfAtRule(index);
                        } else {
                            this.handleError(index, (byte)6, "Unmatched parentheses in rule.");
                            this.resetRuleState();
                        }
                        this.contextHandler = this.selectorHandler;
                    } else {
                        this.buffer.append(';');
                    }
                } else if (this.ruleType == 6) {
                    if (codepoint == 44) {
                        this.processBufferPageRule(index);
                    } else {
                        if (codepoint == 58 && (this.prevcp == 44 || this.prevcp == 32)) {
                            this.buffer.append(':');
                            return;
                        }
                        this.handleError(index, (byte)4, "Unexpected char " + new String(Character.toChars(codepoint)));
                    }
                } else {
                    this.buffer.append(Character.toChars(codepoint));
                }
                this.prevcp = codepoint;
            }
        }

        private void endOfAtRule(int index) {
            this.processBuffer(index);
            if (this.buffer.length() != 0) {
                this.handleError(index, (byte)9, "Malformed @-rule, unexpected <" + this.buffer.toString() + ">");
            }
            if (this.stage == 40 || this.stage == 38) {
                this.medialist = this.ruleSecondPart != null ? this.newMediaList(this.ruleSecondPart) : null;
                if (this.ruleFirstPart != null) {
                    if (this.medialist == null) {
                        this.medialist = this.newMediaListAll();
                    }
                    CSSParser.this.handler.importStyle(this.ruleFirstPart, this.medialist.getMediaList(), null);
                } else if (!this.parseError) {
                    this.handleError(index, (byte)33, "Malformed @-rule");
                }
            } else if (this.stage == 35 || this.stage == 37) {
                if (this.ruleSecondPart != null) {
                    this.namespaceDeclaration(this.ruleFirstPart, this.ruleSecondPart);
                } else {
                    this.handleError(index, (byte)33, "Empty URI in namespace rule");
                }
            } else if (this.stage == 34) {
                this.namespaceDeclaration("", this.ruleFirstPart);
            } else if (this.stage == 36) {
                this.handleError(index, (byte)33, "Bad URI in namespace rule");
            }
            this.resetRuleState();
        }

        private SACMediaListWrapper newMediaListAll() {
            return new SACMediaListWrapper(new MySACAllMediaList(), this.medialist);
        }

        private SACMediaListWrapper newMediaList(String media) {
            return new SACMediaListWrapper(CSSParser.parseMediaList(media), this.medialist);
        }

        void namespaceDeclaration(String prefix, String uri) {
            CSSParser.this.handler.namespaceDeclaration(prefix, uri);
            this.selectorHandler.factory.registerNamespacePrefix(prefix, uri);
        }

        void resetRuleState() {
            this.parseError = false;
            if (this.medialist != null) {
                this.medialist = this.medialist.getParent();
                if (this.medialist == null) {
                    this.stage = 0;
                }
            } else {
                this.stage = 0;
            }
            this.ruleFirstPart = null;
            this.ruleSecondPart = null;
            this.prevcp = 32;
            this.buffer.setLength(0);
        }

        private void processBufferPageRule(int index) {
            int buflen = this.buffer.length();
            if (buflen != 0) {
                if (this.buffer.charAt(0) == ':') {
                    if (buflen == 1) {
                        this.handleError(index - buflen, (byte)4, "Character ':' must always precede an identifier in page rule preludes");
                    } else {
                        this.ruleSecondPart = this.ruleSecondPart == null ? this.buffer.toString() : new StringBuilder(this.ruleSecondPart.length() + buflen).append(this.ruleSecondPart).append(',').append((CharSequence)this.buffer).toString();
                    }
                } else if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = this.buffer.toString();
                } else {
                    this.handleError(index - buflen, (byte)9, "Unexpected identifier at page rule: " + this.buffer.toString());
                }
                this.buffer.setLength(0);
            }
        }

        private void processBuffer(int index) {
            if (this.buffer.length() != 0) {
                this.trimBufferTail();
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = this.buffer.toString();
                    this.buffer.setLength(0);
                } else if (this.ruleSecondPart == null) {
                    this.ruleSecondPart = this.buffer.toString();
                    this.buffer.setLength(0);
                }
            }
        }

        private void trimBufferTail() {
            if (this.buffer.charAt(this.buffer.length() - 1) == ' ') {
                this.buffer.setLength(this.buffer.length() - 1);
            }
        }

        private boolean bufferEquals(String word) {
            if (word.equals(this.buffer.toString().toLowerCase(Locale.US))) {
                this.buffer.setLength(0);
                return true;
            }
            return false;
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.escaped(index, codepoint);
            } else {
                this.buffer.append('\\').append(Character.toChars(codepoint));
            }
            this.prevcp = 65;
        }

        @Override
        public void endOfStream(int len) {
            if (this.contextHandler != null) {
                this.contextHandler.endOfStream(len);
            } else {
                if (this.ruleType == 9) {
                    CSSParser.this.handler.endPage(this.marginRule, null);
                    this.ruleType = (byte)6;
                }
                if (this.ruleType == 6) {
                    this.processBufferPageRule(len);
                    CSSParser.this.handler.endPage(this.ruleFirstPart, this.ruleSecondPart);
                    if (this.stage == 8) {
                        CSSParser.this.handler.endMedia(this.medialist.getMediaList());
                    }
                } else if (this.stage != 0 && !this.parseError) {
                    if (this.curlyBracketDepth == 0) {
                        this.endOfAtRule(len);
                    } else if (this.buffer.length() != 0) {
                        do {
                            --this.curlyBracketDepth;
                            this.buffer.append('}');
                        } while (this.curlyBracketDepth > 0);
                        CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                        this.handleError(len, (byte)10, "Unexpected end of stream");
                    }
                }
            }
            this.endDocument();
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (this.stage == 5) {
                this.buffer.append("/*").append(comment).append("*/");
            } else {
                super.commented(index, commentType, comment);
            }
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            super.error(index, errCode, context);
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            super.handleError(index, errCode, message);
            this.buffer.setLength(0);
            this.stage = (byte)127;
        }

        private class IgnoredDeclarationTokenHandler
        extends CSSTokenHandler {
            private int curlyBracketDepth;

            IgnoredDeclarationTokenHandler() {
                super(null);
                this.curlyBracketDepth = 1;
            }

            @Override
            public void word(int index, String word) {
            }

            @Override
            public void separator(int index, int codePoint) {
            }

            @Override
            public void singleQuoted(int index, String quoted) {
            }

            @Override
            public void doubleQuoted(int index, String quoted) {
            }

            @Override
            public void openGroup(int index, int codePoint) {
                if (codePoint == 123) {
                    ++this.curlyBracketDepth;
                }
            }

            @Override
            public void closeGroup(int index, int codePoint) {
                if (codePoint == 125) {
                    --this.curlyBracketDepth;
                    if (this.curlyBracketDepth == 0) {
                        SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                        SheetTokenHandler.this.selectorHandler.prevcp = 32;
                        SheetTokenHandler.this.selectorHandler.parseError = false;
                        SheetTokenHandler.this.selectorHandler.stage = 0;
                        SheetTokenHandler.this.prevcp = 125;
                    }
                }
            }

            @Override
            public void character(int index, int codePoint) {
            }

            @Override
            public void escaped(int index, int codePoint) {
            }

            @Override
            public void endOfStream(int len) {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }
        }

        class MyDeclarationTokenHandler
        extends DeclarationTokenHandler {
            MyDeclarationTokenHandler(InputSource source) {
                super(source);
            }

            @Override
            protected void handleRightCurlyBracket(int index) {
                SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                SheetTokenHandler.this.selectorHandler.parseError = false;
                SheetTokenHandler.this.selectorHandler.prevcp = 32;
                SheetTokenHandler.this.selectorHandler.stage = 0;
                SheetTokenHandler.this.prevcp = 125;
                if (SheetTokenHandler.this.ruleType == 5) {
                    CSSParser.this.handler.endFontFace();
                    SheetTokenHandler.this.ruleType = (byte)0;
                    SheetTokenHandler.this.stage = (byte)0;
                } else if (SheetTokenHandler.this.ruleType == 6) {
                    CSSParser.this.handler.endPage(SheetTokenHandler.this.ruleFirstPart, SheetTokenHandler.this.ruleSecondPart);
                    SheetTokenHandler.this.ruleFirstPart = null;
                    SheetTokenHandler.this.ruleSecondPart = null;
                    if (SheetTokenHandler.this.stage == 8) {
                        SheetTokenHandler.this.ruleType = (byte)4;
                        this.buffer.setLength(0);
                        SheetTokenHandler.this.stage = (byte)2;
                        SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                        SheetTokenHandler.this.selectorHandler.prevcp = 32;
                    } else {
                        SheetTokenHandler.this.ruleType = (byte)0;
                        SheetTokenHandler.this.stage = (byte)0;
                    }
                } else if (SheetTokenHandler.this.ruleType == 9) {
                    CSSParser.this.handler.endPage(SheetTokenHandler.this.marginRule, null);
                    SheetTokenHandler.this.ruleType = (byte)6;
                    SheetTokenHandler.this.marginRule = null;
                    SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.declarationHandler;
                    SheetTokenHandler.this.declarationHandler.curlyBracketDepth = 1;
                } else {
                    CSSParser.this.handler.endSelector((SelectorList)SheetTokenHandler.this.selectorHandler.selist);
                    SheetTokenHandler.this.selectorHandler.selist = new SelectorListImpl();
                }
            }

            @Override
            protected void handleAtKeyword(int index) {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.prevcp = 64;
            }

            @Override
            protected void badPropertyName(int index, int codepoint) {
                if (this.buffer.length() == 0 && codepoint == 42 && CSSParser.this.parserFlags.contains((Object)Parser2.Flag.STARHACK)) {
                    if (CSSParser.this.errorHandler != null) {
                        CSSParser.this.errorHandler.warning(this.createException(index, (byte)4, "Unexpected character: * (IE hack)"));
                    }
                    this.buffer.append('*');
                } else {
                    this.unexpectedCharError(index, codepoint);
                }
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }

        private class MySelectorTokenHandler
        extends SelectorTokenHandler {
            MySelectorTokenHandler(InputSource source, Parser2.NamespaceMap nsMap) {
                super(source, nsMap);
            }

            @Override
            protected void handleLeftCurlyBracket(int index) {
                SheetTokenHandler.this.declarationHandler.curlyBracketDepth = 1;
                SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.declarationHandler;
                if (!this.parseError) {
                    SheetTokenHandler.this.selectorHandler.processBuffer(index, true);
                    if (!this.parseError) {
                        if (this.addCurrentSelector()) {
                            CSSParser.this.handler.startSelector((SelectorList)this.selist);
                        } else {
                            this.unexpectedCharError(index, 123);
                        }
                    }
                }
                this.stage = 0;
                if (this.parseError) {
                    this.buffer.setLength(0);
                    this.ignoreRule();
                }
            }

            private void ignoreRule() {
                this.selist.clear();
                this.currentsel = null;
                SheetTokenHandler.this.contextHandler = new IgnoredDeclarationTokenHandler();
            }

            @Override
            protected void handleRightCurlyBracket(int index) {
                if (SheetTokenHandler.this.stage == 2) {
                    this.stage = 0;
                    byte ruleType = SheetTokenHandler.this.ruleType;
                    if (ruleType == 4) {
                        CSSParser.this.handler.endMedia(SheetTokenHandler.this.medialist.getMediaList());
                        SheetTokenHandler.this.medialist = SheetTokenHandler.this.medialist.getParent();
                        if (SheetTokenHandler.this.medialist == null) {
                            this.resetSelectorHandler(true);
                        } else {
                            this.resetSelectorHandler(false);
                        }
                        return;
                    }
                    if (SheetTokenHandler.this.curlyBracketDepth == 1) {
                        this.resetSelectorHandler(true);
                        return;
                    }
                }
                this.handleError(index, (byte)4, "Unexpected '}'");
            }

            private void resetSelectorHandler(boolean resetSheetStage) {
                SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                SheetTokenHandler.this.selectorHandler.prevcp = 32;
                this.parseError = false;
                this.buffer.setLength(0);
                this.currentsel = null;
                SheetTokenHandler.this.curlyBracketDepth--;
                if (resetSheetStage) {
                    SheetTokenHandler.this.ruleType = (byte)0;
                    SheetTokenHandler.this.stage = (byte)0;
                }
            }

            @Override
            protected void handleAtKeyword(int index) {
                if (this.stage > 0) {
                    this.unexpectedCharError(index, 64);
                }
                if (this.stage == 0 || SheetTokenHandler.this.curlyBracketDepth == 0) {
                    this.stage = 0;
                    this.parseError = false;
                    SheetTokenHandler.this.contextHandler = null;
                    SheetTokenHandler.this.prevcp = 64;
                    SheetTokenHandler.this.buffer.append('@');
                }
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            public void endOfStream(int len) {
                if (this.buffer.length() != 0) {
                    this.handleError(len, (byte)10, "Unexpected end of stream");
                }
                this.endDocument();
            }

            @Override
            protected void handleError(int index, byte errCode, String message) {
                this.stage = (byte)127;
                if (!this.parseError) {
                    if (CSSParser.this.errorHandler != null) {
                        if (this.prevcp == this.endcp) {
                            CSSParser.this.errorHandler.error(this.createException(index, errCode, "Expected end of file"));
                        } else {
                            CSSParser.this.errorHandler.error(this.createException(index, errCode, message));
                        }
                    }
                    this.parseError = true;
                }
                this.selist.clear();
                this.buffer.setLength(0);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }
    }

    private class RuleTokenHandler
    extends SheetTokenHandler {
        RuleTokenHandler(InputSource source, Parser2.NamespaceMap nsMap) {
            super(source, nsMap);
        }

        @Override
        protected void endRuleBody() {
            this.contextHandler = new RuleEndContentHandler();
        }

        @Override
        protected void resetRuleState() {
            super.resetRuleState();
            this.contextHandler = new RuleEndContentHandler();
        }

        @Override
        void endDocument() {
        }

        private class RuleEndContentHandler
        extends CSSTokenHandler {
            RuleEndContentHandler() {
                super(null);
            }

            @Override
            public void word(int index, String word) {
                this.reportError(index);
            }

            @Override
            public void separator(int index, int codePoint) {
            }

            @Override
            public void singleQuoted(int index, String quoted) {
                this.reportError(index);
            }

            @Override
            public void doubleQuoted(int index, String quoted) {
                this.reportError(index);
            }

            @Override
            public void openGroup(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            public void closeGroup(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            public void character(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            public void escaped(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            public void control(int index, int codePoint) {
            }

            @Override
            public void commented(int index, int commentType, String comment) {
            }

            @Override
            public void endOfStream(int len) {
            }

            @Override
            public void error(int index, byte errCode, CharSequence context) {
                this.handleError(index, (byte)9, "Found tokens after rule");
            }

            private void reportError(int index) {
                this.handleError(index, (byte)9, "Found tokens after rule");
            }

            @Override
            protected void handleError(int index, byte errCode, String message) {
                if (!this.parseError && CSSParser.this.errorHandler != null) {
                    CSSParser.this.errorHandler.fatalError(this.createException(index, errCode, message));
                }
                this.parseError = true;
            }
        }
    }

    private class FontFeatureValuesTH
    extends NestedRuleTH {
        FontFeatureValuesTH(int offset, int bufSize) {
            super(offset, bufSize, "@font-feature-values", false);
        }

        @Override
        void processSelector(int index, String selector) {
            if (selector.length() > 1 && selector.charAt(0) == '@') {
                ((FontFeatureValuesHandler)CSSParser.this.handler).startFeatureMap(selector.substring(1).trim());
            } else {
                this.handleError(index, (byte)33, "Bad feature name: " + selector);
            }
        }

        @Override
        void processName(int index, String name) {
            ((FontFeatureValuesHandler)CSSParser.this.handler).startFontFeatures(name);
        }

        @Override
        void endBlock() {
            ((FontFeatureValuesHandler)CSSParser.this.handler).endFeatureMap();
        }

        @Override
        void endBlockList() {
            ((FontFeatureValuesHandler)CSSParser.this.handler).endFontFeatures();
        }

        @Override
        boolean isValidSelectorCharacter(int codePoint) {
            return codePoint == 64;
        }

        @Override
        boolean isValidNameCharacter(int codePoint) {
            return codePoint == 45;
        }
    }

    private class KeyFrameBlockListTH
    extends NestedRuleTH {
        KeyFrameBlockListTH(int offset, int bufSize) {
            super(offset, bufSize, "@keyframes", true);
        }

        @Override
        void processSelector(int index, String selector) {
            InputSource source = new InputSource((Reader)new StringReader(selector));
            try {
                LexicalUnit kfsel = CSSParser.this.parsePropertyValue(source);
                ((KeyframesHandler)CSSParser.this.handler).startKeyframe(kfsel);
            }
            catch (CSSException e) {
                this.handleError(index, (byte)5, e.getMessage());
                this.setStage((byte)9);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        void processName(int index, String name) {
            ((KeyframesHandler)CSSParser.this.handler).startKeyframes(name);
        }

        @Override
        void endBlock() {
            ((KeyframesHandler)CSSParser.this.handler).endKeyframe();
        }

        @Override
        void endBlockList() {
            ((KeyframesHandler)CSSParser.this.handler).endKeyframes();
        }

        @Override
        boolean isValidSelectorCharacter(int codePoint) {
            return codePoint == 37 || codePoint == 44 || codePoint == 46;
        }

        @Override
        boolean isValidNameCharacter(int codePoint) {
            return false;
        }
    }

    abstract class NestedRuleTH
    extends CSSTokenHandler {
        private final String blockRuleName;
        private final boolean singleName;
        private int offset;
        private StringBuilder buffer;
        private byte stage;
        private int curlyBracketDepth;
        private DeclarationTokenHandler declarationHandler;
        private static final byte STAGE_WAIT_NAME = 1;
        private static final byte STAGE_WAIT_BLOCK_LIST = 2;
        private static final byte STAGE_WAIT_SELECTOR = 3;
        private static final byte STAGE_FOUND_SELECTOR = 4;
        private static final byte STAGE_DECLARATION_LIST = 5;
        private static final byte STAGE_END_BLOCK_LIST = 6;
        static final byte STAGE_SELECTOR_ERROR = 9;

        NestedRuleTH(int offset, int bufSize, String blockRuleName, boolean singleName) {
            super(null);
            this.stage = 1;
            this.curlyBracketDepth = 0;
            this.offset = offset;
            this.blockRuleName = blockRuleName;
            this.singleName = singleName;
            this.declarationHandler = new NestedRuleDeclarationTokenHandler();
            this.buffer = new StringBuilder(bufSize);
        }

        void setStage(byte stage) {
            this.stage = stage;
        }

        @Override
        public void word(int index, String word) {
            if (this.stage == 5) {
                this.declarationHandler.word(index, word);
            } else if (this.stage == 2 || this.stage == 6) {
                this.handleError(index, (byte)9, "Unexpected: " + word);
            } else if (!this.parseError) {
                this.buffer.append(word);
                if (this.stage == 3) {
                    this.stage = (byte)4;
                }
                this.prevcp = 65;
            }
        }

        @Override
        public void separator(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.separator(index, codePoint);
            } else {
                if (this.buffer.length() != 0 && this.prevcp != 32) {
                    this.buffer.append(' ');
                }
                this.prevcp = 32;
            }
        }

        @Override
        public void singleQuoted(int index, String quoted) {
            if (this.stage == 5) {
                this.declarationHandler.singleQuoted(index, quoted);
            } else if (this.stage == 1) {
                if (this.singleName) {
                    if (this.buffer.length() == 0) {
                        this.buffer.append(quoted);
                        this.stage = (byte)2;
                        this.prevcp = 65;
                    } else {
                        this.handleError(index, (byte)9, this.blockRuleName + " name must be a single identifier or string");
                    }
                } else {
                    this.buffer.append('\'').append(quoted).append('\'');
                }
            } else {
                this.handleError(index, (byte)9, "Expected " + this.blockRuleName + " selector, found '" + quoted + "'");
            }
        }

        @Override
        public void doubleQuoted(int index, String quoted) {
            if (this.stage == 5) {
                this.declarationHandler.doubleQuoted(index, quoted);
            } else if (this.stage == 1 && !this.singleName) {
                this.buffer.append('\"').append(quoted).append('\"');
                this.prevcp = 65;
            } else {
                this.singleQuoted(index, quoted);
            }
        }

        @Override
        public void openGroup(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.openGroup(index, codePoint);
                if (codePoint == 123) {
                    ++this.curlyBracketDepth;
                }
            } else {
                if (codePoint == 123) {
                    ++this.curlyBracketDepth;
                    if (this.stage == 1 || this.stage == 2) {
                        if (this.buffer.length() != 0) {
                            this.processName(index, this.buffer.toString().trim());
                            this.buffer.setLength(0);
                            this.prevcp = codePoint;
                            this.stage = (byte)3;
                        } else {
                            this.handleError(index, (byte)4, this.blockRuleName + " must have a name.");
                        }
                    } else if (this.stage == 4) {
                        this.processSelector(index, this.buffer.toString());
                        this.buffer.setLength(0);
                        this.prevcp = codePoint;
                        this.declarationHandler.curlyBracketDepth = 1;
                        this.stage = (byte)5;
                    }
                    return;
                }
                this.handleError(index, (byte)4, "Unexpected char: " + new String(Character.toChars(codePoint)));
            }
        }

        abstract void processName(int var1, String var2);

        abstract void processSelector(int var1, String var2);

        abstract void endBlock();

        abstract void endBlockList();

        @Override
        public void closeGroup(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.closeGroup(index, codePoint);
                if (codePoint == 125) {
                    --this.curlyBracketDepth;
                    if (this.curlyBracketDepth == 1) {
                        this.endBlock();
                        this.stage = (byte)3;
                    }
                }
                this.prevcp = codePoint;
            } else {
                if (codePoint == 125) {
                    --this.curlyBracketDepth;
                    if (this.curlyBracketDepth == 0) {
                        this.endBlockList();
                        this.stage = (byte)6;
                        this.prevcp = codePoint;
                    } else if (this.curlyBracketDepth == 1 && this.stage == 9) {
                        this.stage = (byte)3;
                        this.parseError = false;
                    }
                    return;
                }
                this.handleError(index, (byte)4, "Unexpected char: " + new String(Character.toChars(codePoint)));
            }
        }

        @Override
        public void character(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.character(index, codePoint);
            } else {
                char[] chars = Character.toChars(codePoint);
                if (this.stage == 3 || this.stage == 4) {
                    if (this.isValidSelectorCharacter(codePoint)) {
                        this.buffer.append(chars);
                        this.prevcp = codePoint;
                        return;
                    }
                    this.stage = (byte)9;
                } else if (this.stage == 1 && (this.isValidNameCharacter(codePoint) || !this.singleName && codePoint == 44)) {
                    this.buffer.append(chars);
                    this.prevcp = codePoint;
                    return;
                }
                this.handleError(index, (byte)4, "Unexpected char: " + new String(chars));
            }
        }

        abstract boolean isValidSelectorCharacter(int var1);

        abstract boolean isValidNameCharacter(int var1);

        @Override
        public void escaped(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.escaped(index, codePoint);
            } else {
                char[] chars = Character.toChars(codePoint);
                if (this.stage == 2 || this.stage == 6) {
                    this.handleError(index, (byte)9, "Unexpected: " + new String(chars));
                } else if (!this.parseError) {
                    this.buffer.append(chars);
                    if (this.stage == 3) {
                        this.stage = (byte)4;
                    }
                    this.prevcp = 65;
                }
            }
        }

        @Override
        public void endOfStream(int len) {
            if (this.curlyBracketDepth != 0) {
                if (this.stage == 5) {
                    this.declarationHandler.endOfStream(len);
                } else if (this.stage == 6) {
                    return;
                }
                this.handleError(len, (byte)10, "Unexpected end of " + this.blockRuleName + " rule.");
            }
        }

        @Override
        public void control(int index, int codepoint) {
            super.control(this.offset + index, codepoint);
        }

        @Override
        CSSParseException createException(int index, byte errCode, String message) {
            return super.createException(this.offset + index, errCode, message);
        }

        private class NestedRuleDeclarationTokenHandler
        extends DeclarationTokenHandler {
            private NestedRuleDeclarationTokenHandler() {
                super(null);
            }

            @Override
            protected void handleRightCurlyBracket(int index) {
                this.prevcp = 32;
                NestedRuleTH.this.stage = (byte)3;
                NestedRuleTH.this.prevcp = 125;
            }

            @Override
            public void control(int index, int codepoint) {
                NestedRuleTH.this.control(index, codepoint);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return NestedRuleTH.this.createException(index, errCode, message);
            }
        }
    }

    private static class SACMediaListWrapper {
        private SACMediaList mediaList;
        private SACMediaListWrapper parent;

        SACMediaListWrapper(SACMediaList mediaList, SACMediaListWrapper parent) {
            this.mediaList = mediaList;
            this.parent = parent;
        }

        public SACMediaList getMediaList() {
            return this.mediaList;
        }

        SACMediaListWrapper getParent() {
            return this.parent;
        }

        public String toString() {
            return this.mediaList != null ? this.mediaList.toString() : "";
        }
    }

    private static class MySACAllMediaList
    implements SACMediaList {
        MySACAllMediaList() {
        }

        public int getLength() {
            return 1;
        }

        public String item(int index) {
            if (index != 0) {
                return null;
            }
            return "all";
        }

        public String toString() {
            return "all";
        }
    }

    private static class MySACMediaList
    implements SACMediaList {
        String[] list;

        MySACMediaList(String[] list) {
            this.list = list;
        }

        public int getLength() {
            return this.list.length;
        }

        public String item(int index) {
            if (index < 0 || index >= this.list.length) {
                return null;
            }
            return this.list[index].trim();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.list.length != 0) {
                buf.append(this.list[0].trim());
            }
            for (int i = 1; i < this.list.length; ++i) {
                buf.append(',').append(this.list[i].trim());
            }
            return buf.toString();
        }
    }

    class SupportsTokenHandler
    extends CSSTokenHandler {
        SupportsCondition currentCond;
        StringBuilder buffer;
        int prevcp;
        short parendepth;
        boolean readingValue;
        byte errorCode;
        CSSParseException errorException;

        SupportsTokenHandler() {
            super(null);
            this.currentCond = null;
            this.buffer = new StringBuilder(64);
            this.prevcp = 0;
            this.parendepth = 0;
            this.readingValue = false;
            this.errorCode = 0;
            this.errorException = null;
        }

        @Override
        public void word(int index, String word) {
            String lctoken = word.toLowerCase(Locale.US);
            if ("not".equals(lctoken)) {
                SupportsConditionImpl.NotCondition newCond = new SupportsConditionImpl.NotCondition();
                if (this.currentCond != null) {
                    this.currentCond.addCondition(newCond);
                }
                this.currentCond = newCond;
            } else if ("and".equals(lctoken)) {
                if (this.currentCond != null) {
                    if (this.currentCond.getType() != SupportsCondition.ConditionType.AND_CONDITION || this.currentCond.getType() == SupportsCondition.ConditionType.DECLARATION_CONDITION) {
                        SupportsConditionImpl.AndCondition newCond = new SupportsConditionImpl.AndCondition();
                        if (this.parendepth == 0) {
                            newCond.addCondition(this.currentCond);
                        } else if (this.parendepth >= 1) {
                            SupportsCondition cond = this.currentCond.getParent(this.parendepth);
                            SupportsCondition oldCond = cond.replaceLast(newCond);
                            newCond.addCondition(oldCond);
                        } else {
                            newCond.addCondition(this.currentCond);
                        }
                        this.currentCond = newCond;
                    }
                } else {
                    this.currentCond = new SupportsConditionImpl.AndCondition();
                }
            } else if ("or".equals(lctoken)) {
                if (this.currentCond != null) {
                    if (this.currentCond.getType() != SupportsCondition.ConditionType.OR_CONDITION || this.currentCond.getType() == SupportsCondition.ConditionType.DECLARATION_CONDITION) {
                        SupportsConditionImpl.OrCondition newCond = new SupportsConditionImpl.OrCondition();
                        if (this.parendepth == 0) {
                            newCond.addCondition(this.currentCond);
                        } else if (this.parendepth >= 1) {
                            SupportsCondition cond = this.currentCond.getParent(this.parendepth);
                            SupportsCondition oldCond = cond.replaceLast(newCond);
                            newCond.addCondition(oldCond);
                        } else {
                            newCond.addCondition(this.currentCond);
                        }
                        this.currentCond = newCond;
                    }
                } else {
                    this.currentCond = new SupportsConditionImpl.OrCondition();
                }
            } else {
                if (this.prevcp == 58) {
                    this.readingValue = true;
                }
                if (this.buffer.length() != 0) {
                    this.buffer.append(' ');
                }
                this.buffer.append(word);
            }
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (codepoint == 40) {
                this.parendepth = (short)(this.parendepth + 1);
            }
        }

        @Override
        public void closeGroup(int index, int codepoint) {
            if (codepoint == 41) {
                this.parendepth = (short)(this.parendepth - 1);
                if (this.buffer.length() != 0) {
                    if (this.readingValue) {
                        ValueFactory factory = new ValueFactory();
                        AbstractCSSValue value = factory.parseProperty(this.buffer.toString());
                        ((SupportsConditionImpl.DeclarationCondition)this.currentCond).setValue(value);
                        this.readingValue = false;
                    } else {
                        this.error(index, (byte)4, this.buffer.toString());
                    }
                    this.buffer.setLength(0);
                }
                if (this.currentCond != null && this.currentCond.getParentCondition() != null) {
                    this.currentCond = this.currentCond.getParentCondition();
                }
            }
        }

        @Override
        public void character(int index, int codepoint) {
            if (codepoint == 58) {
                SupportsCondition newCond = SupportsConditionImpl.createDeclarationCondition(this.buffer.toString());
                if (this.currentCond != null) {
                    this.currentCond.addCondition(newCond);
                }
                this.currentCond = newCond;
                this.buffer.setLength(0);
            } else if (codepoint == 33) {
                this.buffer.append('!');
            } else if (codepoint == 59) {
                this.error(index, (byte)4, ";");
            } else {
                this.buffer.append(Character.toChars(codepoint));
            }
            this.prevcp = codepoint;
        }

        @Override
        public void singleQuoted(int index, String quoted) {
            if (this.buffer.length() != 0) {
                this.buffer.append(' ');
            }
            this.buffer.append('\'').append(quoted).append('\'');
        }

        @Override
        public void doubleQuoted(int index, String quoted) {
            if (this.buffer.length() != 0) {
                this.buffer.append(' ');
            }
            this.buffer.append('\"').append(quoted).append('\"');
        }

        @Override
        public void escaped(int index, int codepoint) {
            this.buffer.append('\\').append(Character.toChars(codepoint));
        }

        @Override
        public void separator(int index, int cp) {
        }

        @Override
        public void control(int index, int codepoint) {
        }

        @Override
        public void commented(int index, int commentType, String comment) {
        }

        @Override
        public void endOfStream(int len) {
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            if (this.errorCode == 0) {
                this.errorCode = errCode;
                this.errorException = this.createException(index, errCode, "Error near: " + context.toString());
            }
        }
    }
}

