/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSCalcValue;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.property.AbstractCSSExpression;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.OMCSSFunctionValue;
import io.sf.carte.doc.style.css.property.OperandExpression;
import io.sf.carte.doc.style.css.property.ProductExpression;
import io.sf.carte.doc.style.css.property.SumExpression;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class ExpressionContainerValue
extends AbstractCSSPrimitiveValue
implements CSSCalcValue {
    private AbstractCSSExpression expression = null;

    public ExpressionContainerValue() {
        super((short)101);
    }

    protected ExpressionContainerValue(ExpressionContainerValue copied) {
        super(copied);
        this.expression = copied.expression.clone();
    }

    @Override
    ExpressionLexicalSetter newLexicalSetter() {
        return new ExpressionLexicalSetter();
    }

    private AbstractCSSExpression addOperand(AbstractCSSExpression expression, OperandExpression operand) {
        if (expression == null) {
            expression = operand;
        } else {
            if (expression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                throw new DOMException(5, "Bad expression");
            }
            expression.addExpression(operand);
        }
        return expression;
    }

    protected boolean isInvalidOperand(AbstractCSSPrimitiveValue primi, short lastlutype) {
        return false;
    }

    @Override
    public AbstractCSSExpression getExpression() {
        return this.expression;
    }

    protected String getExpressionValueName() {
        return "";
    }

    @Override
    public String getCssText() {
        String s = this.expression.getCssText();
        StringBuilder buf = new StringBuilder(s.length() + 2);
        buf.append('(').append(s).append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        String s = this.expression.getMinifiedCssText();
        StringBuilder buf = new StringBuilder(s.length() + 2);
        buf.append('(').append(s).append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write('(');
        wri.write(this.expression.getCssText());
        wri.write(')');
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionContainerValue other = (ExpressionContainerValue)obj;
        return !(this.expression == null ? other.expression != null : !this.expression.equals(other.expression));
    }

    @Override
    public ExpressionContainerValue clone() {
        return new ExpressionContainerValue(this);
    }

    class ExpressionLexicalSetter
    extends AbstractCSSPrimitiveValue.LexicalSetter {
        ExpressionLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) throws DOMException {
            this.setLexicalUnitFromSubValues(lunit.getParameters());
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        void setLexicalUnitFromSubValues(LexicalUnit lunit) throws DOMException {
            ExpressionContainerValue.this.expression = this.fillExpressionLevel(lunit, new ValueFactory());
            if (ExpressionContainerValue.this.expression == null) {
                throw new DOMException(12, "Void expression");
            }
        }

        private AbstractCSSExpression fillExpressionLevel(LexicalUnit lu, ValueFactory factory) {
            AbstractCSSExpression expression = null;
            short lastlutype = -1;
            block8: while (lu != null) {
                boolean inverse = false;
                short lutype = lu.getLexicalUnitType();
                switch (lutype) {
                    case 2: {
                        inverse = true;
                    }
                    case 1: {
                        AbstractCSSExpression operation;
                        if (expression == null) {
                            if (inverse) {
                                operation = new SumExpression();
                                operation.nextOperandInverse = true;
                                break;
                            }
                            throw new DOMException(5, "Missing operand");
                        }
                        if (expression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                            operation = new SumExpression();
                            operation.addExpression(expression);
                            operation.nextOperandInverse = inverse;
                            expression = operation;
                            break;
                        }
                        if (expression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                            expression.nextOperandInverse = inverse;
                            break;
                        }
                        AbstractCSSExpression parent = expression.getParentExpression();
                        if (parent == null) {
                            operation = new SumExpression();
                            operation.addExpression(expression);
                            operation.nextOperandInverse = inverse;
                            expression = operation;
                            break;
                        }
                        expression = parent;
                        expression.nextOperandInverse = inverse;
                        break;
                    }
                    case 4: {
                        inverse = true;
                    }
                    case 3: {
                        AbstractCSSExpression operation;
                        if (expression == null) {
                            throw new DOMException(5, "Missing factor");
                        }
                        if (expression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                            operation = new ProductExpression();
                            operation.addExpression(expression);
                            operation.nextOperandInverse = inverse;
                            expression = operation;
                            break;
                        }
                        if (expression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                            operation = new ProductExpression();
                            if (lastlutype != 40) {
                                expression.replaceLastExpression(operation);
                            } else {
                                operation.addExpression(expression);
                            }
                            operation.nextOperandInverse = inverse;
                            expression = operation;
                            break;
                        }
                        expression.nextOperandInverse = inverse;
                        break;
                    }
                    case 40: {
                        LexicalUnit subval = lu.getSubValues();
                        if (subval == null) {
                            throw new DOMException(12, "Empty sub-expression");
                        }
                        AbstractCSSExpression subexpr = this.fillExpressionLevel(subval, factory);
                        if (subexpr != null) {
                            subexpr.setInverseOperation(inverse);
                            if (expression != null) {
                                expression.addExpression(subexpr);
                                if (expression.getPartType() != CSSExpression.AlgebraicPart.SUM) break;
                                expression = subexpr;
                                break;
                            }
                            expression = subexpr;
                            break;
                        }
                        throw new DOMException(5, "Bad subexpression");
                    }
                    case 41: {
                        OperandExpression operand;
                        String funcname = lu.getFunctionName();
                        if (!funcname.equals(ExpressionContainerValue.this.getExpressionValueName())) {
                            lastlutype = lutype;
                            OMCSSFunctionValue function = new OMCSSFunctionValue();
                            AbstractCSSPrimitiveValue.LexicalSetter setter = function.newLexicalSetter();
                            setter.setLexicalUnit(lu);
                            lu = setter.getNextLexicalUnit();
                            operand = new OperandExpression();
                            operand.setOperand(function);
                            expression = ExpressionContainerValue.this.addOperand(expression, operand);
                            continue block8;
                        }
                        lutype = 40;
                        LexicalUnit subval = lu.getParameters();
                        if (subval == null) {
                            throw new DOMException(12, "Empty sub-" + ExpressionContainerValue.this.getExpressionValueName() + "()");
                        }
                        AbstractCSSExpression subexpr = this.fillExpressionLevel(subval, factory);
                        if (subexpr != null) {
                            subexpr.setInverseOperation(inverse);
                            if (expression != null) {
                                expression.addExpression(subexpr);
                                break;
                            }
                            expression = subexpr;
                            break;
                        }
                        throw new DOMException(5, "Bad sub-" + ExpressionContainerValue.this.getExpressionValueName() + "()");
                    }
                    default: {
                        AbstractCSSPrimitiveValue primi;
                        AbstractCSSPrimitiveValue.LexicalSetter item = factory.createCSSPrimitiveValueItem(lu, false);
                        if (item == null || ExpressionContainerValue.this.isInvalidOperand(primi = item.getCSSValue(), lastlutype)) {
                            throw new DOMException(5, "Bad operands");
                        }
                        OperandExpression operand = new OperandExpression();
                        operand.setOperand(primi);
                        expression = ExpressionContainerValue.this.addOperand(expression, operand);
                        lastlutype = lutype;
                        lu = item.getNextLexicalUnit();
                        continue block8;
                    }
                }
                lastlutype = lutype;
                lu = lu.getNextLexicalUnit();
            }
            if (expression.getParentExpression() != null) {
                expression = expression.getParentExpression();
            }
            return expression;
        }
    }
}

