/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.ExtendedCSSValueList;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.LinkedList;
import org.w3c.dom.DOMException;

public class LinkedCSSValueList
extends LinkedList<AbstractCSSValue>
implements ExtendedCSSValueList<AbstractCSSValue> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean add(AbstractCSSValue value) {
        return super.add(value);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public AbstractCSSValue item(int index) {
        return (AbstractCSSValue)this.get(index);
    }

    @Override
    public ExtendedCSSValueList<AbstractCSSValue> clone() {
        LinkedCSSValueList copy = new LinkedCSSValueList();
        copy.addAll(this);
        return copy;
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public String getCssText() {
        if (this.isEmpty()) {
            return "";
        }
        BufferSimpleWriter sw = new BufferSimpleWriter(this.size() * 24 + 16);
        try {
            this.writeCssText(sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(this.size() * 24 + 16);
        buf.append(this.item(0).getMinifiedCssText(propertyName));
        int sz = this.size();
        for (int i = 1; i < sz; ++i) {
            buf.append(',').append(this.item(i).getMinifiedCssText(propertyName));
        }
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        if (!this.isEmpty()) {
            ((AbstractCSSValue)this.get(0)).writeCssText(wri);
            int sz = this.size();
            for (int i = 1; i < sz; ++i) {
                wri.write(',');
                wri.write(' ');
                ((AbstractCSSValue)this.get(i)).writeCssText(wri);
            }
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "This value has to be modified by accessing its elements.");
    }

    @Override
    public short getCssValueType() {
        return 2;
    }
}

