/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSCalcValue;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSPrimitiveValue2;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSUnknownValue;
import io.sf.carte.doc.style.css.property.ExpressionContainerValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Iterator;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class OMCSSFunctionValue
extends AbstractCSSPrimitiveValue
implements CSSFunctionValue {
    private String functionName = null;
    private LinkedCSSValueList arguments = new LinkedCSSValueList();

    public OMCSSFunctionValue() {
        super((short)127);
    }

    protected OMCSSFunctionValue(OMCSSFunctionValue copied) {
        super(copied);
        this.functionName = copied.functionName;
        this.arguments.addAll(copied.arguments);
    }

    public LinkedCSSValueList getArguments() {
        return this.arguments;
    }

    void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    AbstractCSSPrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter sw = new BufferSimpleWriter(this.functionName.length() + this.arguments.size() * 6 + 8);
        try {
            this.writeCssText(sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText(String pname) {
        StringBuilder buf = new StringBuilder(this.functionName.length() + this.arguments.size() * 6 + 8);
        buf.append(this.functionName).append('(');
        int sz = this.arguments.size();
        if (sz > 0) {
            buf.append(((AbstractCSSValue)this.arguments.get(0)).getMinifiedCssText(pname));
            for (int i = 1; i < sz; ++i) {
                buf.append(',').append(((AbstractCSSValue)this.arguments.get(i)).getMinifiedCssText(pname));
            }
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write(this.functionName);
        wri.write('(');
        int sz = this.arguments.size();
        if (sz == 1) {
            AbstractCSSValue first = (AbstractCSSValue)this.arguments.get(0);
            if (first.getCssValueType() == 1 && ((CSSPrimitiveValue2)((Object)first)).getPrimitiveType() == 101) {
                wri.write(((CSSCalcValue)((Object)first)).getExpression().getCssText());
            } else {
                first.writeCssText(wri);
            }
        } else if (sz != 0) {
            ((AbstractCSSValue)this.arguments.get(0)).writeCssText(wri);
            for (int i = 1; i < sz; ++i) {
                wri.write(',');
                wri.write(' ');
                ((AbstractCSSValue)this.arguments.get(i)).writeCssText(wri);
            }
        }
        wri.write(')');
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.functionName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSFunctionValue other = (OMCSSFunctionValue)obj;
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        return !(this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName));
    }

    @Override
    public OMCSSFunctionValue clone() {
        return new OMCSSFunctionValue(this);
    }

    class MyLexicalSetter
    extends AbstractCSSPrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            OMCSSFunctionValue.this.functionName = lunit.getFunctionName();
            LexicalUnit lu = lunit.getParameters();
            ValueFactory factory = new ValueFactory();
            boolean commaSep = false;
            OMCSSValueList list = null;
            while (lu != null) {
                ValueItem item;
                AbstractCSSValue newval;
                short type = lu.getLexicalUnitType();
                if (type == 40) {
                    ExpressionContainerValue expr = new ExpressionContainerValue();
                    ExpressionContainerValue.ExpressionLexicalSetter setter = expr.newLexicalSetter();
                    LexicalUnit nextlex = lu.getNextLexicalUnit();
                    if (nextlex != null) {
                        type = nextlex.getLexicalUnitType();
                        if (type == 4) {
                            setter.setLexicalUnitFromSubValues(lu);
                        } else {
                            setter.setLexicalUnitFromSubValues(lu.getSubValues());
                            setter.nextLexicalUnit = nextlex;
                        }
                    }
                    newval = expr;
                    item = setter;
                } else if (type == 68) {
                    item = factory.parseBracketList(lu.getNextLexicalUnit(), null, false);
                    newval = item.getCSSValue();
                } else if (type == 4) {
                    ValueFactory.BasicValueItem vbi = new ValueFactory.BasicValueItem();
                    vbi.nextLexicalUnit = lu.getNextLexicalUnit();
                    item = vbi;
                    newval = new CSSUnknownValue();
                    newval.setPlainCssText("/");
                } else {
                    item = factory.createCSSPrimitiveValueItem(lu, false);
                    newval = item.getCSSValue();
                }
                lu = item.getNextLexicalUnit();
                if (lu != null) {
                    if (lu.getLexicalUnitType() == 0) {
                        lu = lu.getNextLexicalUnit();
                        if (!commaSep && !OMCSSFunctionValue.this.arguments.isEmpty()) {
                            list = OMCSSValueList.createWSValueList();
                            Iterator it = OMCSSFunctionValue.this.arguments.iterator();
                            while (it.hasNext()) {
                                list.add((AbstractCSSValue)it.next());
                            }
                            list.add(newval);
                            OMCSSFunctionValue.this.arguments.clear();
                            OMCSSFunctionValue.this.arguments.add(list);
                            list = null;
                        } else if (list == null) {
                            OMCSSFunctionValue.this.arguments.add(newval);
                        } else {
                            list.add(newval);
                            list = null;
                        }
                        commaSep = true;
                        continue;
                    }
                    if (list == null) {
                        list = OMCSSValueList.createWSValueList();
                        list.add(newval);
                        OMCSSFunctionValue.this.arguments.add(list);
                        continue;
                    }
                    list.add(newval);
                    continue;
                }
                if (list == null) {
                    OMCSSFunctionValue.this.arguments.add(newval);
                    continue;
                }
                list.add(newval);
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

