/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.property.AbstractCSSExpression;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ProductExpression
extends AbstractCSSExpression
implements CSSExpression.AlgebraicExpression {
    LinkedList<AbstractCSSExpression> operands = new LinkedList();

    ProductExpression() {
    }

    ProductExpression(ProductExpression copyFrom) {
        super(copyFrom);
        Iterator it = copyFrom.operands.iterator();
        while (it.hasNext()) {
            this.operands.add(((AbstractCSSExpression)it.next()).clone());
        }
    }

    @Override
    void addExpression(AbstractCSSExpression expr) {
        AbstractCSSExpression oparent = expr.getParentExpression();
        if (oparent != null && oparent.getPartType() == CSSExpression.AlgebraicPart.SUM) {
            oparent.replaceLastExpression(this);
        } else {
            this.operands.add(expr);
            expr.setParentExpression(this);
            if (this.nextOperandInverse) {
                expr.setInverseOperation(true);
                this.nextOperandInverse = false;
            }
        }
    }

    public List<AbstractCSSExpression> getOperands() {
        return this.operands;
    }

    @Override
    public CSSExpression.AlgebraicPart getPartType() {
        return CSSExpression.AlgebraicPart.PRODUCT;
    }

    @Override
    public int hashCode() {
        int prime = 211;
        int result = super.hashCode();
        result = 211 * result + (this.operands == null ? 0 : this.operands.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductExpression other = (ProductExpression)obj;
        return !(this.operands == null ? other.operands != null : !this.operands.equals(other.operands));
    }

    @Override
    public ProductExpression clone() {
        return new ProductExpression(this);
    }

    @Override
    public String getCssText() {
        StringBuilder buf = new StringBuilder();
        Iterator it = this.operands.iterator();
        if (!it.hasNext()) {
            return "";
        }
        CSSExpression expr = (CSSExpression)it.next();
        if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM) {
            buf.append('(').append(expr.getCssText()).append(')');
        } else {
            buf.append(expr.getCssText());
        }
        while (it.hasNext()) {
            expr = (CSSExpression)it.next();
            if (expr.isInverseOperation()) {
                buf.append('/');
            } else {
                buf.append('*');
            }
            if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                buf.append('(').append(expr.getCssText()).append(')');
                continue;
            }
            buf.append(expr.getCssText());
        }
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder buf = new StringBuilder();
        Iterator it = this.operands.iterator();
        if (!it.hasNext()) {
            return "";
        }
        CSSExpression expr = (CSSExpression)it.next();
        if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM) {
            buf.append('(').append(expr.getMinifiedCssText()).append(')');
        } else {
            buf.append(expr.getMinifiedCssText());
        }
        while (it.hasNext()) {
            expr = (CSSExpression)it.next();
            if (expr.isInverseOperation()) {
                buf.append('/');
            } else {
                buf.append('*');
            }
            if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                buf.append('(').append(expr.getMinifiedCssText()).append(')');
                continue;
            }
            buf.append(expr.getMinifiedCssText());
        }
        return buf.toString();
    }
}

