/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.agent;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;

public class AgentUtil {
    public static String findCharset(String conType, int afterCommaIndex) {
        int idx = conType.indexOf("charset", afterCommaIndex);
        if (idx != -1) {
            idx += 7;
            int lenm1 = conType.length() - 1;
            char c = '\u0000';
            while (idx < lenm1 && (c = conType.charAt(idx)) == ' ') {
                ++idx;
            }
            if (idx < lenm1 && c == '=') {
                lenm1 = (conType = conType.substring(idx + 1).trim()).length() - 1;
                if (lenm1 > 1) {
                    char c0 = conType.charAt(0);
                    char c1 = conType.charAt(lenm1);
                    if (c0 == '\"' && c1 == '\"' || c0 == '\'' && c1 == '\'') {
                        conType = conType.substring(1, lenm1);
                    }
                }
                return conType;
            }
        }
        return null;
    }

    public static Reader inputStreamToReader(InputStream is, String conType, String contentEncoding, String defaultCharset) throws IOException {
        PushbackReader re;
        int iread;
        int sepidx;
        if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
            is = new GZIPInputStream(is);
        }
        String charset = null;
        if (conType != null && (sepidx = conType.indexOf(59)) != -1 && sepidx < conType.length()) {
            conType = conType.substring(0, sepidx);
            charset = AgentUtil.findCharset(conType, sepidx + 1);
        }
        if (charset == null) {
            charset = defaultCharset;
        }
        if ((iread = (re = new PushbackReader(new InputStreamReader(is, charset), 1)).read()) == -1 || iread != 0xEFBBBF) {
            re.unread(iread);
        }
        return re;
    }
}

