/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMNodeList;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeListIterator;
import io.sf.carte.doc.style.css.CSSDocument;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

abstract class AbstractDOMNode
implements DOMNode {
    private final short nodeType;
    private AbstractDOMNode parentNode = null;
    AbstractDOMNode previousSibling = null;
    AbstractDOMNode nextSibling = null;
    private Map<String, Object> userData = null;
    private Map<String, UserDataHandler> userDataHandler = null;
    static final RawNodeList emptyNodeList = new EmptyNodeList();

    AbstractDOMNode(short nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
    }

    @Override
    public short getNodeType() {
        return this.nodeType;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    void setParentNode(AbstractDOMNode parentNode) {
        this.parentNode = parentNode;
    }

    void setAttributeOwner(DOMElement newOwner) {
        this.parentNode = newOwner;
    }

    @Override
    public DOMNode getParentNode() {
        return this.parentNode;
    }

    AbstractDOMNode parentNode() {
        return this.parentNode;
    }

    @Override
    public DOMNodeList getChildNodes() {
        return this.getNodeList();
    }

    RawNodeList getNodeList() {
        return emptyNodeList;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public DOMNode getFirstChild() {
        return this.getNodeList().getFirst();
    }

    @Override
    public DOMNode getLastChild() {
        return this.getNodeList().getLast();
    }

    @Override
    public DOMNode getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public DOMNode getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public DOMNode appendChild(Node newChild) throws DOMException {
        AbstractDOMNode added = (AbstractDOMNode)newChild;
        if (newChild.getNodeType() != 11) {
            this.preAddChild(newChild);
            this.getNodeList().add(added);
            this.postAddChild(added);
        } else {
            this.appendDocumentFragment(newChild);
        }
        return added;
    }

    void preAddChild(Node newChild) {
        this.checkAppendNode(newChild);
        Node node = newChild.getParentNode();
        if (node != null) {
            node.removeChild(newChild);
        }
    }

    void checkAppendNode(Node newChild) {
        if (newChild.getNodeType() == 9) {
            throw new DOMException(3, "Cannot append a document.");
        }
        this.checkAppendNodeHierarchy(newChild);
        this.checkDocumentOwner(newChild);
    }

    void checkAppendNodeHierarchy(Node newChild) {
        if (newChild.getNodeType() == 2) {
            throw new DOMException(3, "Use setAttributeNode to add attribute nodes.");
        }
        for (Node node = this; node != null; node = node.getParentNode()) {
            if (!node.isSameNode(newChild)) continue;
            throw new DOMException(3, "Cannot insert itself or an ancestor.");
        }
    }

    void checkDocumentOwner(Node newChild) {
        if (newChild.getOwnerDocument() != this.getOwnerDocument()) {
            throw new DOMException(4, "Different document owners.");
        }
    }

    void postAddChild(AbstractDOMNode newChild) {
        newChild.setParentNode(this);
        if (newChild.getNodeType() == 1) {
            DOMElement newElm = (DOMElement)newChild;
            this.updateTaglistsOnInsert(newElm, this);
            this.updateClasslists(newElm, this);
        }
    }

    void updateTaglistsOnInsert(DOMElement newChild, AbstractDOMNode appendedTo) {
        if (this.parentNode != null) {
            this.parentNode.updateTaglistsOnInsert(newChild, appendedTo);
        }
    }

    void updateTaglistsOnRemove(DOMElement oldChild, AbstractDOMNode removedFrom) {
        if (this.parentNode != null) {
            this.parentNode.updateTaglistsOnRemove(oldChild, removedFrom);
        }
    }

    void updateClasslists(DOMElement owner, AbstractDOMNode appendedTo) {
        if (this.parentNode != null) {
            this.parentNode.updateClasslists(owner, appendedTo);
        }
    }

    void updateClasslistsOnRemove(DOMElement oldChild, AbstractDOMNode removedFrom) {
        if (this.parentNode != null) {
            this.parentNode.updateClasslistsOnRemove(oldChild, removedFrom);
        }
    }

    private void appendDocumentFragment(Node newChild) {
        Node added = newChild.getFirstChild();
        while (added != null) {
            Node next = added.getNextSibling();
            this.appendChild(added);
            added = next;
        }
    }

    @Override
    public DOMNode insertBefore(Node newChild, Node refChild) throws DOMException {
        AbstractDOMNode inserted = (AbstractDOMNode)newChild;
        AbstractDOMNode refNode = (AbstractDOMNode)refChild;
        if (refNode != null) {
            if (refNode != inserted) {
                if (!this.getNodeList().contains(refNode)) {
                    throw new DOMException(8, "Not a child of this node.");
                }
                if (inserted.getNodeType() == 11) {
                    this.insertDocumentFragment(inserted, refNode);
                    return inserted;
                }
                this.preAddChild(inserted);
                this.getNodeList().insertBefore(inserted, refNode);
                this.postAddChild(inserted);
            }
        } else {
            this.appendChild(inserted);
        }
        return inserted;
    }

    private void insertDocumentFragment(AbstractDOMNode newChild, AbstractDOMNode refNode) {
        AbstractDOMNode curNode = (AbstractDOMNode)newChild.getFirstChild();
        while (curNode != null) {
            AbstractDOMNode next = curNode.nextSibling;
            this.insertBefore(curNode, refNode);
            curNode = next;
        }
    }

    @Override
    public DOMNode replaceChild(Node newChild, Node oldChild) throws DOMException {
        int index = this.getNodeList().indexOf(oldChild);
        if (index == -1) {
            throw new DOMException(8, "Not a child of this node.");
        }
        AbstractDOMNode replaced = (AbstractDOMNode)oldChild;
        AbstractDOMNode newNode = (AbstractDOMNode)newChild;
        if (replaced != newNode) {
            if (newChild.getNodeType() == 11) {
                this.replaceWithDocumentFragment(newNode, replaced);
            } else {
                this.replaceWithNonDocumentFragment(newNode, replaced);
            }
            replaced.setParentNode(null);
            this.postRemoveChild(replaced);
        }
        return replaced;
    }

    private void replaceWithNonDocumentFragment(AbstractDOMNode newNode, AbstractDOMNode replaced) {
        this.preReplaceChild(newNode, replaced);
        if (replaced.getNodeType() == 1) {
            DOMElement oldElm = (DOMElement)replaced;
            this.updateTaglistsOnRemove(oldElm, this);
            this.updateClasslistsOnRemove(oldElm, this);
        }
        replaced = this.getNodeList().replace(newNode, replaced);
        AbstractDOMNode.callUserHandlers((short)3, replaced, null);
        newNode.setParentNode(this);
        if (newNode.getNodeType() == 1) {
            DOMElement newElm = (DOMElement)newNode;
            this.updateTaglistsOnInsert(newElm, this);
            this.updateClasslists(newElm, this);
        }
    }

    void preReplaceChild(AbstractDOMNode newNode, AbstractDOMNode replaced) {
        this.preAddChild(newNode);
    }

    private void replaceWithDocumentFragment(AbstractDOMNode newChild, AbstractDOMNode replaced) {
        AbstractDOMNode curNode = (AbstractDOMNode)newChild.getFirstChild();
        if (curNode != null) {
            AbstractDOMNode next = curNode.nextSibling;
            this.replaceWithNonDocumentFragment(curNode, replaced);
            AbstractDOMNode lastNode = curNode;
            curNode = next;
            while (curNode != null) {
                next = curNode.nextSibling;
                this.insertAfter(curNode, lastNode);
                lastNode = curNode;
                curNode = next;
            }
        }
    }

    void insertAfter(AbstractDOMNode newNode, AbstractDOMNode refNode) {
        this.preAddChild(newNode);
        AbstractDOMNode next = refNode.nextSibling;
        if (next != null) {
            this.getNodeList().insertBefore(newNode, next);
        } else {
            this.getNodeList().add(newNode);
        }
        this.postAddChild(newNode);
    }

    @Override
    public DOMNode removeChild(Node oldChild) throws DOMException {
        if (!this.getNodeList().contains(oldChild)) {
            throw new DOMException(8, "Not a child.");
        }
        this.preRemoveChild(oldChild);
        AbstractDOMNode removed = (AbstractDOMNode)oldChild;
        removed.removeFromParent(this.getNodeList());
        this.postRemoveChild(removed);
        return removed;
    }

    void preRemoveChild(Node removed) {
        if (removed.getNodeType() == 1) {
            this.updateTaglistsOnRemove((DOMElement)removed, this);
            this.updateClasslistsOnRemove((DOMElement)removed, this);
        }
    }

    void postRemoveChild(AbstractDOMNode removed) {
    }

    void removeFromParent(RawNodeList nodeList) {
        this.setParentNode(null);
        nodeList.remove(this);
        AbstractDOMNode.callUserHandlers((short)3, this, null);
    }

    static void callUserHandlers(short operation, AbstractDOMNode child, Node destNode) {
        if (child.userDataHandler != null) {
            for (Map.Entry<String, UserDataHandler> entry : child.userDataHandler.entrySet()) {
                String key = entry.getKey();
                UserDataHandler handler = entry.getValue();
                if (handler == null) continue;
                handler.handle(operation, key, child.userData.get(key), child, destNode);
            }
        }
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        this.lazyUserData();
        Object old_data = this.userData.get(key);
        this.userData.put(key, data);
        this.userDataHandler.put(key, handler);
        return old_data;
    }

    private void lazyUserData() {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>(2);
            this.userDataHandler = new HashMap<String, UserDataHandler>(2);
        }
    }

    @Override
    public Object getUserData(String key) {
        return this.userData != null ? this.userData.get(key) : null;
    }

    @Override
    public void normalize() {
        Node node = this.getFirstChild();
        short lasttype = 1;
        DOMNode lastnode = null;
        while (node != null) {
            Node next = node.getNextSibling();
            short type = node.getNodeType();
            if (type == 3) {
                String data = node.getNodeValue();
                if (data == null || data.length() == 0 || ((Text)node).isElementContentWhitespace()) {
                    ((AbstractDOMNode)node).removeFromParent(this.getNodeList());
                    node = next;
                    continue;
                }
                if (type == lasttype) {
                    ((Text)((Object)lastnode)).setData(((Text)((Object)lastnode)).getData() + " " + ((Text)node).getData());
                    ((AbstractDOMNode)node).removeFromParent(this.getNodeList());
                }
            }
            lasttype = type;
            lastnode = node;
            node = next;
        }
    }

    @Override
    @Deprecated
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    @Deprecated
    public boolean isSupported(String feature, String version) {
        return true;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        Node node;
        if (other == this) {
            return 0;
        }
        if (this.getOwnerDocument() != other.getOwnerDocument()) {
            return 1;
        }
        short mask = 0;
        int mydepth = 1;
        int otherdepth = 1;
        for (node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.equals(other)) {
                mask = (short)(mask + 16);
                mask = (short)(mask + 4);
                break;
            }
            mydepth = (short)(mydepth + 1);
        }
        if (mask == 0) {
            for (node = other.getParentNode(); node != null; node = node.getParentNode()) {
                if (node.equals(this)) {
                    mask = (short)(mask + 8);
                    mask = (short)(mask + 2);
                    break;
                }
                otherdepth = (short)(otherdepth + 1);
            }
        }
        if (mask == 0) {
            int depth = mydepth > otherdepth ? otherdepth : mydepth;
            int[] myindex = new int[depth];
            int[] otherindex = new int[depth];
            this.computeIndexArray(this, myindex);
            this.computeIndexArray((AbstractDOMNode)other, otherindex);
            for (int k = 0; k < depth; k = (int)((short)(k + 1))) {
                if (myindex[k] == otherindex[k]) continue;
                if (myindex[k] > otherindex[k]) {
                    return 4;
                }
                return 2;
            }
        }
        return mask;
    }

    private void computeIndexArray(AbstractDOMNode node, int[] myindex) {
        AbstractDOMNode parent = (AbstractDOMNode)node.getParentNode();
        int i = myindex.length - 1;
        while (parent != null) {
            myindex[i] = parent.getNodeList().indexOf(node);
            node = parent;
            parent = (AbstractDOMNode)node.getParentNode();
            --i;
        }
    }

    @Override
    public String getTextContent() throws DOMException {
        String text;
        switch (this.getNodeType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                int sz = this.getNodeList().getLength();
                if (sz == 0) {
                    text = "";
                    break;
                }
                if (sz == 1) {
                    text = this.getNodeList().getFirst().getTextContent();
                    break;
                }
                StringBuilder buf = new StringBuilder(32 + sz * 20);
                Node node = this.getFirstChild();
                while (node != null) {
                    short type = node.getNodeType();
                    if (type == 8 || type == 7) {
                        node = node.getNextSibling();
                        continue;
                    }
                    String tc = node.getTextContent();
                    if (tc != null) {
                        buf.append(tc);
                    }
                    node = node.getNextSibling();
                }
                text = buf.toString();
                break;
            }
            case 3: {
                if (((Text)((Object)this)).isElementContentWhitespace()) {
                    text = "";
                    break;
                }
                text = this.getNodeValue();
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                text = this.getNodeValue();
                break;
            }
            default: {
                text = null;
            }
        }
        return text;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.getNodeList().clear();
        if (textContent != null && textContent.length() != 0) {
            AbstractDOMNode text = (AbstractDOMNode)((Object)this.getOwnerDocument().createTextNode(textContent));
            this.getNodeList().add(text);
            text.setParentNode(this);
        }
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.getOwnerDocument().isDefaultNamespace(namespaceURI);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        if (arg != null && this.getNodeType() == arg.getNodeType() && this.getNodeName().equals(arg.getNodeName()) && this.stringEquals(this.getLocalName(), arg.getLocalName()) && this.stringEquals(this.getNamespaceURI(), arg.getNamespaceURI()) && this.stringEquals(this.getPrefix(), arg.getPrefix()) && this.stringEquals(this.getNodeValue(), arg.getNodeValue()) && this.getNodeList().getLength() == arg.getChildNodes().getLength()) {
            Node node = this.getFirstChild();
            Node othernode = arg.getFirstChild();
            while (node != null) {
                if (!node.isEqualNode(othernode)) {
                    return false;
                }
                node = node.getNextSibling();
                othernode = othernode.getNextSibling();
            }
            NamedNodeMap nmap = this.getAttributes();
            NamedNodeMap othernmap = arg.getAttributes();
            if (nmap == null) {
                if (othernmap == null) {
                    return true;
                }
            } else {
                int sz = nmap.getLength();
                if (sz == othernmap.getLength()) {
                    block1: for (int i = 0; i < sz; ++i) {
                        Attr attr = (Attr)nmap.item(i);
                        for (int j = 0; j < sz; ++j) {
                            Attr otherAttr = (Attr)othernmap.item(j);
                            if (attr.isEqualNode(otherAttr) && attr.isId() == otherAttr.isId()) continue block1;
                        }
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean stringEquals(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    @Override
    public boolean isSameNode(Node other) {
        return other == this;
    }

    public boolean contains(Node node) {
        Node n = node;
        do {
            if (n != this) continue;
            return true;
        } while ((n = n.getParentNode()) != null);
        return false;
    }

    @Override
    public abstract DOMDocument getOwnerDocument();

    static interface RawNodeList
    extends DOMNodeList {
        public void add(AbstractDOMNode var1) throws DOMException;

        public void insertBefore(AbstractDOMNode var1, AbstractDOMNode var2);

        public void clear();

        public AbstractDOMNode getFirst();

        public AbstractDOMNode getLast();

        public int indexOf(Node var1);

        public boolean isEmpty();

        public void remove(AbstractDOMNode var1);

        public AbstractDOMNode replace(AbstractDOMNode var1, AbstractDOMNode var2);

        public Iterator<DOMElement> elementIterator();

        public Iterator<Attr> attributeIterator();
    }

    private static class EmptyNodeList
    implements RawNodeList {
        private EmptyNodeList() {
        }

        @Override
        public void add(AbstractDOMNode node) throws DOMException {
            throw new DOMException(3, "Cannot add children to this node.");
        }

        @Override
        public void insertBefore(AbstractDOMNode newChild, AbstractDOMNode refChild) {
            throw new DOMException(3, "Cannot add children to this node.");
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(Node node) {
            return false;
        }

        @Override
        public AbstractDOMNode getFirst() {
            return null;
        }

        @Override
        public AbstractDOMNode getLast() {
            return null;
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public int indexOf(Node node) {
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public DOMNode item(int index) {
            return null;
        }

        @Override
        public void remove(AbstractDOMNode node) {
        }

        @Override
        public AbstractDOMNode replace(AbstractDOMNode newChild, AbstractDOMNode oldChild) {
            throw new DOMException(15, "Cannot set children to this node.");
        }

        @Override
        public Iterator<DOMNode> iterator() {
            return new EmptyNodeIterator();
        }

        @Override
        public Iterator<DOMElement> elementIterator() {
            return new EmptyElementIterator();
        }

        @Override
        public Iterator<Attr> attributeIterator() {
            return null;
        }

        public String toString() {
            return "";
        }

        private static class EmptyNodeIterator
        extends EmptyIterator<DOMNode> {
            private EmptyNodeIterator() {
            }

            @Override
            public DOMNode next() {
                throw new NoSuchElementException();
            }
        }

        private static class EmptyElementIterator
        extends EmptyIterator<DOMElement> {
            private EmptyElementIterator() {
            }

            @Override
            public DOMElement next() {
                throw new NoSuchElementException();
            }
        }

        private static abstract class EmptyIterator<T extends Node>
        implements Iterator<T> {
            private EmptyIterator() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }
        }
    }

    static interface ChildCollections
    extends RawNodeList {
        public ElementList getChildren();

        public Iterator<DOMNode> createDescendingIterator();

        public Iterator<DOMNode> createIterator(BitSet var1);

        public Iterator<DOMNode> createIterator(int var1, NodeFilter var2);

        public NodeListIterator createListIterator();

        public ElementList getElementsByTagNameNS(String var1, String var2);

        public ElementList getElementsByTagName(String var1);

        public ElementList getElementsByClassName(String var1, CSSDocument.ComplianceMode var2);

        public void updateTaglistsOnInsert(DOMElement var1, AbstractDOMNode var2);

        public void updateTaglistsOnRemove(DOMElement var1, AbstractDOMNode var2);

        public void updateClasslists(DOMElement var1, AbstractDOMNode var2);

        public void updateClasslistsOnRemove(DOMElement var1, AbstractDOMNode var2);
    }
}

