/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DocumentTypeImpl;
import io.sf.carte.doc.dom.HTMLDocument;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.nsac.Parser2;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.AnonymousStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CompatInlineStyle;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DOMCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DOMComputedStyle;
import io.sf.carte.doc.style.css.om.DOMDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.InlineStyle;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.EnumSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CSSDOMImplementation
extends BaseCSSStyleSheetFactory
implements DOMImplementation {
    private boolean strictErrorChecking = true;
    private BaseDocumentCSSStyleSheet defStyleSheet = null;
    private BaseDocumentCSSStyleSheet defQStyleSheet = null;
    private BaseDocumentCSSStyleSheet uaStyleSheet = null;
    private BaseDocumentCSSStyleSheet uaQStyleSheet = null;

    public CSSDOMImplementation() {
        this(EnumSet.noneOf(Parser2.Flag.class));
    }

    public CSSDOMImplementation(EnumSet<Parser2.Flag> parserFlags) {
        super(parserFlags);
    }

    @Override
    public DOMDocument createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        if (doctype != null && doctype.getParentNode() != null) {
            throw new DOMException(4, "Doctype already in use");
        }
        DOMDocument document = namespaceURI == null || namespaceURI.equals("http://www.w3.org/1999/xhtml") || doctype != null && "html".equalsIgnoreCase(doctype.getName()) ? new MyHTMLDocument(doctype) : new MyXMLDocument(doctype);
        if (!this.strictErrorChecking) {
            document.setStrictErrorChecking(false);
        }
        if (qualifiedName != null && qualifiedName.length() != 0) {
            document.appendChild(document.createElementNS(namespaceURI, qualifiedName));
        }
        return document;
    }

    @Override
    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
        return new DocumentTypeImpl(qualifiedName, publicId, systemId);
    }

    @Override
    @Deprecated
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public boolean hasFeature(String feature, String version) {
        return true;
    }

    protected boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    @Override
    protected BaseDocumentCSSStyleSheet createDocumentStyleSheet(byte origin) {
        return new MyDocumentCSSStyleSheet(null, origin);
    }

    @Override
    protected BaseCSSStyleSheet createRuleStyleSheet(AbstractCSSRule ownerRule, String title, MediaQueryList mediaList) {
        return new MyCSSStyleSheet(title, null, mediaList, ownerRule, ownerRule.getOrigin());
    }

    @Override
    protected BaseCSSStyleSheet createLinkedStyleSheet(Node ownerNode, String title, MediaQueryList mediaList) {
        Node titleattr;
        NamedNodeMap nnm;
        if (title == null && ownerNode != null && (nnm = ownerNode.getAttributes()) != null && (titleattr = nnm.getNamedItem("title")) != null) {
            title = titleattr.getNodeValue();
        }
        return new MyCSSStyleSheet(title, ownerNode, mediaList, null, 8);
    }

    @Override
    public AbstractCSSStyleDeclaration createAnonymousStyleDeclaration(Node node) {
        MyAnonymousStyleDeclaration style = new MyAnonymousStyleDeclaration(node);
        return style;
    }

    @Override
    public BaseDocumentCSSStyleSheet getUserAgentStyleSheet(CSSDocument.ComplianceMode mode) {
        if (mode == CSSDocument.ComplianceMode.STRICT) {
            if (this.uaStyleSheet == null) {
                this.uaStyleSheet = this.createDocumentStyleSheet((byte)16);
            }
            return this.uaStyleSheet;
        }
        if (this.uaQStyleSheet == null) {
            this.uaQStyleSheet = this.createDocumentStyleSheet((byte)16);
        }
        return this.uaQStyleSheet;
    }

    @Override
    public void setDefaultHTMLUserAgentSheet() {
        this.uaStyleSheet = this.htmlDefaultSheet();
        this.uaQStyleSheet = this.htmlQuirksDefaultSheet();
        this.defStyleSheet = null;
        this.defQStyleSheet = null;
    }

    @Override
    protected BaseDocumentCSSStyleSheet getDefaultStyleSheet(CSSDocument.ComplianceMode mode) {
        if (this.defStyleSheet == null) {
            this.mergeUserSheets();
        }
        BaseDocumentCSSStyleSheet sheet = mode == CSSDocument.ComplianceMode.STRICT ? this.defStyleSheet : this.defQStyleSheet;
        return sheet;
    }

    private void mergeUserSheets() {
        this.defStyleSheet = this.getUserAgentStyleSheet(CSSDocument.ComplianceMode.STRICT).clone();
        this.defQStyleSheet = this.getUserAgentStyleSheet(CSSDocument.ComplianceMode.QUIRKS).clone();
        AbstractCSSStyleSheet usersheet = this.getUserNormalStyleSheet();
        if (usersheet != null) {
            this.defStyleSheet.addStyleSheet(usersheet);
            this.defQStyleSheet.addStyleSheet(usersheet);
        }
    }

    @Override
    protected InlineStyle createInlineStyle(Node owner) {
        InlineStyle style = !this.hasCompatValueFlags() ? new MyInlineStyle(owner) : new MyCompatInlineStyle(owner);
        return style;
    }

    class MyHTMLDocument
    extends HTMLDocument {
        public MyHTMLDocument(DocumentType documentType) {
            super(documentType);
        }

        @Override
        public CSSDOMImplementation getImplementation() {
            return CSSDOMImplementation.this;
        }

        @Override
        public URLConnection openConnection(URL url) throws IOException {
            return url.openConnection();
        }

        @Override
        protected CSSDOMImplementation getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }
    }

    class MyXMLDocument
    extends DOMDocument {
        public MyXMLDocument(DocumentType documentType) {
            super(documentType);
        }

        @Override
        public CSSDOMImplementation getImplementation() {
            return CSSDOMImplementation.this;
        }

        @Override
        public URLConnection openConnection(URL url) throws IOException {
            return url.openConnection();
        }

        @Override
        protected CSSDOMImplementation getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }
    }

    private class MyDocumentCSSStyleSheet
    extends DOMDocumentCSSStyleSheet {
        MyDocumentCSSStyleSheet(String medium, byte origin) {
            super(medium, origin);
        }

        @Override
        protected DOMDocumentCSSStyleSheet createDocumentStyleSheet(String medium, byte origin) {
            return new MyDocumentCSSStyleSheet(medium, origin);
        }

        @Override
        protected ComputedCSSStyle createComputedCSSStyle(BaseDocumentCSSStyleSheet parentSheet) {
            return new MyDOMComputedStyle(parentSheet);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }
    }

    class MyCSSStyleSheet
    extends DOMCSSStyleSheet {
        MyCSSStyleSheet(String title, Node ownerNode, MediaQueryList media, AbstractCSSRule ownerRule, byte origin) {
            super(title, ownerNode, media, ownerRule, origin);
        }

        @Override
        protected DOMCSSStyleSheet createCSSStyleSheet(String title, Node ownerNode, MediaQueryList media, AbstractCSSRule ownerRule, byte origin) {
            return new MyCSSStyleSheet(title, ownerNode, media, ownerRule, origin);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }

        @Override
        protected void setMedia(MediaQueryList media) throws DOMException {
            super.setMedia(media);
        }

        @Override
        protected void setTitle(String title) {
            super.setTitle(title);
        }
    }

    class MyAnonymousStyleDeclaration
    extends AnonymousStyleDeclaration {
        MyAnonymousStyleDeclaration(Node ownerNode) {
            super(ownerNode);
        }

        private MyAnonymousStyleDeclaration(MyAnonymousStyleDeclaration copiedObject) {
            super(copiedObject);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }

        @Override
        public AnonymousStyleDeclaration clone() {
            MyAnonymousStyleDeclaration styleClone = new MyAnonymousStyleDeclaration(this);
            return styleClone;
        }
    }

    class MyInlineStyle
    extends InlineStyle {
        MyInlineStyle(Node node) {
            this.setOwnerNode(node);
        }

        MyInlineStyle(InlineStyle copiedObject) {
            super(copiedObject);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }

        @Override
        public InlineStyle clone() {
            return new MyInlineStyle(this);
        }
    }

    class MyCompatInlineStyle
    extends CompatInlineStyle {
        MyCompatInlineStyle(Node node) {
            this.setOwnerNode(node);
        }

        MyCompatInlineStyle(CompatInlineStyle copiedObject) {
            super(copiedObject);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }

        @Override
        public InlineStyle clone() {
            return new MyCompatInlineStyle(this);
        }
    }

    class MyDOMComputedStyle
    extends DOMComputedStyle {
        MyDOMComputedStyle(BaseDocumentCSSStyleSheet parentSheet) {
            super(parentSheet);
        }

        private MyDOMComputedStyle(ComputedCSSStyle copiedObject) {
            super(copiedObject);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }

        @Override
        protected void setOwnerNode(CSSElement node) {
            super.setOwnerNode(node);
        }

        @Override
        public ComputedCSSStyle clone() {
            MyDOMComputedStyle styleClone = new MyDOMComputedStyle(this);
            return styleClone;
        }
    }
}

