/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.CSSDOMImplementation;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMParentNode;
import io.sf.carte.doc.dom.DefaultNodeList;
import io.sf.carte.doc.dom.DocumentTypeImpl;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.NDTNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeIterator;
import io.sf.carte.doc.dom.NodeIteratorImpl;
import io.sf.carte.doc.dom.TreeWalker;
import io.sf.carte.doc.dom.TreeWalkerImpl;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.ExtendedCSSStyleDeclaration;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DOMUtil;
import io.sf.carte.doc.style.css.om.DefaultErrorHandler;
import io.sf.carte.doc.style.css.om.MediaList;
import io.sf.carte.doc.style.css.om.StyleSheetList;
import io.sf.carte.doc.xml.dtd.ContentModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.stylesheets.LinkStyle;
import org.xml.sax.SAXException;

public abstract class DOMDocument
extends DOMParentNode
implements CSSDocument {
    static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    private boolean strictErrorChecking = true;
    private String documentURI = null;
    final Set<LinkStyleDefiner> linkedStyle = new LinkedHashSet<LinkStyleDefiner>(4);
    final Set<LinkStyleDefiner> embeddedStyle = new LinkedHashSet<LinkStyleDefiner>(3);
    private BaseDocumentCSSStyleSheet mergedStyleSheet = null;
    private final MyOMStyleSheetList sheets = new MyOMStyleSheetList(7);
    private final ErrorHandler errorHandler = this.createErrorHandler();
    private String metaDefaultStyleSet = "";
    private String metaReferrerPolicy = "";
    private String lastStyleSheetSet = null;
    private String targetMedium = null;
    private final Map<String, CSSCanvas> canvases = new HashMap<String, CSSCanvas>(3);

    public DOMDocument(DocumentType documentType) {
        super((short)9);
        if (documentType != null && documentType.getOwnerDocument() == null) {
            DocumentTypeImpl doctype = (DocumentTypeImpl)documentType;
            this.getNodeList().add(doctype);
            doctype.setParentNode(this);
        }
    }

    @Override
    public CSSDocument.ComplianceMode getComplianceMode() {
        DocumentType doctype = this.getDoctype();
        if (doctype != null) {
            return CSSDocument.ComplianceMode.STRICT;
        }
        return CSSDocument.ComplianceMode.QUIRKS;
    }

    @Override
    public DOMElement getDocumentElement() {
        return this.getLastElementChild();
    }

    @Override
    public DocumentType getDoctype() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 10) continue;
            return (DocumentType)node;
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public DOMDocument getOwnerDocument() {
        return null;
    }

    @Override
    public DOMNode getParentNode() {
        return null;
    }

    @Override
    public boolean isVisitedURI(String href) {
        return false;
    }

    @Override
    public DOMDocument cloneNode(boolean deep) {
        boolean hasDocType;
        DocumentType docType = this.getDoctype();
        boolean bl = hasDocType = docType != null;
        if (hasDocType) {
            docType = (DocumentType)docType.cloneNode(deep);
        }
        DOMDocument doc = this.cloneDocument(docType);
        if (deep) {
            boolean foundDoctype = !hasDocType;
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 10) {
                    if (foundDoctype) {
                        doc.appendChild(doc.importNode(node, true));
                        continue;
                    }
                    doc.insertBefore(doc.importNode(node, true), docType);
                    continue;
                }
                foundDoctype = true;
            }
        } else if (hasDocType) {
            doc.removeChild(docType);
        }
        DOMDocument.callUserHandlers((short)1, this, doc);
        return doc;
    }

    DOMDocument cloneDocument(DocumentType docType) {
        String nsUri = null;
        String qName = null;
        DOMElement docElm = this.getDocumentElement();
        if (docElm != null) {
            nsUri = docElm.getNamespaceURI();
            qName = docElm.getTagName();
        }
        if (!(nsUri != null || "html".equals(qName) || docType != null && "html".equalsIgnoreCase(docType.getName()))) {
            nsUri = "";
        }
        DOMDocument doc = this.getImplementation().createDocument(nsUri, qName, docType);
        if (docElm != null) {
            doc.removeChild(doc.getDocumentElement());
        }
        return doc;
    }

    @Override
    public abstract CSSDOMImplementation getImplementation();

    protected abstract CSSDOMImplementation getStyleSheetFactory();

    MediaQueryList parseMediaList(String media, Node node) {
        MediaQueryList mediaList;
        if (media.length() == 0) {
            mediaList = MediaList.createMediaList();
        } else {
            mediaList = this.getStyleSheetFactory().createMediaQueryList(media, node);
            if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                return null;
            }
        }
        return mediaList;
    }

    AbstractCSSStyleSheet loadStyleSheet(AbstractCSSStyleSheet sheet, String href, String title, MediaQueryList media, Node ownerNode) {
        if (sheet == null) {
            sheet = this.getStyleSheetFactory().createLinkedStyleSheet(ownerNode, title, media);
        } else {
            CSSDOMImplementation.MyCSSStyleSheet mysheet = (CSSDOMImplementation.MyCSSStyleSheet)sheet;
            mysheet.setTitle(title);
            mysheet.setMedia(media);
            mysheet.getCssRules().clear();
        }
        String referrerPolicy = this.getReferrerpolicyAttribute(ownerNode);
        try {
            URL url = this.getURL(href);
            sheet.setHref(url.toExternalForm());
            sheet.loadStyleSheet(url, referrerPolicy);
        }
        catch (Exception e) {
            this.getErrorHandler().linkedSheetError(e, sheet);
        }
        return sheet;
    }

    private String getReferrerpolicyAttribute(Node node) {
        Node rp;
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null && (rp = nnm.getNamedItem("referrerpolicy")) != null) {
            return rp.getNodeValue();
        }
        return "";
    }

    AbstractCSSStyleSheet parseEmbeddedStyleSheet(AbstractCSSStyleSheet sheet, String styleText, String title, MediaQueryList media, Node ownerNode) {
        if (sheet == null) {
            sheet = this.getStyleSheetFactory().createLinkedStyleSheet(ownerNode, title, media);
        } else {
            CSSDOMImplementation.MyCSSStyleSheet mysheet = (CSSDOMImplementation.MyCSSStyleSheet)sheet;
            mysheet.setTitle(title);
            mysheet.setMedia(media);
            mysheet.getCssRules().clear();
        }
        sheet.setHref(this.getBaseURI());
        if (styleText.length() != 0) {
            InputSource source = new InputSource();
            StringReader re = new StringReader(styleText);
            source.setCharacterStream((Reader)re);
            try {
                sheet.parseStyleSheet(source);
            }
            catch (Exception e) {
                this.getErrorHandler().linkedSheetError(e, sheet);
            }
        } else {
            sheet.getCssRules().clear();
        }
        return sheet;
    }

    LinkStyleDefiner getEmbeddedStyleDefiner(DOMElement element) {
        if (element != null) {
            return this.getEmbeddedStyleDefiner(element.getId());
        }
        return null;
    }

    static boolean isValidName(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        if (!DOMDocument.isValidStartCharacter(name.codePointAt(0))) {
            return false;
        }
        int i = name.offsetByCodePoints(0, 1);
        while (i < len) {
            if (!DOMDocument.isValidCharacter(name.codePointAt(i))) {
                return false;
            }
            i = name.offsetByCodePoints(i, 1);
        }
        return true;
    }

    private static boolean isValidCharacter(int cp) {
        return cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || cp >= 48 && cp <= 57 || cp == 45 || cp == 95 || cp == 46 || cp == 183 || cp >= 192 && cp <= 214 || cp >= 216 && cp <= 246 || cp >= 248 && cp <= 767 || cp >= 768 && cp <= 893 || cp >= 895 && cp <= 8191 || cp >= 8204 && cp <= 8205 || cp >= 8255 && cp <= 8256 || cp >= 8304 && cp <= 8591 || cp >= 11264 && cp <= 12271 || cp >= 12289 && cp <= 55295 || cp >= 63744 && cp <= 64975 || cp >= 65008 && cp <= 65533 || cp >= 65536 && cp <= 983039;
    }

    private static boolean isValidStartCharacter(int cp) {
        return cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || cp == 95 || cp >= 192 && cp <= 214 || cp >= 216 && cp <= 246 || cp >= 248 && cp <= 767 || cp >= 880 && cp <= 893 || cp >= 895 && cp <= 8191 || cp >= 8204 && cp <= 8205 || cp >= 8304 && cp <= 8591 || cp >= 11264 && cp <= 12271 || cp >= 12289 && cp <= 55295 || cp >= 63744 && cp <= 64975 || cp >= 65008 && cp <= 65533 || cp >= 65536 && cp <= 983039;
    }

    static String escapeCloseTag(String tagname, String data) {
        int idx = data.indexOf(60);
        if (idx == -1) {
            return data;
        }
        int tnidx = data.indexOf(tagname, 2);
        if (tnidx == -1) {
            return data;
        }
        StringBuilder buf = null;
        int tnlen = tagname.length();
        int lenm1 = data.length() - 1;
        while (idx < lenm1) {
            int i;
            char d;
            char c = data.charAt(idx);
            if (c == '<' && (d = data.charAt(i = idx + 1)) == '/' && lenm1 - i > tnlen) {
                ++i;
                if ((i = DOMDocument.skipIgnorableChars(i, data, lenm1)) < lenm1 && data.regionMatches(true, i, tagname, 0, tnlen) && (i = DOMDocument.skipIgnorableChars(i + tnlen, data, lenm1)) <= lenm1 && data.charAt(i) == '>') {
                    if (buf == null) {
                        buf = new StringBuilder(lenm1 + 4);
                        buf.append(data.subSequence(0, idx));
                    }
                    buf.append("&lt;");
                    buf.append(data.subSequence(idx + 1, i + 1));
                    idx = i + 1;
                    continue;
                }
            }
            if (buf != null) {
                buf.append(c);
            }
            ++idx;
        }
        if (buf != null && idx == lenm1) {
            buf.append(data.charAt(idx));
        }
        return buf == null ? data : buf.toString();
    }

    private static int skipIgnorableChars(int idx, String text, int lenm1) {
        while (idx < lenm1) {
            char c = text.charAt(idx);
            if (c != ' ' && c != '\t' && c != '\n') {
                if (c != '\r') break;
                int i = idx + 1;
                if (text.charAt(i) == '\n') {
                    idx = i;
                }
            }
            ++idx;
        }
        return idx;
    }

    static String escapeLtGtEntities(String text) {
        StringBuilder buf = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                buf = DOMDocument.appendEntityToBuffer(buf, "lt", text, i, len);
                continue;
            }
            if (c == '>') {
                buf = DOMDocument.appendEntityToBuffer(buf, "gt", text, i, len);
                continue;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        if (buf != null) {
            text = buf.toString();
        }
        return text;
    }

    static StringBuilder appendEntityToBuffer(StringBuilder buf, String string, String text, int index, int inilen) {
        if (buf == null) {
            buf = new StringBuilder(inilen + string.length() + 2);
            buf.append(text.subSequence(0, index));
        }
        buf.append('&').append(string).append(';');
        return buf;
    }

    @Override
    public DOMElement createElement(String tagName) throws DOMException {
        if (tagName == null) {
            throw new DOMException(5, "null tag name");
        }
        return this.createElementNS(null, tagName);
    }

    @Override
    public DOMElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName;
        if (qualifiedName == null) {
            throw new DOMException(5, "null qualified name");
        }
        String prefix = null;
        if (namespaceURI != null) {
            if (namespaceURI.length() == 0) {
                namespaceURI = null;
                localName = qualifiedName.toLowerCase(Locale.ROOT);
            } else {
                namespaceURI = namespaceURI.intern();
                int idx = qualifiedName.indexOf(58);
                if (idx == -1) {
                    prefix = this.lookupPrefix(namespaceURI);
                    localName = qualifiedName;
                } else {
                    if (idx == qualifiedName.length() - 1) {
                        throw new DOMException(5, "Empty local name");
                    }
                    if (idx == 0) {
                        throw new DOMException(5, "Empty prefix");
                    }
                    prefix = qualifiedName.substring(0, idx).intern();
                    localName = qualifiedName.substring(idx + 1);
                }
            }
        } else {
            if (qualifiedName.indexOf(58) != -1) {
                throw new DOMException(14, "Prefix with null namespace");
            }
            localName = qualifiedName.toLowerCase(Locale.ROOT);
        }
        if (!DOMDocument.isValidName(localName)) {
            throw new DOMException(5, "Invalid name: " + localName);
        }
        localName = localName.intern();
        MyXMLElement myelem = new MyXMLElement(localName, namespaceURI);
        if (prefix != null) {
            myelem.setPrefix(prefix);
        }
        return myelem;
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new DOMDocumentFragment();
    }

    @Override
    public Text createTextNode(String data) {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyText text = new MyText();
        text.setData(data);
        return text;
    }

    @Override
    public Comment createComment(String data) {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyComment my = new MyComment();
        my.setData(data);
        return my;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyCDATASection my = new MyCDATASection();
        my.setData(data);
        return my;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (target == null || target.length() == 0) {
            throw new DOMException(5, "Void target");
        }
        if (target.equalsIgnoreCase("xml")) {
            throw new DOMException(5, "An xml declaration is not a processing instruction");
        }
        if (!DOMDocument.isValidName(target)) {
            throw new DOMException(5, "Invalid target: " + target);
        }
        if (data.contains("?>")) {
            throw new DOMException(5, "A processing instruction data cannot contain a '?>'");
        }
        if ("xml-stylesheet".equals(target)) {
            return new MyStyleProcessingInstruction(data);
        }
        return new MyProcessingInstruction(target, data);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        if (name == null) {
            throw new DOMException(5, "null entity reference name");
        }
        return new MyEntityReference(name);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return this.createAttributeNS(null, name);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (qualifiedName == null) {
            throw new DOMException(5, "null name");
        }
        String localName = qualifiedName;
        String prefix = null;
        if (namespaceURI != null) {
            if (namespaceURI.length() != 0) {
                namespaceURI = namespaceURI.intern();
                int idx = qualifiedName.indexOf(58);
                if (idx == -1) {
                    prefix = this.lookupPrefix(namespaceURI);
                } else {
                    if (idx == qualifiedName.length() - 1) {
                        throw new DOMException(14, "Empty local name");
                    }
                    if (idx == 0) {
                        throw new DOMException(14, "Empty prefix");
                    }
                    prefix = qualifiedName.substring(0, idx).intern();
                    localName = qualifiedName.substring(idx + 1);
                }
                if ("http://www.w3.org/1999/xhtml" == namespaceURI) {
                    localName = localName.toLowerCase(Locale.ROOT);
                }
            } else {
                if (qualifiedName.indexOf(58) != -1) {
                    throw new DOMException(14, "Prefix with null namespace");
                }
                namespaceURI = null;
            }
        } else if (qualifiedName.indexOf(58) != -1) {
            throw new DOMException(14, "Prefix with null namespace");
        }
        localName = localName.intern();
        Attr my = this.createAttributeNS(namespaceURI, prefix, localName);
        return my;
    }

    Attr createAttributeNS(String namespaceURI, String prefix, String localName) throws DOMException {
        MyAttr my;
        if (!DOMDocument.isValidName(localName)) {
            throw new DOMException(5, "Invalid name: " + localName);
        }
        if (localName == "xmlns") {
            if (namespaceURI != null && !XMLNS_NAMESPACE_URI.equals(namespaceURI)) {
                throw new DOMException(14, "xmlns local name but not xmlns namespace");
            }
            my = new XmlnsAttr();
        } else {
            my = localName == "class" ? new ClassAttr(namespaceURI) : (localName == "base" && "xml".equals(prefix) ? new StyleEventAttr(localName, namespaceURI) : (localName == "style" && prefix == null ? new MyStyleAttr(localName) : new MyAttr(localName, namespaceURI)));
        }
        if (prefix != null) {
            my.setPrefix(prefix);
        }
        return my;
    }

    public NodeIterator createNodeIterator(Node rootNode, int whatToShow, NodeFilter filter) {
        return new NodeIteratorImpl((AbstractDOMNode)rootNode, whatToShow, filter);
    }

    public TreeWalker createTreeWalker(Node rootNode, int whatToShow, NodeFilter filter) {
        return new TreeWalkerImpl((AbstractDOMNode)rootNode, whatToShow, filter);
    }

    @Override
    public ElementList getElementsByClassName(String names) {
        return this.getNodeList().getElementsByClassName(names, this.getComplianceMode());
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        DOMElement html = this.getDocumentElement();
        if (html == null) {
            return null;
        }
        return this.lookupPrefix(html, namespaceURI);
    }

    private String lookupPrefix(Node node, String namespaceURI) {
        if (node.getNamespaceURI() == namespaceURI) {
            String prefix = node.getPrefix();
            if (prefix != null) {
                return prefix;
            }
            return null;
        }
        for (Node cnode = node.getFirstChild(); cnode != null; cnode = cnode.getNextSibling()) {
            String prefix;
            if (cnode.getNodeType() != 1 || (prefix = this.lookupPrefix(cnode, namespaceURI)) == null) continue;
            return prefix;
        }
        return null;
    }

    @Override
    public DOMElement getElementById(String elementId) {
        return this.findElementById(this.getFirstChild(), elementId);
    }

    private DOMElement findElementById(Node node, String elementId) {
        while (node != null) {
            DOMElement elm;
            String idValue;
            if (node.getNodeType() == 1 && (idValue = (elm = (DOMElement)node).getId()).equals(elementId)) {
                return elm;
            }
            elm = this.findElementById(node.getFirstChild(), elementId);
            if (elm != null) {
                return elm;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    @Deprecated
    public String getXmlEncoding() {
        return null;
    }

    @Override
    @Deprecated
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    @Deprecated
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    @Override
    @Deprecated
    public String getXmlVersion() {
        return null;
    }

    @Override
    @Deprecated
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    @Override
    public String getDocumentURI() {
        return this.documentURI;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        switch (importedNode.getNodeType()) {
            case 2: {
                Attr importedAttr = (Attr)importedNode;
                DOMAttr attr = importedAttr.getLocalName() != null ? (DOMAttr)this.createAttributeNS(importedAttr.getNamespaceURI(), importedAttr.getLocalName()) : (DOMAttr)this.createAttribute(importedNode.getNodeName());
                attr.specified = importedAttr.getSpecified();
                attr.setValue(importedNode.getNodeValue());
                if (importedAttr.getPrefix() != null) {
                    attr.setPrefix(importedAttr.getPrefix());
                }
                return attr;
            }
            case 1: {
                Element foreignElm = (Element)importedNode;
                DOMElement elm = foreignElm.getLocalName() != null ? this.createElementNS(foreignElm.getNamespaceURI(), foreignElm.getLocalName()) : this.createElement(importedNode.getNodeName());
                NamedNodeMap attributes = foreignElm.getAttributes();
                int count = attributes.getLength();
                for (int i = 0; i < count; ++i) {
                    Attr importedAttr = (Attr)attributes.item(i);
                    DOMAttr attr = (DOMAttr)this.importNode(importedAttr, true);
                    attr.specified = importedAttr.getSpecified();
                    elm.setAttributeNode(attr);
                    if (!importedAttr.isId()) continue;
                    elm.setIdAttributeNode(attr, true);
                }
                if (deep) {
                    for (Node node = importedNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                        elm.appendChild(this.importNode(node, true));
                    }
                }
                return elm;
            }
            case 3: {
                return this.createTextNode(importedNode.getNodeValue());
            }
            case 4: {
                return this.createCDATASection(importedNode.getNodeValue());
            }
            case 8: {
                return this.createComment(importedNode.getNodeValue());
            }
            case 11: {
                DocumentFragment df = this.createDocumentFragment();
                if (deep) {
                    for (Node node = importedNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                        df.appendChild(this.importNode(node, true));
                    }
                }
                return df;
            }
            case 5: {
                return this.createEntityReference(importedNode.getNodeName());
            }
            case 7: {
                return this.createProcessingInstruction(importedNode.getNodeName(), importedNode.getNodeValue());
            }
        }
        throw new DOMException(9, "Cannot import this node type.");
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        throw new DOMException(9, "Node adoption not supported");
    }

    @Override
    public DOMNode insertBefore(Node newChild, Node refChild) throws DOMException {
        block3: {
            short newType;
            block2: {
                newType = newChild.getNodeType();
                if (newType != 1) break block2;
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block3;
            }
            if (newType != 10) break block3;
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
        return super.insertBefore(newChild, refChild);
    }

    @Override
    public DOMNode replaceChild(Node newChild, Node oldChild) throws DOMException {
        block2: {
            short newType;
            block3: {
                newType = newChild.getNodeType();
                if (newType == oldChild.getNodeType()) break block2;
                if (newType != 1) break block3;
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block2;
            }
            if (newType != 10) break block2;
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    void preAddChild(Node newChild) {
        block3: {
            block2: {
                super.preAddChild(newChild);
                if (newChild.getNodeType() != 1) break block2;
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block3;
            }
            if (newChild.getNodeType() != 10) break block3;
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
    }

    @Override
    void checkDocumentOwner(Node newChild) {
        if (newChild.getOwnerDocument() != this && newChild.getNodeType() != 10) {
            throw new DOMException(4, "Different document owners.");
        }
    }

    @Override
    void preReplaceChild(AbstractDOMNode newChild, AbstractDOMNode replaced) {
        block4: {
            block3: {
                super.preAddChild(newChild);
                if (newChild.getNodeType() != 1) break block3;
                if (replaced.getNodeType() == 1) break block4;
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block4;
            }
            if (newChild.getNodeType() == 10 && replaced.getNodeType() != 10) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 10) continue;
                    throw new DOMException(3, "Document already has a doctype.");
                }
            }
        }
    }

    @Override
    @Deprecated
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "This operation is not supported.");
    }

    @Override
    @Deprecated
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public void normalizeDocument() {
        DOMElement docelm = this.getDocumentElement();
        if (docelm != null) {
            docelm.normalize();
        }
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        DOMElement docelm = this.getDocumentElement();
        return docelm != null ? docelm.lookupNamespaceURI(prefix) : null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        DOMElement docelm = this.getDocumentElement();
        if (docelm != null) {
            return docelm.getNamespaceURI() == namespaceURI;
        }
        return namespaceURI == null;
    }

    @Override
    public StyleSheetList getStyleSheets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets;
    }

    void updateStyleLists() {
        int i;
        this.linkedStyle.clear();
        NodeList nl = this.getLinkedStyleNodeList();
        int len = nl.getLength();
        for (i = 0; i < len; ++i) {
            LinkStyleDefiner link = (LinkStyleDefiner)nl.item(i);
            if (link.getSheet() == null) continue;
            this.linkedStyle.add(link);
        }
        this.embeddedStyle.clear();
        nl = this.getEmbeddedStyleNodeList();
        len = nl.getLength();
        for (i = 0; i < len; ++i) {
            this.embeddedStyle.add((LinkStyleDefiner)nl.item(i));
        }
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            this.addLinkedSheet(links.next().getSheet());
        }
        Iterator<LinkStyleDefiner> embd = this.embeddedStyle.iterator();
        while (embd.hasNext()) {
            this.addLinkedSheet(embd.next().getSheet());
        }
        this.sheets.setNeedsUpdate(false);
        if (this.lastStyleSheetSet != null) {
            this.setSelectedStyleSheetSet(this.lastStyleSheetSet);
        } else if (this.metaDefaultStyleSet.length() > 0) {
            this.setSelectedStyleSheetSet(this.metaDefaultStyleSet);
            this.lastStyleSheetSet = null;
        } else {
            this.setSelectedStyleSheetSet(this.sheets.getPreferredStyleSheetSet());
            this.lastStyleSheetSet = null;
        }
        if (this.getCanvas() != null) {
            this.getCanvas().reloadStyleState();
        }
    }

    private void addLinkedSheet(AbstractCSSStyleSheet linkedSheet) {
        if (linkedSheet != null) {
            this.sheets.add(linkedSheet);
        }
    }

    NodeList getLinkedStyleNodeList() {
        return this.getLinkedStyleNodeList(true);
    }

    NodeList getEmbeddedStyleNodeList() {
        return this.getLinkedStyleNodeList(false);
    }

    private NodeList getLinkedStyleNodeList(boolean external) {
        LinkedList list = null;
        AbstractDOMNode node = this.getNodeList().getFirst();
        while (node != null) {
            short type = node.getNodeType();
            if (type == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction pi = (LinkStyleProcessingInstruction)((Object)node);
                String href = pi.getPseudoAttribute("href");
                if (href.length() > 1) {
                    if (href.charAt(0) == '#') {
                        if (!external) {
                            if (list == null) {
                                list = new DefaultNodeList();
                            }
                            list.add(node);
                        }
                    } else if (external) {
                        if (list == null) {
                            list = new DefaultNodeList();
                        }
                        list.add(node);
                    }
                }
            } else if (type == 1) break;
            node = node.nextSibling;
        }
        return list == null ? AbstractDOMNode.emptyNodeList : list;
    }

    LinkStyleDefiner getEmbeddedStyleDefiner(String id) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            short type = node.getNodeType();
            if (type == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction pi = (LinkStyleProcessingInstruction)node;
                String href = pi.getPseudoAttribute("href");
                if (href.length() <= 1 || href.charAt(0) != '#' || !id.equals(href.substring(1))) continue;
                return pi;
            }
            if (type == 1) break;
        }
        return null;
    }

    @Override
    public DocumentCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        this.getStyleSheets();
        BaseDocumentCSSStyleSheet defSheet = this.getStyleSheetFactory().getDefaultStyleSheet(this.getComplianceMode());
        this.mergedStyleSheet = this.targetMedium == null ? defSheet.clone() : defSheet.clone(this.targetMedium);
        this.mergedStyleSheet.setOwnerDocument(this);
        Iterator<AbstractCSSStyleSheet> it = this.sheets.iterator();
        while (it.hasNext()) {
            this.mergedStyleSheet.addStyleSheet(it.next());
        }
    }

    @Override
    public DOMStringList getStyleSheetSets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets.getStyleSheetSets();
    }

    @Override
    public String getSelectedStyleSheetSet() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        String selectedSetName = "";
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equalsIgnoreCase(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        return selectedSetName;
    }

    @Override
    public void setSelectedStyleSheetSet(String name) {
        if (name == null || name.length() > 0 && !this.getStyleSheetSets().contains(name)) {
            return;
        }
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() == 0) continue;
            if (title.equalsIgnoreCase(name)) {
                sheet.setDisabled(false);
                this.lastStyleSheetSet = name;
                continue;
            }
            sheet.setDisabled(true);
        }
    }

    @Override
    public String getLastStyleSheetSet() {
        return this.lastStyleSheetSet;
    }

    @Override
    public void enableStyleSheetsForSet(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || !title.equals(name)) continue;
            sheet.setDisabled(false);
        }
    }

    void onSheetModify() {
        this.mergedStyleSheet = null;
        this.sheets.setNeedsUpdate(true);
        this.onStyleModify();
    }

    void onStyleModify() {
    }

    @Override
    public ExtendedCSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        return ((DOMElement)elt).getOverrideStyle(pseudoElt);
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        DeviceFactory df;
        StyleDatabase sdb = null;
        if (this.targetMedium != null && (df = this.getStyleSheetFactory().getDeviceFactory()) != null) {
            sdb = df.getStyleDatabase(this.targetMedium);
        }
        return sdb;
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public void setTargetMedium(String medium) throws CSSMediaException {
        this.targetMedium = "all".equals(medium = medium.intern()) ? null : medium;
        this.onSheetModify();
    }

    @Override
    public CSSCanvas getCanvas() {
        CSSCanvas canvas;
        if (this.targetMedium == null) {
            return null;
        }
        if (this.canvases.containsKey(this.targetMedium)) {
            return this.canvases.get(this.targetMedium);
        }
        DeviceFactory df = this.getStyleSheetFactory().getDeviceFactory();
        if (df != null) {
            canvas = df.createCanvas(this.targetMedium, this);
            this.canvases.put(this.targetMedium, canvas);
        } else {
            canvas = null;
        }
        return canvas;
    }

    ErrorHandler createErrorHandler() {
        return new MyDefaultErrorHandler();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean hasStyleIssues() {
        return this.sheets.hasErrorsOrWarnings() || this.getErrorHandler().hasErrors() || this.getErrorHandler().hasWarnings();
    }

    public void onMetaAdded(String name, String attribute) {
        if ("Default-Style".equals(name)) {
            this.metaDefaultStyleSet = attribute;
        } else if ("referrer".equals(name)) {
            this.metaReferrerPolicy = attribute;
        }
    }

    public void onMetaRemoved(String name, String attribute) {
        if ("Default-Style".equals(name)) {
            this.metaDefaultStyleSet = "";
        } else if ("referrer".equals(name)) {
            this.metaReferrerPolicy = "";
        }
    }

    @Override
    public URL getBaseURL() {
        URL baseURL = null;
        String buri = this.getBaseURI();
        if (buri != null) {
            try {
                baseURL = new URL(buri);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return baseURL;
    }

    @Override
    public String getBaseURI() {
        String attr;
        String buri = this.getDocumentURI();
        DOMElement elm = this.getDocumentElement();
        if (elm != null && (attr = elm.getAttribute("xml:base")).length() != 0) {
            if (buri != null && attr.startsWith("//")) {
                try {
                    URL url = new URL(buri);
                    url = new URL(url, attr);
                    buri = url.toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                buri = attr;
            }
        }
        return buri;
    }

    @Override
    public URL getURL(String uri) throws MalformedURLException {
        if (uri.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        URL url = uri.indexOf("://") < 0 ? new URL(this.getBaseURL(), uri) : new URL(uri);
        return url;
    }

    @Override
    public boolean isSafeOrigin(URL linkedURL) {
        URL base = this.getBaseURL();
        String docHost = base.getHost();
        int docPort = base.getPort();
        if (docPort == -1) {
            docPort = base.getDefaultPort();
        }
        String linkedHost = linkedURL.getHost();
        int linkedPort = linkedURL.getPort();
        if (linkedPort == -1) {
            linkedPort = linkedURL.getDefaultPort();
        }
        return (docHost.equalsIgnoreCase(linkedHost) || linkedHost.endsWith(docHost)) && docPort == linkedPort;
    }

    @Override
    public String getReferrerPolicy() {
        return this.metaReferrerPolicy;
    }

    protected void setReferrerPolicyHeader(String policy) {
        if (this.metaReferrerPolicy.length() == 0) {
            this.metaReferrerPolicy = policy;
        }
    }

    public String toString() {
        return this.getChildNodes().toString();
    }

    public InputStream openStream(String uri) throws IOException {
        return this.openConnection(this.getURL(uri)).getInputStream();
    }

    class MyOMStyleSheetList
    extends StyleSheetList {
        protected MyOMStyleSheetList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected boolean hasErrorsOrWarnings() {
            boolean hasRuleErrors = false;
            Iterator<AbstractCSSStyleSheet> it = this.iterator();
            while (it.hasNext()) {
                AbstractCSSStyleSheet sheet = it.next();
                SheetErrorHandler eh = sheet.getErrorHandler();
                if (!sheet.hasRuleErrorsOrWarnings() && !eh.hasSacErrors() && !eh.hasSacWarnings() && !eh.hasOMErrors() && !eh.hasOMWarnings()) continue;
                hasRuleErrors = true;
                break;
            }
            return hasRuleErrors;
        }

        @Override
        protected Iterator<AbstractCSSStyleSheet> iterator() {
            return super.iterator();
        }

        @Override
        protected void clear() {
            super.clear();
        }

        @Override
        protected boolean needsUpdate() {
            return super.needsUpdate();
        }

        @Override
        protected void setNeedsUpdate(boolean needsUpdate) {
            super.setNeedsUpdate(needsUpdate);
        }

        @Override
        protected void update() {
            super.update();
            DOMDocument.this.updateStyleLists();
        }
    }

    static interface LinkStyleDefiner
    extends LinkStyle,
    Node {
        @Override
        public AbstractCSSStyleSheet getSheet();

        public void resetLinkedSheet();
    }

    class MyXMLElement
    extends DOMElement {
        private final HashMap<String, String> idAttrNameMap;

        MyXMLElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
            this.idAttrNameMap = new HashMap();
        }

        @Override
        public String getId() {
            Attr attr;
            String idAttrName = this.idAttrNameMap.get(null);
            if (idAttrName != null && (attr = (Attr)this.nodeMap.getNamedItem(idAttrName)) != null) {
                return attr.getNodeValue();
            }
            return super.getId();
        }

        @Override
        boolean isIdAttributeNS(String namespaceURI, String localName) {
            return localName.equals(this.idAttrNameMap.get(namespaceURI));
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            if (!this.hasAttribute(name)) {
                throw new DOMException(8, "Not an attribute of this element");
            }
            this.setIdAttrNS(null, name, isId);
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            if (!this.hasAttributeNS(namespaceURI, localName)) {
                throw new DOMException(8, "Not an attribute of this element");
            }
            this.setIdAttrNS(namespaceURI, localName, isId);
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            if (idAttr == null || !this.nodeMap.getNodeList().contains(idAttr)) {
                throw new DOMException(8, "Not an attribute of this element");
            }
            this.setIdAttrNS(idAttr.getNamespaceURI(), idAttr.getLocalName(), isId);
        }

        private void setIdAttrNS(String namespaceURI, String localName, boolean isId) {
            if (isId) {
                this.idAttrNameMap.put(namespaceURI, localName);
            } else if (localName.equals(this.idAttrNameMap.get(namespaceURI))) {
                this.idAttrNameMap.remove(namespaceURI);
            }
        }

        @Override
        boolean isVoid() {
            DocumentType docType = DOMDocument.this.getDoctype();
            if (docType != null) {
                ContentModel contentModel;
                try {
                    contentModel = ContentModel.getModel(docType);
                }
                catch (IOException | SAXException e) {
                    contentModel = null;
                }
                if (contentModel != null) {
                    return contentModel.isEmpty(this.localName);
                }
            }
            return false;
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        protected BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMDocument.this.getStyleSheetFactory();
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public DOMElement cloneNode(boolean deep) {
            return this.cloneElementNode(new MyXMLElement(this.getLocalName(), this.getNamespaceURI()), deep);
        }

        DOMElement cloneElementNode(MyXMLElement my, boolean deep) {
            my.setPrefix(this.getPrefix());
            for (DOMAttr attr : this.nodeMap.getNodeList()) {
                DOMAttr myattr = (DOMAttr)attr.cloneNode(deep);
                myattr.specified = attr.getSpecified();
                my.setAttributeNode(myattr);
                if (!attr.isId()) continue;
                my.setIdAttributeNode(myattr, true);
            }
            if (deep) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    my.appendChild(node.cloneNode(true));
                }
            }
            MyXMLElement.callUserHandlers((short)1, this, my);
            return my;
        }
    }

    class DOMDocumentFragment
    extends DOMParentNode
    implements DocumentFragment {
        DOMDocumentFragment() {
            super((short)11);
        }

        @Override
        public String getNodeName() {
            return "#document-fragment";
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return null;
        }

        @Override
        void checkAppendNodeHierarchy(Node newChild) {
            super.checkAppendNodeHierarchy(newChild);
            if (newChild.getNodeType() == 10) {
                throw new DOMException(3, "Doctype must be added to document.");
            }
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public DOMDocumentFragment cloneNode(boolean deep) {
            DOMDocumentFragment my = new DOMDocumentFragment();
            if (deep) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    my.appendChild(node.cloneNode(true));
                }
            }
            DOMDocumentFragment.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            int sz = this.getChildNodes().getLength();
            StringBuilder buf = new StringBuilder(64 + sz * 32);
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                buf.append(node.toString());
            }
            return buf.toString();
        }
    }

    class MyText
    extends MyCharacterData
    implements Text {
        boolean elementContentWhitespace;

        MyText() {
            super((short)3);
            this.elementContentWhitespace = false;
        }

        MyText(short nodeType) {
            super(nodeType);
            this.elementContentWhitespace = false;
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) {
            DOMNode oldParent = this.getParentNode();
            if (oldParent != null && oldParent.getNodeType() == 1) {
                this.onDOMChange((DOMElement)oldParent);
            }
            if (parentNode == null) {
                super.setParentNode(parentNode);
            } else {
                super.setParentNode(parentNode);
                if (parentNode.getNodeType() == 1) {
                    this.onDOMChange((DOMElement)parentNode);
                }
            }
        }

        @Override
        public void setData(String data) throws DOMException {
            super.setData(data);
            DOMNode parent = this.getParentNode();
            if (parent != null && parent.getNodeType() == 1) {
                this.onDOMChange((DOMElement)parent);
            }
        }

        void onDOMChange(DOMElement container) {
            LinkStyleDefiner definer = DOMDocument.this.getEmbeddedStyleDefiner(container);
            if (definer != null) {
                definer.resetLinkedSheet();
            }
        }

        @Override
        public Text splitText(int offset) throws DOMException {
            Text newnode;
            DOMNode parent = this.getParentNode();
            try {
                String newdata = this.data.substring(0, offset);
                newnode = this.getOwnerDocument().createTextNode(this.data.substring(offset, this.data.length()));
                if (parent != null) {
                    parent.insertBefore(newnode, this.getNextSibling());
                }
                this.setData(newdata);
            }
            catch (IndexOutOfBoundsException e) {
                DOMException ex = new DOMException(1, e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            return newnode;
        }

        @Override
        public boolean isElementContentWhitespace() {
            if (this.data != null) {
                int dl = this.data.length();
                for (int i = 0; i < dl; ++i) {
                    if (Character.isWhitespace(this.data.charAt(i))) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public String getWholeText() {
            short type;
            short type2;
            Node node;
            DOMNode firstnode = this;
            for (node = this.getPreviousSibling(); node != null && ((type2 = node.getNodeType()) == 3 || type2 == 5); node = node.getPreviousSibling()) {
                firstnode = node;
            }
            Node lastnode = this;
            for (node = this.getNextSibling(); node != null && ((type = node.getNodeType()) == 3 || type == 5); node = node.getNextSibling()) {
                lastnode = node;
            }
            if (firstnode == lastnode) {
                return this.getData();
            }
            StringBuilder buf = new StringBuilder(this.data.length() * 2);
            for (node = firstnode; node != lastnode; node = node.getNextSibling()) {
                buf.append(node.toString());
            }
            buf.append(lastnode.toString());
            return buf.toString();
        }

        @Override
        public Text replaceWholeText(String content) throws DOMException {
            if (content == null) {
                throw new DOMException(5, "null content (use empty string instead)");
            }
            DOMNode parent = this.getParentNode();
            if (parent != null) {
                Node sibling;
                short type;
                Node node = this.getPreviousSibling();
                while (node != null && ((type = node.getNodeType()) == 5 || type == 3)) {
                    sibling = node.getPreviousSibling();
                    parent.removeChild(node);
                    node = sibling;
                }
                node = this.getNextSibling();
                while (node != null && ((type = node.getNodeType()) == 5 || type == 3)) {
                    sibling = node.getNextSibling();
                    parent.removeChild(node);
                    node = sibling;
                }
            }
            this.setData(content);
            if (content.length() == 0) {
                if (parent != null) {
                    parent.removeChild(this);
                }
                return null;
            }
            return this;
        }

        @Override
        public String getNodeName() {
            return "#text";
        }

        @Override
        public Text cloneNode(boolean deep) {
            MyText my = new MyText();
            my.setData(this.getData());
            MyText.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            String text = this.getData();
            if (!this.isElementContentWhitespace()) {
                DOMNode node = this.getParentNode();
                if (node != null && node.getNodeType() == 1 && ((DOMElement)node).isRawText()) {
                    String parentLName = node.getLocalName();
                    text = DOMDocument.escapeCloseTag(parentLName, text);
                } else {
                    text = DOMDocument.escapeLtGtEntities(text);
                }
            }
            return text;
        }
    }

    class MyComment
    extends MyCharacterData
    implements Comment {
        MyComment() {
            super((short)8);
        }

        @Override
        public String getNodeName() {
            return "#comment";
        }

        @Override
        public void setData(String data) throws DOMException {
            if (data.contains("-->")) {
                throw new DOMException(5, "Comment cannot contain '--'");
            }
            super.setData(data);
        }

        @Override
        public Comment cloneNode(boolean deep) {
            MyComment my = new MyComment();
            my.setData(this.getData());
            MyComment.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    class MyCDATASection
    extends MyText
    implements CDATASection {
        MyCDATASection() {
            super((short)4);
        }

        @Override
        public String getNodeName() {
            return "#cdata-section";
        }

        @Override
        public void setData(String data) throws DOMException {
            if (data.contains("]]>")) {
                throw new DOMException(5, "cdata-section cannot contain ']]>'");
            }
            super.setData(data);
        }

        @Override
        public CDATASection cloneNode(boolean deep) {
            MyCDATASection my = new MyCDATASection();
            my.setData(this.getData());
            MyCDATASection.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        public String toString() {
            return "<![CDATA[" + this.getData() + "]]>";
        }
    }

    class MyStyleProcessingInstruction
    extends MyProcessingInstruction
    implements LinkStyleProcessingInstruction {
        private AbstractCSSStyleSheet linkedSheet;
        private final LinkedHashMap<String, String> pseudoAttrs;

        MyStyleProcessingInstruction(String data) {
            super("xml-stylesheet", data);
            this.linkedSheet = null;
            this.pseudoAttrs = new LinkedHashMap();
            this.parseData();
        }

        @Override
        public void setData(String data) throws DOMException {
            super.setData(data);
            this.parseData();
            this.resetLinkedSheet();
            if (this.getParentNode() != null) {
                DOMDocument.this.onSheetModify();
            }
        }

        private void parseData() throws DOMException {
            DOMUtil.parsePseudoAttributes(this.getData(), this.pseudoAttrs);
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            super.setParentNode(parentNode);
            DOMDocument.this.onSheetModify();
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.linkedSheet == null) {
                boolean alternate;
                String type = this.getPseudoAttribute("type");
                if (type.length() != 0 && !"text/css".equals(type)) {
                    return null;
                }
                MediaQueryList media = DOMDocument.this.parseMediaList(this.getPseudoAttribute("media").trim(), this);
                if (media == null) {
                    return null;
                }
                String title = this.getPseudoAttribute("title");
                if (title.length() == 0) {
                    title = null;
                }
                if ((alternate = "yes".equalsIgnoreCase(this.getPseudoAttribute("alternate"))) && title == null) {
                    DOMDocument.this.getErrorHandler().linkedStyleError(this, "Alternate sheet without title");
                    return null;
                }
                String href = this.getPseudoAttribute("href");
                int hreflen = href.length();
                if (hreflen > 1) {
                    if (href.charAt(0) != '#') {
                        this.linkedSheet = DOMDocument.this.loadStyleSheet(this.linkedSheet, href, title, media, this);
                    } else {
                        String id = href.substring(1);
                        DOMElement elm = DOMDocument.this.getElementById(id);
                        if (elm != null) {
                            String text = elm.getTextContent().trim();
                            this.linkedSheet = DOMDocument.this.parseEmbeddedStyleSheet(this.linkedSheet, text, title, media, this);
                        } else {
                            DOMDocument.this.getErrorHandler().linkedStyleError(this, "Could not find element with id: " + id);
                        }
                    }
                    if (alternate && this.linkedSheet != null) {
                        this.linkedSheet.setDisabled(true);
                    }
                } else {
                    DOMDocument.this.getErrorHandler().linkedStyleError(this, "Missing or void href pseudo-attribute.");
                }
            }
            return this.linkedSheet;
        }

        @Override
        public String getPseudoAttribute(String attrname) {
            String value = this.pseudoAttrs.get(attrname);
            if (value == null) {
                value = "";
            }
            return value;
        }

        @Override
        public void resetLinkedSheet() {
            this.linkedSheet = null;
            this.getOwnerDocument().onSheetModify();
        }

        @Override
        public ProcessingInstruction cloneNode(boolean deep) {
            MyStyleProcessingInstruction my = new MyStyleProcessingInstruction(this.getData());
            MyStyleProcessingInstruction.callUserHandlers((short)1, this, my);
            return my;
        }
    }

    class MyProcessingInstruction
    extends MyNode
    implements ProcessingInstruction {
        String data;
        private final String target;

        MyProcessingInstruction(String target, String data) {
            super((short)7);
            this.target = target;
            this.data = data;
        }

        @Override
        public String getNodeName() {
            return this.getTarget();
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public String getTarget() {
            return this.target;
        }

        @Override
        public void setData(String data) throws DOMException {
            if (data.indexOf(62) != -1) {
                throw new DOMException(5, "PI is not allowed to contain '>'");
            }
            this.data = data;
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getData();
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.setData(nodeValue);
        }

        @Override
        public ProcessingInstruction cloneNode(boolean deep) {
            MyProcessingInstruction my = new MyProcessingInstruction(this.getTarget(), this.getData());
            MyProcessingInstruction.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            return "<?" + this.getTarget() + " " + this.getData() + "?>";
        }
    }

    class MyEntityReference
    extends MyNode
    implements EntityReference {
        private final String name;

        MyEntityReference(String name) {
            super((short)5);
            this.name = name;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        void checkAppendNodeHierarchy(Node newChild) {
            super.checkAppendNodeHierarchy(newChild);
            throw new DOMException(9, "This implementation does not support appending nodes to an entity reference.");
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return null;
        }

        public String toString() {
            return '&' + this.name + ';';
        }
    }

    class XmlnsAttr
    extends MyAttr {
        XmlnsAttr() {
            super("xmlns", DOMDocument.XMLNS_NAMESPACE_URI);
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
            throw new DOMException(14, "Cannot set prefix for xmlns attribute");
        }
    }

    class ClassAttr
    extends MyAttr {
        ClassAttr(String namespaceURI) {
            super("class", namespaceURI);
        }

        @Override
        void setAttributeOwner(DOMElement newOwner) throws DOMException {
            DOMElement parentElm;
            DOMNode parent;
            DOMElement oldOwner;
            if (newOwner == null && (oldOwner = this.getOwnerElement()) != null && this.isSameNamespace(oldOwner.getNamespaceURI())) {
                parent = oldOwner.getParentNode();
                if (parent != null && parent.getNodeType() == 1) {
                    parentElm = (DOMElement)parent;
                    parentElm.updateClasslistsOnRemove(oldOwner, parentElm);
                }
                if (oldOwner.classList != null) {
                    this.value = oldOwner.classList.getValue();
                    oldOwner.classList.clear();
                }
            }
            super.setAttributeOwner(newOwner);
            if (newOwner != null && this.isSameNamespace(newOwner.getNamespaceURI())) {
                if (newOwner.classList != null) {
                    newOwner.classList.setValue(this.value);
                }
                if ((parent = newOwner.getParentNode()) != null && parent.getNodeType() == 1) {
                    parentElm = (DOMElement)parent;
                    parentElm.updateClasslists(newOwner, parentElm);
                }
            }
        }

        private boolean isSameNamespace(String ownerNamespaceURI) {
            String namespaceURI = this.getNamespaceURI();
            if (namespaceURI == null) {
                return ownerNamespaceURI == null || this.isDefaultNamespace(ownerNamespaceURI);
            }
            return namespaceURI.equals(ownerNamespaceURI);
        }

        @Override
        public String getValue() {
            DOMElement.ClassList list = this.getListValue();
            if (list == null) {
                return super.getValue();
            }
            return list.getValue();
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            DOMElement.ClassList list = this.getListValue();
            if (list != null) {
                list.setValue(value);
            }
        }

        DOMElement.ClassList getListValue() {
            DOMElement owner = this.getOwnerElement();
            if (owner == null || !this.isSameNamespace(owner.getNamespaceURI())) {
                return null;
            }
            return (DOMElement.ClassList)owner.getClassList();
        }
    }

    class StyleEventAttr
    extends MyAttr {
        StyleEventAttr(String name, String namespaceURI) {
            super(name, namespaceURI);
        }

        @Override
        void setAttributeOwner(DOMElement newOwner) {
            super.setAttributeOwner(newOwner);
            this.onDOMChange(newOwner);
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            this.onDOMChange(this.getOwnerElement());
        }

        void onDOMChange(Node ownerNode) {
            if (ownerNode != null && ownerNode instanceof LinkStyleDefiner) {
                ((LinkStyleDefiner)ownerNode).resetLinkedSheet();
            }
        }
    }

    class MyStyleAttr
    extends MyAttr
    implements StyleAttr {
        private AbstractCSSStyleDeclaration inlineStyle;

        MyStyleAttr(String name) {
            super(name, null);
            this.inlineStyle = null;
        }

        @Override
        void setAttributeOwner(DOMElement newOwner) {
            super.setAttributeOwner(newOwner);
            this.onDOMChange();
        }

        @Override
        public String getValue() {
            if (this.inlineStyle == null) {
                return super.getValue();
            }
            return this.inlineStyle.getCssText();
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            if (this.inlineStyle != null) {
                this.setInlineStyle(value);
            } else {
                this.getStyle();
            }
            this.onDOMChange();
        }

        @Override
        public AbstractCSSStyleDeclaration getStyle() {
            if (this.inlineStyle == null) {
                this.inlineStyle = this.getOwnerDocument().getStyleSheetFactory().createInlineStyle(this);
                this.setInlineStyle(super.getValue());
            }
            return this.inlineStyle;
        }

        void setInlineStyle(String value) {
            if (value == null) {
                value = "";
            }
            try {
                this.inlineStyle.setCssText(value);
            }
            catch (DOMException e) {
                DOMDocument.this.getErrorHandler().inlineStyleError(this.getOwnerElement(), e, value);
            }
        }

        void onDOMChange() {
            DOMDocument.this.onStyleModify();
        }
    }

    class MyAttr
    extends DOMAttr {
        MyAttr(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public boolean isId() {
            String nsuri = this.getNamespaceURI();
            DOMElement owner = this.getOwnerElement();
            return owner != null && owner.isIdAttributeNS(nsuri, this.getLocalName());
        }

        @Override
        public Attr cloneNode(boolean deep) {
            MyAttr my = (MyAttr)this.getOwnerDocument().createAttributeNS(this.getNamespaceURI(), this.getName());
            my.setValue(this.getValue());
            MyAttr.callUserHandlers((short)1, this, my);
            return my;
        }
    }

    static interface LinkStyleProcessingInstruction
    extends LinkStyleDefiner,
    ProcessingInstruction {
        public String getPseudoAttribute(String var1);
    }

    class MyDefaultErrorHandler
    extends DefaultErrorHandler {
        MyDefaultErrorHandler() {
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMDocument.this.getStyleSheetFactory();
        }
    }

    static interface StyleAttr
    extends Attr {
        public AbstractCSSStyleDeclaration getStyle();
    }

    abstract class MyCharacterData
    extends MyNode
    implements CharacterData {
        String data;

        MyCharacterData(short nodeType) {
            super(nodeType);
            this.data = null;
        }

        @Override
        void checkAppendNodeHierarchy(Node newChild) {
            throw new DOMException(3, "Cannot append the node to text/comment/cdatasection");
        }

        @Override
        public String getData() throws DOMException {
            return this.data;
        }

        @Override
        public void setData(String data) throws DOMException {
            this.data = data;
        }

        @Override
        public int getLength() {
            return this.data.length();
        }

        @Override
        public String substringData(int offset, int count) throws DOMException {
            int dl = this.data.length();
            int oc = offset + count;
            if (offset <= dl && oc >= dl) {
                return this.data;
            }
            try {
                return this.data.substring(offset, oc);
            }
            catch (IndexOutOfBoundsException e) {
                DOMException ex = new DOMException(1, e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }

        @Override
        public void appendData(String arg) throws DOMException {
            StringBuilder buf = new StringBuilder(this.data.length() + arg.length());
            buf.append(this.data).append(arg);
            this.setData(buf.toString());
        }

        @Override
        public void insertData(int offset, String arg) throws DOMException {
            int dl = this.data.length();
            if (offset < 0 || offset > dl) {
                throw new DOMException(1, "Wrong arguments");
            }
            StringBuilder buf = new StringBuilder(dl + arg.length());
            buf.append(this.data.subSequence(0, offset)).append(arg).append(this.data.subSequence(offset, dl));
            this.setData(buf.toString());
        }

        @Override
        public void deleteData(int offset, int count) throws DOMException {
            int dl = this.data.length();
            if (offset < 0 || count < 0 || offset >= dl) {
                throw new DOMException(1, "Wrong arguments");
            }
            int begin2 = offset + count;
            if (begin2 > dl) {
                begin2 = dl;
                count = dl - offset;
            }
            StringBuilder buf = new StringBuilder(dl - count);
            buf.append(this.data.subSequence(0, offset)).append(this.data.subSequence(begin2, dl));
            this.setData(buf.toString());
        }

        @Override
        public void replaceData(int offset, int count, String arg) throws DOMException {
            int dl = this.data.length();
            StringBuilder buf = new StringBuilder(dl + arg.length() - count);
            try {
                buf.append(this.data.subSequence(0, offset)).append(arg);
                if (offset + count < dl) {
                    buf.append(this.data.subSequence(offset + count, dl));
                }
            }
            catch (IndexOutOfBoundsException e) {
                DOMException ex = new DOMException(1, e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            this.setData(buf.toString());
        }

        @Override
        public String getNodeValue() {
            return this.getData();
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.setData(nodeValue);
        }
    }

    abstract class MyNode
    extends NDTNode {
        MyNode(short nodeType) {
            super(nodeType);
        }

        @Override
        void checkAppendNode(Node newChild) {
            throw new DOMException(3, "Cannot append the node to " + this.getNodeName());
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public Node cloneNode(boolean deep) {
            return this;
        }
    }
}

