/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMTokenList;
import io.sf.carte.doc.DOMTokenSetImpl;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.AttributeNamedNodeMap;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMNamedNodeMap;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMNodeList;
import io.sf.carte.doc.dom.DOMTypeInfo;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.NDTNode;
import io.sf.carte.doc.dom.NamespacedNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeListIterator;
import io.sf.carte.doc.dom.ParentNode;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSStyleSheetFactory;
import io.sf.carte.doc.style.css.ExtendedCSSStyleDeclaration;
import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DOMSelectorMatcher;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.css.CSSStyleDeclaration;

public abstract class DOMElement
extends NamespacedNode
implements CSSElement,
ParentNode {
    final String localName;
    final MyNamedNodeMap nodeMap;
    private final AbstractDOMNode.ChildCollections child;
    ClassList classList = null;
    private TypeInfo schemaTypeInfo = null;
    private WeakReference<SelectorMatcher> selectorMatcherRef = null;
    private Map<String, ExtendedCSSStyleDeclaration> overrideStyleSet = null;
    private boolean rawTextElement = false;

    DOMElement(String localName, String namespaceUri) {
        super((short)1, namespaceUri);
        this.localName = localName;
        this.nodeMap = new MyNamedNodeMap();
        this.child = new NDTNode.DefaultChildNodeList(this);
    }

    @Override
    AbstractDOMNode.ChildCollections getNodeList() {
        return this.child;
    }

    boolean isVoid() {
        return false;
    }

    void setRawText() {
        this.rawTextElement = true;
    }

    boolean isRawText() {
        return this.rawTextElement || "preserve".equalsIgnoreCase(this.getAttributeNS("http://www.w3.org/XML/1998/namespace", "space"));
    }

    @Override
    public AttributeNamedNodeMap getAttributes() {
        return this.nodeMap;
    }

    @Override
    public boolean hasAttributes() {
        return !this.nodeMap.isEmpty();
    }

    @Override
    public String getAttribute(String name) {
        Attr attr = (Attr)this.nodeMap.getNamedItem(name);
        String attrStr = attr == null ? "" : attr.getValue();
        return attrStr;
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attr attr = (Attr)this.nodeMap.getNamedItemNS(namespaceURI, localName);
        String attrStr = attr == null ? "" : attr.getValue();
        return attrStr;
    }

    @Override
    public Attr getAttributeNode(String name) {
        return (Attr)this.nodeMap.getNamedItem(name);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return (Attr)this.nodeMap.getNamedItemNS(namespaceURI, localName);
    }

    @Override
    public boolean hasAttribute(String name) {
        boolean ret = this.nodeMap.hasAttribute(name);
        if (!ret && name.indexOf(58) == -1) {
            name = name.toLowerCase(Locale.ROOT);
            ret = this.nodeMap.hasAttribute(name);
        }
        return ret;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.nodeMap.getNamedItemNS(namespaceURI, localName) != null;
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        block2: {
            try {
                this.nodeMap.removeNamedItem(name);
            }
            catch (DOMException e) {
                if (e.code == 8) break block2;
                throw e;
            }
        }
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        block2: {
            try {
                this.nodeMap.removeNamedItemNS(namespaceURI, localName);
            }
            catch (DOMException e) {
                if (e.code == 8) break block2;
                throw e;
            }
        }
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        return (Attr)this.nodeMap.removeItem(oldAttr);
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        Attr attr = (Attr)this.nodeMap.getNamedItem(name);
        if (attr == null) {
            attr = this.getOwnerDocument().createAttribute(name);
            attr.setValue(value);
            this.nodeMap.setNamedItem(attr);
        } else {
            attr.setValue(value);
        }
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        Attr attr = (Attr)this.nodeMap.getNamedItem(qualifiedName);
        if (attr == null) {
            attr = this.getOwnerDocument().createAttributeNS(namespaceURI, qualifiedName);
            this.nodeMap.setNamedItemNS(attr);
        }
        attr.setValue(value);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return (Attr)this.nodeMap.setNamedItem(newAttr);
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.setAttributeNode(newAttr);
    }

    @Override
    public String getId() {
        if (!this.nodeMap.isEmpty()) {
            for (Attr attr : this.nodeMap.getNodeList()) {
                if (!attr.isId()) continue;
                return attr.getValue();
            }
        }
        return "";
    }

    abstract boolean isIdAttributeNS(String var1, String var2);

    @Override
    public ElementList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.child.getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public ElementList getElementsByTagName(String name) {
        return this.child.getElementsByTagName(name);
    }

    @Override
    void updateTaglistsOnInsert(DOMElement newChild, AbstractDOMNode appendedTo) {
        this.child.updateTaglistsOnInsert(newChild, appendedTo);
        super.updateTaglistsOnInsert(newChild, appendedTo);
    }

    @Override
    void updateTaglistsOnRemove(DOMElement oldChild, AbstractDOMNode removedFrom) {
        this.child.updateTaglistsOnRemove(oldChild, removedFrom);
        super.updateTaglistsOnRemove(oldChild, removedFrom);
    }

    public DOMTokenList getClassList() {
        if (this.classList == null) {
            DOMAttr attr = (DOMAttr)this.nodeMap.getNamedItem("class");
            this.classList = this.getOwnerDocument().getComplianceMode() == CSSDocument.ComplianceMode.STRICT ? new ClassList() : new QuirksClassList();
            if (attr != null && attr.value.length() != 0) {
                this.classList.setValue(attr.value);
            }
        }
        return this.classList;
    }

    @Override
    public ElementList getElementsByClassName(String names) {
        return this.child.getElementsByClassName(names, this.getOwnerDocument().getComplianceMode());
    }

    @Override
    void updateClasslists(DOMElement owner, AbstractDOMNode appendedTo) {
        this.child.updateClasslists(owner, appendedTo);
        super.updateClasslists(owner, appendedTo);
    }

    @Override
    void updateClasslistsOnRemove(DOMElement oldChild, AbstractDOMNode removedFrom) {
        this.child.updateClasslistsOnRemove(oldChild, removedFrom);
        super.updateClasslistsOnRemove(oldChild, removedFrom);
    }

    public String getClassName() {
        return this.getAttribute("class");
    }

    public void setClassName(String className) {
        this.setAttribute("class", className);
    }

    @Override
    public ElementList querySelectorAll(String selectors) {
        return DOMElement.querySelectorAll(selectors, this.getFirstChild());
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getTagName() {
        String tagname = this.localName;
        String prefix = this.getPrefix();
        if (prefix == null) {
            return tagname;
        }
        StringBuilder buf = new StringBuilder(tagname.length() + prefix.length() + 1);
        buf.append(prefix).append(':').append(tagname);
        return buf.toString();
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        String namespaceURI = super.lookupNamespaceURI(prefix);
        if (namespaceURI == null) {
            AbstractDOMNode.RawNodeList nodelist = this.nodeMap.getNodeList();
            if (!nodelist.isEmpty()) {
                for (Attr attr : nodelist) {
                    String localName = attr.getLocalName();
                    String pre = attr.getPrefix();
                    if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
                    if ("xmlns".equals(localName) && prefix.equals(pre)) {
                        return attr.getValue();
                    }
                    if (!"xmlns".equals(pre) || !pre.equals(localName)) continue;
                    return attr.getValue();
                }
            }
            Node pnode = this;
            while ((pnode = pnode.getParentNode()) != null && pnode.getNodeType() != 1) {
            }
            if (pnode != null) {
                namespaceURI = pnode.lookupNamespaceURI(namespaceURI);
            }
        }
        return namespaceURI;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        if (namespaceURI.equals(this.getNamespaceURI())) {
            return this.getPrefix();
        }
        AbstractDOMNode.RawNodeList nodelist = this.nodeMap.getNodeList();
        if (!nodelist.isEmpty()) {
            for (Attr attr : nodelist) {
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !namespaceURI.equals(attr.getValue())) continue;
                String localName = attr.getLocalName();
                String prefix = attr.getPrefix();
                if ("xmlns".equals(localName)) {
                    return prefix;
                }
                if (!"xmlns".equals(prefix)) continue;
                return localName;
            }
        }
        Node pnode = this;
        while ((pnode = pnode.getParentNode()) != null && pnode.getNodeType() != 1) {
        }
        if (pnode != null) {
            return pnode.lookupPrefix(namespaceURI);
        }
        return namespaceURI == "http://www.w3.org/XML/1998/namespace" ? "xml" : null;
    }

    @Override
    void checkAppendNodeHierarchy(Node newChild) {
        super.checkAppendNodeHierarchy(newChild);
        if (newChild.getNodeType() == 10) {
            throw new DOMException(3, "Doctype must be added to document.");
        }
    }

    @Override
    public DOMElement getFirstElementChild() {
        return super.getFirstElementChild();
    }

    @Override
    public DOMElement getLastElementChild() {
        return super.getLastElementChild();
    }

    @Override
    public ElementList getChildren() {
        return this.child.getChildren();
    }

    @Override
    public int getChildElementCount() {
        return super.getChildElementCount();
    }

    @Override
    public Iterator<DOMNode> iterator() {
        return this.child.iterator();
    }

    @Override
    public Iterator<DOMNode> descendingIterator() {
        return this.child.createDescendingIterator();
    }

    @Override
    public Iterator<DOMNode> iterator(BitSet whatToShow) {
        return this.child.createIterator(whatToShow);
    }

    @Override
    public Iterator<DOMElement> elementIterator() {
        return this.child.elementIterator();
    }

    @Override
    public Iterator<DOMNode> iterator(int whatToShow, NodeFilter filter) {
        return this.child.createIterator(whatToShow, filter);
    }

    @Override
    public Iterator<DOMNode> typeIterator(short typeToShow) {
        return this.iterator(NodeFilter.maskTable[typeToShow - 1], null);
    }

    @Override
    public Iterator<DOMNode> iterator(NodeFilter filter) {
        return this.child.createIterator(-1, filter);
    }

    @Override
    public NodeListIterator listIterator() {
        return this.child.createListIterator();
    }

    @Override
    public SelectorMatcher getSelectorMatcher() {
        SelectorMatcher matcher = null;
        if (this.selectorMatcherRef != null) {
            matcher = (SelectorMatcher)this.selectorMatcherRef.get();
        }
        if (matcher == null) {
            matcher = new DOMSelectorMatcher(this);
            this.selectorMatcherRef = new WeakReference<SelectorMatcher>(matcher);
        }
        return matcher;
    }

    @Override
    public boolean matches(String selectorString, String pseudoElement) throws DOMException {
        SelectorList list;
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource((Reader)new StringReader(selectorString));
        try {
            list = parser.parseSelectors(source);
        }
        catch (Exception e) {
            throw new DOMException(12, "Unable to parse selector in: " + selectorString);
        }
        return this.matches(list, pseudoElement);
    }

    @Override
    public boolean matches(SelectorList selist, String pseudoElement) {
        SelectorMatcher matcher = this.getSelectorMatcher();
        matcher.setPseudoElement(pseudoElement);
        return matcher.matches(selist) != -1;
    }

    @Override
    public ExtendedCSSStyleDeclaration getStyle() {
        DOMDocument.StyleAttr styleAttr = (DOMDocument.StyleAttr)this.getAttributeNode("style");
        if (styleAttr == null) {
            if (this.getOwnerDocument().getComplianceMode() == CSSDocument.ComplianceMode.QUIRKS) {
                for (Attr node : this.getAttributes()) {
                    if (!"style".equalsIgnoreCase(node.getNodeName())) continue;
                    return ((DOMDocument.StyleAttr)node).getStyle();
                }
            }
            return null;
        }
        return styleAttr.getStyle();
    }

    @Override
    public boolean hasOverrideStyle(String pseudoElt) {
        if (this.overrideStyleSet == null) {
            return false;
        }
        return this.overrideStyleSet.containsKey(pseudoElt);
    }

    @Override
    public ExtendedCSSStyleDeclaration getOverrideStyle(String pseudoElt) {
        ExtendedCSSStyleDeclaration overrideStyle = null;
        if (this.overrideStyleSet == null) {
            this.overrideStyleSet = new HashMap<String, ExtendedCSSStyleDeclaration>(1);
        } else {
            overrideStyle = this.overrideStyleSet.get(pseudoElt);
        }
        if (overrideStyle == null) {
            overrideStyle = this.getOwnerDocument().getStyleSheetFactory().createInlineStyle(this);
            this.overrideStyleSet.put(pseudoElt, overrideStyle);
        }
        return overrideStyle;
    }

    @Override
    public boolean hasPresentationalHints() {
        return false;
    }

    @Override
    public void exportHintsToStyle(CSSStyleDeclaration style) {
    }

    @Override
    public ComputedCSSStyle getComputedStyle(String pseudoElt) {
        return (ComputedCSSStyle)this.getOwnerDocument().getStyleSheet().getComputedStyle(this, pseudoElt);
    }

    @Override
    public abstract DOMElement cloneNode(boolean var1);

    abstract CSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public TypeInfo getSchemaTypeInfo() {
        if (this.schemaTypeInfo == null) {
            this.schemaTypeInfo = new ElementTypeInfo();
        }
        return this.schemaTypeInfo;
    }

    public String getStartTag() {
        StringBuilder buf = new StringBuilder(128);
        buf.append('<').append(this.getTagName());
        if (this.nodeMap.getLength() > 0) {
            buf.append(' ');
            this.nodeMap.appendTo(buf);
        }
        if (this.hasChildNodes()) {
            buf.append('>');
        } else {
            buf.append(" />");
        }
        return buf.toString();
    }

    public String toString() {
        int bufsz = 32;
        if (this.hasChildNodes()) {
            bufsz = 720;
        } else if (this.hasAttributes()) {
            bufsz = 128;
        }
        String tagname = this.getTagName();
        StringBuilder buf = new StringBuilder(bufsz);
        buf.append('<').append(tagname);
        if (this.nodeMap.getLength() > 0) {
            buf.append(' ');
            this.nodeMap.appendTo(buf);
        }
        if (!this.isVoid()) {
            buf.append('>');
            if (this.hasChildNodes()) {
                DOMNodeList list = this.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    buf.append(list.item(i).toString());
                }
            }
            buf.append("</").append(tagname).append('>');
        } else {
            buf.append(" />");
        }
        return buf.toString();
    }

    class ClassList
    extends DOMTokenSetImpl {
        ClassList() {
        }

        @Override
        public void setValue(String value) throws DOMException {
            if (value == null || value.length() == 0) {
                this.clear();
                value = "";
            }
            super.setValue(value);
            this.updateClassLists();
        }

        @Override
        protected void addUnchecked(String token) throws DOMException {
            super.addUnchecked(token);
            if (!DOMElement.this.nodeMap.hasAttribute("class")) {
                DOMAttr attr = (DOMAttr)DOMElement.this.getOwnerDocument().createAttributeNS(null, "class");
                attr.setValue(token);
                DOMElement.this.nodeMap.setNamedItem(attr);
                attr.setAttributeOwner(DOMElement.this);
            }
            this.updateClassLists();
        }

        @Override
        protected void removeUnchecked(String token) throws DOMException {
            super.removeUnchecked(token);
            this.updateClassLists();
        }

        @Override
        protected boolean toggleUnchecked(String token) throws DOMException {
            boolean result = super.toggleUnchecked(token);
            this.updateClassLists();
            return result;
        }

        @Override
        protected void replaceUnchecked(String oldToken, String newToken) throws DOMException {
            super.replaceUnchecked(oldToken, newToken);
            this.updateClassLists();
        }

        @Override
        public void clear() {
            super.clear();
            this.updateClassLists();
        }

        private void updateClassLists() {
            AbstractDOMNode parent = DOMElement.this.parentNode();
            if (parent instanceof ParentNode) {
                parent.updateClasslists(DOMElement.this, parent);
            }
        }
    }

    class MyNamedNodeMap
    extends DOMNamedNodeMap<DOMAttr>
    implements AttributeNamedNodeMap {
        MyNamedNodeMap() {
            super((short)2);
        }

        @Override
        public Iterator<Attr> iterator() {
            return this.getNodeList().attributeIterator();
        }

        @Override
        void registerNode(DOMAttr arg) {
            arg.setAttributeOwner(DOMElement.this);
        }

        @Override
        void unregisterNode(DOMAttr removedItem) {
            removedItem.setAttributeOwner(null);
        }

        @Override
        void verifyNewNode(Node arg) throws DOMException {
            super.verifyNewNode(arg);
            Element owner = ((Attr)arg).getOwnerElement();
            if (owner != null && owner != DOMElement.this) {
                throw new DOMException(10, "Attribute is already in use.");
            }
        }

        @Override
        DOMElement getOwnerNode() {
            return DOMElement.this;
        }
    }

    class QuirksClassList
    extends ClassList {
        QuirksClassList() {
        }

        @Override
        public void setValue(String value) throws DOMException {
            if (value != null && value.length() == 0) {
                value = value.toLowerCase(Locale.ROOT);
            }
            super.setValue(value);
        }

        @Override
        public boolean contains(String token) {
            if (token == null) {
                return false;
            }
            token = token.toLowerCase(Locale.ROOT);
            return super.contains(token);
        }

        @Override
        public void add(String token) throws DOMException {
            this.argumentCheckVoidSpaces(token);
            token = token.toLowerCase(Locale.ROOT);
            this.addUnchecked(token);
        }

        @Override
        public void remove(String token) throws DOMException {
            this.argumentCheckVoidSpaces(token);
            token = token.toLowerCase(Locale.ROOT);
            this.removeUnchecked(token);
        }

        @Override
        public boolean toggle(String token) throws DOMException {
            this.argumentCheckVoidSpaces(token);
            token = token.toLowerCase(Locale.ROOT);
            return this.toggleUnchecked(token);
        }

        @Override
        public void replace(String oldToken, String newToken) throws DOMException {
            this.argumentCheckVoidSpaces(oldToken);
            this.argumentCheckVoidSpaces(newToken);
            oldToken = oldToken.toLowerCase(Locale.ROOT);
            newToken = newToken.toLowerCase(Locale.ROOT);
            this.replaceUnchecked(oldToken, newToken);
        }
    }

    static class ElementTypeInfo
    extends DOMTypeInfo {
        ElementTypeInfo() {
        }

        @Override
        public String getTypeNamespace() {
            return null;
        }
    }
}

