/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AttributeNamedNodeMap;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMNodeList;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.ExtendedCSSRuleList;
import io.sf.carte.doc.style.css.ExtendedCSSStyleRule;
import io.sf.carte.doc.style.css.ExtendedCSSStyleSheet;
import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import io.sf.carte.doc.xml.dtd.EntityFinder;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class DOMWriter {
    private String indentingUnit = "  ";
    private final StringBuilder indentString = new StringBuilder(48);
    private HashMap<Integer, String> entityMap = null;
    private EntityResolver2 resolver = null;
    private ExtendedCSSStyleSheet<?> uaSheet;
    private HashMap<String, String> displayMap = null;
    private Node rootNode = null;

    public DOMWriter() {
    }

    public DOMWriter(ExtendedCSSStyleSheet<? extends ExtendedCSSRule> refSheet) {
        this.uaSheet = refSheet;
    }

    public int setEntityCodepoints(DocumentType docType, int[] entities) throws SAXException, IOException {
        InputSource is;
        if (docType == null || entities == null) {
            throw new NullPointerException();
        }
        int ret = 0;
        if (this.entityMap == null) {
            this.entityMap = new HashMap(entities.length + 2);
            this.entityMap.put(60, "lt");
            this.entityMap.put(62, "gt");
        }
        for (int i = 0; i < entities.length; ++i) {
            this.entityMap.putIfAbsent(entities[i], null);
        }
        if (this.resolver == null) {
            this.resolver = new DefaultEntityResolver();
        }
        if ((is = this.resolver.resolveEntity(docType.getName(), docType.getPublicId(), docType.getBaseURI(), docType.getSystemId())) != null) {
            EntityFinder finder = new EntityFinder(this.resolver);
            Reader re = is.getCharacterStream();
            ret = finder.findEntities(this.entityMap, re);
            re.close();
        }
        return ret;
    }

    public void setEntityResolver(EntityResolver2 resolver) {
        this.resolver = resolver;
    }

    public void setIndentingUnit(int whitespaceCount) {
        if (whitespaceCount < 0) {
            throw new IllegalArgumentException("Negative count");
        }
        StringBuilder buf = new StringBuilder(whitespaceCount);
        for (int i = 0; i < whitespaceCount; ++i) {
            buf.append(' ');
        }
        this.indentingUnit = buf.toString();
    }

    public static void writeTree(Node root, SimpleWriter writer) throws IOException {
        DOMWriter domWriter = new DOMWriter();
        domWriter.writeNode(root, writer);
    }

    public String serializeToString(Node root) {
        BufferSimpleWriter writer = new BufferSimpleWriter(512);
        try {
            this.writeNode(root, writer);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public void writeNode(Node root, SimpleWriter writer) throws IOException {
        this.rootNode = root;
        ExtendedCSSStyleSheet<?> oldUaSheet = this.uaSheet;
        if (oldUaSheet == null) {
            DOMDocument doc = (DOMDocument)this.getOwnerDocument();
            this.uaSheet = doc.getImplementation().getUserAgentStyleSheet(doc.getComplianceMode());
        }
        this.writeNode(root, writer, true);
        this.uaSheet = oldUaSheet;
        this.rootNode = null;
    }

    protected void writeNode(Node node, SimpleWriter wri, boolean indented) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                this.writeElement((DOMElement)node, wri, indented);
                break;
            }
            case 3: {
                Text text = (Text)node;
                if (!text.isElementContentWhitespace()) {
                    this.writeText(text, wri, indented);
                    break;
                }
                this.writeElementContentWhitespace(text, wri);
                break;
            }
            case 4: {
                this.writeCDataSection((CDATASection)node, wri);
                break;
            }
            case 8: {
                this.writeComment((Comment)node, wri, indented);
                break;
            }
            case 7: {
                this.writeProcessingInstruction((ProcessingInstruction)node, wri);
                break;
            }
            case 10: {
                this.writeDocumentType((DocumentType)node, wri);
                break;
            }
            case 9: 
            case 11: {
                if (!node.hasChildNodes()) break;
                this.writeChildNodes(node, wri, indented);
                break;
            }
            case 5: {
                this.writeEntityReference(node, wri);
                break;
            }
            default: {
                wri.write(node.toString());
            }
        }
    }

    protected void writeElement(DOMElement element, SimpleWriter wri, boolean indented) throws IOException {
        if (indented) {
            this.startIndentedNode(element, wri);
        }
        String tagname = element.getTagName();
        wri.write('<');
        wri.write(tagname);
        this.writeAttributes(element.getAttributes(), wri);
        if (!element.isVoid()) {
            wri.write('>');
            boolean ast = this.afterStartTag(element, wri);
            if (element.hasChildNodes()) {
                if (ast) {
                    this.startIndentedNodeList(element, wri);
                }
                this.writeChildNodes(element, wri, ast);
                if (ast) {
                    this.endIndentedNodeList(element, wri);
                }
            }
            if (ast) {
                this.writeFullIndent(wri);
            }
            wri.write("</");
            wri.write(tagname);
            wri.write(">");
        } else {
            this.closeEmptyElementTag(wri);
        }
        if (indented) {
            this.endIndentedNode(element, wri);
        }
    }

    protected void writeAttributes(AttributeNamedNodeMap nodeMap, SimpleWriter wri) throws IOException {
        for (Attr attr : nodeMap) {
            if (!attr.getSpecified()) continue;
            wri.write(' ');
            this.writeAttribute(attr, wri);
        }
    }

    protected void writeAttribute(Attr attr, SimpleWriter wri) throws IOException {
        ((DOMAttr)attr).write(wri);
    }

    protected void writeChildNodes(Node parent, SimpleWriter wri, boolean indented) throws IOException {
        DOMNodeList list = ((DOMNode)parent).getChildNodes();
        for (DOMNode node : list) {
            this.writeNode(node, wri, indented);
        }
    }

    protected void writeText(Text text, SimpleWriter wri, boolean indented) throws IOException {
        boolean doIndent = indented && !this.previousSiblingWasTextOrERef(text);
        Node node = text.getParentNode();
        if (node != null && node.getNodeType() == 1 && this.isRawTextElement((DOMElement)node)) {
            String parentLName = node.getLocalName();
            this.writeRawText(text, parentLName, wri);
        } else {
            this.writeNonRawText(text, wri, doIndent);
        }
    }

    private boolean previousSiblingWasTextOrERef(Text text) {
        short type;
        Node previous = text.getPreviousSibling();
        return previous != null && ((type = previous.getNodeType()) == 3 || type == 5);
    }

    protected boolean isRawTextElement(DOMElement element) {
        return element.isRawText();
    }

    protected void writeRawText(Text text, String parentLocalName, SimpleWriter wri) throws IOException {
        wri.write(DOMDocument.escapeCloseTag(parentLocalName, text.getData()));
    }

    protected void writeNonRawText(Text text, SimpleWriter wri, boolean indented) throws IOException {
        String s = text.getData();
        if (indented) {
            String last = s;
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                this.writeFullIndent(wri);
                last = st.nextToken();
                this.writeTextLine(last, wri);
            }
            if (!last.endsWith("\n")) {
                this.endIndentedNode(text, wri);
            }
        } else {
            this.writeTextLine(s, wri);
        }
    }

    protected void writeTextLine(String line, SimpleWriter wri) throws IOException {
        if (line.length() != 0) {
            if (this.entityMap != null) {
                try {
                    line = this.replaceByEntities(line);
                }
                catch (SAXException sAXException) {}
            } else {
                line = DOMDocument.escapeLtGtEntities(line);
            }
            wri.write(line);
        }
    }

    protected String replaceByEntities(String line) throws SAXException, IOException {
        StringBuilder buf = null;
        int len = line.length();
        int i = 0;
        while (i < len) {
            int cp = line.codePointAt(i);
            if (this.entityMap.containsKey(cp)) {
                String entity = this.entityMap.get(cp);
                if (buf == null) {
                    buf = new StringBuilder(len + 64);
                    buf.append(line.subSequence(0, i));
                }
                buf.append('&');
                if (entity != null) {
                    buf.append(entity);
                } else {
                    buf.append('#').append(Integer.toString(cp));
                }
                buf.append(';');
            } else if (buf != null) {
                buf.append(Character.toChars(cp));
            }
            i = line.offsetByCodePoints(i, 1);
        }
        return buf == null ? line : buf.toString();
    }

    private Document getOwnerDocument() {
        Document doc = this.rootNode.getNodeType() == 9 ? (Document)this.rootNode : this.rootNode.getOwnerDocument();
        return doc;
    }

    protected void writeElementContentWhitespace(Text text, SimpleWriter wri) throws IOException {
    }

    protected void writeCDataSection(CDATASection data, SimpleWriter wri) throws IOException {
        this.startIndentedNode(data, wri);
        wri.write("<![CDATA[");
        wri.write(data.getData());
        wri.write("]]>");
        this.endIndentedNode(data, wri);
    }

    protected void writeComment(Comment comment, SimpleWriter wri, boolean indented) throws IOException {
        if (indented) {
            this.startIndentedNode(comment, wri);
        }
        wri.write("<!--");
        wri.write(comment.getData());
        wri.write("-->");
        if (indented) {
            this.endIndentedNode(comment, wri);
        }
    }

    protected void writeDocumentType(DocumentType docType, SimpleWriter wri) throws IOException {
        this.startIndentedNode(docType, wri);
        String systemId = docType.getSystemId();
        boolean hasSystemId = systemId != null;
        wri.write("<!DOCTYPE ");
        wri.write(docType.getName());
        String publicId = docType.getPublicId();
        if (publicId != null) {
            wri.write(" PUBLIC \"");
            wri.write(publicId);
            wri.write('\"');
        } else if (hasSystemId) {
            wri.write(" SYSTEM");
        }
        if (hasSystemId) {
            wri.write(" \"");
            wri.write(systemId);
            wri.write('\"');
        }
        wri.write('>');
        this.endIndentedNode(docType, wri);
    }

    protected void writeProcessingInstruction(ProcessingInstruction pi, SimpleWriter wri) throws IOException {
        this.startIndentedNode(pi, wri);
        wri.write("<?");
        wri.write(pi.getTarget());
        wri.write(' ');
        wri.write(pi.getData());
        wri.write("?>");
        this.endIndentedNode(pi, wri);
    }

    protected void writeEntityReference(Node node, SimpleWriter wri) throws IOException {
        wri.write('&');
        wri.write(node.getNodeName());
        wri.write(';');
    }

    protected void startIndentedNodeList(Node parent, SimpleWriter wri) throws IOException {
        this.deepenIndent();
    }

    protected void startIndentedNode(Node node, SimpleWriter wri) throws IOException {
        this.writeFullIndent(wri);
    }

    protected void endIndentedNode(Node node, SimpleWriter wri) throws IOException {
        wri.newLine();
    }

    protected void endIndentedNodeList(Node listParent, SimpleWriter wri) throws IOException {
        this.updateIndent(listParent);
    }

    protected boolean afterStartTag(DOMElement element, SimpleWriter wri) throws IOException {
        boolean indentChild = false;
        ElementList elist = element.getChildren();
        if (elist.getLength() != 0) {
            for (DOMElement el : elist) {
                String display = this.getDisplayProperty(el);
                if (!"block".equalsIgnoreCase(display) && !"table".equalsIgnoreCase(display) && !"table-row".equalsIgnoreCase(display)) continue;
                indentChild = true;
                break;
            }
        }
        String tc = element.getTextContent();
        if (!indentChild) {
            boolean bl = indentChild = tc.length() > 64 || tc.indexOf(10) != -1;
        }
        if (indentChild && !tc.startsWith("\n")) {
            wri.newLine();
        }
        return indentChild;
    }

    protected String getDisplayProperty(Element element) {
        ExtendedCSSRuleList<ExtendedCSSRule> list;
        String display;
        String localName = element.getLocalName();
        if (this.displayMap == null) {
            this.displayMap = new HashMap();
        }
        if ((display = this.displayMap.get(localName)) == null && this.uaSheet != null && (list = this.uaSheet.getRulesForProperty("display")) != null) {
            for (ExtendedCSSRule rule : list) {
                if (rule.getType() != 1) continue;
                ExtendedCSSStyleRule stylerule = (ExtendedCSSStyleRule)rule;
                SelectorList selist = stylerule.getSelectorList();
                for (int i = 0; i < selist.getLength(); ++i) {
                    Selector sel = selist.item(i);
                    if (sel.getSelectorType() != 4 || !localName.equals(((ElementSelector)sel).getLocalName()) || (display = stylerule.getStyle().getPropertyValue("display")) == null) continue;
                    this.displayMap.put(localName, display);
                    return display;
                }
            }
        }
        return display;
    }

    protected void closeEmptyElementTag(SimpleWriter wri) throws IOException {
        wri.write(" />");
    }

    protected void deepenIndent() {
        this.indentString.append(this.indentingUnit);
    }

    protected void updateIndent(Node node) {
        Node parent;
        this.indentString.setLength(0);
        if (parent != null) {
            for (parent = node.getParentNode(); parent != this.rootNode; parent = parent.getParentNode()) {
                this.deepenIndent();
            }
        }
    }

    protected void writeFullIndent(SimpleWriter wri) throws IOException {
        wri.write(this.indentString);
    }
}

