/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DocumentTypeImpl
extends AbstractDOMNode
implements DocumentType {
    private final String qualifiedName;
    private final String publicId;
    private final String systemId;

    public DocumentTypeImpl(String qualifiedName, String publicId, String systemId) {
        super((short)10);
        this.qualifiedName = qualifiedName;
        this.publicId = publicId;
        this.systemId = systemId;
    }

    @Override
    void checkAppendNode(Node newChild) {
        throw new DOMException(3, "Cannot add children to this node");
    }

    @Override
    public String getBaseURI() {
        DOMDocument doc = this.getOwnerDocument();
        if (doc != null) {
            return doc.getBaseURI();
        }
        return null;
    }

    @Override
    @Deprecated
    public NamedNodeMap getEntities() {
        return null;
    }

    @Override
    @Deprecated
    public String getInternalSubset() {
        return null;
    }

    @Override
    public String getName() {
        return this.qualifiedName;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    @Deprecated
    public NamedNodeMap getNotations() {
        return null;
    }

    @Override
    public DOMDocument getOwnerDocument() {
        return (DOMDocument)this.getParentNode();
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public DocumentType cloneNode(boolean deep) {
        return new DocumentTypeImpl(this.qualifiedName, this.publicId, this.systemId);
    }

    public String toString() {
        boolean hasSystemId = this.systemId != null;
        StringBuilder buf = new StringBuilder(128);
        buf.append("<!DOCTYPE ").append(this.qualifiedName);
        if (this.publicId != null) {
            buf.append(" PUBLIC \"").append(this.publicId).append('\"');
        } else if (hasSystemId) {
            buf.append(" SYSTEM");
        }
        if (hasSystemId) {
            buf.append(" \"").append(this.systemId).append('\"');
        }
        buf.append('>');
        return buf.toString();
    }
}

