/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.HTMLElement;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.property.AttributeToStyle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;

public abstract class HTMLDocument
extends DOMDocument {
    public static final String HTML_NAMESPACE_URI = "http://www.w3.org/1999/xhtml";
    private URL baseURL = null;
    private String idAttrName = "id";

    public HTMLDocument(DocumentType documentType) {
        super(documentType);
    }

    @Override
    public HTMLElement getDocumentElement() {
        return (HTMLElement)super.getDocumentElement();
    }

    @Override
    public HTMLDocument getOwnerDocument() {
        return null;
    }

    @Override
    public HTMLDocument cloneNode(boolean deep) {
        return (HTMLDocument)super.cloneNode(deep);
    }

    @Override
    DOMDocument cloneDocument(DocumentType docType) {
        String nsUri = null;
        String qName = null;
        HTMLElement docElm = this.getDocumentElement();
        if (docElm != null) {
            nsUri = docElm.getNamespaceURI();
            qName = docElm.getTagName();
        }
        DOMDocument doc = this.getImplementation().createDocument(nsUri, qName, docType);
        if (docElm != null) {
            doc.removeChild(doc.getDocumentElement());
        }
        return doc;
    }

    @Override
    public DOMElement createElement(String tagName) throws DOMException {
        if (tagName == null) {
            throw new DOMException(5, "null tag name");
        }
        return this.createElementNS(HTML_NAMESPACE_URI, tagName);
    }

    @Override
    public DOMElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName;
        String prefix;
        if (qualifiedName == null) {
            throw new DOMException(5, "null qualified name");
        }
        if (namespaceURI != null && !namespaceURI.equals(HTML_NAMESPACE_URI) && namespaceURI.length() != 0) {
            namespaceURI = namespaceURI.intern();
            int idx = qualifiedName.indexOf(58);
            if (idx == -1) {
                prefix = this.lookupPrefix(namespaceURI);
                localName = qualifiedName;
            } else {
                if (idx == qualifiedName.length() - 1) {
                    throw new DOMException(5, "Empty local name");
                }
                if (idx == 0) {
                    throw new DOMException(5, "Empty prefix");
                }
                prefix = qualifiedName.substring(0, idx).intern();
                localName = qualifiedName.substring(idx + 1);
            }
        } else {
            namespaceURI = HTML_NAMESPACE_URI;
            localName = qualifiedName.toLowerCase(Locale.ROOT);
            prefix = null;
        }
        if (!DOMDocument.isValidName(localName)) {
            throw new DOMException(5, "Invalid name: " + localName);
        }
        localName = localName.intern();
        DOMElement myelem = namespaceURI == HTML_NAMESPACE_URI ? ("link" == localName ? new LinkElement() : ("style" == localName ? new StyleElement() : ("meta" == localName ? new MetaElement() : ("base" == localName ? new BaseElement() : ("title" == localName ? new MetacontentElement(localName) : ("html" == localName ? new HtmlRootElement() : ("img" == localName ? new ImgElement() : ("font" == localName ? new FontElement() : ("table" == localName ? new TableElement() : ("tr" == localName ? new TableRowElement() : ("td" == localName ? new TableCellElement(localName) : ("th" == localName ? new TableCellElement(localName) : ("script" == localName ? new RawTextElement(localName, namespaceURI) : new MyHTMLElement(localName, namespaceURI)))))))))))))) : new DOMDocument.MyXMLElement(this, localName, namespaceURI);
        if (prefix != null) {
            myelem.setPrefix(prefix);
        }
        return myelem;
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        DOMDocument.MyAttr my;
        if (qualifiedName == null) {
            throw new DOMException(5, "null name");
        }
        String localName = qualifiedName;
        String prefix = null;
        if (namespaceURI != null) {
            if (namespaceURI.length() != 0) {
                namespaceURI = namespaceURI.intern();
                int idx = qualifiedName.indexOf(58);
                if (idx == -1) {
                    prefix = this.lookupPrefix(namespaceURI);
                } else {
                    if (idx == qualifiedName.length() - 1) {
                        throw new DOMException(5, "Empty local name");
                    }
                    if (idx == 0) {
                        throw new DOMException(5, "Empty prefix");
                    }
                    prefix = qualifiedName.substring(0, idx).intern();
                    localName = qualifiedName.substring(idx + 1);
                }
                if (HTML_NAMESPACE_URI == namespaceURI) {
                    localName = localName.toLowerCase(Locale.ROOT);
                }
            } else {
                namespaceURI = null;
                localName = localName.toLowerCase(Locale.ROOT);
            }
        } else {
            if (qualifiedName.indexOf(58) != -1) {
                throw new DOMException(14, "Prefix with null namespace");
            }
            localName = localName.toLowerCase(Locale.ROOT);
        }
        if (!DOMDocument.isValidName(localName)) {
            throw new DOMException(5, "Invalid name: " + localName);
        }
        localName = localName.intern();
        if (namespaceURI == null || namespaceURI == HTML_NAMESPACE_URI) {
            my = localName == "class" ? new DOMDocument.ClassAttr(this, namespaceURI) : (localName == "href" ? new HrefEventAttr(namespaceURI) : (localName == "style" && prefix == null ? new DOMDocument.MyStyleAttr(this, localName) : (localName == "media" ? new DOMDocument.StyleEventAttr(this, "media", namespaceURI) : new DOMDocument.MyAttr(this, localName, namespaceURI))));
        } else if (localName == "xmlns") {
            if (!"http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                throw new DOMException(14, "xmlns local name but not xmlns namespace");
            }
            my = new DOMDocument.XmlnsAttr(this);
        } else {
            my = new DOMDocument.MyAttr(this, localName, namespaceURI);
        }
        if (prefix != null) {
            my.setPrefix(prefix);
        }
        return my;
    }

    @Override
    public URL getBaseURL() {
        if (this.baseURL == null) {
            Element elm;
            String s;
            String buri = this.getDocumentURI();
            ElementList nl = this.getElementsByTagName("base");
            if (nl.getLength() != 0 && (s = (elm = (Element)nl.item(0)).getAttribute("href")).length() > 0) {
                if (buri != null && s.startsWith("//")) {
                    try {
                        URL url = new URL(buri);
                        url = new URL(url, s);
                        buri = url.toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else {
                    buri = s;
                }
            }
            try {
                this.baseURL = new URL(buri);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.baseURL;
    }

    @Override
    public String getBaseURI() {
        URL url = this.getBaseURL();
        if (url != null) {
            return url.toExternalForm();
        }
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return HTML_NAMESPACE_URI.equals(namespaceURI);
    }

    @Override
    DOMDocument.LinkStyleDefiner getEmbeddedStyleDefiner(DOMElement element) {
        if (element != null) {
            return element instanceof DOMDocument.LinkStyleDefiner ? (DOMDocument.LinkStyleDefiner)((Object)element) : null;
        }
        return null;
    }

    @Override
    ElementList getLinkedStyleNodeList() {
        return this.getElementsByTagName("link");
    }

    @Override
    ElementList getEmbeddedStyleNodeList() {
        return this.getElementsByTagName("style");
    }

    class LinkElement
    extends StyleDefinerElement {
        LinkElement() {
            super("link");
        }

        @Override
        boolean isVoid() {
            return true;
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            super.setParentNode(parentNode);
            HTMLDocument.this.onSheetModify();
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.needsUpdate) {
                String rel = this.getAttribute("rel");
                String type = this.getAttribute("type");
                int typelen = type.length();
                if (typelen == 0 ? rel.length() == 0 : !"text/css".equalsIgnoreCase(type)) {
                    return null;
                }
                byte relAttr = AbstractCSSStyleSheet.parseRelAttribute(rel);
                if (relAttr != -1) {
                    String href;
                    String title = this.getAttribute("title").trim();
                    if (title.length() == 0) {
                        title = null;
                    }
                    if ((href = this.getAttribute("href")).length() != 0) {
                        if (relAttr == 0) {
                            if (this.loadStyleSheet(href, title)) {
                                this.needsUpdate = false;
                            }
                        } else if (title != null) {
                            if (href.length() != 0) {
                                boolean disable;
                                boolean bl = disable = this.definedSheet == null || !title.equalsIgnoreCase(HTMLDocument.this.getSelectedStyleSheetSet());
                                if (this.loadStyleSheet(href, title)) {
                                    if (disable) {
                                        this.definedSheet.setDisabled(true);
                                    }
                                    this.needsUpdate = false;
                                }
                            }
                        } else {
                            HTMLDocument.this.getErrorHandler().linkedStyleError(this, "Alternate sheet without title");
                        }
                    } else {
                        HTMLDocument.this.getErrorHandler().linkedStyleError(this, "Missing or void href attribute.");
                    }
                } else {
                    this.definedSheet = null;
                }
            }
            return this.definedSheet;
        }

        private boolean loadStyleSheet(String href, String title) {
            MediaQueryList media = HTMLDocument.this.parseMediaList(this.getAttribute("media").trim(), this);
            if (media == null) {
                this.definedSheet = null;
                return false;
            }
            this.definedSheet = HTMLDocument.this.loadStyleSheet(this.definedSheet, href, title, media, this);
            return true;
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new LinkElement(), deep);
        }
    }

    class StyleElement
    extends StyleDefinerElement {
        StyleElement() {
            super("style");
        }

        @Override
        boolean isRawText() {
            return true;
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.needsUpdate) {
                String type = this.getAttribute("type");
                if (!"text/css".equals(type)) {
                    return null;
                }
                MediaQueryList mediaList = HTMLDocument.this.parseMediaList(this.getAttribute("media").trim(), this);
                if (mediaList == null) {
                    return null;
                }
                String title = this.getAttribute("title").trim();
                if (title.length() == 0) {
                    title = null;
                }
                String styleText = this.getTextContent().trim();
                this.definedSheet = HTMLDocument.this.parseEmbeddedStyleSheet(this.definedSheet, styleText, title, mediaList, this);
                this.needsUpdate = false;
            }
            return this.definedSheet;
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            super.setParentNode(parentNode);
            HTMLDocument.this.onSheetModify();
        }

        @Override
        void postAddChild(AbstractDOMNode newChild) {
            super.postAddChild(newChild);
            this.resetLinkedSheet();
        }

        @Override
        void postRemoveChild(AbstractDOMNode removed) {
            this.resetLinkedSheet();
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            super.setTextContent(textContent);
            this.resetLinkedSheet();
        }

        @Override
        public void normalize() {
            if (this.definedSheet == null) {
                super.normalize();
            } else {
                super.setTextContent(this.definedSheet.toString());
            }
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new StyleElement(), deep);
        }
    }

    class MetaElement
    extends MyHTMLElement {
        MetaElement() {
            super("meta");
        }

        @Override
        boolean isVoid() {
            return true;
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            if (parentNode == null) {
                String name = this.getAttribute("http-equiv");
                if (name.length() == 0) {
                    name = this.getAttribute("name");
                }
                this.getOwnerDocument().onMetaRemoved(name, this.getAttribute("content"));
                super.setParentNode(null);
            } else {
                short type = parentNode.getNodeType();
                if (HTMLDocument.this.getStrictErrorChecking() && type != 11 && (type != 1 || !this.isValidContext(parentNode))) {
                    String msg = "A <meta> tag can occur only in the head or noscript element, not in " + parentNode.getNodeName();
                    throw new DOMException(3, msg);
                }
                super.setParentNode(parentNode);
                String name = this.getAttribute("http-equiv");
                if (name.length() == 0) {
                    name = this.getAttribute("name");
                }
                this.getOwnerDocument().onMetaAdded(name, this.getAttribute("content"));
            }
        }

        private boolean isValidContext(Node parentNode) {
            String parentTag = parentNode.getNodeName();
            return parentTag == "head" || parentTag == "noscript" || this.hasAttribute("itemprop");
        }
    }

    class BaseElement
    extends MetacontentElement {
        BaseElement() {
            super("base");
        }

        @Override
        boolean isVoid() {
            return true;
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            if (parentNode != null) {
                super.setParentNode(parentNode);
                if (parentNode.getNodeType() == 1) {
                    for (Node node = parentNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                        if (node.getNodeType() != 1 || node.getNodeName() != "base" || node == this) continue;
                        throw new DOMException(3, "A document can have only one base element.");
                    }
                }
            }
            super.setParentNode(parentNode);
        }
    }

    class MetacontentElement
    extends MyHTMLElement {
        MetacontentElement(String tagName) {
            super(tagName);
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            short type;
            if (parentNode != null && (type = parentNode.getNodeType()) != 11 && (type != 1 || parentNode.getNodeName() != "head" && parentNode.getNodeName() != "noscript")) {
                String msg = "A <" + this.getNodeName() + "> tag can occur only in a head or noscript element, not in " + parentNode.toString();
                throw new DOMException(3, msg);
            }
            super.setParentNode(parentNode);
        }
    }

    class HtmlRootElement
    extends MyHTMLElement {
        HtmlRootElement() {
            super("html");
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            short type;
            if (parentNode != null && (type = parentNode.getNodeType()) != 9 && type != 11) {
                throw new DOMException(3, "A <html> tag cannot be added here.");
            }
            super.setParentNode(parentNode);
        }

        @Override
        void preAddChild(Node newChild) {
            String nname;
            super.preAddChild(newChild);
            if (newChild.getNodeType() == 1 && ((nname = newChild.getNodeName()) == "head" || nname == "body")) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || node.getNodeName() != nname) continue;
                    throw new DOMException(3, "<html> already has a " + nname + " child.");
                }
            }
        }

        @Override
        void preReplaceChild(AbstractDOMNode newChild, AbstractDOMNode replaced) {
            String rname;
            String nname;
            super.preAddChild(newChild);
            if (!(newChild.getNodeType() != 1 || (nname = newChild.getNodeName()).equalsIgnoreCase(rname = replaced.getNodeName()) || nname != "head" && nname != "body")) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || node.getNodeName() != nname) continue;
                    throw new DOMException(3, "<html> already has a " + nname + " child.");
                }
            }
        }
    }

    class ImgElement
    extends MyHTMLElement {
        ImgElement() {
            super("img");
        }

        @Override
        boolean isVoid() {
            return true;
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("width") || this.hasAttribute("height") || this.hasAttribute("border") || this.hasAttribute("hspace") || this.hasAttribute("vspace");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.width(this.getAttribute("width"), style);
            AttributeToStyle.height(this.getAttribute("height"), style);
            AttributeToStyle.hspace(this.getAttribute("hspace"), style);
            AttributeToStyle.vspace(this.getAttribute("vspace"), style);
            if (AttributeToStyle.border(this.getAttribute("border"), style)) {
                style.setProperty("border-top-style", "solid", null);
                style.setProperty("border-right-style", "solid", null);
                style.setProperty("border-bottom-style", "solid", null);
                style.setProperty("border-left-style", "solid", null);
            }
        }
    }

    class FontElement
    extends MyHTMLElement {
        FontElement() {
            super("font");
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("face") || this.hasAttribute("size") || this.hasAttribute("color");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.face(this.getAttribute("face"), style);
            AttributeToStyle.size(this.getAttribute("size"), style);
            AttributeToStyle.color(this.getAttribute("color"), style);
        }
    }

    class TableElement
    extends MyHTMLElement {
        TableElement() {
            super("table");
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("width") || this.hasAttribute("height") || this.hasAttribute("cellspacing") || this.hasAttribute("border") || this.hasAttribute("bordercolor") || this.hasAttribute("bgcolor") || this.hasAttribute("background");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.bgcolor(this.getAttribute("bgcolor"), style);
            AttributeToStyle.cellSpacing(this.getAttribute("cellspacing"), style);
            AttributeToStyle.width(this.getAttribute("width"), style);
            AttributeToStyle.height(this.getAttribute("height"), style);
            AttributeToStyle.border(this.getAttribute("border"), style);
            AttributeToStyle.borderColor(this.getAttribute("bordercolor"), style);
            AttributeToStyle.background(this.getAttribute("background"), style);
        }
    }

    class TableRowElement
    extends MyHTMLElement {
        TableRowElement() {
            super("tr");
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("bgcolor") || this.hasAttribute("height") || this.hasAttribute("background") || this.hasAttribute("align");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.bgcolor(this.getAttribute("bgcolor"), style);
            AttributeToStyle.height(this.getAttribute("height"), style);
            AttributeToStyle.background(this.getAttribute("background"), style);
            AttributeToStyle.align(this.getAttribute("align"), style);
        }
    }

    class TableCellElement
    extends MyHTMLElement {
        TableCellElement(String localName) {
            super(localName);
        }

        TableCellElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("bgcolor") || this.hasAttribute("width") || this.hasAttribute("height") || this.hasAttribute("background") || this.hasAttribute("align");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.bgcolor(this.getAttribute("bgcolor"), style);
            AttributeToStyle.width(this.getAttribute("width"), style);
            AttributeToStyle.height(this.getAttribute("height"), style);
            AttributeToStyle.background(this.getAttribute("background"), style);
            AttributeToStyle.align(this.getAttribute("align"), style);
        }
    }

    class RawTextElement
    extends MyHTMLElement {
        RawTextElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        boolean isRawText() {
            return true;
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new RawTextElement(this.getLocalName(), this.getNamespaceURI()), deep);
        }
    }

    class MyHTMLElement
    extends HTMLElement {
        MyHTMLElement(String localName) {
            this(localName, HTMLDocument.HTML_NAMESPACE_URI);
        }

        MyHTMLElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        boolean isIdAttributeNS(String namespaceURI, String localName) {
            return HTMLDocument.this.idAttrName.equals(localName);
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            if (!isId || !"id".equalsIgnoreCase(name)) {
                throw new DOMException(7, "Id attribute is always 'id'");
            }
            if (!this.hasAttribute(name)) {
                throw new DOMException(8, "Not an attribute of this element");
            }
            HTMLDocument.this.idAttrName = name;
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            if (!this.hasAttributeNS(namespaceURI, localName)) {
                throw new DOMException(8, "Not an attribute of this element");
            }
            if (namespaceURI != null && namespaceURI.length() > 0 && !namespaceURI.equals(HTMLDocument.HTML_NAMESPACE_URI)) {
                return;
            }
            if (isId && !"id".equalsIgnoreCase(localName)) {
                throw new DOMException(7, "Id attribute is always 'id'");
            }
            HTMLDocument.this.idAttrName = localName;
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            String nsuri = idAttr.getNamespaceURI();
            if (idAttr == null || !this.hasAttributeNS(nsuri, idAttr.getLocalName())) {
                throw new DOMException(8, "Not an attribute of this element");
            }
            if (nsuri == null || nsuri == HTMLDocument.HTML_NAMESPACE_URI) {
                if (!"id".equalsIgnoreCase(idAttr.getName())) {
                    throw new DOMException(7, "Id attribute is always 'id'");
                }
                HTMLDocument.this.idAttrName = idAttr.getName();
            }
        }

        @Override
        public void setId(String id) {
            this.setIdAttribute(id, true);
        }

        @Override
        public String getId() {
            return this.getAttribute(HTMLDocument.this.idAttrName);
        }

        @Override
        public boolean isDefaultNamespace(String namespaceURI) {
            return HTMLDocument.this.isDefaultNamespace(namespaceURI);
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return HTMLDocument.this;
        }

        @Override
        protected BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return HTMLDocument.this.getStyleSheetFactory();
        }

        @Override
        public String getBaseURI() {
            return HTMLDocument.this.getBaseURI();
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new MyHTMLElement(this.getLocalName(), this.getNamespaceURI()), deep);
        }

        HTMLElement cloneElementNode(MyHTMLElement my, boolean deep) {
            for (Attr attr : this.nodeMap.getNodeList()) {
                DOMAttr myattr = (DOMAttr)attr.cloneNode(deep);
                myattr.specified = attr.getSpecified();
                my.setAttributeNode(myattr);
            }
            if (deep) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    my.appendChild(node.cloneNode(true));
                }
            }
            MyHTMLElement.callUserHandlers((short)1, this, my);
            return my;
        }
    }

    class HrefEventAttr
    extends DOMDocument.MyAttr {
        HrefEventAttr(String namespaceURI) {
            super(HTMLDocument.this, "href", namespaceURI);
        }

        @Override
        void setAttributeOwner(DOMElement newOwner) {
            super.setAttributeOwner(newOwner);
            if (newOwner != null) {
                this.onDOMChange(newOwner);
            }
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            DOMElement owner = this.getOwnerElement();
            if (owner != null) {
                this.onDOMChange(owner);
            }
        }

        void onDOMChange(DOMElement owner) {
            String tagname = owner.getTagName();
            if (tagname == "link") {
                ((LinkElement)owner).resetLinkedSheet();
            } else if (tagname == "base") {
                HTMLDocument doc = (HTMLDocument)this.getOwnerDocument();
                String value = this.getValue();
                if (value.length() != 0) {
                    URL base;
                    try {
                        base = new URL(value);
                    }
                    catch (MalformedURLException e) {
                        if (doc != null) {
                            doc.baseURL = null;
                        }
                        return;
                    }
                    if (doc != null) {
                        doc.baseURL = base;
                    }
                } else if (doc != null) {
                    doc.baseURL = null;
                }
            }
        }
    }

    abstract class StyleDefinerElement
    extends MyHTMLElement
    implements DOMDocument.LinkStyleDefiner {
        AbstractCSSStyleSheet definedSheet;
        boolean needsUpdate;

        StyleDefinerElement(String localName) {
            super(localName, HTMLDocument.HTML_NAMESPACE_URI);
            this.definedSheet = null;
            this.needsUpdate = true;
        }

        @Override
        public void resetLinkedSheet() {
            if (this.definedSheet != null) {
                this.definedSheet.getCssRules().clear();
                this.needsUpdate = true;
                this.getSheet();
            }
            this.needsUpdate = true;
            this.getOwnerDocument().onSheetModify();
        }
    }
}

