/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMTokenList;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMElementLinkedList;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.LinkedNodeList;
import io.sf.carte.doc.dom.NonDocumentTypeChildNode;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

abstract class NDTNode
extends AbstractDOMNode
implements NonDocumentTypeChildNode {
    NDTNode(short nodeType) {
        super(nodeType);
    }

    public DOMElement getFirstElementChild() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (DOMElement)node;
        }
        return null;
    }

    public DOMElement getLastElementChild() {
        for (Node node = this.getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (DOMElement)node;
        }
        return null;
    }

    public int getChildElementCount() {
        int count = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean hasChildNodes() {
        return !this.getNodeList().isEmpty();
    }

    @Override
    public DOMElement getPreviousElementSibling() {
        Node next;
        for (next = this.getPreviousSibling(); next != null && next.getNodeType() != 1; next = next.getPreviousSibling()) {
        }
        return (DOMElement)next;
    }

    @Override
    public DOMElement getNextElementSibling() {
        Node next;
        for (next = this.getNextSibling(); next != null && next.getNodeType() != 1; next = next.getNextSibling()) {
        }
        return (DOMElement)next;
    }

    public DOMNode prependChild(Node newChild) throws DOMException {
        AbstractDOMNode.RawNodeList nl = this.getNodeList();
        if (nl.isEmpty()) {
            return this.appendChild(newChild);
        }
        AbstractDOMNode added = (AbstractDOMNode)newChild;
        if (added.getNodeType() != 11) {
            this.preAddChild(added);
            AbstractDOMNode refChild = nl.getFirst();
            nl.insertBefore(added, refChild);
            this.postAddChild(added);
        } else {
            this.prependDocumentFragment(added);
        }
        return added;
    }

    private void prependDocumentFragment(Node newChild) {
        Node added = newChild.getLastChild();
        while (added != null) {
            Node next = added.getPreviousSibling();
            this.prependChild(added);
            added = next;
        }
    }

    static ElementList querySelectorAll(String selectors, Node firstChild) {
        SelectorList selist;
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource((Reader)new StringReader(selectors));
        try {
            selist = parser.parseSelectors(source);
        }
        catch (CSSNamespaceParseException e) {
            throw NDTNode.createDOMException((short)14, "Namespaces inside the selectors are not supported: " + selectors, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw NDTNode.createDOMException((short)12, "Unable to parse selector in: " + selectors, e);
        }
        DOMElementLinkedList list = new DOMElementLinkedList();
        list.fillQuerySelectorList(selist, firstChild);
        return list;
    }

    private static DOMException createDOMException(short type, String message, Exception cause) {
        DOMException ex = new DOMException(type, message);
        ex.initCause(cause);
        return ex;
    }

    class DefaultChildNodeList
    extends LinkedNodeList
    implements AbstractDOMNode.ChildCollections {
        private Map<String, WeakReference<DOMElementLinkedList>> tagListMap = null;
        private Map<String, WeakReference<DOMElementLinkedList>> classListMap = null;
        private WeakReference<ElementList> childElementRef = null;

        DefaultChildNodeList() {
        }

        @Override
        public ElementList getChildren() {
            ElementList list = null;
            if (this.childElementRef != null) {
                list = (ElementList)this.childElementRef.get();
            }
            if (list == null) {
                list = new ChildElementList();
                this.childElementRef = new WeakReference<ElementList>(list);
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ElementList getElementsByTagNameNS(String namespaceURI, String localName) {
            if (namespaceURI != null && namespaceURI.length() > 0 && !NDTNode.this.isDefaultNamespace(namespaceURI)) {
                String qname;
                namespaceURI = namespaceURI.intern();
                boolean matchAll = "*".equals(localName = localName.intern());
                if (matchAll) {
                    qname = namespaceURI;
                } else {
                    qname = namespaceURI + ":" + localName;
                    qname = qname.intern();
                }
                DOMElementLinkedList list = this.findList(qname);
                if (list == null) {
                    list = this.createElementNodeList();
                    list.fillByTagList(localName, NDTNode.this, namespaceURI, matchAll);
                    Map<String, WeakReference<DOMElementLinkedList>> map = this.tagListMap;
                    synchronized (map) {
                        this.tagListMap.put(qname, new WeakReference<DOMElementLinkedList>(list));
                    }
                }
                return list;
            }
            return this.getElementsByTagName(localName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DOMElementLinkedList findList(String qname) {
            if (this.tagListMap == null) {
                this.tagListMap = new HashMap<String, WeakReference<DOMElementLinkedList>>(3);
            } else {
                Map<String, WeakReference<DOMElementLinkedList>> map = this.tagListMap;
                synchronized (map) {
                    WeakReference<DOMElementLinkedList> ref = this.tagListMap.get(qname);
                    if (ref != null) {
                        DOMElementLinkedList list = (DOMElementLinkedList)ref.get();
                        if (list == null) {
                            this.tagListMap.remove(qname);
                        } else {
                            return list;
                        }
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ElementList getElementsByTagName(String name) {
            DOMElementLinkedList list = this.findList(name = name.toLowerCase(Locale.ROOT).intern());
            if (list != null) {
                return list;
            }
            list = this.createElementNodeList();
            list.fillByTagList(name, NDTNode.this, NDTNode.this.getNamespaceURI(), "*".equals(name));
            Map<String, WeakReference<DOMElementLinkedList>> map = this.tagListMap;
            synchronized (map) {
                this.tagListMap.put(name, new WeakReference<DOMElementLinkedList>(list));
            }
            return list;
        }

        private DOMElementLinkedList createElementNodeList() {
            return new DOMElementLinkedList();
        }

        @Override
        public void updateTaglistsOnInsert(DOMElement newChild, AbstractDOMNode appendedTo) {
            boolean appendThis = NDTNode.this == appendedTo;
            boolean descendant = this.isDescendant(appendedTo);
            if (this.tagListMap != null && (appendThis || descendant)) {
                this.updateMyTaglistsOnInsert(newChild);
            }
            if (!descendant) {
                for (DOMElement elm = newChild.getFirstElementChild(); elm != null; elm = elm.getNextElementSibling()) {
                    newChild.updateTaglistsOnInsert(elm, appendedTo);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMyTaglistsOnInsert(DOMElement newChild) {
            String newtag = newChild.getLocalName();
            if (!this.isNullOrDefaultNamespaceURI(newChild.getNamespaceURI())) {
                newtag = newChild.getNamespaceURI() + ":" + newtag;
                newtag = newtag.intern();
            }
            String allTags = this.allTagsName(newChild);
            Map<String, WeakReference<DOMElementLinkedList>> map = this.tagListMap;
            synchronized (map) {
                Iterator<String> it = this.tagListMap.keySet().iterator();
                while (it.hasNext()) {
                    String tag = it.next();
                    if (!newtag.equals(tag) && !allTags.equals(tag)) continue;
                    DOMElementLinkedList list = (DOMElementLinkedList)this.tagListMap.get(tag).get();
                    if (list == null) {
                        it.remove();
                        continue;
                    }
                    list.updateOnInsert(newChild);
                }
            }
        }

        @Override
        public void updateTaglistsOnRemove(DOMElement oldChild, AbstractDOMNode removedFrom) {
            boolean appendThis = NDTNode.this == removedFrom;
            boolean descendant = this.isDescendant(removedFrom);
            if (this.tagListMap != null && (appendThis || descendant)) {
                this.updateMyTaglistsOnRemoveElement(oldChild);
            }
            if (!descendant) {
                for (DOMElement elm = oldChild.getFirstElementChild(); elm != null; elm = elm.getNextElementSibling()) {
                    oldChild.updateTaglistsOnRemove(elm, removedFrom);
                }
            }
        }

        private boolean isDescendant(Node node) {
            for (node = node.getParentNode(); node != null; node = node.getParentNode()) {
                if (NDTNode.this != node) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMyTaglistsOnRemoveElement(DOMElement oldChild) {
            String newtag = oldChild.getLocalName();
            if (!this.isNullOrDefaultNamespaceURI(oldChild.getNamespaceURI())) {
                newtag = oldChild.getNamespaceURI() + ":" + newtag;
                newtag = newtag.intern();
            }
            String allTags = this.allTagsName(oldChild);
            Map<String, WeakReference<DOMElementLinkedList>> map = this.tagListMap;
            synchronized (map) {
                Iterator<String> it = this.tagListMap.keySet().iterator();
                while (it.hasNext()) {
                    String tag = it.next();
                    if (!newtag.equals(tag) && !allTags.equals(tag)) continue;
                    DOMElementLinkedList list = (DOMElementLinkedList)this.tagListMap.get(tag).get();
                    if (list == null) {
                        it.remove();
                        continue;
                    }
                    list.updateOnRemove(oldChild);
                }
            }
        }

        String allTagsName(CSSElement element) {
            if (!this.isNullOrDefaultNamespaceURI(element.getNamespaceURI())) {
                return element.getNamespaceURI();
            }
            return "*";
        }

        private boolean isNullOrDefaultNamespaceURI(String namespaceURI) {
            return namespaceURI == null || NDTNode.this.isDefaultNamespace(namespaceURI);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ElementList getElementsByClassName(String names, CSSDocument.ComplianceMode mode) {
            DOMElementLinkedList list;
            boolean hasSpace;
            names = names.trim();
            if (mode == CSSDocument.ComplianceMode.QUIRKS) {
                names = names.toLowerCase(Locale.ROOT);
            }
            TreeSet<String> sorted = new TreeSet<String>();
            boolean bl = hasSpace = names.indexOf(32) != -1;
            if (hasSpace) {
                names = this.sortClassNames(names, sorted);
            }
            if ((list = this.findClassList(names)) != null) {
                return list;
            }
            if (!hasSpace) {
                sorted.add(names);
            }
            list = new DOMElementLinkedList();
            list.fillByClassList(sorted, NDTNode.this);
            Map<String, WeakReference<DOMElementLinkedList>> map = this.classListMap;
            synchronized (map) {
                this.classListMap.put(names, new WeakReference<DOMElementLinkedList>(list));
            }
            return list;
        }

        private String sortClassNames(String names, SortedSet<String> sorted) {
            StringTokenizer st = new StringTokenizer(names);
            while (st.hasMoreTokens()) {
                sorted.add(st.nextToken());
            }
            StringBuilder buf = new StringBuilder(names.length());
            Iterator it = sorted.iterator();
            buf.append((String)it.next());
            while (it.hasNext()) {
                buf.append(' ').append((String)it.next());
            }
            return buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DOMElementLinkedList findClassList(String names) {
            if (this.classListMap == null) {
                this.classListMap = new HashMap<String, WeakReference<DOMElementLinkedList>>(3);
            } else {
                Map<String, WeakReference<DOMElementLinkedList>> map = this.classListMap;
                synchronized (map) {
                    WeakReference<DOMElementLinkedList> ref = this.classListMap.get(names);
                    if (ref != null) {
                        DOMElementLinkedList list = (DOMElementLinkedList)ref.get();
                        if (list == null) {
                            this.classListMap.remove(names);
                        } else {
                            return list;
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public void updateClasslists(DOMElement owner, AbstractDOMNode appendedTo) {
            boolean appendThis = NDTNode.this == appendedTo;
            boolean descendant = this.isDescendant(appendedTo);
            if (this.classListMap != null && (appendThis || descendant)) {
                this.updateMyClasslists(owner);
            }
            if (!descendant) {
                for (DOMElement elm = owner.getFirstElementChild(); elm != null; elm = elm.getNextElementSibling()) {
                    owner.updateClasslists(elm, appendedTo);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMyClasslists(DOMElement owner) {
            boolean hasSpace;
            String ownerNames;
            DOMTokenList ownerClasses;
            boolean hasClasses = owner.hasAttribute("class");
            if (hasClasses) {
                ownerClasses = owner.getClassList();
                ownerNames = ownerClasses.getSortedValue();
                hasSpace = ownerNames.indexOf(32) != -1;
            } else {
                ownerClasses = null;
                ownerNames = "";
                hasSpace = false;
            }
            TreeSet<String> sorted = new TreeSet<String>();
            Map<String, WeakReference<DOMElementLinkedList>> map = this.classListMap;
            synchronized (map) {
                Iterator<Map.Entry<String, WeakReference<DOMElementLinkedList>>> it = this.classListMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, WeakReference<DOMElementLinkedList>> entry = it.next();
                    String classNames = entry.getKey();
                    DOMElementLinkedList list = (DOMElementLinkedList)entry.getValue().get();
                    if (list == null) {
                        it.remove();
                        continue;
                    }
                    boolean hasOwner = list.contains(owner);
                    if (!hasClasses) {
                        if (!hasOwner) continue;
                        list.updateOnRemove(owner);
                        continue;
                    }
                    if (!classNames.equals(ownerNames) && !hasSpace) {
                        if (!hasOwner) continue;
                        list.updateOnRemove(owner);
                        continue;
                    }
                    if (hasSpace) {
                        sorted.clear();
                        StringTokenizer st = new StringTokenizer(classNames);
                        while (st.hasMoreTokens()) {
                            sorted.add(st.nextToken());
                        }
                        if (!ownerClasses.containsAll(sorted)) {
                            if (!hasOwner) continue;
                            list.updateOnRemove(owner);
                            continue;
                        }
                    }
                    if (hasOwner) continue;
                    list.updateOnInsert(owner);
                }
            }
        }

        @Override
        public void updateClasslistsOnRemove(DOMElement oldChild, AbstractDOMNode removedFrom) {
            boolean appendThis = NDTNode.this == removedFrom;
            boolean descendant = this.isDescendant(removedFrom);
            if (this.classListMap != null && (appendThis || descendant)) {
                this.updateMyClasslistsOnRemove(oldChild);
            }
            if (!descendant) {
                for (DOMElement elm = oldChild.getFirstElementChild(); elm != null; elm = elm.getNextElementSibling()) {
                    oldChild.updateClasslistsOnRemove(elm, removedFrom);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMyClasslistsOnRemove(DOMElement oldChild) {
            DOMTokenList oldClasses = oldChild.getClassList();
            String oldNames = oldClasses.getSortedValue();
            boolean hasSpace = oldNames.indexOf(32) != -1;
            TreeSet<String> sorted = new TreeSet<String>();
            Map<String, WeakReference<DOMElementLinkedList>> map = this.classListMap;
            synchronized (map) {
                Iterator<String> it = this.classListMap.keySet().iterator();
                while (it.hasNext()) {
                    DOMElementLinkedList list;
                    String classNames = it.next();
                    if (!classNames.equals(oldNames) && !hasSpace) continue;
                    if (hasSpace) {
                        sorted.clear();
                        StringTokenizer st = new StringTokenizer(classNames);
                        while (st.hasMoreTokens()) {
                            sorted.add(st.nextToken());
                        }
                        if (!oldClasses.containsAll(sorted)) continue;
                    }
                    if ((list = (DOMElementLinkedList)this.classListMap.get(classNames).get()) == null) {
                        it.remove();
                        continue;
                    }
                    list.updateOnRemove(oldChild);
                }
            }
        }

        @Override
        void preRemoveChild(AbstractDOMNode removed) {
            NDTNode.this.preRemoveChild(removed);
        }

        @Override
        void postRemoveChild(AbstractDOMNode removed) {
            NDTNode.this.postRemoveChild(removed);
        }

        @Override
        void preAddChild(Node node) {
            NDTNode.this.preAddChild(node);
        }

        @Override
        void postAddChild(AbstractDOMNode node) {
            NDTNode.this.postAddChild(node);
        }

        @Override
        void replaceChild(Node newChild, Node oldChild) {
            NDTNode.this.replaceChild(newChild, oldChild);
        }
    }

    class ChildElementList
    implements ElementList {
        ChildElementList() {
        }

        @Override
        public boolean contains(Node node) {
            return NDTNode.this.getNodeList().contains(node);
        }

        @Override
        public DOMElement item(int index) {
            int idx = 0;
            for (Node node = NDTNode.this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                if (idx == index) {
                    return (DOMElement)node;
                }
                ++idx;
            }
            return null;
        }

        @Override
        public Iterator<DOMElement> iterator() {
            return NDTNode.this.getNodeList().elementIterator();
        }

        @Override
        public int getLength() {
            return NDTNode.this.getChildElementCount();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.getLength() * 32 + 40);
            for (Node node = NDTNode.this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                buf.append(node.toString());
            }
            return buf.toString();
        }
    }
}

