/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class SACParserFactory {
    public static final String DEFAULT_PARSER = "io.sf.carte.doc.style.css.parser.CSSParser";
    static Logger log = LoggerFactory.getLogger((String)SACParserFactory.class.getName());

    public static Parser createSACParser() throws DOMException {
        String parserClass = null;
        try {
            parserClass = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("org.w3c.css.sac.parser");
                }
            });
        }
        catch (SecurityException e) {
            log.warn("Unable to read system property org.w3c.css.sac.parser", (Throwable)e);
        }
        if (parserClass != null) {
            if (log.isTraceEnabled()) {
                log.trace("Instantiating SAC parser " + parserClass);
            }
            try {
                return SACParserFactory.instantiateParser(parserClass);
            }
            catch (Exception e) {
                log.error("Could not instantiate system SAC parser", (Throwable)e);
                log.trace("Instantiating default SAC parser io.sf.carte.doc.style.css.parser.CSSParser");
            }
        }
        return SACParserFactory.instantiateParser(DEFAULT_PARSER);
    }

    private static Parser instantiateParser(final String parserClass) throws DOMException {
        Parser parser = null;
        String message = null;
        try {
            parser = AccessController.doPrivileged(new PrivilegedAction<Parser>(){

                @Override
                public Parser run() {
                    try {
                        return (Parser)Class.forName(parserClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        log.warn("Could not instantiate " + parserClass, (Throwable)e);
                        return null;
                    }
                }
            });
            if (parser == null) {
                message = "Could not instantiate " + parserClass;
            }
        }
        catch (SecurityException e) {
            message = "Unable to instantiate " + parserClass + " due to access restriction: " + e.getMessage();
            log.warn(message, (Throwable)e);
        }
        if (parser == null) {
            throw new DOMException(15, message);
        }
        return parser;
    }
}

