/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.agent.Viewport;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.ExtendedCSSPrimitiveValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.NumberValue;

public abstract class AbstractCSSCanvas
implements CSSCanvas {
    private CSSDocument document;

    protected AbstractCSSCanvas(CSSDocument doc) {
        this.document = doc;
    }

    @Override
    public CSSDocument getDocument() {
        return this.document;
    }

    protected void setDocument(CSSDocument doc) {
        this.document = doc;
    }

    @Override
    public ExtendedCSSPrimitiveValue getFeatureValue(String feature) {
        if ("width".equals(feature)) {
            return this.getWidth();
        }
        if ("height".equals(feature)) {
            return this.getHeight();
        }
        if ("aspect-ratio".equals(feature)) {
            float fratio = this.getWidthFloat() / this.getHeightFloat();
            NumberValue number = new NumberValue();
            number.setFloatValue((short)1, fratio);
            return number;
        }
        if ("orientation".equals(feature)) {
            return new IdentifierValue(this.getOrientation());
        }
        if ("resolution".equals(feature)) {
            NumberValue number = new NumberValue();
            number.setFloatValue((short)40, this.getResolution());
            return number;
        }
        if ("scan".equals(feature)) {
            return new IdentifierValue(this.getScanType());
        }
        if ("grid".equals(feature)) {
            NumberValue number = new NumberValue();
            number.setFloatValue((short)1, this.isGridDevice() ? 1.0f : 0.0f);
            return number;
        }
        if ("update".equals(feature)) {
            return new IdentifierValue(this.getUpdateFrequency());
        }
        if ("overflow-block".equals(feature)) {
            return new IdentifierValue(this.getOverflowBlock());
        }
        if ("overflow-inline".equals(feature)) {
            return new IdentifierValue(this.getOverflowInline());
        }
        if ("color".equals(feature)) {
            NumberValue number = new NumberValue();
            int color = this.getStyleDatabase().getColorDepth();
            number.setFloatValue((short)1, color);
            return number;
        }
        if ("color-index".equals(feature)) {
            NumberValue number = new NumberValue();
            number.setFloatValue((short)1, this.getColorIndex());
            return number;
        }
        if ("monochrome".equals(feature)) {
            NumberValue number = new NumberValue();
            number.setFloatValue((short)1, this.getMonoBitsPerPixel());
            return number;
        }
        return null;
    }

    @Override
    public boolean matchesFeature(String feature, ExtendedCSSPrimitiveValue value) {
        if ("orientation".equals(feature)) {
            return this.matches(value, this.getOrientation());
        }
        if ("scan".equals(feature)) {
            return this.matches(value, this.getScanType());
        }
        if ("grid".equals(feature)) {
            return this.isGridDevice() ? value == null || !value.isNumberZero() : value != null && value.isNumberZero();
        }
        if ("update".equals(feature)) {
            return this.matches(value, this.getUpdateFrequency());
        }
        if ("overflow-block".equals(feature)) {
            return this.matches(value, this.getOverflowBlock());
        }
        if ("overflow-inline".equals(feature)) {
            return this.matches(value, this.getOverflowInline());
        }
        if ("color-gamut".equals(feature)) {
            if (value == null) {
                return !this.supportsGamut("none");
            }
            if (value.getPrimitiveType() == 21) {
                String sv = value.getStringValue();
                return this.supportsGamut(sv);
            }
        } else if ("pointer".equals(feature)) {
            return this.matches(value, this.getPointerAccuracy());
        }
        return false;
    }

    private boolean matches(ExtendedCSSPrimitiveValue valueToMatch, String featureValue) {
        if (valueToMatch == null) {
            return !"none".equals(featureValue);
        }
        return ShorthandBuilder.isCSSIdentifier(valueToMatch, featureValue);
    }

    private NumberValue getWidth() {
        StyleDatabase sdb = this.getStyleDatabase();
        Viewport viewport = this.getViewport();
        float fval = viewport == null ? sdb.getDeviceWidth() : (float)viewport.getViewportWidth();
        NumberValue num = new NumberValue();
        num.setFloatValue(sdb.getNaturalUnit(), fval);
        return num;
    }

    private NumberValue getHeight() {
        StyleDatabase sdb = this.getStyleDatabase();
        Viewport viewport = this.getViewport();
        float fval = viewport == null ? sdb.getDeviceHeight() : (float)viewport.getViewportHeight();
        NumberValue num = new NumberValue();
        num.setFloatValue(sdb.getNaturalUnit(), fval);
        return num;
    }

    private float getWidthFloat() {
        StyleDatabase sdb = this.getStyleDatabase();
        Viewport viewport = this.getViewport();
        float fval = viewport == null ? sdb.getDeviceWidth() : (float)viewport.getViewportWidth();
        return fval;
    }

    private float getHeightFloat() {
        StyleDatabase sdb = this.getStyleDatabase();
        Viewport viewport = this.getViewport();
        float fval = viewport == null ? sdb.getDeviceHeight() : (float)viewport.getViewportHeight();
        return fval;
    }

    protected abstract float getColorIndex();

    protected abstract boolean isGridDevice();

    protected abstract int getMonoBitsPerPixel();

    protected abstract String getOrientation();

    protected abstract String getOverflowBlock();

    protected abstract String getOverflowInline();

    protected abstract String getPointerAccuracy();

    protected abstract float getResolution();

    protected abstract String getScanType();

    protected abstract String getUpdateFrequency();

    protected abstract boolean supportsGamut(String var1);
}

