/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

abstract class AbstractErrorHandler
implements ErrorHandler {
    private HashMap<CSSElement, StyleDeclarationErrorHandler> inlineErrorHandlerMap = null;
    private HashMap<CSSElement, HashMap<String, CSSPropertyValueException>> computedStyleErrors = null;
    private HashMap<CSSElement, List<DOMException>> hintErrors = null;
    private HashMap<Node, CSSMediaException> mediaQueryErrors = null;
    private HashMap<String, IOException> ruleIOErrors = null;
    private HashMap<CSSElement, HashMap<String, CSSPropertyValueException>> computedStyleWarnings = null;
    private HashMap<Node, CSSMediaException> mediaQueryWarnings = null;

    AbstractErrorHandler() {
    }

    @Override
    public StyleDeclarationErrorHandler getInlineStyleErrorHandler(CSSElement owner) {
        StyleDeclarationErrorHandler handler;
        if (this.inlineErrorHandlerMap == null) {
            this.inlineErrorHandlerMap = new HashMap();
        }
        if ((handler = this.inlineErrorHandlerMap.get(owner)) == null) {
            handler = this.getStyleSheetFactory().createInlineStyleErrorHandler(owner);
            this.inlineErrorHandlerMap.put(owner, handler);
        }
        return handler;
    }

    public Set<CSSElement> getInlineStyleOwners() {
        Set<CSSElement> owners;
        if (this.inlineErrorHandlerMap != null && !(owners = this.inlineErrorHandlerMap.keySet()).isEmpty()) {
            return owners;
        }
        return null;
    }

    protected boolean hasInlineErrors() {
        if (this.inlineErrorHandlerMap != null) {
            Iterator<StyleDeclarationErrorHandler> it = this.inlineErrorHandlerMap.values().iterator();
            while (it.hasNext()) {
                if (!it.next().hasErrors()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasInlineWarnings() {
        if (this.inlineErrorHandlerMap != null) {
            Iterator<StyleDeclarationErrorHandler> it = this.inlineErrorHandlerMap.values().iterator();
            while (it.hasNext()) {
                if (!it.next().hasWarnings()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void computedStyleError(CSSElement element, String propertyName, CSSPropertyValueException exception) {
        HashMap<String, CSSPropertyValueException> map;
        if (this.computedStyleErrors == null) {
            this.computedStyleErrors = new HashMap();
            map = new HashMap();
            this.computedStyleErrors.put(element, map);
        } else {
            map = this.computedStyleErrors.get(element);
            if (map == null) {
                map = new HashMap();
                this.computedStyleErrors.put(element, map);
            }
        }
        map.put(propertyName, exception);
    }

    @Override
    public void mediaQueryError(Node ownerNode, CSSMediaException exception) {
        if (this.mediaQueryErrors == null) {
            this.mediaQueryErrors = new HashMap(5);
        }
        this.mediaQueryErrors.put(ownerNode, exception);
    }

    @Override
    public void ruleIOError(String uri, IOException exception) {
        if (this.ruleIOErrors == null) {
            this.ruleIOErrors = new HashMap();
        }
        this.ruleIOErrors.put(uri, exception);
    }

    @Override
    public boolean hasErrors() {
        return this.hasInlineErrors() || this.hasComputedStyleErrors() || this.hasMediaErrors();
    }

    @Override
    public boolean hasIOErrors() {
        return this.ruleIOErrors != null;
    }

    @Override
    public boolean hasComputedStyleErrors() {
        return this.computedStyleErrors != null && !this.computedStyleErrors.isEmpty() || this.hintErrors != null && !this.hintErrors.isEmpty();
    }

    @Override
    public boolean hasComputedStyleErrors(CSSElement element) {
        if (this.computedStyleErrors != null && this.computedStyleErrors.containsKey(element)) {
            return true;
        }
        return this.hintErrors != null && this.hintErrors.containsKey(element);
    }

    @Override
    public boolean hasMediaErrors() {
        return this.mediaQueryErrors != null && !this.mediaQueryErrors.isEmpty();
    }

    @Override
    public boolean hasWarnings() {
        return this.hasInlineWarnings() || this.hasComputedStyleWarnings() || this.hasMediaWarnings();
    }

    @Override
    public boolean hasMediaWarnings() {
        return this.mediaQueryWarnings != null && !this.mediaQueryWarnings.isEmpty();
    }

    @Override
    public boolean hasComputedStyleWarnings() {
        return this.computedStyleWarnings != null && !this.computedStyleWarnings.isEmpty();
    }

    @Override
    public boolean hasComputedStyleWarnings(CSSElement element) {
        return this.computedStyleWarnings != null && this.computedStyleWarnings.containsKey(element);
    }

    @Override
    public void computedStyleWarning(CSSElement element, String propertyName, CSSPropertyValueException exception) {
        HashMap<String, CSSPropertyValueException> map;
        if (this.computedStyleWarnings == null) {
            this.computedStyleWarnings = new HashMap();
            map = new HashMap();
            this.computedStyleWarnings.put(element, map);
        } else {
            map = this.computedStyleWarnings.get(element);
            if (map == null) {
                map = new HashMap();
                this.computedStyleWarnings.put(element, map);
            }
        }
        map.put(propertyName, exception);
    }

    @Override
    public void mediaQueryWarning(Node ownerNode, CSSMediaException exception) {
        if (this.mediaQueryWarnings == null) {
            this.mediaQueryWarnings = new HashMap(5);
        }
        this.mediaQueryWarnings.put(ownerNode, exception);
    }

    public HashMap<String, CSSPropertyValueException> getComputedStyleErrors(CSSElement element) {
        return this.computedStyleErrors != null ? this.computedStyleErrors.get(element) : null;
    }

    public List<DOMException> getHintErrors(CSSElement element) {
        return this.hintErrors != null ? this.hintErrors.get(element) : null;
    }

    public HashMap<String, CSSPropertyValueException> getComputedStyleWarnings(CSSElement element) {
        return this.computedStyleWarnings != null ? this.computedStyleWarnings.get(element) : null;
    }

    public HashMap<Node, CSSMediaException> getMediaErrors() {
        return this.mediaQueryErrors;
    }

    public HashMap<String, IOException> getRuleIOErrors() {
        return this.ruleIOErrors;
    }

    @Override
    public void resetComputedStyleErrors(CSSElement element) {
        if (this.computedStyleErrors != null) {
            this.computedStyleErrors.remove(element);
        }
        if (this.hintErrors != null) {
            this.hintErrors.remove(element);
        }
        if (this.computedStyleWarnings != null) {
            this.computedStyleWarnings.remove(element);
        }
    }

    @Override
    public void resetComputedStyleErrors() {
        this.computedStyleErrors = null;
        this.hintErrors = null;
        this.computedStyleWarnings = null;
    }

    @Override
    public void presentationalHintError(CSSElement elm, DOMException ex) {
        List<DOMException> exlist;
        if (this.hintErrors == null) {
            this.hintErrors = new HashMap();
            exlist = new LinkedList<DOMException>();
            this.hintErrors.put(elm, exlist);
        } else {
            exlist = this.hintErrors.get(elm);
            if (exlist == null) {
                exlist = new LinkedList<DOMException>();
            }
        }
        exlist.add(ex);
    }

    @Override
    public void reset() {
        if (this.inlineErrorHandlerMap != null) {
            Iterator<StyleDeclarationErrorHandler> it = this.inlineErrorHandlerMap.values().iterator();
            while (it.hasNext()) {
                it.next().reset();
            }
        }
        this.resetComputedStyleErrors();
        this.mediaQueryErrors = null;
        this.mediaQueryWarnings = null;
        this.ruleIOErrors = null;
    }

    protected abstract AbstractCSSStyleSheetFactory getStyleSheetFactory();
}

