/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.ExtendedCSSFontFaceRule;
import io.sf.carte.doc.style.css.ExtendedCSSStyleDeclaration;
import io.sf.carte.doc.style.css.ExtendedCSSValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Locale;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractStyleDatabase
implements StyleDatabase {
    protected final String DEFAULT_GENERIC_FONT_FAMILY = "serif";
    private static final PrimitiveValue DEFAULT_INITIAL_COLOR = (PrimitiveValue)new ValueFactory().parseProperty("#000000");
    private CSSPrimitiveValue initialColor = DEFAULT_INITIAL_COLOR;

    @Override
    public float getExSizeInPt(String familyName, float size) {
        return Math.round(0.5f * size);
    }

    @Override
    public CSSPrimitiveValue getInitialColor() {
        return this.initialColor;
    }

    @Override
    public void setInitialColor(String initialColor) {
        this.initialColor = (PrimitiveValue)new ValueFactory().parseProperty(initialColor);
        ((ColorValue)this.initialColor).setSystemDefault();
    }

    @Override
    public String getDefaultGenericFontFamily() {
        return this.getDefaultGenericFontFamily("serif");
    }

    @Override
    public String getSystemFontDeclaration(String systemFontName) {
        return null;
    }

    @Override
    public String getUsedFontFamily(CSSComputedProperties computedStyle) {
        String requestedFamily = this.scanFontFamilyValue(computedStyle);
        if (requestedFamily == null) {
            requestedFamily = this.getDefaultGenericFontFamily();
        }
        return requestedFamily;
    }

    private String scanFontFamilyValue(CSSComputedProperties style) {
        CSSComputedProperties ancStyle;
        ExtendedCSSValue value = style.getPropertyCSSValue("font-family");
        String requestedFamily = null;
        if (value != null) {
            if (value.getCssValueType() == 2) {
                ValueList fontList = (ValueList)value;
                for (StyleValue item : fontList) {
                    requestedFamily = this.stringValueOrNull(item);
                    if (requestedFamily == null || !this.isFontFamilyAvailable(requestedFamily, style)) continue;
                    return requestedFamily;
                }
            } else {
                requestedFamily = this.stringValueOrNull(value);
                if (requestedFamily != null && this.isFontFamilyAvailable(requestedFamily, style)) {
                    return requestedFamily;
                }
            }
        }
        if ((ancStyle = style.getParentComputedStyle()) != null) {
            requestedFamily = this.scanFontFamilyValue(ancStyle);
        }
        return requestedFamily;
    }

    private String stringValueOrNull(ExtendedCSSValue value) {
        CSSPrimitiveValue primi;
        short ptype;
        String s = value.getCssValueType() == 1 && ((ptype = (primi = (CSSPrimitiveValue)((Object)value)).getPrimitiveType()) == 19 || ptype == 21) ? primi.getStringValue() : null;
        return s;
    }

    protected boolean isFontFamilyAvailable(String requestedFamily, CSSComputedProperties style) {
        if (this.isFontFamilyAvailable(requestedFamily = requestedFamily.toLowerCase(Locale.ROOT))) {
            return true;
        }
        return this.isFontFaceName(requestedFamily);
    }

    @Override
    public void loadFontFaceRule(ExtendedCSSFontFaceRule rule) {
        String familyName = rule.getStyle().getPropertyValue("font-family");
        if (familyName == null) {
            rule.getStyleDeclarationErrorHandler().missingRequiredProperty(familyName);
            return;
        }
        if (!this.isFontFaceName(familyName = familyName.toLowerCase(Locale.ROOT))) {
            ExtendedCSSStyleDeclaration decl = rule.getStyle();
            ExtendedCSSValue value = decl.getPropertyCSSValue("src");
            if (value.getCssValueType() == 2) {
                ValueList list = (ValueList)value;
                if (list.isCommaSeparated()) {
                    for (StyleValue item : list) {
                        if (!(item.getCssValueType() == 2 ? this.loadFont(familyName, (ValueList)item, rule) : this.loadFont(familyName, (PrimitiveValue)item, null, rule))) continue;
                        return;
                    }
                } else if (this.loadFont(familyName, list, rule)) {
                    return;
                }
            } else if (this.loadFont(familyName, (PrimitiveValue)value, null, rule)) {
                return;
            }
        }
    }

    private boolean loadFont(String familyName, ValueList value, ExtendedCSSFontFaceRule rule) {
        if (!value.isCommaSeparated()) {
            ValueList list = value;
            Iterator<StyleValue> it = list.iterator();
            PrimitiveValue uri = null;
            String fontFormat = null;
            while (it.hasNext()) {
                StyleValue item = it.next();
                if (item.getCssValueType() == 1) {
                    StyleValue arg;
                    LinkedCSSValueList args;
                    PrimitiveValue primi = (PrimitiveValue)item;
                    short pType = primi.getPrimitiveType();
                    if (pType == 20 || pType == 19) {
                        if (uri == null) {
                            uri = primi;
                            continue;
                        }
                    } else if (pType == 127 && "format".equalsIgnoreCase(primi.getStringValue()) && (args = ((FunctionValue)primi).getArguments()).size() == 1 && (arg = args.item(0)).getCssValueType() == 1 && ((pType = (primi = (PrimitiveValue)arg).getPrimitiveType()) == 19 || pType == 21)) {
                        fontFormat = primi.getStringValue();
                        continue;
                    }
                }
                this.errorSrc(item, rule);
                return false;
            }
            if (uri != null) {
                return this.loadFont(familyName, uri, fontFormat, rule);
            }
            this.errorSrc(value, rule);
            return false;
        }
        this.errorSrc(value, rule);
        return false;
    }

    private void errorSrc(StyleValue value, CSSDeclarationRule rule) {
        CSSPropertyValueException ex = new CSSPropertyValueException("Expected primitive value.");
        ex.setValueText(value.getCssText());
        rule.getStyleDeclarationErrorHandler().wrongValue("src", ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFont(String familyName, PrimitiveValue value, String format, ExtendedCSSFontFaceRule rule) {
        short pType = value.getPrimitiveType();
        if (pType == 20) {
            URL url;
            String uri = value.getStringValue();
            Node node = rule.getParentStyleSheet().getOwnerNode();
            CSSDocument doc = node.getNodeType() != 9 ? (CSSDocument)node.getOwnerDocument() : (CSSDocument)node;
            try {
                url = doc.getURL(uri);
            }
            catch (MalformedURLException e) {
                doc.getErrorHandler().ruleIOError(uri, e);
                return false;
            }
            InputStream is = null;
            try {
                FontFormat fontFormat = null;
                URLConnection conn = doc.openConnection(url);
                conn.connect();
                String conType = conn.getContentType();
                if (conType != null) {
                    int scidx = conType.indexOf(59);
                    if (scidx != -1) {
                        conType = conType.substring(0, scidx);
                    }
                    conType = conType.toLowerCase(Locale.ROOT);
                    fontFormat = this.fontFormatFromContentType(conType);
                }
                if (fontFormat == null && format != null) {
                    fontFormat = this.fontFormatFromRule(format.toLowerCase(Locale.ROOT));
                }
                is = conn.getInputStream();
                this.loadFontFace(familyName, fontFormat, is, rule);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                doc.getErrorHandler().ruleIOError(url.toExternalForm(), e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (pType == 127) {
            StyleValue arg;
            String fname = value.getStringValue();
            FunctionValue function = (FunctionValue)value;
            if ("local".equalsIgnoreCase(fname) && function.getArguments().size() == 1 && (arg = (StyleValue)function.getArguments().get(0)).getCssValueType() == 1 && (value = (PrimitiveValue)arg).getPrimitiveType() == 19) {
                return this.isFontFamilyAvailable(value.getStringValue());
            }
        }
        return false;
    }

    protected FontFormat fontFormatFromContentType(String conType) {
        FontFormat fontFormat = "application/font-ttf".equals(conType) || "application/x-font-ttf".equals(conType) || "application/font-sfnt".equals(conType) || "font/ttf".equals(conType) ? FontFormat.TRUETYPE : ("application/font-woff".equals(conType) || "application/x-font-woff".equals(conType) || "font/woff".equals(conType) ? FontFormat.WOFF : ("application/font-woff2".equals(conType) || "font/woff2".equals(conType) ? FontFormat.WOFF2 : ("application/font-opentype".equals(conType) || "application/x-font-opentype".equals(conType) || "application/vnd.ms-opentype".equals(conType) || "font/otf".equals(conType) || "font/opentype".equals(conType) ? FontFormat.OPENTYPE : ("application/vnd.ms-fontobject".equals(conType) || "font/eot".equals(conType) ? FontFormat.EMBEDDED_OPENTYPE : ("image/svg+xml".equals(conType) ? FontFormat.SVG : null)))));
        return fontFormat;
    }

    protected FontFormat fontFormatFromRule(String format) {
        FontFormat fontFormat = "truetype".equals(format) ? FontFormat.TRUETYPE : ("woff".equals(format) ? FontFormat.WOFF : ("woff2".equals(format) ? FontFormat.WOFF2 : ("opentype".equals(format) ? FontFormat.OPENTYPE : ("embedded-opentype".equals(format) ? FontFormat.EMBEDDED_OPENTYPE : ("opentype".equals(format) ? FontFormat.OPENTYPE : ("svg".equals(format) ? FontFormat.SVG : null))))));
        return fontFormat;
    }

    protected boolean loadFontFace(String familyName, FontFormat fontFormat, InputStream is, ExtendedCSSFontFaceRule rule) throws IOException {
        return false;
    }

    @Override
    public boolean supports(String featureName, CSSValue value) {
        return false;
    }

    protected abstract boolean isFontFamilyAvailable(String var1);

    static {
        ((ColorValue)DEFAULT_INITIAL_COLOR).setSystemDefault();
    }

    public static enum FontFormat {
        TRUETYPE,
        OPENTYPE,
        EMBEDDED_OPENTYPE,
        SVG,
        WOFF,
        WOFF2;

    }
}

